/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.source.atlas;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.atlas.kafka.AtlasKafkaMessage;
import org.apache.atlas.kafka.NotificationProvider;
import org.apache.atlas.model.notification.EntityNotification;
import org.apache.atlas.notification.NotificationConsumer;
import org.apache.atlas.notification.NotificationInterface;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.ranger.plugin.util.ServiceTags;
import org.apache.ranger.tagsync.model.AbstractTagSource;
import org.apache.ranger.tagsync.process.TagSyncConfig;
import org.apache.ranger.tagsync.source.atlas.AtlasNotificationMapper;
import org.apache.ranger.tagsync.source.atlas.AtlasResourceMapperUtil;
import org.apache.ranger.tagsync.source.atlas.EntityNotificationWrapper;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntityWithTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasTagSource
extends AbstractTagSource {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasTagSource.class);
    public static final String TAGSYNC_ATLAS_PROPERTIES_FILE_NAME = "atlas-application.properties";
    public static final String TAGSYNC_ATLAS_KAFKA_ENDPOINTS = "atlas.kafka.bootstrap.servers";
    public static final String TAGSYNC_ATLAS_ZOOKEEPER_ENDPOINT = "atlas.kafka.zookeeper.connect";
    public static final String TAGSYNC_ATLAS_CONSUMER_GROUP = "atlas.kafka.entities.group.id";
    public static final int MAX_WAIT_TIME_IN_MILLIS = 1000;
    private int maxBatchSize;
    private ConsumerRunnable consumerTask;
    private Thread myThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initialize(Properties properties) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasTagSource.initialize()");
        }
        Properties atlasProperties = new Properties();
        boolean ret = AtlasResourceMapperUtil.initializeAtlasResourceMappers(properties);
        if (ret) {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(TAGSYNC_ATLAS_PROPERTIES_FILE_NAME);
            if (inputStream != null) {
                try {
                    atlasProperties.load(inputStream);
                }
                catch (Exception exception) {
                    ret = false;
                    LOG.error("Cannot load Atlas application properties file, file-name:atlas-application.properties", (Throwable)exception);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ioException) {
                        LOG.error("Cannot close Atlas application properties file, file-name:\" + TAGSYNC_ATLAS_PROPERTIES_FILE_NAME", (Throwable)ioException);
                    }
                }
            } else {
                ret = false;
                LOG.error("Cannot find Atlas application properties file");
            }
        }
        if (ret) {
            if (StringUtils.isBlank((String)atlasProperties.getProperty(TAGSYNC_ATLAS_KAFKA_ENDPOINTS))) {
                ret = false;
                LOG.error("Value of property 'atlas.kafka.bootstrap.servers' is not specified!");
            }
            if (StringUtils.isBlank((String)atlasProperties.getProperty(TAGSYNC_ATLAS_ZOOKEEPER_ENDPOINT))) {
                ret = false;
                LOG.error("Value of property 'atlas.kafka.zookeeper.connect' is not specified!");
            }
            if (StringUtils.isBlank((String)atlasProperties.getProperty(TAGSYNC_ATLAS_CONSUMER_GROUP))) {
                ret = false;
                LOG.error("Value of property 'atlas.kafka.entities.group.id' is not specified!");
            }
        }
        if (ret) {
            NotificationInterface notification = NotificationProvider.get();
            List iterators = notification.createConsumers(NotificationInterface.NotificationType.ENTITIES, 1);
            this.consumerTask = new ConsumerRunnable((NotificationConsumer)iterators.get(0));
        }
        this.maxBatchSize = TagSyncConfig.getSinkMaxBatchSize(properties);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasTagSource.initialize(), result=" + ret);
        }
        return ret;
    }

    @Override
    public boolean start() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasTagSource.start()");
        }
        if (this.consumerTask == null) {
            LOG.error("No consumerTask!!!");
        } else {
            this.myThread = new Thread(this.consumerTask);
            this.myThread.setDaemon(true);
            this.myThread.start();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasTagSource.start()");
        }
        return this.myThread != null;
    }

    @Override
    public void stop() {
        if (this.myThread != null && this.myThread.isAlive()) {
            this.myThread.interrupt();
        }
    }

    private static String getPrintableEntityNotification(EntityNotificationWrapper notification) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ Notification-Type: ").append((Object)notification.getOpType()).append(", ");
        RangerAtlasEntityWithTags entityWithTags = new RangerAtlasEntityWithTags(notification);
        sb.append(entityWithTags.toString());
        sb.append("}");
        return sb.toString();
    }

    private class ConsumerRunnable
    implements Runnable {
        private final NotificationConsumer<EntityNotification> consumer;
        private final List<RangerAtlasEntityWithTags> atlasEntitiesWithTags = new ArrayList<RangerAtlasEntityWithTags>();
        private final List<AtlasKafkaMessage<EntityNotification>> messages = new ArrayList<AtlasKafkaMessage<EntityNotification>>();
        private long offsetOfLastMessageDeliveredToRanger = -1L;
        private long offsetOfLastMessageCommittedToKafka = -1L;
        private boolean isHandlingDeleteOps = false;

        private ConsumerRunnable(NotificationConsumer<EntityNotification> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> ConsumerRunnable.run()");
            }
            while (true) {
                try {
                    while (true) {
                        List newMessages;
                        if ((newMessages = this.consumer.receive(1000L)).size() == 0) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("AtlasTagSource.ConsumerRunnable.run: no message from NotificationConsumer within 1000 milliseconds");
                            }
                            if (!CollectionUtils.isNotEmpty(this.atlasEntitiesWithTags)) continue;
                            this.buildAndUploadServiceTags();
                            continue;
                        }
                        for (AtlasKafkaMessage message : newMessages) {
                            EntityNotification notification;
                            EntityNotification entityNotification = notification = message != null ? (EntityNotification)message.getMessage() : null;
                            if (notification != null) {
                                EntityNotificationWrapper notificationWrapper = null;
                                try {
                                    notificationWrapper = new EntityNotificationWrapper(notification);
                                }
                                catch (Throwable e) {
                                    LOG.error("notification:[" + notification + "] has some issues..perhaps null entity??", e);
                                }
                                if (notificationWrapper == null) continue;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Message-offset=" + message.getOffset() + ", Notification=" + AtlasTagSource.getPrintableEntityNotification(notificationWrapper));
                                }
                                RangerAtlasEntityWithTags entityWithTags = new RangerAtlasEntityWithTags(notificationWrapper);
                                if (notificationWrapper.getIsEntityDeleteOp() && !this.isHandlingDeleteOps || !notificationWrapper.getIsEntityDeleteOp() && this.isHandlingDeleteOps) {
                                    this.buildAndUploadServiceTags();
                                    this.isHandlingDeleteOps = !this.isHandlingDeleteOps;
                                }
                                this.atlasEntitiesWithTags.add(entityWithTags);
                                this.messages.add((AtlasKafkaMessage<EntityNotification>)message);
                                continue;
                            }
                            LOG.error("Null entityNotification received from Kafka!! Ignoring..");
                        }
                        if (!CollectionUtils.isNotEmpty(this.atlasEntitiesWithTags) || this.atlasEntitiesWithTags.size() < AtlasTagSource.this.maxBatchSize) continue;
                        this.buildAndUploadServiceTags();
                    }
                }
                catch (Exception exception) {
                    LOG.error("Caught exception..: ", (Throwable)exception);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interrupted) {
                        LOG.error("Interrupted: ", (Throwable)interrupted);
                        LOG.error("Returning from thread. May cause process to be up but not processing events!!");
                        return;
                    }
                }
            }
        }

        private void buildAndUploadServiceTags() throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> buildAndUploadServiceTags()");
            }
            this.commitToKafka();
            Map<String, ServiceTags> serviceTagsMap = AtlasNotificationMapper.processAtlasEntities(this.atlasEntitiesWithTags);
            if (MapUtils.isNotEmpty(serviceTagsMap)) {
                if (serviceTagsMap.size() != 1) {
                    LOG.warn("Unexpected!! Notifications for more than one service received by AtlasTagSource.. Service-Names:[" + serviceTagsMap.keySet() + "]");
                }
                for (Map.Entry<String, ServiceTags> entry : serviceTagsMap.entrySet()) {
                    if (this.isHandlingDeleteOps) {
                        entry.getValue().setOp("delete");
                        entry.getValue().setTagDefinitions(Collections.EMPTY_MAP);
                        entry.getValue().setTags(Collections.EMPTY_MAP);
                    } else {
                        entry.getValue().setOp("add_or_update");
                    }
                    if (LOG.isDebugEnabled()) {
                        Gson gsonBuilder = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").setPrettyPrinting().create();
                        String serviceTagsString = gsonBuilder.toJson((Object)entry.getValue());
                        LOG.debug("serviceTags=" + serviceTagsString);
                    }
                    AtlasTagSource.this.updateSink(entry.getValue());
                }
                this.offsetOfLastMessageDeliveredToRanger = this.messages.get(this.messages.size() - 1).getOffset();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Completed processing batch of messages of size:[" + this.messages.size() + "] received from NotificationConsumer");
                }
                this.commitToKafka();
            }
            this.atlasEntitiesWithTags.clear();
            this.messages.clear();
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== buildAndUploadServiceTags()");
            }
        }

        private void commitToKafka() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> commitToKafka()");
            }
            for (AtlasKafkaMessage<EntityNotification> message : this.messages) {
                if (message.getOffset() <= this.offsetOfLastMessageCommittedToKafka) continue;
                if (message.getOffset() > this.offsetOfLastMessageDeliveredToRanger) break;
                TopicPartition partition = new TopicPartition("ATLAS_ENTITIES", message.getPartition());
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Committing message with offset:[" + message.getOffset() + "] to Kafka");
                    }
                    this.consumer.commit(partition, message.getOffset());
                    this.offsetOfLastMessageCommittedToKafka = message.getOffset();
                }
                catch (Exception commitException) {
                    LOG.warn("Ranger tagsync already processed message at offset " + message.getOffset() + ". Ignoring failure in committing this message and continuing to process next message", (Throwable)commitException);
                    LOG.warn("This will cause Kafka to deliver this message:[" + message.getOffset() + "] repeatedly!! This may be unrecoverable error!!");
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== commitToKafka()");
            }
        }
    }
}

