/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.source.atlas;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.tagsync.source.atlas.AtlasResourceMapper;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasOzoneResourceMapper
extends AtlasResourceMapper {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasOzoneResourceMapper.class);
    public static final String ENTITY_TYPE_OZONE_VOLUME = "ozone_volume";
    public static final String ENTITY_TYPE_OZONE_BUCKET = "ozone_bucket";
    public static final String ENTITY_TYPE_OZONE_KEY = "ozone_key";
    public static final String RANGER_TYPE_OZONE_VOLUME = "volume";
    public static final String RANGER_TYPE_OZONE_BUCKET = "bucket";
    public static final String RANGER_TYPE_OZONE_KEY = "key";
    public static final String[] SUPPORTED_ENTITY_TYPES = new String[]{"ozone_volume", "ozone_bucket", "ozone_key"};
    private static final String SEP_PROTOCOL = "://";
    private static final String SEP_RELATIVE_PATH = "/";
    private static final int IDX_VOLUME = 0;
    private static final int IDX_BUCKET = 1;
    private static final int IDX_KEY = 2;
    private static final int IDX_CLUSTER_NAME = 3;
    private static final int RESOURCE_COUNT = 4;

    public AtlasOzoneResourceMapper() {
        super("ozone", SUPPORTED_ENTITY_TYPES);
    }

    @Override
    public RangerServiceResource buildResource(RangerAtlasEntity entity) throws Exception {
        String qualifiedName = (String)entity.getAttributes().get("qualifiedName");
        if (StringUtils.isEmpty((String)qualifiedName)) {
            throw new Exception("attribute 'qualifiedName' not found in entity");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ENTITY_ATTRIBUTE_QUALIFIED_NAME = " + qualifiedName);
        }
        String entityType = entity.getTypeName();
        String entityGuid = entity.getGuid();
        Object[] resources = this.parseQualifiedName(qualifiedName, entityType);
        String volName = resources[0];
        String bktName = resources[1];
        String keyName = resources[2];
        String clusterName = resources[3];
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ozone resources for entityType " + entityType + " are " + Arrays.toString(resources));
        }
        if (StringUtils.isEmpty((String)clusterName)) {
            this.throwExceptionWithMessage("cluster-name not found in attribute 'qualifiedName': " + qualifiedName);
        }
        String serviceName = this.getRangerServiceName(clusterName);
        HashMap<String, RangerPolicy.RangerPolicyResource> elements = new HashMap<String, RangerPolicy.RangerPolicyResource>();
        if (StringUtils.equals((String)entityType, (String)ENTITY_TYPE_OZONE_VOLUME)) {
            if (StringUtils.isNotEmpty((String)volName)) {
                elements.put(RANGER_TYPE_OZONE_VOLUME, new RangerPolicy.RangerPolicyResource(volName));
            } else {
                this.throwExceptionWithMessage("volume-name not found in attribute 'qualifiedName': " + qualifiedName);
            }
        } else if (StringUtils.equals((String)entityType, (String)ENTITY_TYPE_OZONE_BUCKET)) {
            if (StringUtils.isNotEmpty((String)volName) && StringUtils.isNotEmpty((String)bktName)) {
                elements.put(RANGER_TYPE_OZONE_VOLUME, new RangerPolicy.RangerPolicyResource(volName));
                elements.put(RANGER_TYPE_OZONE_BUCKET, new RangerPolicy.RangerPolicyResource(bktName));
            } else if (StringUtils.isEmpty((String)volName)) {
                this.throwExceptionWithMessage("volume-name not found in attribute 'qualifiedName': " + qualifiedName);
            } else if (StringUtils.isEmpty((String)bktName)) {
                this.throwExceptionWithMessage("bucket-name not found in attribute 'qualifiedName': " + qualifiedName);
            }
        } else if (StringUtils.equals((String)entityType, (String)ENTITY_TYPE_OZONE_KEY)) {
            if (StringUtils.isNotEmpty((String)volName) && StringUtils.isNotEmpty((String)bktName) && StringUtils.isNotEmpty((String)keyName)) {
                elements.put(RANGER_TYPE_OZONE_VOLUME, new RangerPolicy.RangerPolicyResource(volName));
                elements.put(RANGER_TYPE_OZONE_BUCKET, new RangerPolicy.RangerPolicyResource(bktName));
                elements.put(RANGER_TYPE_OZONE_KEY, new RangerPolicy.RangerPolicyResource(keyName));
            } else if (StringUtils.isEmpty((String)volName)) {
                this.throwExceptionWithMessage("volume-name not found in attribute 'qualifiedName': " + qualifiedName);
            } else if (StringUtils.isEmpty((String)bktName)) {
                this.throwExceptionWithMessage("bucket-name not found in attribute 'qualifiedName': " + qualifiedName);
            } else if (StringUtils.isEmpty((String)keyName)) {
                this.throwExceptionWithMessage("key-name not found in attribute 'qualifiedName': " + qualifiedName);
            }
        } else {
            this.throwExceptionWithMessage("unrecognized entity-type: " + entityType);
        }
        if (elements.isEmpty()) {
            this.throwExceptionWithMessage("invalid qualifiedName for entity-type '" + entityType + "': " + qualifiedName);
        }
        RangerServiceResource ret = new RangerServiceResource(entityGuid, serviceName, elements);
        return ret;
    }

    private String[] parseQualifiedName(String qualifiedName, String entityType) {
        int idxClusterNameSep;
        String[] ret = new String[4];
        if (StringUtils.isNotBlank((String)qualifiedName) && (idxClusterNameSep = qualifiedName.lastIndexOf("@")) != -1) {
            ret[3] = qualifiedName.substring(idxClusterNameSep + "@".length());
            int idxProtocolSep = qualifiedName.indexOf(SEP_PROTOCOL);
            if (idxProtocolSep != -1) {
                int idxResourceStart = idxProtocolSep + SEP_PROTOCOL.length();
                if (StringUtils.equals((String)entityType, (String)ENTITY_TYPE_OZONE_VOLUME)) {
                    ret[0] = qualifiedName.substring(idxResourceStart, idxClusterNameSep);
                } else if (StringUtils.equals((String)entityType, (String)ENTITY_TYPE_OZONE_BUCKET)) {
                    String[] resources = qualifiedName.substring(idxResourceStart, idxClusterNameSep).split("\\.");
                    ret[0] = resources.length > 0 ? resources[0] : null;
                    ret[1] = resources.length > 1 ? resources[1] : null;
                } else if (StringUtils.equals((String)entityType, (String)ENTITY_TYPE_OZONE_KEY)) {
                    String[] resources = qualifiedName.substring(idxResourceStart, idxClusterNameSep).split("\\.");
                    ret[1] = resources.length > 0 ? resources[0] : null;
                    ret[0] = resources.length > 1 ? resources[1] : null;
                    int idxRelativePath = qualifiedName.indexOf(SEP_RELATIVE_PATH, idxResourceStart);
                    if (idxRelativePath != -1) {
                        ret[2] = qualifiedName.substring(idxRelativePath, idxClusterNameSep);
                    }
                }
            }
        }
        return ret;
    }
}

