/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.process;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.tagsync.model.TagSink;
import org.apache.ranger.tagsync.model.TagSource;
import org.apache.ranger.tagsync.process.TagSyncConfig;
import org.apache.ranger.tagsync.process.TagSyncMetricsProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagSynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(TagSynchronizer.class);
    private static final String AUTH_TYPE_KERBEROS = "kerberos";
    private static final String TAGSYNC_SOURCE_BASE = "ranger.tagsync.source.";
    private static final String PROP_CLASS_NAME = "class";
    private TagSink tagSink = null;
    private List<TagSource> tagSources = new ArrayList<TagSource>();
    private List<TagSource> failedTagSources = new ArrayList<TagSource>();
    private Properties properties = null;
    private final Object shutdownNotifier = new Object();
    private volatile boolean isShutdownInProgress = false;

    public static void main(String[] args) {
        TagSynchronizer tagSynchronizer = new TagSynchronizer();
        TagSyncConfig config = TagSyncConfig.getInstance();
        Properties props = config.getProperties();
        tagSynchronizer.setProperties(props);
        boolean tagSynchronizerInitialized = tagSynchronizer.initialize();
        if (tagSynchronizerInitialized) {
            try {
                tagSynchronizer.run();
            }
            catch (Throwable t) {
                LOG.error("main thread caught exception..:", t);
                System.exit(1);
            }
        } else {
            LOG.error("TagSynchronizer failed to initialize correctly, exiting..");
            System.exit(1);
        }
    }

    TagSynchronizer() {
        this(null);
    }

    TagSynchronizer(Properties properties) {
        this.setProperties(properties);
    }

    void setProperties(Properties properties) {
        this.properties = properties == null || MapUtils.isEmpty((Map)properties) ? new Properties() : properties;
    }

    public boolean initialize() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> TagSynchronizer.initialize()");
        }
        TagSynchronizer.printConfigurationProperties(this.properties);
        boolean ret = TagSynchronizer.initializeKerberosIdentity(this.properties);
        if (ret) {
            LOG.info("Initializing TAG source and sink");
            ret = false;
            this.tagSink = TagSynchronizer.initializeTagSink(this.properties);
            if (this.tagSink != null) {
                this.initializeTagSources();
                ret = true;
            }
        } else {
            LOG.error("Error initializing kerberos identity");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== TagSynchronizer.initialize() : " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        block14: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> TagSynchronizer.run()");
            }
            this.isShutdownInProgress = false;
            try {
                boolean isTagSyncMetricsEnabled;
                boolean threadsStarted = this.tagSink.start();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("==> starting TagSyncMetricsProducer with default metrics location : " + System.getProperty("logdir"));
                }
                if (isTagSyncMetricsEnabled = TagSyncConfig.isTagSyncMetricsEnabled(this.properties)) {
                    TagSyncMetricsProducer tagSyncMetricsProducer = new TagSyncMetricsProducer();
                    Thread tagSyncMetricsProducerThread = new Thread(tagSyncMetricsProducer);
                    tagSyncMetricsProducerThread.setName("TagSyncMetricsProducerThread");
                    tagSyncMetricsProducerThread.setDaemon(true);
                    tagSyncMetricsProducerThread.start();
                } else {
                    LOG.info(" Ranger tagsync metrics is not enabled");
                }
                for (TagSource tagSource : this.tagSources) {
                    threadsStarted = threadsStarted && tagSource.start();
                }
                if (!threadsStarted) break block14;
                long tagSourceRetryInitializationInterval = TagSyncConfig.getTagSourceRetryInitializationInterval(this.properties);
                Object object = this.shutdownNotifier;
                synchronized (object) {
                    while (!this.isShutdownInProgress) {
                        this.shutdownNotifier.wait(tagSourceRetryInitializationInterval);
                        if (!CollectionUtils.isNotEmpty(this.failedTagSources)) continue;
                        this.reInitializeFailedTagSources();
                    }
                }
            }
            finally {
                LOG.info("Stopping all tagSources");
                for (TagSource tagSource : this.tagSources) {
                    tagSource.stop();
                }
                LOG.info("Stopping tagSink");
                this.tagSink.stop();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== TagSynchronizer.run()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String reason) {
        LOG.info("Received shutdown(), reason=" + reason);
        Object object = this.shutdownNotifier;
        synchronized (object) {
            this.isShutdownInProgress = true;
            this.shutdownNotifier.notifyAll();
        }
    }

    public static void printConfigurationProperties(Properties properties) {
        LOG.info("--------------------------------");
        LOG.info("");
        LOG.info("Ranger-TagSync Configuration: {\n");
        if (MapUtils.isNotEmpty((Map)properties)) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                LOG.info("\tProperty-Name:" + entry.getKey());
                LOG.info("\tProperty-Value:" + entry.getValue());
                LOG.info("\n");
            }
        }
        LOG.info("\n}");
        LOG.info("");
        LOG.info("--------------------------------");
    }

    public static TagSink initializeTagSink(Properties properties) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> TagSynchronizer.initializeTagSink()");
        }
        TagSink ret = null;
        try {
            Class<?> tagSinkClass;
            String tagSinkClassName = TagSyncConfig.getTagSinkClassName(properties);
            if (LOG.isDebugEnabled()) {
                LOG.debug("tagSinkClassName=" + tagSinkClassName);
            }
            if (!(ret = (TagSink)(tagSinkClass = Class.forName(tagSinkClassName)).newInstance()).initialize(properties)) {
                LOG.error("Failed to initialize TAG sink " + tagSinkClassName);
                ret = null;
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to initialize TAG sink. Error details: ", t);
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== TagSynchronizer.initializeTagSink(), result:" + (ret == null ? "false" : "true"));
        }
        return ret;
    }

    private void initializeTagSources() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> TagSynchronizer.initializeTagSources()");
        }
        ArrayList<String> tagSourceNameList = new ArrayList<String>();
        for (Object propNameObj : this.properties.keySet()) {
            String value;
            String tagSourceName;
            List<String> splits;
            String propName = propNameObj.toString();
            if (!propName.startsWith(TAGSYNC_SOURCE_BASE) || (splits = TagSynchronizer.toArray(tagSourceName = propName.substring(TAGSYNC_SOURCE_BASE.length()), ".")).size() > 1 || !(value = this.properties.getProperty(propName)).equalsIgnoreCase("enable") && !value.equalsIgnoreCase("enabled") && !value.equalsIgnoreCase("true")) continue;
            tagSourceNameList.add(tagSourceName);
            LOG.info("Tag source " + propName + " is set to " + value);
        }
        ArrayList<String> initializedTagSourceNameList = new ArrayList<String>();
        for (String tagSourceName : tagSourceNameList) {
            String tagSourcePropPrefix = TAGSYNC_SOURCE_BASE + tagSourceName;
            TagSource tagSource = TagSynchronizer.getTagSourceFromConfig(this.properties, tagSourcePropPrefix, tagSourceName);
            if (tagSource == null) continue;
            try {
                if (!tagSource.initialize(this.properties)) {
                    LOG.error("Failed to initialize TAG source " + tagSourceName);
                    this.failedTagSources.add(tagSource);
                    continue;
                }
                tagSource.setTagSink(this.tagSink);
                this.tagSources.add(tagSource);
                initializedTagSourceNameList.add(tagSourceName);
            }
            catch (Exception exception) {
                LOG.error("tag-source:" + tagSourceName + " initialization failed with ", (Throwable)exception);
                this.failedTagSources.add(tagSource);
            }
        }
        if (CollectionUtils.isEmpty(this.tagSources)) {
            LOG.warn("TagSync is not configured for any tag-sources. No tags will be received by TagSync.");
            LOG.warn("Please recheck configuration properties and tagsync environment to ensure that this is correct.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== TagSynchronizer.initializeTagSources(initializedTagSources=" + initializedTagSourceNameList + ", failedTagSources=" + this.failedTagSources + ")");
        }
    }

    private void reInitializeFailedTagSources() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> TagSynchronizer.reInitializeFailedTagSources()");
        }
        for (int index = 0; index < this.failedTagSources.size(); ++index) {
            TagSource tagSource = this.failedTagSources.get(index);
            try {
                if (tagSource.initialize(this.properties)) {
                    this.failedTagSources.remove(index);
                    --index;
                    this.tagSources.add(tagSource);
                    tagSource.setTagSink(this.tagSink);
                    if (tagSource.start()) {
                        this.tagSources.add(tagSource);
                        continue;
                    }
                    LOG.error("Failed to start tagSource: " + tagSource);
                    continue;
                }
                LOG.error("Failed to initialize TAG source " + tagSource);
                continue;
            }
            catch (Exception exception) {
                LOG.error("tag-source:" + tagSource + " initialization failed with ", (Throwable)exception);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== TagSynchronizer.reInitializeFailedTagSources()");
        }
    }

    private static TagSource getTagSourceFromConfig(Properties props, String propPrefix, String tagSourceName) {
        TagSource tagSource = null;
        String className = TagSynchronizer.getStringProperty(props, propPrefix + "." + PROP_CLASS_NAME);
        if (StringUtils.isBlank((String)className)) {
            if (tagSourceName.equals("file")) {
                className = "org.apache.ranger.tagsync.source.file.FileTagSource";
            } else if (tagSourceName.equalsIgnoreCase("atlas")) {
                className = "org.apache.ranger.tagsync.source.atlas.AtlasTagSource";
            } else if (tagSourceName.equals("atlasrest")) {
                className = "org.apache.ranger.tagsync.source.atlasrest.AtlasRESTTagSource";
            } else {
                LOG.error("tagSource name doesn't have any class associated with it. tagSourceName=" + tagSourceName + ", propertyPrefix=" + propPrefix);
            }
        }
        if (StringUtils.isNotBlank((String)className)) {
            try {
                Class<?> tagSourceClass = Class.forName(className);
                tagSource = (TagSource)tagSourceClass.newInstance();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Created instance of " + className);
                }
                tagSource.setName(tagSourceName);
            }
            catch (Exception e) {
                LOG.error("Can't instantiate tagSource class for tagSourceName=" + tagSourceName + ", className=" + className + ", propertyPrefix=" + propPrefix, (Throwable)e);
            }
        }
        return tagSource;
    }

    public static boolean initializeKerberosIdentity(Properties props) {
        boolean ret;
        block13: {
            boolean isKerberized;
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> TagSynchronizer.initializeKerberosIdentity()");
            }
            ret = false;
            String authenticationType = TagSyncConfig.getAuthenticationType(props);
            String principal = TagSyncConfig.getKerberosPrincipal(props);
            String keytab = TagSyncConfig.getKerberosKeytab(props);
            String nameRules = TagSyncConfig.getNameRules(props);
            if (LOG.isDebugEnabled() && LOG.isDebugEnabled()) {
                LOG.debug("authenticationType=" + authenticationType);
                LOG.debug("principal=" + principal);
                LOG.debug("keytab" + keytab);
                LOG.debug("nameRules=" + nameRules);
            }
            boolean bl = isKerberized = !StringUtils.isEmpty((String)authenticationType) && authenticationType.trim().equalsIgnoreCase(AUTH_TYPE_KERBEROS);
            if (isKerberized) {
                LOG.info("Configured for Kerberos Authentication");
                if (SecureClientLogin.isKerberosCredentialExists((String)principal, (String)keytab)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Trying to get kerberos identity");
                    }
                    try {
                        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
                        UserGroupInformation kerberosIdentity = UserGroupInformation.getLoginUser();
                        if (kerberosIdentity != null) {
                            props.put("tagsync.kerberos.identity", kerberosIdentity.getUserName());
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Got UGI, user:[" + kerberosIdentity.getUserName() + "]");
                            }
                            ret = true;
                            break block13;
                        }
                        LOG.error("KerberosIdentity is null!");
                    }
                    catch (IOException exception) {
                        LOG.error("Failed to get UGI from principal:[" + principal + "], and keytab:[" + keytab + "]", (Throwable)exception);
                    }
                } else {
                    LOG.error("Invalid Kerberos principal and/or keytab specified. Failed to initialize Kerberos identity");
                }
            } else {
                LOG.info("Not configured for Kerberos Authentication");
                props.remove("tagsync.kerberos.identity");
                ret = true;
            }
        }
        if (!ret) {
            props.remove("tagsync.kerberos.identity");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== TagSynchronizer.initializeKerberosIdentity() : " + ret);
        }
        return ret;
    }

    private static String getStringProperty(Properties props, String propName) {
        String val;
        String ret = null;
        if (props != null && propName != null && (val = props.getProperty(propName)) != null) {
            ret = val;
        }
        return ret;
    }

    private static List<String> toArray(String destListStr, String delim) {
        ArrayList<String> list = new ArrayList<String>();
        if (destListStr != null && !destListStr.isEmpty()) {
            StringTokenizer tokenizer = new StringTokenizer(destListStr, delim.trim());
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
        }
        return list;
    }
}

