/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.model;

import com.google.gson.Gson;
import org.apache.ranger.plugin.util.ServiceTags;
import org.apache.ranger.tagsync.model.TagSink;
import org.apache.ranger.tagsync.model.TagSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTagSource
implements TagSource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTagSource.class);
    private TagSink tagSink;
    private String name;

    @Override
    public void setTagSink(TagSink sink) {
        if (sink == null) {
            LOG.error("Sink is null!!!");
        } else {
            this.tagSink = sink;
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    protected void updateSink(ServiceTags toUpload) throws Exception {
        if (toUpload == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No ServiceTags to upload");
            }
        } else {
            if (LOG.isDebugEnabled()) {
                String toUploadJSON = new Gson().toJson((Object)toUpload);
                LOG.debug("Uploading serviceTags=" + toUploadJSON);
            }
            try {
                ServiceTags uploaded = this.tagSink.upload(toUpload);
                if (LOG.isDebugEnabled()) {
                    String uploadedJSON = new Gson().toJson((Object)uploaded);
                    LOG.debug("Uploaded serviceTags=" + uploadedJSON);
                }
            }
            catch (Exception exception) {
                String toUploadJSON = new Gson().toJson((Object)toUpload);
                LOG.error("Failed to upload serviceTags: " + toUploadJSON);
                LOG.error("Exception : ", (Throwable)exception);
                throw exception;
            }
        }
    }
}

