/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsKMSUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.web.AuthFilterInitializer;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.ProxyUserAuthenticationFilterInitializer;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.protobuf.BlockingService;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DFSUtil {
    public static final Logger LOG = LoggerFactory.getLogger((String)DFSUtil.class.getName());
    private static final ThreadLocal<SecureRandom> SECURE_RANDOM = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return new SecureRandom();
        }
    };
    static final AddressMatcher LOCAL_ADDRESS_MATCHER = new AddressMatcher(){

        @Override
        public boolean match(InetSocketAddress s) {
            return NetUtils.isLocalAddress((InetAddress)s.getAddress());
        }
    };
    public static final Options helpOptions = new Options();
    public static final Option helpOpt = new Option("h", "help", false, "get help information");

    private DFSUtil() {
    }

    public static SecureRandom getSecureRandom() {
        return SECURE_RANDOM.get();
    }

    public static boolean isValidName(String src) {
        return DFSUtilClient.isValidName((String)src);
    }

    public static boolean isValidNameForComponent(String component) {
        if (component.equals(".") || component.equals("..") || component.indexOf(":") >= 0 || component.indexOf("/") >= 0) {
            return false;
        }
        return !DFSUtil.isReservedPathComponent(component);
    }

    public static boolean isReservedPathComponent(String component) {
        for (String reserved : HdfsServerConstants.RESERVED_PATH_COMPONENTS) {
            if (!component.equals(reserved)) continue;
            return true;
        }
        return false;
    }

    public static String bytes2String(byte[] bytes) {
        return DFSUtil.bytes2String(bytes, 0, bytes.length);
    }

    public static String bytes2String(byte[] bytes, int offset, int length) {
        return DFSUtilClient.bytes2String((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static byte[] string2Bytes(String str) {
        return DFSUtilClient.string2Bytes((String)str);
    }

    public static String byteArray2PathString(byte[][] components, int offset, int length) {
        boolean isAbsolute;
        int range = offset + length;
        Preconditions.checkPositionIndexes((int)offset, (int)range, (int)components.length);
        if (length == 0) {
            return "";
        }
        byte[] firstComponent = components[offset];
        boolean bl = isAbsolute = offset == 0 && (firstComponent == null || firstComponent.length == 0);
        if (offset == 0 && length == 1) {
            return isAbsolute ? "/" : DFSUtil.bytes2String(firstComponent);
        }
        int pos = isAbsolute ? 0 : firstComponent.length;
        int size = pos + length - 1;
        for (int i = offset + 1; i < range; ++i) {
            size += components[i].length;
        }
        byte[] result = new byte[size];
        if (!isAbsolute) {
            System.arraycopy(firstComponent, 0, result, 0, firstComponent.length);
        }
        for (int i = offset + 1; i < range; ++i) {
            result[pos++] = 47;
            int len = components[i].length;
            System.arraycopy(components[i], 0, result, pos, len);
            pos += len;
        }
        return DFSUtil.bytes2String(result);
    }

    public static String byteArray2PathString(byte[][] pathComponents) {
        return DFSUtil.byteArray2PathString(pathComponents, 0, pathComponents.length);
    }

    public static String strings2PathString(String[] components) {
        if (components.length == 0) {
            return "";
        }
        if (components.length == 1 && (components[0] == null || components[0].isEmpty())) {
            return "/";
        }
        return Joiner.on((String)"/").join((Object[])components);
    }

    public static String path2String(Object path) {
        return path == null ? null : (path instanceof String ? (String)path : (path instanceof byte[][] ? DFSUtil.byteArray2PathString((byte[][])path) : path.toString()));
    }

    public static byte[][] getPathComponents(String path) {
        byte[] bytes = DFSUtil.string2Bytes(path);
        return DFSUtilClient.bytes2byteArray((byte[])bytes, (int)bytes.length, (byte)47);
    }

    public static byte[][] bytes2byteArray(byte[] bytes, byte separator) {
        return DFSUtil.bytes2byteArray(bytes, bytes.length, separator);
    }

    public static byte[][] bytes2byteArray(byte[] bytes, int len, byte separator) {
        return DFSUtilClient.bytes2byteArray((byte[])bytes, (int)len, (byte)separator);
    }

    public static String addKeySuffixes(String key, String ... suffixes) {
        String keySuffix = DFSUtilClient.concatSuffixes((String[])suffixes);
        return DFSUtilClient.addSuffix((String)key, (String)keySuffix);
    }

    public static Map<String, InetSocketAddress> getRpcAddressesForNameserviceId(Configuration conf, String nsId, String defaultValue) {
        return DFSUtilClient.getAddressesForNameserviceId((Configuration)conf, (String)nsId, (String)defaultValue, (String[])new String[]{"dfs.namenode.rpc-address"});
    }

    public static Set<String> getAllNnPrincipals(Configuration conf) throws IOException {
        HashSet<String> principals = new HashSet<String>();
        for (String nsId : DFSUtilClient.getNameServiceIds((Configuration)conf)) {
            if (HAUtil.isHAEnabled(conf, nsId)) {
                for (String nnId : DFSUtilClient.getNameNodeIds((Configuration)conf, (String)nsId)) {
                    Configuration confForNn = new Configuration(conf);
                    NameNode.initializeGenericKeys(confForNn, nsId, nnId);
                    String principal = SecurityUtil.getServerPrincipal((String)confForNn.get("dfs.namenode.kerberos.principal"), (String)DFSUtilClient.getNNAddress((Configuration)confForNn).getHostName());
                    principals.add(principal);
                }
                continue;
            }
            Configuration confForNn = new Configuration(conf);
            NameNode.initializeGenericKeys(confForNn, nsId, null);
            String principal = SecurityUtil.getServerPrincipal((String)confForNn.get("dfs.namenode.kerberos.principal"), (String)DFSUtilClient.getNNAddress((Configuration)confForNn).getHostName());
            principals.add(principal);
        }
        return principals;
    }

    public static Set<String> getJournalNodeAddresses(Configuration conf) throws URISyntaxException, IOException {
        HashSet<String> journalNodeList;
        block13: {
            journalNodeList = new HashSet<String>();
            String journalsUri = "";
            try {
                journalsUri = conf.get("dfs.namenode.shared.edits.dir");
                if (journalsUri == null) {
                    Collection nameserviceIds = DFSUtilClient.getNameServiceIds((Configuration)conf);
                    for (String nsId : nameserviceIds) {
                        journalsUri = DFSUtilClient.getConfValue(null, (String)nsId, (Configuration)conf, (String[])new String[]{"dfs.namenode.shared.edits.dir"});
                        if (journalsUri == null) {
                            Collection nnIds = DFSUtilClient.getNameNodeIds((Configuration)conf, (String)nsId);
                            for (String nnId : nnIds) {
                                String suffix = DFSUtilClient.concatSuffixes((String[])new String[]{nsId, nnId});
                                journalsUri = DFSUtilClient.getConfValue(null, (String)suffix, (Configuration)conf, (String[])new String[]{"dfs.namenode.shared.edits.dir"});
                                if (journalsUri == null || !journalsUri.startsWith("qjournal://")) {
                                    return journalNodeList;
                                }
                                LOG.warn("dfs.namenode.shared.edits.dir is to be configured as nameservice specific key(append it with nameserviceId), no need to append it with namenodeId");
                                URI uri = new URI(journalsUri);
                                List<InetSocketAddress> socketAddresses = Util.getAddressesList(uri);
                                for (InetSocketAddress is : socketAddresses) {
                                    journalNodeList.add(is.getHostName());
                                }
                            }
                            continue;
                        }
                        if (!journalsUri.startsWith("qjournal://")) {
                            return journalNodeList;
                        }
                        URI uri = new URI(journalsUri);
                        List<InetSocketAddress> socketAddresses = Util.getAddressesList(uri);
                        for (InetSocketAddress is : socketAddresses) {
                            journalNodeList.add(is.getHostName());
                        }
                    }
                    break block13;
                }
                if (!journalsUri.startsWith("qjournal://")) {
                    return journalNodeList;
                }
                URI uri = new URI(journalsUri);
                List<InetSocketAddress> socketAddresses = Util.getAddressesList(uri);
                for (InetSocketAddress is : socketAddresses) {
                    journalNodeList.add(is.getHostName());
                }
            }
            catch (UnknownHostException e) {
                LOG.error("The conf property dfs.namenode.shared.edits.dir is not properly set with correct journal node hostnames");
                throw new UnknownHostException(journalsUri);
            }
            catch (URISyntaxException e) {
                LOG.error("The conf property dfs.namenode.shared.edits.diris not set properly with correct journal node uri");
                throw new URISyntaxException(journalsUri, "The conf property dfs.namenode.shared.edits.diris not properly set with correct journal node uri");
            }
        }
        return journalNodeList;
    }

    public static Map<String, Map<String, InetSocketAddress>> getBackupNodeAddresses(Configuration conf) throws IOException {
        Map addressList = DFSUtilClient.getAddresses((Configuration)conf, null, (String[])new String[]{"dfs.namenode.backup.address"});
        if (addressList.isEmpty()) {
            throw new IOException("Incorrect configuration: backup node address dfs.namenode.backup.address is not configured.");
        }
        return addressList;
    }

    public static Map<String, Map<String, InetSocketAddress>> getSecondaryNameNodeAddresses(Configuration conf) throws IOException {
        Map addressList = DFSUtilClient.getAddresses((Configuration)conf, null, (String[])new String[]{"dfs.namenode.secondary.http-address"});
        if (addressList.isEmpty()) {
            throw new IOException("Incorrect configuration: secondary namenode address dfs.namenode.secondary.http-address is not configured.");
        }
        return addressList;
    }

    public static Map<String, Map<String, InetSocketAddress>> getNNServiceRpcAddresses(Configuration conf) throws IOException {
        String defaultAddress;
        try {
            defaultAddress = NetUtils.getHostPortString((InetSocketAddress)DFSUtilClient.getNNAddress((Configuration)conf));
        }
        catch (IllegalArgumentException e) {
            defaultAddress = null;
        }
        Map addressList = DFSUtilClient.getAddresses((Configuration)conf, (String)defaultAddress, (String[])new String[]{"dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address"});
        if (addressList.isEmpty()) {
            throw new IOException("Incorrect configuration: namenode address dfs.namenode.servicerpc-address or dfs.namenode.rpc-address is not configured.");
        }
        return addressList;
    }

    public static Map<String, Map<String, InetSocketAddress>> getNNServiceRpcAddressesForCluster(Configuration conf) throws IOException {
        String defaultAddress;
        try {
            defaultAddress = NetUtils.getHostPortString((InetSocketAddress)DFSUtilClient.getNNAddress((Configuration)conf));
        }
        catch (IllegalArgumentException e) {
            defaultAddress = null;
        }
        Collection parentNameServices = conf.getTrimmedStringCollection("dfs.internal.nameservices");
        if (parentNameServices.isEmpty()) {
            parentNameServices = conf.getTrimmedStringCollection("dfs.nameservices");
        } else {
            HashSet availableNameServices = Sets.newHashSet((Iterable)conf.getTrimmedStringCollection("dfs.nameservices"));
            for (String nsId : parentNameServices) {
                if (availableNameServices.contains(nsId)) continue;
                throw new IOException("Unknown nameservice: " + nsId);
            }
        }
        Map addressList = DFSUtilClient.getAddressesForNsIds((Configuration)conf, (Collection)parentNameServices, (String)defaultAddress, (String[])new String[]{"dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address"});
        if (addressList.isEmpty()) {
            throw new IOException("Incorrect configuration: namenode address dfs.namenode.servicerpc-address." + parentNameServices + " or " + "dfs.namenode.rpc-address" + "." + parentNameServices + " is not configured.");
        }
        return addressList;
    }

    public static Map<String, Map<String, InetSocketAddress>> getNNLifelineRpcAddressesForCluster(Configuration conf) throws IOException {
        Collection parentNameServices = conf.getTrimmedStringCollection("dfs.internal.nameservices");
        if (parentNameServices.isEmpty()) {
            parentNameServices = conf.getTrimmedStringCollection("dfs.nameservices");
        } else {
            HashSet availableNameServices = Sets.newHashSet((Iterable)conf.getTrimmedStringCollection("dfs.nameservices"));
            for (String nsId : parentNameServices) {
                if (availableNameServices.contains(nsId)) continue;
                throw new IOException("Unknown nameservice: " + nsId);
            }
        }
        return DFSUtilClient.getAddressesForNsIds((Configuration)conf, (Collection)parentNameServices, null, (String[])new String[]{"dfs.namenode.lifeline.rpc-address"});
    }

    public static String getNamenodeLifelineAddr(Configuration conf, String nsId, String nnId) {
        if (nsId == null) {
            nsId = DFSUtil.getOnlyNameServiceIdOrNull(conf);
        }
        String lifelineAddrKey = DFSUtilClient.concatSuffixes((String[])new String[]{"dfs.namenode.lifeline.rpc-address", nsId, nnId});
        return conf.get(lifelineAddrKey);
    }

    public static List<ConfiguredNNAddress> flattenAddressMap(Map<String, Map<String, InetSocketAddress>> map) {
        ArrayList ret = Lists.newArrayList();
        for (Map.Entry<String, Map<String, InetSocketAddress>> entry : map.entrySet()) {
            String nsId = entry.getKey();
            Map<String, InetSocketAddress> nnMap = entry.getValue();
            for (Map.Entry<String, InetSocketAddress> e2 : nnMap.entrySet()) {
                String nnId = e2.getKey();
                InetSocketAddress addr = e2.getValue();
                ret.add(new ConfiguredNNAddress(nsId, nnId, addr));
            }
        }
        return ret;
    }

    public static String addressMapToString(Map<String, Map<String, InetSocketAddress>> map) {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, Map<String, InetSocketAddress>> entry : map.entrySet()) {
            String nsId = entry.getKey();
            Map<String, InetSocketAddress> nnMap = entry.getValue();
            b.append("Nameservice <").append(nsId).append(">:").append("\n");
            for (Map.Entry<String, InetSocketAddress> e2 : nnMap.entrySet()) {
                b.append("  NN ID ").append(e2.getKey()).append(" => ").append(e2.getValue()).append("\n");
            }
        }
        return b.toString();
    }

    public static String nnAddressesAsString(Configuration conf) {
        Map addresses = DFSUtilClient.getHaNnRpcAddresses((Configuration)conf);
        return DFSUtil.addressMapToString(addresses);
    }

    static Collection<String> getInternalNameServices(Configuration conf) {
        Collection ids = conf.getTrimmedStringCollection("dfs.internal.nameservices");
        return !ids.isEmpty() ? ids : DFSUtilClient.getNameServiceIds((Configuration)conf);
    }

    public static Collection<URI> getInternalNsRpcUris(Configuration conf) {
        return DFSUtil.getNameServiceUris(conf, DFSUtil.getInternalNameServices(conf), "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
    }

    /*
     * WARNING - void declaration
     */
    static Collection<URI> getNameServiceUris(Configuration conf, Collection<String> nameServices, String ... keys) {
        URI uRI;
        HashSet<URI> ret = new HashSet<URI>();
        HashSet<URI> nonPreferredUris = new HashSet<URI>();
        for (String string : nameServices) {
            URI nsUri = DFSUtil.createUri("hdfs", string, -1);
            boolean useLogicalUri = false;
            try {
                useLogicalUri = HAUtil.useLogicalUri(conf, nsUri);
            }
            catch (IOException e) {
                LOG.warn("Getting exception  while trying to determine if nameservice " + string + " can use logical URI: " + e);
            }
            if (HAUtil.isHAEnabled(conf, string) && useLogicalUri) {
                ret.add(nsUri);
                continue;
            }
            boolean uriFound = false;
            for (String key : keys) {
                String addr = conf.get(DFSUtilClient.concatSuffixes((String[])new String[]{key, string}));
                if (addr == null) continue;
                URI uri = DFSUtil.createUri("hdfs", NetUtils.createSocketAddr((String)addr));
                if (!uriFound) {
                    uriFound = true;
                    ret.add(uri);
                    continue;
                }
                nonPreferredUris.add(uri);
            }
        }
        boolean uriFound = false;
        for (String key : keys) {
            String addr = conf.get(key);
            if (addr == null) continue;
            URI uri = DFSUtil.createUri("hdfs", NetUtils.createSocketAddr((String)addr));
            if (!uriFound) {
                uriFound = true;
                ret.add(uri);
                continue;
            }
            nonPreferredUris.add(uri);
        }
        if (!uriFound && (uRI = FileSystem.getDefaultUri((Configuration)conf)) != null) {
            void var6_11;
            URI uRI2;
            if (uRI.getPort() != -1) {
                URI uRI3 = DFSUtil.createUri(uRI.getScheme(), NetUtils.createSocketAddr((String)uRI.getHost(), (int)uRI.getPort()));
            }
            if ("hdfs".equals((uRI2 = DFSUtil.trimUri((URI)var6_11)).getScheme()) && !nonPreferredUris.contains(uRI2)) {
                ret.add(uRI2);
            }
        }
        return ret;
    }

    public static String getNameServiceIdFromAddress(Configuration conf, InetSocketAddress address, String ... keys) {
        String[] ids = DFSUtil.getSuffixIDs(conf, address, keys);
        return ids != null ? ids[0] : null;
    }

    public static URI getInfoServer(InetSocketAddress namenodeAddr, Configuration conf, String scheme) throws IOException {
        String authority;
        String[] suffixes = null;
        if (namenodeAddr != null) {
            suffixes = DFSUtil.getSuffixIDs(conf, namenodeAddr, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
        }
        if ("http".equals(scheme)) {
            authority = DFSUtil.getSuffixedConf(conf, "dfs.namenode.http-address", "0.0.0.0:9870", suffixes);
        } else if ("https".equals(scheme)) {
            authority = DFSUtil.getSuffixedConf(conf, "dfs.namenode.https-address", "0.0.0.0:9871", suffixes);
        } else {
            throw new IllegalArgumentException("Invalid scheme:" + scheme);
        }
        if (namenodeAddr != null) {
            authority = DFSUtil.substituteForWildcardAddress(authority, namenodeAddr.getHostName());
        }
        return URI.create(scheme + "://" + authority);
    }

    public static URI getInfoServerWithDefaultHost(String defaultHost, Configuration conf, String scheme) throws IOException {
        URI configuredAddr = DFSUtil.getInfoServer(null, conf, scheme);
        String authority = DFSUtil.substituteForWildcardAddress(configuredAddr.getAuthority(), defaultHost);
        return URI.create(scheme + "://" + authority);
    }

    public static String getHttpClientScheme(Configuration conf) {
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(conf);
        return policy == HttpConfig.Policy.HTTPS_ONLY ? "https" : "http";
    }

    @VisibleForTesting
    static String substituteForWildcardAddress(String configuredAddress, String defaultHost) {
        InetSocketAddress sockAddr = NetUtils.createSocketAddr((String)configuredAddress);
        InetAddress addr = sockAddr.getAddress();
        if (addr != null && addr.isAnyLocalAddress()) {
            return defaultHost + ":" + sockAddr.getPort();
        }
        return configuredAddress;
    }

    private static String getSuffixedConf(Configuration conf, String key, String defaultVal, String[] suffixes) {
        String ret = conf.get(DFSUtil.addKeySuffixes(key, suffixes));
        if (ret != null) {
            return ret;
        }
        return conf.get(key, defaultVal);
    }

    public static void setGenericConf(Configuration conf, String nameserviceId, String nnId, String ... keys) {
        for (String key : keys) {
            String value = conf.get(DFSUtil.addKeySuffixes(key, nameserviceId, nnId));
            if (value != null) {
                conf.set(key, value);
                continue;
            }
            value = conf.get(DFSUtil.addKeySuffixes(key, nameserviceId));
            if (value == null) continue;
            conf.set(key, value);
        }
    }

    public static int roundBytesToGB(long bytes) {
        return Math.round((float)bytes / 1024.0f / 1024.0f / 1024.0f);
    }

    public static String getNamenodeNameServiceId(Configuration conf) {
        return DFSUtil.getNameServiceId(conf, "dfs.namenode.rpc-address");
    }

    public static String getBackupNameServiceId(Configuration conf) {
        return DFSUtil.getNameServiceId(conf, "dfs.namenode.backup.address");
    }

    public static String getSecondaryNameServiceId(Configuration conf) {
        return DFSUtil.getNameServiceId(conf, "dfs.namenode.secondary.http-address");
    }

    private static String getNameServiceId(Configuration conf, String addressKey) {
        String nameserviceId = conf.get("dfs.nameservice.id");
        if (nameserviceId != null) {
            return nameserviceId;
        }
        Collection nsIds = DFSUtilClient.getNameServiceIds((Configuration)conf);
        if (1 == nsIds.size()) {
            return nsIds.toArray(new String[1])[0];
        }
        String nnId = conf.get("dfs.ha.namenode.id");
        return DFSUtil.getSuffixIDs(conf, addressKey, null, nnId, LOCAL_ADDRESS_MATCHER)[0];
    }

    public static InetSocketAddress getBindAddress(Configuration conf, String confKey, String defaultValue, String bindHostKey) {
        String bindHostActualKey;
        InetSocketAddress address;
        String nsId = DFSUtil.getNamenodeNameServiceId(conf);
        if (nsId != null) {
            String namenodeId = HAUtil.getNameNodeId(conf, nsId);
            address = (InetSocketAddress)DFSUtilClient.getAddressesForNameserviceId((Configuration)conf, (String)nsId, null, (String[])new String[]{confKey}).get(namenodeId);
            bindHostActualKey = DFSUtil.addKeySuffixes(bindHostKey, nsId, namenodeId);
        } else {
            address = NetUtils.createSocketAddr((String)conf.get(confKey, defaultValue));
            bindHostActualKey = bindHostKey;
        }
        String bindHost = conf.get(bindHostActualKey);
        if (bindHost == null || bindHost.isEmpty()) {
            bindHost = address.getHostName();
        }
        return new InetSocketAddress(bindHost, address.getPort());
    }

    static String[] getSuffixIDs(Configuration conf, String addressKey, String knownNsId, String knownNNId, AddressMatcher matcher) {
        String nameserviceId = null;
        String namenodeId = null;
        int found = 0;
        Collection nsIds = DFSUtilClient.getNameServiceIds((Configuration)conf);
        for (String nsId : DFSUtilClient.emptyAsSingletonNull((Collection)nsIds)) {
            if (knownNsId != null && !knownNsId.equals(nsId)) continue;
            Collection nnIds = DFSUtilClient.getNameNodeIds((Configuration)conf, (String)nsId);
            for (String nnId : DFSUtilClient.emptyAsSingletonNull((Collection)nnIds)) {
                String key;
                String addr;
                if (LOG.isTraceEnabled()) {
                    LOG.trace(String.format("addressKey: %s nsId: %s nnId: %s", addressKey, nsId, nnId));
                }
                if (knownNNId != null && !knownNNId.equals(nnId) || (addr = conf.get(key = DFSUtil.addKeySuffixes(addressKey, nsId, nnId))) == null) continue;
                InetSocketAddress s = null;
                try {
                    s = NetUtils.createSocketAddr((String)addr);
                }
                catch (Exception e) {
                    LOG.warn("Exception in creating socket address " + addr, (Throwable)e);
                    continue;
                }
                if (s.isUnresolved() || !matcher.match(s)) continue;
                nameserviceId = nsId;
                namenodeId = nnId;
                ++found;
            }
        }
        if (found > 1) {
            String msg = "Configuration has multiple addresses that match local node's address. Please configure the system with dfs.nameservice.id and dfs.ha.namenode.id";
            throw new HadoopIllegalArgumentException(msg);
        }
        return new String[]{nameserviceId, namenodeId};
    }

    static String[] getSuffixIDs(Configuration conf, final InetSocketAddress address, String ... keys) {
        AddressMatcher matcher = new AddressMatcher(){

            @Override
            public boolean match(InetSocketAddress s) {
                return address.equals(s);
            }
        };
        for (String key : keys) {
            String[] ids = DFSUtil.getSuffixIDs(conf, key, null, null, matcher);
            if (ids == null || ids[0] == null && ids[1] == null) continue;
            return ids;
        }
        return null;
    }

    public static URI createUri(String scheme, InetSocketAddress address) {
        return DFSUtil.createUri(scheme, address.getHostName(), address.getPort());
    }

    public static URI createUri(String scheme, String host, int port) {
        try {
            return new URI(scheme, null, host, port, null, null, null);
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x.getMessage(), x);
        }
    }

    static URI trimUri(URI uri) {
        String path = uri.getPath();
        if ("hdfs".equals(uri.getScheme()) && path != null && !path.isEmpty()) {
            uri = DFSUtil.createUri(uri.getScheme(), uri.getHost(), uri.getPort());
        }
        return uri;
    }

    public static void addPBProtocol(Configuration conf, Class<?> protocol, BlockingService service, RPC.Server server) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, protocol, ProtobufRpcEngine2.class);
        server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, protocol, (Object)service);
    }

    @Deprecated
    public static void addPBProtocol(Configuration conf, Class<?> protocol, com.google.protobuf.BlockingService service, RPC.Server server) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, protocol, ProtobufRpcEngine.class);
        server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, protocol, (Object)service);
    }

    public static String getNamenodeServiceAddr(Configuration conf, String nsId, String nnId) {
        if (nsId == null) {
            nsId = DFSUtil.getOnlyNameServiceIdOrNull(conf);
        }
        String serviceAddrKey = DFSUtilClient.concatSuffixes((String[])new String[]{"dfs.namenode.servicerpc-address", nsId, nnId});
        String addrKey = DFSUtilClient.concatSuffixes((String[])new String[]{"dfs.namenode.rpc-address", nsId, nnId});
        String serviceRpcAddr = conf.get(serviceAddrKey);
        if (serviceRpcAddr == null) {
            serviceRpcAddr = conf.get(addrKey);
        }
        return serviceRpcAddr;
    }

    public static String getNamenodeWebAddr(Configuration conf, String nsId, String nnId) {
        if (nsId == null) {
            nsId = DFSUtil.getOnlyNameServiceIdOrNull(conf);
        }
        String webAddrBaseKey = "dfs.namenode.http-address";
        String webAddrDefault = "0.0.0.0:9870";
        if (DFSUtil.getHttpPolicy(conf) == HttpConfig.Policy.HTTPS_ONLY) {
            webAddrBaseKey = "dfs.namenode.https-address";
            webAddrDefault = "0.0.0.0:9871";
        }
        String webAddrKey = DFSUtilClient.concatSuffixes((String[])new String[]{webAddrBaseKey, nsId, nnId});
        String webAddr = conf.get(webAddrKey, webAddrDefault);
        return webAddr;
    }

    public static Map<String, InetSocketAddress> getWebAddressesForNameserviceId(Configuration conf, String nsId, String defaultValue) {
        return DFSUtilClient.getAddressesForNameserviceId((Configuration)conf, (String)nsId, (String)defaultValue, (String[])new String[]{"dfs.namenode.http-address"});
    }

    public static String getOnlyNameServiceIdOrNull(Configuration conf) {
        Collection nsIds = DFSUtilClient.getNameServiceIds((Configuration)conf);
        if (1 == nsIds.size()) {
            return nsIds.toArray(new String[1])[0];
        }
        return null;
    }

    public static boolean parseHelpArgument(String[] args, String helpDescription, PrintStream out, boolean printGenericCommandUsage) {
        if (args.length == 1) {
            try {
                PosixParser parser = new PosixParser();
                CommandLine cmdLine = parser.parse(helpOptions, args);
                if (cmdLine.hasOption(helpOpt.getOpt()) || cmdLine.hasOption(helpOpt.getLongOpt())) {
                    out.println(helpDescription + "\n");
                    if (printGenericCommandUsage) {
                        ToolRunner.printGenericCommandUsage((PrintStream)out);
                    }
                    return true;
                }
            }
            catch (ParseException pe) {
                return false;
            }
        }
        return false;
    }

    public static float getInvalidateWorkPctPerIteration(Configuration conf) {
        float blocksInvalidateWorkPct = conf.getFloat("dfs.namenode.invalidate.work.pct.per.iteration", 0.32f);
        Preconditions.checkArgument((blocksInvalidateWorkPct > 0.0f && blocksInvalidateWorkPct <= 1.0f ? 1 : 0) != 0, (Object)("dfs.namenode.invalidate.work.pct.per.iteration = '" + blocksInvalidateWorkPct + "' is invalid. It should be a positive, non-zero float value, not greater than 1.0f, to indicate a percentage."));
        return blocksInvalidateWorkPct;
    }

    public static int getReplWorkMultiplier(Configuration conf) {
        int blocksReplWorkMultiplier = conf.getInt("dfs.namenode.replication.work.multiplier.per.iteration", 2);
        Preconditions.checkArgument((blocksReplWorkMultiplier > 0 ? 1 : 0) != 0, (Object)("dfs.namenode.replication.work.multiplier.per.iteration = '" + blocksReplWorkMultiplier + "' is invalid. It should be a positive, non-zero integer value."));
        return blocksReplWorkMultiplier;
    }

    public static String getSpnegoKeytabKey(Configuration conf, String defaultKey) {
        String value = conf.get("dfs.web.authentication.kerberos.keytab");
        return value == null || value.isEmpty() ? defaultKey : "dfs.web.authentication.kerberos.keytab";
    }

    public static HttpConfig.Policy getHttpPolicy(Configuration conf) {
        String policyStr = conf.get("dfs.http.policy", DFSConfigKeys.DFS_HTTP_POLICY_DEFAULT);
        HttpConfig.Policy policy = HttpConfig.Policy.fromString((String)policyStr);
        if (policy == null) {
            throw new HadoopIllegalArgumentException("Unrecognized value '" + policyStr + "' for " + "dfs.http.policy");
        }
        conf.set("dfs.http.policy", policy.name());
        return policy;
    }

    public static HttpServer2.Builder loadSslConfToHttpServerBuilder(HttpServer2.Builder builder, Configuration sslConf) {
        return builder.needsClientAuth(sslConf.getBoolean("dfs.client.https.need-auth", false)).keyPassword(DFSUtil.getPassword(sslConf, "ssl.server.keystore.keypassword")).keyStore(sslConf.get("ssl.server.keystore.location"), DFSUtil.getPassword(sslConf, "ssl.server.keystore.password"), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), DFSUtil.getPassword(sslConf, "ssl.server.truststore.password"), sslConf.get("ssl.server.truststore.type", "jks")).excludeCiphers(sslConf.get("ssl.server.exclude.cipher.list"));
    }

    static String getPassword(Configuration conf, String alias) {
        String password = null;
        try {
            char[] passchars = conf.getPassword(alias);
            if (passchars != null) {
                password = new String(passchars);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Setting password to null since IOException is caught when getting password", (Throwable)ioe);
            password = null;
        }
        return password;
    }

    public static String dateToIso8601String(Date date) {
        return DFSUtilClient.dateToIso8601String((Date)date);
    }

    public static String durationToString(long durationMs) {
        return DFSUtilClient.durationToString((long)durationMs);
    }

    public static long parseRelativeTime(String relTime) throws IOException {
        long ttl;
        if (relTime.length() < 2) {
            throw new IOException("Unable to parse relative time value of " + relTime + ": too short");
        }
        String ttlString = relTime.substring(0, relTime.length() - 1);
        try {
            ttl = Long.parseLong(ttlString);
        }
        catch (NumberFormatException e) {
            throw new IOException("Unable to parse relative time value of " + relTime + ": " + ttlString + " is not a number");
        }
        if (!relTime.endsWith("s")) {
            if (relTime.endsWith("m")) {
                ttl *= 60L;
            } else if (relTime.endsWith("h")) {
                ttl *= 3600L;
            } else if (relTime.endsWith("d")) {
                ttl *= 86400L;
            } else {
                throw new IOException("Unable to parse relative time value of " + relTime + ": unknown time unit " + relTime.charAt(relTime.length() - 1));
            }
        }
        return ttl * 1000L;
    }

    public static Configuration loadSslConfiguration(Configuration conf) {
        String[] reqSslProps;
        Configuration sslConf = new Configuration(false);
        sslConf.addResource(conf.get("dfs.https.server.keystore.resource", "ssl-server.xml"));
        for (String sslProp : reqSslProps = new String[]{"ssl.server.truststore.location", "ssl.server.keystore.location", "ssl.server.keystore.password", "ssl.server.keystore.keypassword"}) {
            if (sslConf.get(sslProp) != null) continue;
            LOG.warn("SSL config " + sslProp + " is missing. If " + "dfs.https.server.keystore.resource" + " is specified, make sure it is a relative path");
        }
        boolean requireClientAuth = conf.getBoolean("dfs.client.https.need-auth", false);
        sslConf.setBoolean("dfs.client.https.need-auth", requireClientAuth);
        return sslConf;
    }

    public static HttpServer2.Builder httpServerTemplateForNNAndJN(Configuration conf, InetSocketAddress httpAddr, InetSocketAddress httpsAddr, String name, String spnegoUserNameKey, String spnegoKeytabFileKey) throws IOException {
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(conf);
        String filterInitializerConfKey = "hadoop.http.filter.initializers";
        String initializers = conf.get(filterInitializerConfKey, "");
        String[] parts = initializers.split(",");
        LinkedHashSet<String> target = new LinkedHashSet<String>();
        for (String filterInitializer : parts) {
            if ((filterInitializer = filterInitializer.trim()).equals(AuthenticationFilterInitializer.class.getName()) || filterInitializer.equals(ProxyUserAuthenticationFilterInitializer.class.getName()) || filterInitializer.isEmpty()) continue;
            target.add(filterInitializer);
        }
        target.add(AuthFilterInitializer.class.getName());
        initializers = StringUtils.join(target, (String)",");
        conf.set(filterInitializerConfKey, initializers);
        LOG.info("Filter initializers set : " + initializers);
        HttpServer2.Builder builder = new HttpServer2.Builder().setName(name).setConf(conf).setACL(new AccessControlList(conf.get("dfs.cluster.administrators", " "))).setSecurityEnabled(UserGroupInformation.isSecurityEnabled()).setUsernameConfKey(spnegoUserNameKey).setKeytabConfKey(DFSUtil.getSpnegoKeytabKey(conf, spnegoKeytabFileKey));
        if (UserGroupInformation.isSecurityEnabled()) {
            LOG.info("Starting web server as: " + SecurityUtil.getServerPrincipal((String)conf.get(spnegoUserNameKey), (String)httpAddr.getHostName()));
        }
        if (policy.isHttpEnabled()) {
            if (httpAddr.getPort() == 0) {
                builder.setFindPort(true);
            }
            URI uri = URI.create("http://" + NetUtils.getHostPortString((InetSocketAddress)httpAddr));
            builder.addEndpoint(uri);
            LOG.info("Starting Web-server for " + name + " at: " + uri);
        }
        if (policy.isHttpsEnabled() && httpsAddr != null) {
            Configuration sslConf = DFSUtil.loadSslConfiguration(conf);
            DFSUtil.loadSslConfToHttpServerBuilder(builder, sslConf);
            if (httpsAddr.getPort() == 0) {
                builder.setFindPort(true);
            }
            URI uri = URI.create("https://" + NetUtils.getHostPortString((InetSocketAddress)httpsAddr));
            builder.addEndpoint(uri);
            LOG.info("Starting Web-server for " + name + " at: " + uri);
        }
        return builder;
    }

    public static void assertAllResultsEqual(Collection<?> objects) throws AssertionError {
        if (objects.size() == 0 || objects.size() == 1) {
            return;
        }
        Object[] resultsArray = objects.toArray();
        for (int i = 1; i < resultsArray.length; ++i) {
            Object currElement = resultsArray[i];
            Object lastElement = resultsArray[i - 1];
            if (currElement == null && currElement != lastElement || currElement != null && !currElement.equals(lastElement)) {
                throw new AssertionError((Object)("Not all elements match in results: " + Arrays.toString(resultsArray)));
            }
        }
    }

    public static KeyProviderCryptoExtension createKeyProviderCryptoExtension(Configuration conf) throws IOException {
        KeyProvider keyProvider = HdfsKMSUtil.createKeyProvider((Configuration)conf);
        if (keyProvider == null) {
            return null;
        }
        KeyProviderCryptoExtension cryptoProvider = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)keyProvider);
        return cryptoProvider;
    }

    public static DelegationTokenIdentifier decodeDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        DelegationTokenIdentifier id = new DelegationTokenIdentifier();
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        try (DataInputStream in = new DataInputStream(buf);){
            id.readFields((DataInput)in);
        }
        return id;
    }

    public static void checkProtectedDescendants(FSDirectory fsd, INodesInPath iip) throws AccessControlException, UnresolvedLinkException, ParentNotDirectoryException {
        SortedSet<String> protectedDirs = fsd.getProtectedDirectories();
        if (protectedDirs.isEmpty()) {
            return;
        }
        String src = iip.getPath();
        if (protectedDirs.contains(src)) {
            throw new AccessControlException("Cannot delete/rename non-empty protected directory " + src);
        }
        for (String descendant : protectedDirs.subSet(src + "/", src + "0")) {
            INodesInPath subdirIIP = fsd.getINodesInPath(descendant, FSDirectory.DirOp.WRITE);
            if (!fsd.isNonEmptyDirectory(subdirIIP)) continue;
            throw new AccessControlException("Cannot delete/rename non-empty protected subdirectory " + descendant);
        }
    }

    public static EnumSet<HdfsFileStatus.Flags> getFlags(boolean isEncrypted, boolean isErasureCoded, boolean isSnapShottable, boolean hasAcl) {
        EnumSet<HdfsFileStatus.Flags> flags = EnumSet.noneOf(HdfsFileStatus.Flags.class);
        if (hasAcl) {
            flags.add(HdfsFileStatus.Flags.HAS_ACL);
        }
        if (isEncrypted) {
            flags.add(HdfsFileStatus.Flags.HAS_CRYPT);
        }
        if (isErasureCoded) {
            flags.add(HdfsFileStatus.Flags.HAS_EC);
        }
        if (isSnapShottable) {
            flags.add(HdfsFileStatus.Flags.SNAPSHOT_ENABLED);
        }
        return flags;
    }

    public static boolean isParentEntry(String path, String parent) {
        if (!path.startsWith(parent)) {
            return false;
        }
        if (path.equals(parent)) {
            return true;
        }
        return path.charAt(parent.length()) == '/' || parent.equals("/");
    }

    static {
        helpOptions.addOption(helpOpt);
    }

    private static interface AddressMatcher {
        public boolean match(InetSocketAddress var1);
    }

    public static class ConfiguredNNAddress {
        private final String nameserviceId;
        private final String namenodeId;
        private final InetSocketAddress addr;

        private ConfiguredNNAddress(String nameserviceId, String namenodeId, InetSocketAddress addr) {
            this.nameserviceId = nameserviceId;
            this.namenodeId = namenodeId;
            this.addr = addr;
        }

        public String getNameserviceId() {
            return this.nameserviceId;
        }

        public String getNamenodeId() {
            return this.namenodeId;
        }

        public InetSocketAddress getAddress() {
            return this.addr;
        }

        public String toString() {
            return "ConfiguredNNAddress[nsId=" + this.nameserviceId + ";nnId=" + this.namenodeId + ";addr=" + this.addr + "]";
        }
    }

    @InterfaceAudience.Private
    public static class ServiceAndStaleComparator
    extends ServiceComparator {
        private final long staleInterval;

        public ServiceAndStaleComparator(long interval) {
            this.staleInterval = interval;
        }

        @Override
        public int compare(DatanodeInfo a, DatanodeInfo b) {
            boolean bStale;
            int ret = super.compare(a, b);
            if (ret != 0) {
                return ret;
            }
            boolean aStale = a.isStale(this.staleInterval);
            return aStale == (bStale = b.isStale(this.staleInterval)) ? 0 : (aStale ? 1 : -1);
        }
    }

    public static class ServiceComparator
    implements Comparator<DatanodeInfo> {
        @Override
        public int compare(DatanodeInfo a, DatanodeInfo b) {
            if (a.isDecommissioned()) {
                return b.isDecommissioned() ? 0 : 1;
            }
            if (b.isDecommissioned()) {
                return -1;
            }
            if (a.isEnteringMaintenance()) {
                return b.isEnteringMaintenance() ? 0 : 1;
            }
            if (b.isEnteringMaintenance()) {
                return -1;
            }
            return 0;
        }
    }
}

