/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsDeletingByParent;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsGettingById;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsGettingByParent;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.SupportsListingByParent;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.models.IndependentChild;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.collection.SupportsDeletingById;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;

@LangDefinition
public abstract class IndependentChildrenImpl<T extends IndependentChild<ManagerT>, ImplT extends T, InnerT, InnerCollectionT, ManagerT extends ManagerBase, ParentT extends Resource & HasResourceGroup>
extends CreatableResourcesImpl<T, ImplT, InnerT>
implements SupportsGettingById<T>,
SupportsGettingByParent<T, ParentT, ManagerT>,
SupportsListingByParent<T, ParentT, ManagerT>,
SupportsDeletingById,
SupportsDeletingByParent,
HasManager<ManagerT>,
HasInner<InnerCollectionT> {
    protected final InnerCollectionT innerCollection;
    protected final ManagerT manager;

    protected IndependentChildrenImpl(InnerCollectionT innerCollection, ManagerT manager) {
        this.innerCollection = innerCollection;
        this.manager = manager;
    }

    @Override
    public InnerCollectionT inner() {
        return this.innerCollection;
    }

    @Override
    public T getByParent(String resourceGroup, String parentName, String name) {
        return (T)((IndependentChild)this.getByParentAsync(resourceGroup, parentName, name).toBlocking().last());
    }

    @Override
    public T getByParent(ParentT parentResource, String name) {
        return (T)((IndependentChild)this.getByParentAsync(parentResource, name).toBlocking().last());
    }

    @Override
    public Observable<T> getByParentAsync(ParentT parentResource, String name) {
        return this.getByParentAsync(((HasResourceGroup)parentResource).resourceGroupName(), parentResource.name(), name);
    }

    @Override
    public T getById(String id) {
        return (T)((IndependentChild)this.getByIdAsync(id).toBlocking().last());
    }

    @Override
    public Observable<T> getByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString(id);
        if (resourceId == null) {
            return null;
        }
        return this.getByParentAsync(resourceId.resourceGroupName(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public ServiceFuture<T> getByIdAsync(String id, ServiceCallback<T> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    @Override
    public PagedList<T> listByParent(ParentT parentResource) {
        return this.listByParent(((HasResourceGroup)parentResource).resourceGroupName(), parentResource.name());
    }

    @Override
    public void deleteByParent(String groupName, String parentName, String name) {
        this.deleteByParentAsync(groupName, parentName, name).await();
    }

    @Override
    public ServiceFuture<Void> deleteByParentAsync(String groupName, String parentName, String name, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.deleteByParentAsync(groupName, parentName, name), callback);
    }

    @Override
    public Completable deleteByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString(id);
        return this.deleteByParentAsync(resourceId.resourceGroupName(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public ManagerT manager() {
        return this.manager;
    }
}

