/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.kafka.authorizer;

import java.util.Map;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Operation;
import kafka.security.auth.Resource;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.immutable.Set;

public class RangerKafkaAuthorizer
implements Authorizer {
    private static final Logger LOG = LoggerFactory.getLogger(RangerKafkaAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "kafka";
    private static final String RANGER_KAFKA_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.kafka.authorizer.RangerKafkaAuthorizer";
    private Authorizer rangerKakfaAuthorizerImpl = null;
    private RangerPluginClassLoader rangerPluginClassLoader = null;

    public RangerKafkaAuthorizer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKafkaAuthorizer.RangerKafkaAuthorizer()");
        }
        this.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKafkaAuthorizer.RangerKafkaAuthorizer()");
        }
    }

    private void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKafkaAuthorizer.init()");
        }
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_KAFKA_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.rangerKakfaAuthorizerImpl = (Authorizer)cls.newInstance();
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerKafkaPlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKafkaAuthorizer.init()");
        }
    }

    public void configure(Map<String, ?> configs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKafkaAuthorizer.configure(Map<String, ?>)");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerKakfaAuthorizerImpl.configure(configs);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKafkaAuthorizer.configure(Map<String, ?>)");
        }
    }

    public void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKafkaAuthorizer.close()");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerKakfaAuthorizerImpl.close();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKafkaAuthorizer.close()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authorize(RequestChannel.Session session, Operation operation, Resource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerKafkaAuthorizer.authorize(Session=%s, Operation=%s, Resource=%s)", session, operation, resource));
        }
        boolean ret = false;
        try {
            this.activatePluginClassLoader();
            ret = this.rangerKakfaAuthorizerImpl.authorize(session, operation, resource);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKafkaAuthorizer.authorize: " + ret);
        }
        return ret;
    }

    public void addAcls(Set<Acl> acls, Resource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKafkaAuthorizer.addAcls(Set<Acl>, Resource)");
        }
        try {
            this.activatePluginClassLoader();
            this.rangerKakfaAuthorizerImpl.addAcls(acls, resource);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKafkaAuthorizer.addAcls(Set<Acl>, Resource)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAcls(Set<Acl> acls, Resource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKafkaAuthorizer.removeAcls(Set<Acl>, Resource)");
        }
        boolean ret = false;
        try {
            this.activatePluginClassLoader();
            ret = this.rangerKakfaAuthorizerImpl.removeAcls(acls, resource);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKafkaAuthorizer.removeAcls(Set<Acl>, Resource)");
        }
        return ret;
    }

    public boolean removeAcls(Resource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKafkaAuthorizer.removeAcls(Resource)");
        }
        boolean ret = false;
        try {
            this.activatePluginClassLoader();
            ret = this.rangerKakfaAuthorizerImpl.removeAcls(resource);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKafkaAuthorizer.removeAcls(Resource)");
        }
        return ret;
    }

    public Set<Acl> getAcls(Resource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKafkaAuthorizer.getAcls(Resource)");
        }
        Set ret = null;
        try {
            this.activatePluginClassLoader();
            ret = this.rangerKakfaAuthorizerImpl.getAcls(resource);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKafkaAuthorizer.getAcls(Resource)");
        }
        return ret;
    }

    public scala.collection.immutable.Map<Resource, Set<Acl>> getAcls(KafkaPrincipal principal) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKafkaAuthorizer.getAcls(KafkaPrincipal)");
        }
        scala.collection.immutable.Map ret = null;
        try {
            this.activatePluginClassLoader();
            ret = this.rangerKakfaAuthorizerImpl.getAcls(principal);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKafkaAuthorizer.getAcls(KafkaPrincipal)");
        }
        return ret;
    }

    public scala.collection.immutable.Map<Resource, Set<Acl>> getAcls() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKafkaAuthorizer.getAcls()");
        }
        scala.collection.immutable.Map ret = null;
        try {
            this.activatePluginClassLoader();
            ret = this.rangerKakfaAuthorizerImpl.getAcls();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKafkaAuthorizer.getAcls()");
        }
        return ret;
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }
}

