/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributeProvider;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.authorization.hadoop.AuthzContext;
import org.apache.ranger.authorization.hadoop.RangerHdfsAccessRequest;
import org.apache.ranger.authorization.hadoop.RangerHdfsAuditHandler;
import org.apache.ranger.authorization.hadoop.RangerHdfsPlugin;
import org.apache.ranger.authorization.hadoop.exceptions.RangerAccessControlException;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerHdfsAuthorizer
extends INodeAttributeProvider {
    public static final String KEY_FILENAME = "FILENAME";
    public static final String KEY_BASE_FILENAME = "BASE_FILENAME";
    public static final String DEFAULT_FILENAME_EXTENSION_SEPARATOR = ".";
    public static final String KEY_RESOURCE_PATH = "path";
    public static final String RANGER_FILENAME_EXTENSION_SEPARATOR_PROP = "ranger.plugin.hdfs.filename.extension.separator";
    private static final Logger LOG = LoggerFactory.getLogger(RangerHdfsAuthorizer.class);
    private static final Logger PERF_HDFSAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"hdfsauth.request");
    private RangerHdfsPlugin rangerPlugin = null;
    private Map<FsAction, Set<String>> access2ActionListMapper = new HashMap<FsAction, Set<String>>();
    private final Path addlConfigFile;

    public RangerHdfsAuthorizer() {
        this(null);
    }

    public RangerHdfsAuthorizer(Path addlConfigFile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.RangerHdfsAuthorizer()");
        }
        this.addlConfigFile = addlConfigFile;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.RangerHdfsAuthorizer()");
        }
    }

    public void start() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.start()");
        }
        RangerHdfsPlugin plugin = new RangerHdfsPlugin(this.addlConfigFile);
        plugin.init();
        if (plugin.isOptimizeSubAccessAuthEnabled()) {
            LOG.info("ranger.optimize-subaccess-authorization is enabled");
        }
        this.access2ActionListMapper.put(FsAction.NONE, new HashSet());
        this.access2ActionListMapper.put(FsAction.ALL, Sets.newHashSet((Object[])new String[]{"read", "write", "execute"}));
        this.access2ActionListMapper.put(FsAction.READ, Sets.newHashSet((Object[])new String[]{"read"}));
        this.access2ActionListMapper.put(FsAction.READ_WRITE, Sets.newHashSet((Object[])new String[]{"read", "write"}));
        this.access2ActionListMapper.put(FsAction.READ_EXECUTE, Sets.newHashSet((Object[])new String[]{"read", "execute"}));
        this.access2ActionListMapper.put(FsAction.WRITE, Sets.newHashSet((Object[])new String[]{"write"}));
        this.access2ActionListMapper.put(FsAction.WRITE_EXECUTE, Sets.newHashSet((Object[])new String[]{"write", "execute"}));
        this.access2ActionListMapper.put(FsAction.EXECUTE, Sets.newHashSet((Object[])new String[]{"execute"}));
        this.rangerPlugin = plugin;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.start()");
        }
    }

    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.stop()");
        }
        RangerHdfsPlugin plugin = this.rangerPlugin;
        this.rangerPlugin = null;
        if (plugin != null) {
            plugin.cleanup();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.stop()");
        }
    }

    public INodeAttributes getAttributes(String fullPath, INodeAttributes inode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.getAttributes(" + fullPath + ")");
        }
        INodeAttributes ret = inode;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.getAttributes(" + fullPath + "): " + ret);
        }
        return ret;
    }

    public INodeAttributes getAttributes(String[] pathElements, INodeAttributes inode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.getAttributes(pathElementsCount=" + (pathElements == null ? 0 : pathElements.length) + ")");
        }
        INodeAttributes ret = inode;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.getAttributes(pathElementsCount=" + (pathElements == null ? 0 : pathElements.length) + "): " + ret);
        }
        return ret;
    }

    public INodeAttributeProvider.AccessControlEnforcer getExternalAccessControlEnforcer(INodeAttributeProvider.AccessControlEnforcer defaultEnforcer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerHdfsAuthorizer.getExternalAccessControlEnforcer()");
        }
        RangerAccessControlEnforcer rangerAce = new RangerAccessControlEnforcer(defaultEnforcer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerHdfsAuthorizer.getExternalAccessControlEnforcer()");
        }
        return rangerAce;
    }

    public Configuration getConfig() {
        return this.rangerPlugin.getConfig();
    }

    class RangerAccessControlEnforcer
    implements INodeAttributeProvider.AccessControlEnforcer {
        private INodeAttributeProvider.AccessControlEnforcer defaultEnforcer = null;

        public RangerAccessControlEnforcer(INodeAttributeProvider.AccessControlEnforcer defaultEnforcer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerAccessControlEnforcer.RangerAccessControlEnforcer()");
            }
            this.defaultEnforcer = defaultEnforcer;
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerAccessControlEnforcer.RangerAccessControlEnforcer()");
            }
        }

        public void checkPermissionWithContext(INodeAttributeProvider.AuthorizationContext authzContext) throws AccessControlException {
            this.checkRangerPermission(authzContext.getFsOwner(), authzContext.getSupergroup(), authzContext.getCallerUgi(), authzContext.getInodeAttrs(), authzContext.getInodes(), authzContext.getPathByNameArr(), authzContext.getSnapshotId(), authzContext.getPath(), authzContext.getAncestorIndex(), authzContext.isDoCheckOwner(), authzContext.getAncestorAccess(), authzContext.getParentAccess(), authzContext.getAccess(), authzContext.getSubAccess(), authzContext.isIgnoreEmptyDir(), authzContext.getOperationName(), authzContext.getCallerContext());
        }

        public void checkPermission(String fsOwner, String superGroup, UserGroupInformation ugi, INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] pathByNameArr, int snapshotId, String path, int ancestorIndex, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException {
            this.checkRangerPermission(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkRangerPermission(String fsOwner, String superGroup, UserGroupInformation ugi, INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] pathByNameArr, int snapshotId, String path, int ancestorIndex, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir, String operationName, CallerContext callerContext) throws AccessControlException {
            RangerPerfTracer perf;
            AuthzContext context;
            String resourcePath;
            AuthzStatus authzStatus;
            block38: {
                authzStatus = AuthzStatus.NOT_DETERMINED;
                resourcePath = path;
                context = new AuthzContext(RangerHdfsAuthorizer.this.rangerPlugin, ugi, operationName, access == null && parentAccess == null && ancestorAccess == null && subAccess == null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("==> RangerAccessControlEnforcer.checkPermission(fsOwner=" + fsOwner + "; superGroup=" + superGroup + ", inodesCount=" + (inodes != null ? inodes.length : 0) + ", snapshotId=" + snapshotId + ", user=" + context.user + ", provided-path=" + path + ", ancestorIndex=" + ancestorIndex + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=" + ancestorAccess + ", parentAccess=" + parentAccess + ", access=" + access + ", subAccess=" + subAccess + ", ignoreEmptyDir=" + ignoreEmptyDir + ", operationName=" + operationName + ", callerContext=" + callerContext + ")");
                }
                perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_HDFSAUTH_REQUEST_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer((Logger)PERF_HDFSAUTH_REQUEST_LOG, (String)("RangerHdfsAuthorizer.checkPermission(provided-path=" + path + ")"));
                }
                try {
                    INode ancestor = null;
                    INode parent = null;
                    INode inode = null;
                    String providedPath = path;
                    boolean useDefaultAuthorizerOnly = false;
                    boolean doNotGenerateAuditRecord = false;
                    if (context.plugin != null && !ArrayUtils.isEmpty((Object[])inodes)) {
                        INodeAttributes inodeAttribs;
                        String parentPath;
                        INodeAttributes parentAttribs;
                        String ancestorPath;
                        INodeAttributes ancestorAttribs;
                        int i;
                        int sz = inodeAttrs.length;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Size of INodeAttrs array:[" + sz + "]");
                            LOG.debug("Size of INodes array:[" + inodes.length + "]");
                        }
                        byte[][] components = new byte[sz][];
                        for (i = 0; i < sz && inodeAttrs[i] != null; ++i) {
                            components[i] = inodeAttrs[i].getLocalNameBytes();
                        }
                        if (i != sz && LOG.isDebugEnabled()) {
                            LOG.debug("Input INodeAttributes array contains null at position " + i);
                            LOG.debug("Will use only first [" + i + "] components");
                        }
                        if (sz == 1 && inodes.length == 1 && inodes[0].getParent() != null) {
                            doNotGenerateAuditRecord = true;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Using the only inode in the array to figure out path to resource. No audit record will be generated for this authorization request");
                            }
                            resourcePath = inodes[0].getFullPathName();
                            if (snapshotId != 0x7FFFFFFE) {
                                useDefaultAuthorizerOnly = true;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("path:[" + resourcePath + "] is for a snapshot, id=[" + snapshotId + "], default Authorizer will be used to authorize this request");
                                }
                            } else if (LOG.isDebugEnabled()) {
                                LOG.debug("path:[" + resourcePath + "] is not for a snapshot, id=[" + snapshotId + "]. It will be used to authorize this request");
                            }
                        } else if (snapshotId != 0x7FFFFFFE) {
                            resourcePath = DFSUtil.byteArray2PathString((byte[][])pathByNameArr);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("pathByNameArr array is used to figure out path to resource, resourcePath:[" + resourcePath + "]");
                            }
                        } else {
                            resourcePath = DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)i);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("INodeAttributes array is used to figure out path to resource, resourcePath:[" + resourcePath + "]");
                            }
                        }
                        if (ancestorIndex >= inodes.length) {
                            ancestorIndex = inodes.length - 1;
                        }
                        while (ancestorIndex >= 0 && inodes[ancestorIndex] == null) {
                            --ancestorIndex;
                        }
                        authzStatus = useDefaultAuthorizerOnly ? AuthzStatus.NOT_DETERMINED : AuthzStatus.ALLOW;
                        ancestor = inodes.length > ancestorIndex && ancestorIndex >= 0 ? inodes[ancestorIndex] : null;
                        parent = inodes.length > 1 ? inodes[inodes.length - 2] : null;
                        inode = inodes[inodes.length - 1];
                        RangerHdfsAuditHandler rangerHdfsAuditHandler = doNotGenerateAuditRecord ? null : (context.auditHandler = new RangerHdfsAuditHandler(providedPath, context.isTraverseOnlyCheck, context.plugin.getHadoopModuleName(), context.plugin.getExcludedUsers(), callerContext != null ? callerContext.toString() : null));
                        if (authzStatus == AuthzStatus.ALLOW && context.isTraverseOnlyCheck) {
                            authzStatus = this.traverseOnlyCheck(inode, inodeAttrs, resourcePath, components, parent, ancestor, ancestorIndex, context);
                        }
                        if (authzStatus == AuthzStatus.ALLOW && parentAccess != null && parentAccess.implies(FsAction.WRITE) && parent != null && inode != null && parent.getFsPermission() != null && parent.getFsPermission().getStickyBit()) {
                            AuthzStatus authzStatus2 = authzStatus = StringUtils.equals((String)parent.getUserName(), (String)context.user) || StringUtils.equals((String)inode.getUserName(), (String)context.user) ? AuthzStatus.ALLOW : AuthzStatus.NOT_DETERMINED;
                        }
                        if (authzStatus == AuthzStatus.ALLOW && ancestorAccess != null && ancestor != null && (authzStatus = this.isAccessAllowed(ancestor, ancestorAttribs = inodeAttrs.length > ancestorIndex ? inodeAttrs[ancestorIndex] : null, ancestorPath = ancestorAttribs != null ? DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)(ancestorIndex + 1)) : null, ancestorAccess, context)) == AuthzStatus.NOT_DETERMINED) {
                            authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, null, null, null, ignoreEmptyDir, ancestor, parent, inode, context);
                        }
                        if (authzStatus == AuthzStatus.ALLOW && parentAccess != null && parent != null && (authzStatus = this.isAccessAllowed(parent, parentAttribs = inodeAttrs.length > 1 ? inodeAttrs[inodeAttrs.length - 2] : null, parentPath = parentAttribs != null ? DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)(inodeAttrs.length - 1)) : null, parentAccess, context)) == AuthzStatus.NOT_DETERMINED) {
                            authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, null, parentAccess, null, null, ignoreEmptyDir, ancestor, parent, inode, context);
                        }
                        if (authzStatus == AuthzStatus.ALLOW && access != null && inode != null && (authzStatus = this.isAccessAllowed(inode, inodeAttribs = inodeAttrs.length > 0 ? inodeAttrs[inodeAttrs.length - 1] : null, resourcePath, access, context)) == AuthzStatus.NOT_DETERMINED) {
                            authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, null, null, access, null, ignoreEmptyDir, ancestor, parent, inode, context);
                        }
                        if (authzStatus == AuthzStatus.ALLOW && subAccess != null && inode != null && inode.isDirectory()) {
                            Stack<SubAccessData> directories = new Stack<SubAccessData>();
                            directories.push(new SubAccessData(inode.asDirectory(), resourcePath));
                            while (!directories.isEmpty()) {
                                SubAccessData data = (SubAccessData)directories.pop();
                                ReadOnlyList cList = data.dir.getChildrenList(snapshotId);
                                if (cList.isEmpty() && ignoreEmptyDir) continue;
                                INodeDirectoryAttributes dirAttribs = data.dir.getSnapshotINode(snapshotId);
                                authzStatus = this.isAccessAllowed((INode)data.dir, (INodeAttributes)dirAttribs, data.resourcePath, subAccess, context);
                                if (authzStatus != AuthzStatus.ALLOW) break;
                                AuthzStatus subDirAuthStatus = AuthzStatus.NOT_DETERMINED;
                                boolean optimizeSubAccessAuthEnabled = RangerHdfsAuthorizer.this.rangerPlugin.isOptimizeSubAccessAuthEnabled();
                                if (optimizeSubAccessAuthEnabled) {
                                    subDirAuthStatus = this.isAccessAllowedForHierarchy((INode)data.dir, (INodeAttributes)dirAttribs, data.resourcePath, subAccess, context);
                                }
                                if (subDirAuthStatus == AuthzStatus.ALLOW) continue;
                                for (INode child : cList) {
                                    if (!child.isDirectory()) continue;
                                    directories.push(new SubAccessData(child.asDirectory(), resourcePath + '/' + child.getLocalName()));
                                }
                            }
                            if (authzStatus == AuthzStatus.NOT_DETERMINED) {
                                authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, null, null, null, subAccess, ignoreEmptyDir, ancestor, parent, inode, context);
                            }
                        }
                        if (authzStatus == AuthzStatus.ALLOW && doCheckOwner) {
                            inodeAttribs = inodeAttrs.length > 0 ? inodeAttrs[inodeAttrs.length - 1] : null;
                            String owner = inodeAttribs != null ? inodeAttribs.getUserName() : null;
                            AuthzStatus authzStatus3 = authzStatus = StringUtils.equals((String)context.user, (String)owner) ? AuthzStatus.ALLOW : AuthzStatus.NOT_DETERMINED;
                        }
                    }
                    if (authzStatus == AuthzStatus.NOT_DETERMINED) {
                        authzStatus = this.checkDefaultEnforcer(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir, ancestor, parent, inode, context);
                    }
                    if (authzStatus != AuthzStatus.ALLOW) {
                        FsAction action = access;
                        if (action == null) {
                            action = parentAccess != null ? parentAccess : (ancestorAccess != null ? ancestorAccess : FsAction.EXECUTE);
                        }
                        throw new RangerAccessControlException("Permission denied: user=" + context.user + ", access=" + action + ", inode=\"" + resourcePath + "\"");
                    }
                    if (context.auditHandler == null) break block38;
                    context.auditHandler.flushAudit();
                }
                catch (Throwable throwable) {
                    if (context.auditHandler != null) {
                        context.auditHandler.flushAudit();
                    }
                    RangerPerfTracer.log(perf);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<== RangerAccessControlEnforcer.checkPermission(" + resourcePath + ", " + access + ", user=" + context.user + ") : " + (Object)((Object)authzStatus));
                    }
                    throw throwable;
                }
            }
            RangerPerfTracer.log((RangerPerfTracer)perf);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerAccessControlEnforcer.checkPermission(" + resourcePath + ", " + access + ", user=" + context.user + ") : " + (Object)((Object)authzStatus));
            }
        }

        private AuthzStatus traverseOnlyCheck(INode inode, INodeAttributes[] inodeAttrs, String path, byte[][] components, INode parent, INode ancestor, int ancestorIndex, AuthzContext context) {
            AuthzStatus ret;
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerAccessControlEnforcer.traverseOnlyCheck(path=" + path + ", user=" + context.user + ", groups=" + context.userGroups + ")");
            }
            INode nodeToCheck = inode;
            INodeAttributes nodeAttribs = inodeAttrs.length > 0 ? inodeAttrs[inodeAttrs.length - 1] : null;
            boolean skipAuditOnAllow = false;
            String resourcePath = path;
            if (nodeToCheck == null || nodeToCheck.isFile()) {
                skipAuditOnAllow = true;
                if (parent != null) {
                    nodeToCheck = parent;
                    nodeAttribs = inodeAttrs.length > 1 ? inodeAttrs[inodeAttrs.length - 2] : null;
                    resourcePath = inodeAttrs.length > 0 ? DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)(inodeAttrs.length - 1)) : "/";
                } else if (ancestor != null) {
                    nodeToCheck = ancestor;
                    nodeAttribs = inodeAttrs.length > ancestorIndex ? inodeAttrs[ancestorIndex] : null;
                    String string = resourcePath = nodeAttribs != null ? DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)(ancestorIndex + 1)) : "/";
                }
            }
            if (nodeToCheck != null) {
                if (resourcePath.length() > 1 && resourcePath.endsWith("/")) {
                    resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
                }
                ret = this.isAccessAllowedForTraversal(nodeToCheck, nodeAttribs, resourcePath, skipAuditOnAllow, context);
            } else {
                ret = AuthzStatus.ALLOW;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerAccessControlEnforcer.traverseOnlyCheck(path=" + path + ", resourcePath=" + resourcePath + ", user=" + context.user + ", groups=" + context.userGroups + ") : " + (Object)((Object)ret));
            }
            return ret;
        }

        private AuthzStatus isAccessAllowedForTraversal(INode inode, INodeAttributes inodeAttribs, String path, boolean skipAuditOnAllow, AuthzContext context) {
            String pathOwner = inodeAttribs != null ? inodeAttribs.getUserName() : null;
            FsAction access = FsAction.EXECUTE;
            if (pathOwner == null) {
                pathOwner = inode.getUserName();
            }
            if ("".equals(path)) {
                path = "/";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerAccessControlEnforcer.isAccessAllowedForTraversal(" + path + ", " + access + ", " + context.user + ", " + skipAuditOnAllow + ")");
            }
            RangerHdfsAccessRequest request = new RangerHdfsAccessRequest(inode, path, pathOwner, access, "execute", context.operationName, context.user, context.userGroups);
            RangerAccessResult result = context.plugin.isAccessAllowed((RangerAccessRequest)request, null);
            context.saveResult(result);
            AuthzStatus ret = result != null && result.getIsAccessDetermined() && !result.getIsAllowed() ? AuthzStatus.DENY : AuthzStatus.ALLOW;
            if ((ret == AuthzStatus.DENY || !skipAuditOnAllow && result != null && result.getIsAccessDetermined()) && context.auditHandler != null) {
                context.auditHandler.processResult(result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerAccessControlEnforcer.isAccessAllowedForTraversal(" + path + ", " + access + ", " + context.user + ", " + skipAuditOnAllow + "): " + (Object)((Object)ret));
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AuthzStatus checkDefaultEnforcer(String fsOwner, String superGroup, UserGroupInformation ugi, INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] pathByNameArr, int snapshotId, String path, int ancestorIndex, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir, INode ancestor, INode parent, INode inode, AuthzContext context) throws AccessControlException {
            AuthzStatus authzStatus;
            block31: {
                RangerPerfTracer hadoopAuthPerf;
                block29: {
                    FsAction action;
                    INode nodeChecked;
                    block32: {
                        block30: {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("==> RangerAccessControlEnforcer.checkDefaultEnforcer(fsOwner=" + fsOwner + "; superGroup=" + superGroup + ", inodesCount=" + (inodes != null ? inodes.length : 0) + ", snapshotId=" + snapshotId + ", path=" + path + ", ancestorIndex=" + ancestorIndex + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=" + ancestorAccess + ", parentAccess=" + parentAccess + ", access=" + access + ", subAccess=" + subAccess + ", ignoreEmptyDir=" + ignoreEmptyDir + ", isTraverseOnlyCheck=" + context.isTraverseOnlyCheck + ",ancestor=" + (ancestor == null ? null : ancestor.getFullPathName()) + ", parent=" + (parent == null ? null : parent.getFullPathName()) + ", inode=" + (inode == null ? null : inode.getFullPathName()) + ")");
                            }
                            authzStatus = AuthzStatus.NOT_DETERMINED;
                            if (!RangerHdfsAuthorizer.this.rangerPlugin.isHadoopAuthEnabled() || this.defaultEnforcer == null) break block31;
                            hadoopAuthPerf = null;
                            if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_HDFSAUTH_REQUEST_LOG)) {
                                hadoopAuthPerf = RangerPerfTracer.getPerfTracer((Logger)PERF_HDFSAUTH_REQUEST_LOG, (String)("RangerAccessControlEnforcer.checkDefaultEnforcer(path=" + path + ")"));
                            }
                            try {
                                this.defaultEnforcer.checkPermission(fsOwner, superGroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir);
                                authzStatus = AuthzStatus.ALLOW;
                                if (context.auditHandler == null) break block29;
                                nodeChecked = inode;
                                action = access;
                                if (!context.isTraverseOnlyCheck) break block30;
                            }
                            catch (Throwable throwable) {
                                if (context.auditHandler != null) {
                                    INode nodeChecked2 = inode;
                                    FsAction action2 = access;
                                    if (context.isTraverseOnlyCheck) {
                                        if (nodeChecked2 == null || nodeChecked2.isFile()) {
                                            if (parent != null) {
                                                nodeChecked2 = parent;
                                            } else if (ancestor != null) {
                                                nodeChecked2 = ancestor;
                                            }
                                        }
                                        action2 = FsAction.EXECUTE;
                                    } else if (action2 == null || action2 == FsAction.NONE) {
                                        if (parentAccess != null && parentAccess != FsAction.NONE) {
                                            nodeChecked2 = parent;
                                            action2 = parentAccess;
                                        } else if (ancestorAccess != null && ancestorAccess != FsAction.NONE) {
                                            nodeChecked2 = ancestor;
                                            action2 = ancestorAccess;
                                        } else if (subAccess != null && subAccess != FsAction.NONE) {
                                            action2 = subAccess;
                                        }
                                    }
                                    String pathChecked = nodeChecked2 != null ? nodeChecked2.getFullPathName() : path;
                                    boolean isAllowed = authzStatus == AuthzStatus.ALLOW;
                                    RangerAccessResult lastResult = context.getLastResult();
                                    if (lastResult != null) {
                                        lastResult.setIsAllowed(isAllowed);
                                        lastResult.setIsAccessDetermined(true);
                                        context.plugin.evalAuditPolicies(lastResult);
                                        context.auditHandler.processResult(lastResult);
                                    }
                                    context.auditHandler.logHadoopEvent(pathChecked, action2, isAllowed);
                                }
                                RangerPerfTracer.log(hadoopAuthPerf);
                                throw throwable;
                            }
                            if (nodeChecked == null || nodeChecked.isFile()) {
                                if (parent != null) {
                                    nodeChecked = parent;
                                } else if (ancestor != null) {
                                    nodeChecked = ancestor;
                                }
                            }
                            action = FsAction.EXECUTE;
                            break block32;
                        }
                        if (action == null || action == FsAction.NONE) {
                            if (parentAccess != null && parentAccess != FsAction.NONE) {
                                nodeChecked = parent;
                                action = parentAccess;
                            } else if (ancestorAccess != null && ancestorAccess != FsAction.NONE) {
                                nodeChecked = ancestor;
                                action = ancestorAccess;
                            } else if (subAccess != null && subAccess != FsAction.NONE) {
                                action = subAccess;
                            }
                        }
                    }
                    String pathChecked = nodeChecked != null ? nodeChecked.getFullPathName() : path;
                    boolean isAllowed = authzStatus == AuthzStatus.ALLOW;
                    RangerAccessResult lastResult = context.getLastResult();
                    if (lastResult != null) {
                        lastResult.setIsAllowed(isAllowed);
                        lastResult.setIsAccessDetermined(true);
                        context.plugin.evalAuditPolicies(lastResult);
                        context.auditHandler.processResult(lastResult);
                    }
                    context.auditHandler.logHadoopEvent(pathChecked, action, isAllowed);
                }
                RangerPerfTracer.log((RangerPerfTracer)hadoopAuthPerf);
            }
            LOG.debug("<== RangerAccessControlEnforcer.checkDefaultEnforcer(fsOwner=" + fsOwner + "; superGroup=" + superGroup + ", inodesCount=" + (inodes != null ? inodes.length : 0) + ", snapshotId=" + snapshotId + ", path=" + path + ", ancestorIndex=" + ancestorIndex + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=" + ancestorAccess + ", parentAccess=" + parentAccess + ", access=" + access + ", subAccess=" + subAccess + ", ignoreEmptyDir=" + ignoreEmptyDir + ", isTraverseOnlyCheck=" + context.isTraverseOnlyCheck + ",ancestor=" + (ancestor == null ? null : ancestor.getFullPathName()) + ", parent=" + (parent == null ? null : parent.getFullPathName()) + ", inode=" + (inode == null ? null : inode.getFullPathName()) + ") : " + (Object)((Object)authzStatus));
            return authzStatus;
        }

        private AuthzStatus isAccessAllowed(INode inode, INodeAttributes inodeAttribs, String path, FsAction access, AuthzContext context) {
            Set accessTypes;
            String pathOwner;
            AuthzStatus ret = null;
            String string = pathOwner = inodeAttribs != null ? inodeAttribs.getUserName() : null;
            if (pathOwner == null && inode != null) {
                pathOwner = inode.getUserName();
            }
            if ("".equals(path)) {
                path = "/";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerAccessControlEnforcer.isAccessAllowed(" + path + ", " + access + ", " + context.user + ")");
            }
            if ((accessTypes = (Set)RangerHdfsAuthorizer.this.access2ActionListMapper.get(access)) == null) {
                LOG.warn("RangerAccessControlEnforcer.isAccessAllowed(" + path + ", " + access + ", " + context.user + "): no Ranger accessType found for " + access);
                accessTypes = (Set)RangerHdfsAuthorizer.this.access2ActionListMapper.get(FsAction.NONE);
            }
            for (String accessType : accessTypes) {
                RangerHdfsAccessRequest request = new RangerHdfsAccessRequest(inode, path, pathOwner, access, accessType, context.operationName, context.user, context.userGroups);
                Map requestContext = request.getContext();
                requestContext.put("ACCESSTYPES", accessTypes);
                RangerAccessResult result = context.plugin.isAccessAllowed((RangerAccessRequest)request, (RangerAccessResultProcessor)context.auditHandler);
                context.saveResult(result);
                if (result == null || !result.getIsAccessDetermined()) {
                    ret = AuthzStatus.NOT_DETERMINED;
                    continue;
                }
                if (!result.getIsAllowed()) {
                    ret = AuthzStatus.DENY;
                    break;
                }
                if (AuthzStatus.NOT_DETERMINED.equals((Object)ret)) continue;
                ret = AuthzStatus.ALLOW;
            }
            if (ret == null) {
                ret = AuthzStatus.NOT_DETERMINED;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerAccessControlEnforcer.isAccessAllowed(" + path + ", " + access + ", " + context.user + "): " + (Object)((Object)ret));
            }
            return ret;
        }

        private AuthzStatus isAccessAllowedForHierarchy(INode inode, INodeAttributes inodeAttribs, String path, FsAction access, AuthzContext context) {
            String pathOwner;
            AuthzStatus ret = null;
            String string = pathOwner = inodeAttribs != null ? inodeAttribs.getUserName() : null;
            if (pathOwner == null && inode != null) {
                pathOwner = inode.getUserName();
            }
            if ("".equals(path)) {
                path = "/";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerAccessControlEnforcer.isAccessAllowedForHierarchy(" + path + ", " + access + ", " + context.user + ")");
            }
            if (path != null) {
                String subDirPath;
                Set accessTypes = (Set)RangerHdfsAuthorizer.this.access2ActionListMapper.get(access);
                if (accessTypes == null) {
                    LOG.warn("RangerAccessControlEnforcer.isAccessAllowedForHierarchy(" + path + ", " + access + ", " + context.user + "): no Ranger accessType found for " + access);
                    accessTypes = (Set)RangerHdfsAuthorizer.this.access2ActionListMapper.get(FsAction.NONE);
                }
                if ((subDirPath = path).charAt(subDirPath.length() - 1) != '/') {
                    subDirPath = subDirPath + Character.toString('/');
                }
                subDirPath = subDirPath + RangerHdfsAuthorizer.this.rangerPlugin.getRandomizedWildcardPathName();
                for (String accessType : accessTypes) {
                    RangerHdfsAccessRequest request = new RangerHdfsAccessRequest(null, subDirPath, pathOwner, access, accessType, context.operationName, context.user, context.userGroups);
                    Map requestContext = request.getContext();
                    requestContext.put("ACCESSTYPES", accessTypes);
                    RangerAccessResult result = context.plugin.isAccessAllowed((RangerAccessRequest)request, null);
                    context.saveResult(result);
                    if (result == null || !result.getIsAccessDetermined()) {
                        ret = AuthzStatus.NOT_DETERMINED;
                        continue;
                    }
                    if (!result.getIsAllowed()) {
                        ret = AuthzStatus.DENY;
                        break;
                    }
                    if (AuthzStatus.NOT_DETERMINED.equals((Object)ret)) continue;
                    ret = AuthzStatus.ALLOW;
                }
            }
            if (ret == null) {
                ret = AuthzStatus.NOT_DETERMINED;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerAccessControlEnforcer.isAccessAllowedForHierarchy(" + path + ", " + access + ", " + context.user + "): " + (Object)((Object)ret));
            }
            return ret;
        }

        class SubAccessData {
            final INodeDirectory dir;
            final String resourcePath;

            SubAccessData(INodeDirectory dir, String resourcePath) {
                this.dir = dir;
                this.resourcePath = resourcePath;
            }
        }
    }

    private static enum AuthzStatus {
        ALLOW,
        DENY,
        NOT_DETERMINED;

    }
}

