/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RangerServiceDef
extends RangerBaseModelObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ENABLE_DENY_AND_EXCEPTIONS_IN_POLICIES = "enableDenyAndExceptionsInPolicies";
    public static final String OPTION_ENABLE_IMPLICIT_CONDITION_EXPRESSION = "enableImplicitConditionExpression";
    private String name;
    private String displayName;
    private String implClass;
    private String label;
    private String description;
    private String rbKeyLabel;
    private String rbKeyDescription;
    private Map<String, String> options;
    private List<RangerServiceConfigDef> configs;
    private List<RangerResourceDef> resources;
    private List<RangerAccessTypeDef> accessTypes;
    private List<RangerPolicyConditionDef> policyConditions;
    private List<RangerContextEnricherDef> contextEnrichers;
    private List<RangerEnumDef> enums;
    private RangerDataMaskDef dataMaskDef;
    private RangerRowFilterDef rowFilterDef;

    public RangerServiceDef() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public RangerServiceDef(String name, String implClass, String label, String description, Map<String, String> options, List<RangerServiceConfigDef> configs, List<RangerResourceDef> resources, List<RangerAccessTypeDef> accessTypes, List<RangerPolicyConditionDef> policyConditions, List<RangerContextEnricherDef> contextEnrichers, List<RangerEnumDef> enums) {
        this(name, implClass, label, description, options, configs, resources, accessTypes, policyConditions, contextEnrichers, enums, null, null);
    }

    public RangerServiceDef(String name, String implClass, String label, String description, Map<String, String> options, List<RangerServiceConfigDef> configs, List<RangerResourceDef> resources, List<RangerAccessTypeDef> accessTypes, List<RangerPolicyConditionDef> policyConditions, List<RangerContextEnricherDef> contextEnrichers, List<RangerEnumDef> enums, RangerDataMaskDef dataMaskDef, RangerRowFilterDef rowFilterDef) {
        this.setName(name);
        this.setImplClass(implClass);
        this.setLabel(label);
        this.setDescription(description);
        this.setConfigs(configs);
        this.setOptions(options);
        this.setResources(resources);
        this.setAccessTypes(accessTypes);
        this.setPolicyConditions(policyConditions);
        this.setContextEnrichers(contextEnrichers);
        this.setEnums(enums);
        this.setDataMaskDef(dataMaskDef);
        this.setRowFilterDef(rowFilterDef);
    }

    public RangerServiceDef(String name, String displayName, String implClass, String label, String description, Map<String, String> options, List<RangerServiceConfigDef> configs, List<RangerResourceDef> modifiedResourceDefs, List<RangerAccessTypeDef> accessTypes, List<RangerPolicyConditionDef> policyConditions, List<RangerContextEnricherDef> contextEnrichers, List<RangerEnumDef> enums) {
        this(name, implClass, label, description, options, configs, modifiedResourceDefs, accessTypes, policyConditions, contextEnrichers, enums);
        this.setDisplayName(displayName);
    }

    public void updateFrom(RangerServiceDef other) {
        super.updateFrom(other);
        this.setName(other.getName());
        this.setDisplayName(other.getDisplayName());
        this.setImplClass(other.getImplClass());
        this.setLabel(other.getLabel());
        this.setDescription(other.getDescription());
        this.setRbKeyLabel(other.getRbKeyLabel());
        this.setRbKeyDescription(other.getRbKeyDescription());
        this.setOptions(other.getOptions());
        this.setConfigs(other.getConfigs());
        this.setResources(other.getResources());
        this.setAccessTypes(other.getAccessTypes());
        this.setPolicyConditions(other.getPolicyConditions());
        this.setContextEnrichers(other.getContextEnrichers());
        this.setEnums(other.getEnums());
        this.setDataMaskDef(other.getDataMaskDef());
        this.setRowFilterDef(other.getRowFilterDef());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImplClass() {
        return this.implClass;
    }

    public void setImplClass(String implClass) {
        this.implClass = implClass;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRbKeyLabel() {
        return this.rbKeyLabel;
    }

    public void setRbKeyLabel(String rbKeyLabel) {
        this.rbKeyLabel = rbKeyLabel;
    }

    public String getRbKeyDescription() {
        return this.rbKeyDescription;
    }

    public void setRbKeyDescription(String rbKeyDescription) {
        this.rbKeyDescription = rbKeyDescription;
    }

    public List<RangerServiceConfigDef> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<RangerServiceConfigDef> configs) {
        if (this.configs == null) {
            this.configs = new ArrayList<RangerServiceConfigDef>();
        } else if (this.configs == configs) {
            return;
        }
        this.configs.clear();
        if (configs != null) {
            this.configs.addAll(configs);
        }
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        } else if (this.options == options) {
            return;
        }
        this.options.clear();
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                this.options.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public List<RangerResourceDef> getResources() {
        return this.resources;
    }

    public void setResources(List<RangerResourceDef> resources) {
        if (this.resources == null) {
            this.resources = new ArrayList<RangerResourceDef>();
        }
        if (this.resources == resources) {
            return;
        }
        this.resources.clear();
        if (resources != null) {
            this.resources.addAll(resources);
        }
    }

    public List<RangerAccessTypeDef> getAccessTypes() {
        return this.accessTypes;
    }

    public void setAccessTypes(List<RangerAccessTypeDef> accessTypes) {
        if (this.accessTypes == null) {
            this.accessTypes = new ArrayList<RangerAccessTypeDef>();
        }
        if (this.accessTypes == accessTypes) {
            return;
        }
        this.accessTypes.clear();
        if (accessTypes != null) {
            this.accessTypes.addAll(accessTypes);
        }
    }

    public List<RangerPolicyConditionDef> getPolicyConditions() {
        return this.policyConditions;
    }

    public void setPolicyConditions(List<RangerPolicyConditionDef> policyConditions) {
        if (this.policyConditions == null) {
            this.policyConditions = new ArrayList<RangerPolicyConditionDef>();
        }
        if (this.policyConditions == policyConditions) {
            return;
        }
        this.policyConditions.clear();
        if (policyConditions != null) {
            this.policyConditions.addAll(policyConditions);
        }
    }

    public List<RangerContextEnricherDef> getContextEnrichers() {
        return this.contextEnrichers;
    }

    public void setContextEnrichers(List<RangerContextEnricherDef> contextEnrichers) {
        if (this.contextEnrichers == null) {
            this.contextEnrichers = new ArrayList<RangerContextEnricherDef>();
        }
        if (this.contextEnrichers == contextEnrichers) {
            return;
        }
        this.contextEnrichers.clear();
        if (contextEnrichers != null) {
            this.contextEnrichers.addAll(contextEnrichers);
        }
    }

    public List<RangerEnumDef> getEnums() {
        return this.enums;
    }

    public void setEnums(List<RangerEnumDef> enums) {
        if (this.enums == null) {
            this.enums = new ArrayList<RangerEnumDef>();
        }
        if (this.enums == enums) {
            return;
        }
        this.enums.clear();
        if (enums != null) {
            this.enums.addAll(enums);
        }
    }

    public RangerDataMaskDef getDataMaskDef() {
        return this.dataMaskDef;
    }

    public void setDataMaskDef(RangerDataMaskDef dataMaskDef) {
        this.dataMaskDef = dataMaskDef == null ? new RangerDataMaskDef() : dataMaskDef;
    }

    public RangerRowFilterDef getRowFilterDef() {
        return this.rowFilterDef;
    }

    public void setRowFilterDef(RangerRowFilterDef rowFilterDef) {
        this.rowFilterDef = rowFilterDef == null ? new RangerRowFilterDef() : rowFilterDef;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public void dedupStrings(Map<String, String> strTbl) {
        this.name = StringUtil.dedupString(this.name, strTbl);
        this.displayName = StringUtil.dedupString(this.displayName, strTbl);
        this.implClass = StringUtil.dedupString(this.implClass, strTbl);
        this.label = StringUtil.dedupString(this.label, strTbl);
        this.description = StringUtil.dedupString(this.description, strTbl);
        this.rbKeyLabel = StringUtil.dedupString(this.rbKeyLabel, strTbl);
        this.options = StringUtil.dedupStringsMap(this.options, strTbl);
        if (this.configs != null) {
            for (RangerServiceConfigDef config : this.configs) {
                config.dedupStrings(strTbl);
            }
        }
        if (this.resources != null) {
            for (RangerResourceDef resource : this.resources) {
                resource.dedupStrings(strTbl);
            }
        }
        if (this.accessTypes != null) {
            for (RangerAccessTypeDef accessType : this.accessTypes) {
                accessType.dedupStrings(strTbl);
            }
        }
        if (this.policyConditions != null) {
            for (RangerPolicyConditionDef policyCondition : this.policyConditions) {
                policyCondition.dedupStrings(strTbl);
            }
        }
        if (this.contextEnrichers != null) {
            for (RangerContextEnricherDef contextEnricher : this.contextEnrichers) {
                contextEnricher.dedupStrings(strTbl);
            }
        }
        if (this.enums != null) {
            for (RangerEnumDef enu : this.enums) {
                enu.dedupStrings(strTbl);
            }
        }
        if (this.dataMaskDef != null) {
            this.dataMaskDef.dedupStrings(strTbl);
        }
        if (this.rowFilterDef != null) {
            this.rowFilterDef.dedupStrings(strTbl);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerServiceDef={");
        super.toString(sb);
        sb.append("name={").append(this.name).append("} ");
        sb.append("displayName={").append(this.displayName).append("} ");
        sb.append("implClass={").append(this.implClass).append("} ");
        sb.append("label={").append(this.label).append("} ");
        sb.append("description={").append(this.description).append("} ");
        sb.append("rbKeyLabel={").append(this.rbKeyLabel).append("} ");
        sb.append("rbKeyDescription={").append(this.rbKeyDescription).append("} ");
        sb.append("options={");
        if (this.options != null) {
            for (Map.Entry<String, String> entry : this.options.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue()).append(" ");
            }
        }
        sb.append("} ");
        sb.append("configs={");
        if (this.configs != null) {
            for (RangerServiceConfigDef config : this.configs) {
                if (config == null) continue;
                config.toString(sb);
            }
        }
        sb.append("} ");
        sb.append("resources={");
        if (this.resources != null) {
            for (RangerResourceDef resource : this.resources) {
                if (resource == null) continue;
                resource.toString(sb);
            }
        }
        sb.append("} ");
        sb.append("accessTypes={");
        if (this.accessTypes != null) {
            for (RangerAccessTypeDef accessType : this.accessTypes) {
                if (accessType == null) continue;
                accessType.toString(sb);
            }
        }
        sb.append("} ");
        sb.append("policyConditions={");
        if (this.policyConditions != null) {
            for (RangerPolicyConditionDef policyCondition : this.policyConditions) {
                if (policyCondition == null) continue;
                policyCondition.toString(sb);
            }
        }
        sb.append("} ");
        sb.append("contextEnrichers={");
        if (this.contextEnrichers != null) {
            for (RangerContextEnricherDef contextEnricher : this.contextEnrichers) {
                if (contextEnricher == null) continue;
                contextEnricher.toString(sb);
            }
        }
        sb.append("} ");
        sb.append("enums={");
        if (this.enums != null) {
            for (RangerEnumDef e : this.enums) {
                if (e == null) continue;
                e.toString(sb);
            }
        }
        sb.append("} ");
        sb.append("dataMaskDef={");
        if (this.dataMaskDef != null) {
            this.dataMaskDef.toString(sb);
        }
        sb.append("} ");
        sb.append("rowFilterDef={");
        if (this.rowFilterDef != null) {
            this.rowFilterDef.toString(sb);
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerRowFilterDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<RangerAccessTypeDef> accessTypes;
        private List<RangerResourceDef> resources;

        public RangerRowFilterDef() {
            this.setAccessTypes(null);
            this.setResources(null);
        }

        public RangerRowFilterDef(List<RangerAccessTypeDef> accessTypes, List<RangerResourceDef> resources) {
            this.setAccessTypes(accessTypes);
            this.setResources(resources);
        }

        public RangerRowFilterDef(RangerRowFilterDef other) {
            this.setAccessTypes(other.getAccessTypes());
            this.setResources(other.getResources());
        }

        public List<RangerAccessTypeDef> getAccessTypes() {
            return this.accessTypes;
        }

        public void setAccessTypes(List<RangerAccessTypeDef> accessTypes) {
            if (this.accessTypes == null) {
                this.accessTypes = new ArrayList<RangerAccessTypeDef>();
            }
            if (this.accessTypes == accessTypes) {
                return;
            }
            this.accessTypes.clear();
            if (accessTypes != null) {
                this.accessTypes.addAll(accessTypes);
            }
        }

        public List<RangerResourceDef> getResources() {
            return this.resources;
        }

        public void setResources(List<RangerResourceDef> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList<RangerResourceDef>();
            }
            if (this.resources == resources) {
                return;
            }
            this.resources.clear();
            if (resources != null) {
                this.resources.addAll(resources);
            }
        }

        public void dedupStrings(Map<String, String> strTbl) {
            if (this.accessTypes != null) {
                for (RangerAccessTypeDef accessType : this.accessTypes) {
                    accessType.dedupStrings(strTbl);
                }
            }
            if (this.resources != null) {
                for (RangerResourceDef resource : this.resources) {
                    resource.dedupStrings(strTbl);
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerRowFilterDef={");
            sb.append("accessTypes={");
            if (this.accessTypes != null) {
                for (RangerAccessTypeDef accessType : this.accessTypes) {
                    if (accessType == null) continue;
                    accessType.toString(sb).append(" ");
                }
            }
            sb.append("} ");
            sb.append("resources={");
            if (this.resources != null) {
                for (RangerResourceDef resource : this.resources) {
                    if (resource == null) continue;
                    resource.toString(sb).append(" ");
                }
            }
            sb.append("} ");
            sb.append("}");
            return sb;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.accessTypes == null ? 0 : this.accessTypes.hashCode());
            result = 31 * result + (this.resources == null ? 0 : this.resources.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerRowFilterDef other = (RangerRowFilterDef)obj;
            if (this.accessTypes == null ? other.accessTypes != null : !this.accessTypes.equals(other.accessTypes)) {
                return false;
            }
            return !(this.resources == null ? other.resources != null : !this.resources.equals(other.resources));
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerDataMaskTypeDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long itemId;
        private String name;
        private String label;
        private String description;
        private String transformer;
        private Map<String, String> dataMaskOptions;
        private String rbKeyLabel;
        private String rbKeyDescription;

        public RangerDataMaskTypeDef() {
            this(null, null, null, null, null, null, null, null);
        }

        public RangerDataMaskTypeDef(Long itemId, String name, String label, String description, String transformer, Map<String, String> dataMaskOptions, String rbKeyLabel, String rbKeyDescription) {
            this.setItemId(itemId);
            this.setName(name);
            this.setLabel(label);
            this.setDescription(description);
            this.setTransformer(transformer);
            this.setDataMaskOptions(dataMaskOptions);
            this.setRbKeyLabel(rbKeyLabel);
            this.setRbKeyDescription(rbKeyDescription);
        }

        public RangerDataMaskTypeDef(RangerDataMaskTypeDef other) {
            this.setItemId(other.getItemId());
            this.setName(other.getName());
            this.setLabel(other.getLabel());
            this.setDescription(other.getDescription());
            this.setTransformer(other.getTransformer());
            this.setDataMaskOptions(other.getDataMaskOptions());
            this.setRbKeyLabel(other.getRbKeyLabel());
            this.setRbKeyDescription(other.getRbKeyDescription());
        }

        public Long getItemId() {
            return this.itemId;
        }

        public void setItemId(Long itemId) {
            this.itemId = itemId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getTransformer() {
            return this.transformer;
        }

        public void setTransformer(String transformer) {
            this.transformer = transformer;
        }

        public Map<String, String> getDataMaskOptions() {
            return this.dataMaskOptions;
        }

        public void setDataMaskOptions(Map<String, String> dataMaskOptions) {
            this.dataMaskOptions = dataMaskOptions == null ? new HashMap() : dataMaskOptions;
        }

        public String getRbKeyLabel() {
            return this.rbKeyLabel;
        }

        public void setRbKeyLabel(String rbKeyLabel) {
            this.rbKeyLabel = rbKeyLabel;
        }

        public String getRbKeyDescription() {
            return this.rbKeyDescription;
        }

        public void setRbKeyDescription(String rbKeyDescription) {
            this.rbKeyDescription = rbKeyDescription;
        }

        public void dedupStrings(Map<String, String> strTbl) {
            this.name = StringUtil.dedupString(this.name, strTbl);
            this.label = StringUtil.dedupString(this.label, strTbl);
            this.description = StringUtil.dedupString(this.description, strTbl);
            this.transformer = StringUtil.dedupString(this.transformer, strTbl);
            this.dataMaskOptions = StringUtil.dedupStringsMap(this.dataMaskOptions, strTbl);
            this.rbKeyLabel = StringUtil.dedupString(this.rbKeyLabel, strTbl);
            this.rbKeyDescription = StringUtil.dedupString(this.rbKeyDescription, strTbl);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerDataMaskTypeDef={");
            sb.append("itemId={").append(this.itemId).append("} ");
            sb.append("name={").append(this.name).append("} ");
            sb.append("label={").append(this.label).append("} ");
            sb.append("description={").append(this.description).append("} ");
            sb.append("transformer={").append(this.transformer).append("} ");
            sb.append("dataMaskOptions={").append(this.dataMaskOptions).append("} ");
            sb.append("rbKeyLabel={").append(this.rbKeyLabel).append("} ");
            sb.append("rbKeyDescription={").append(this.rbKeyDescription).append("} ");
            sb.append("}");
            return sb;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
            result = 31 * result + (this.dataMaskOptions == null ? 0 : this.dataMaskOptions.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.rbKeyLabel == null ? 0 : this.rbKeyLabel.hashCode());
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.transformer == null ? 0 : this.transformer.hashCode());
            result = 31 * result + (this.rbKeyDescription == null ? 0 : this.rbKeyDescription.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerDataMaskTypeDef other = (RangerDataMaskTypeDef)obj;
            if (this.itemId == null ? other.itemId != null : other.itemId == null || !this.itemId.equals(other.itemId)) {
                return false;
            }
            if (this.dataMaskOptions == null ? other.dataMaskOptions != null : !this.dataMaskOptions.equals(other.dataMaskOptions)) {
                return false;
            }
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.rbKeyLabel == null ? other.rbKeyLabel != null : !this.rbKeyLabel.equals(other.rbKeyLabel)) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.transformer == null ? other.transformer != null : !this.transformer.equals(other.transformer)) {
                return false;
            }
            return !(this.rbKeyDescription == null ? other.rbKeyDescription != null : !this.rbKeyDescription.equals(other.rbKeyDescription));
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerDataMaskDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<RangerDataMaskTypeDef> maskTypes;
        private List<RangerAccessTypeDef> accessTypes;
        private List<RangerResourceDef> resources;

        public RangerDataMaskDef() {
            this.setMaskTypes(null);
            this.setAccessTypes(null);
            this.setResources(null);
        }

        public RangerDataMaskDef(List<RangerDataMaskTypeDef> maskTypes, List<RangerAccessTypeDef> accessTypes, List<RangerResourceDef> resources) {
            this.setMaskTypes(maskTypes);
            this.setAccessTypes(accessTypes);
            this.setResources(resources);
        }

        public RangerDataMaskDef(RangerDataMaskDef other) {
            this.setMaskTypes(other.getMaskTypes());
            this.setAccessTypes(other.getAccessTypes());
            this.setResources(other.getResources());
        }

        public List<RangerDataMaskTypeDef> getMaskTypes() {
            return this.maskTypes;
        }

        public void setMaskTypes(List<RangerDataMaskTypeDef> maskTypes) {
            if (this.maskTypes == null) {
                this.maskTypes = new ArrayList<RangerDataMaskTypeDef>();
            }
            if (this.maskTypes == maskTypes) {
                return;
            }
            this.maskTypes.clear();
            if (maskTypes != null) {
                this.maskTypes.addAll(maskTypes);
            }
        }

        public List<RangerAccessTypeDef> getAccessTypes() {
            return this.accessTypes;
        }

        public void setAccessTypes(List<RangerAccessTypeDef> accessTypes) {
            if (this.accessTypes == null) {
                this.accessTypes = new ArrayList<RangerAccessTypeDef>();
            }
            if (this.accessTypes == accessTypes) {
                return;
            }
            this.accessTypes.clear();
            if (accessTypes != null) {
                this.accessTypes.addAll(accessTypes);
            }
        }

        public List<RangerResourceDef> getResources() {
            return this.resources;
        }

        public void setResources(List<RangerResourceDef> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList<RangerResourceDef>();
            }
            if (this.resources == resources) {
                return;
            }
            this.resources.clear();
            if (resources != null) {
                this.resources.addAll(resources);
            }
        }

        public void dedupStrings(Map<String, String> strTbl) {
            if (this.maskTypes != null) {
                for (RangerDataMaskTypeDef maskType : this.maskTypes) {
                    maskType.dedupStrings(strTbl);
                }
            }
            if (this.accessTypes != null) {
                for (RangerAccessTypeDef accessType : this.accessTypes) {
                    accessType.dedupStrings(strTbl);
                }
            }
            if (this.resources != null) {
                for (RangerResourceDef resource : this.resources) {
                    resource.dedupStrings(strTbl);
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerDataMaskDef={");
            sb.append("maskTypes={");
            if (this.maskTypes != null) {
                for (RangerDataMaskTypeDef maskType : this.maskTypes) {
                    if (maskType == null) continue;
                    sb.append(maskType).append(" ");
                }
            }
            sb.append("} ");
            sb.append("accessTypes={");
            if (this.accessTypes != null) {
                for (RangerAccessTypeDef accessType : this.accessTypes) {
                    if (accessType == null) continue;
                    accessType.toString(sb).append(" ");
                }
            }
            sb.append("} ");
            sb.append("resources={");
            if (this.resources != null) {
                for (RangerResourceDef resource : this.resources) {
                    if (resource == null) continue;
                    resource.toString(sb).append(" ");
                }
            }
            sb.append("} ");
            sb.append("}");
            return sb;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.maskTypes == null ? 0 : this.maskTypes.hashCode());
            result = 31 * result + (this.accessTypes == null ? 0 : this.accessTypes.hashCode());
            result = 31 * result + (this.resources == null ? 0 : this.resources.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerDataMaskDef other = (RangerDataMaskDef)obj;
            if (this.maskTypes == null ? other.maskTypes != null : other.maskTypes == null || !this.maskTypes.equals(other.maskTypes)) {
                return false;
            }
            if (this.accessTypes == null ? other.accessTypes != null : !this.accessTypes.equals(other.accessTypes)) {
                return false;
            }
            return !(this.resources == null ? other.resources != null : !this.resources.equals(other.resources));
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerContextEnricherDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long itemId;
        private String name;
        private String enricher;
        private Map<String, String> enricherOptions;

        public RangerContextEnricherDef() {
            this(null, null, null, null);
        }

        public RangerContextEnricherDef(Long itemId, String name, String enricher, Map<String, String> enricherOptions) {
            this.setItemId(itemId);
            this.setName(name);
            this.setEnricher(enricher);
            this.setEnricherOptions(enricherOptions);
        }

        public Long getItemId() {
            return this.itemId;
        }

        public void setItemId(Long itemId) {
            this.itemId = itemId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getEnricher() {
            return this.enricher;
        }

        public void setEnricher(String enricher) {
            this.enricher = enricher;
        }

        public Map<String, String> getEnricherOptions() {
            return this.enricherOptions;
        }

        public void setEnricherOptions(Map<String, String> enricherOptions) {
            this.enricherOptions = enricherOptions == null ? new HashMap() : enricherOptions;
        }

        public void dedupStrings(Map<String, String> strTbl) {
            this.name = StringUtil.dedupString(this.name, strTbl);
            this.enricher = StringUtil.dedupString(this.enricher, strTbl);
            this.enricherOptions = StringUtil.dedupStringsMap(this.enricherOptions, strTbl);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerContextEnricherDef={");
            sb.append("itemId={").append(this.itemId).append("} ");
            sb.append("name={").append(this.name).append("} ");
            sb.append("enricher={").append(this.enricher).append("} ");
            sb.append("enricherOptions={").append(this.enricherOptions).append("} ");
            sb.append("}");
            return sb;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
            result = 31 * result + (this.enricher == null ? 0 : this.enricher.hashCode());
            result = 31 * result + (this.enricherOptions == null ? 0 : this.enricherOptions.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerContextEnricherDef other = (RangerContextEnricherDef)obj;
            if (this.itemId == null ? other.itemId != null : other.itemId == null || !this.itemId.equals(other.itemId)) {
                return false;
            }
            if (this.enricher == null ? other.enricher != null : !this.enricher.equals(other.enricher)) {
                return false;
            }
            if (this.enricherOptions == null ? other.enricherOptions != null : !this.enricherOptions.equals(other.enricherOptions)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerPolicyConditionDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long itemId;
        private String name;
        private String evaluator;
        private Map<String, String> evaluatorOptions;
        private String validationRegEx;
        private String validationMessage;
        private String uiHint;
        private String label;
        private String description;
        private String rbKeyLabel;
        private String rbKeyDescription;
        private String rbKeyValidationMessage;

        public RangerPolicyConditionDef() {
            this(null, null, null, null, null, null, null, null, null, null, null, null);
        }

        public RangerPolicyConditionDef(Long itemId, String name, String evaluator, Map<String, String> evaluatorOptions) {
            this(itemId, name, evaluator, evaluatorOptions, null, null, null, null, null, null, null, null);
        }

        public RangerPolicyConditionDef(Long itemId, String name, String evaluator, Map<String, String> evaluatorOptions, String validationRegEx, String vaidationMessage, String uiHint, String label, String description, String rbKeyLabel, String rbKeyDescription, String rbKeyValidationMessage) {
            this.setItemId(itemId);
            this.setName(name);
            this.setEvaluator(evaluator);
            this.setEvaluatorOptions(evaluatorOptions);
            this.setValidationRegEx(validationRegEx);
            this.setValidationMessage(this.validationMessage);
            this.setUiHint(uiHint);
            this.setLabel(label);
            this.setDescription(description);
            this.setRbKeyLabel(rbKeyLabel);
            this.setRbKeyDescription(rbKeyDescription);
            this.setRbKeyValidationMessage(rbKeyValidationMessage);
        }

        public Long getItemId() {
            return this.itemId;
        }

        public void setItemId(Long itemId) {
            this.itemId = itemId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getEvaluator() {
            return this.evaluator;
        }

        public void setEvaluator(String evaluator) {
            this.evaluator = evaluator;
        }

        public Map<String, String> getEvaluatorOptions() {
            return this.evaluatorOptions;
        }

        public void setEvaluatorOptions(Map<String, String> evaluatorOptions) {
            this.evaluatorOptions = evaluatorOptions == null ? new HashMap() : evaluatorOptions;
        }

        public String getValidationRegEx() {
            return this.validationRegEx;
        }

        public void setValidationRegEx(String validationRegEx) {
            this.validationRegEx = validationRegEx;
        }

        public String getValidationMessage() {
            return this.validationMessage;
        }

        public void setValidationMessage(String validationMessage) {
            this.validationMessage = validationMessage;
        }

        public String getUiHint() {
            return this.uiHint;
        }

        public void setUiHint(String uiHint) {
            this.uiHint = uiHint;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getRbKeyLabel() {
            return this.rbKeyLabel;
        }

        public void setRbKeyLabel(String rbKeyLabel) {
            this.rbKeyLabel = rbKeyLabel;
        }

        public String getRbKeyDescription() {
            return this.rbKeyDescription;
        }

        public void setRbKeyDescription(String rbKeyDescription) {
            this.rbKeyDescription = rbKeyDescription;
        }

        public String getRbKeyValidationMessage() {
            return this.rbKeyValidationMessage;
        }

        public void setRbKeyValidationMessage(String rbKeyValidationMessage) {
            this.rbKeyValidationMessage = rbKeyValidationMessage;
        }

        public void dedupStrings(Map<String, String> strTbl) {
            this.name = StringUtil.dedupString(this.name, strTbl);
            this.evaluator = StringUtil.dedupString(this.evaluator, strTbl);
            this.evaluatorOptions = StringUtil.dedupStringsMap(this.evaluatorOptions, strTbl);
            this.validationRegEx = StringUtil.dedupString(this.validationRegEx, strTbl);
            this.validationMessage = StringUtil.dedupString(this.validationMessage, strTbl);
            this.uiHint = StringUtil.dedupString(this.uiHint, strTbl);
            this.label = StringUtil.dedupString(this.label, strTbl);
            this.description = StringUtil.dedupString(this.description, strTbl);
            this.rbKeyLabel = StringUtil.dedupString(this.rbKeyLabel, strTbl);
            this.rbKeyDescription = StringUtil.dedupString(this.rbKeyDescription, strTbl);
            this.rbKeyValidationMessage = StringUtil.dedupString(this.rbKeyValidationMessage, strTbl);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerPolicyConditionDef={");
            sb.append("itemId={").append(this.itemId).append("} ");
            sb.append("name={").append(this.name).append("} ");
            sb.append("evaluator={").append(this.evaluator).append("} ");
            sb.append("evaluatorOptions={").append(this.evaluatorOptions).append("} ");
            sb.append("validationRegEx={").append(this.validationRegEx).append("} ");
            sb.append("validationMessage={").append(this.validationMessage).append("} ");
            sb.append("uiHint={").append(this.uiHint).append("} ");
            sb.append("label={").append(this.label).append("} ");
            sb.append("description={").append(this.description).append("} ");
            sb.append("rbKeyLabel={").append(this.rbKeyLabel).append("} ");
            sb.append("rbKeyDescription={").append(this.rbKeyDescription).append("} ");
            sb.append("rbKeyValidationMessage={").append(this.rbKeyValidationMessage).append("} ");
            sb.append("}");
            return sb;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.evaluator == null ? 0 : this.evaluator.hashCode());
            result = 31 * result + (this.evaluatorOptions == null ? 0 : this.evaluatorOptions.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.rbKeyDescription == null ? 0 : this.rbKeyDescription.hashCode());
            result = 31 * result + (this.rbKeyLabel == null ? 0 : this.rbKeyLabel.hashCode());
            result = 31 * result + (this.rbKeyValidationMessage == null ? 0 : this.rbKeyValidationMessage.hashCode());
            result = 31 * result + (this.uiHint == null ? 0 : this.uiHint.hashCode());
            result = 31 * result + (this.validationMessage == null ? 0 : this.validationMessage.hashCode());
            result = 31 * result + (this.validationRegEx == null ? 0 : this.validationRegEx.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerPolicyConditionDef other = (RangerPolicyConditionDef)obj;
            if (this.itemId == null ? other.itemId != null : other.itemId != null || !this.itemId.equals(other.itemId)) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.evaluator == null ? other.evaluator != null : !this.evaluator.equals(other.evaluator)) {
                return false;
            }
            if (this.evaluatorOptions == null ? other.evaluatorOptions != null : !this.evaluatorOptions.equals(other.evaluatorOptions)) {
                return false;
            }
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.rbKeyDescription == null ? other.rbKeyDescription != null : !this.rbKeyDescription.equals(other.rbKeyDescription)) {
                return false;
            }
            if (this.rbKeyLabel == null ? other.rbKeyLabel != null : !this.rbKeyLabel.equals(other.rbKeyLabel)) {
                return false;
            }
            if (this.rbKeyValidationMessage == null ? other.rbKeyValidationMessage != null : !this.rbKeyValidationMessage.equals(other.rbKeyValidationMessage)) {
                return false;
            }
            if (this.uiHint == null ? other.uiHint != null : !this.uiHint.equals(other.uiHint)) {
                return false;
            }
            if (this.validationMessage == null ? other.validationMessage != null : !this.validationMessage.equals(other.validationMessage)) {
                return false;
            }
            return !(this.validationRegEx == null ? other.validationRegEx != null : !this.validationRegEx.equals(other.validationRegEx));
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerAccessTypeDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long itemId;
        private String name;
        private String label;
        private String rbKeyLabel;
        private Collection<String> impliedGrants;

        public RangerAccessTypeDef() {
            this(null, null, null, null, null);
        }

        public RangerAccessTypeDef(Long itemId, String name, String label, String rbKeyLabel, Collection<String> impliedGrants) {
            this.setItemId(itemId);
            this.setName(name);
            this.setLabel(label);
            this.setRbKeyLabel(rbKeyLabel);
            this.setImpliedGrants(impliedGrants);
        }

        public RangerAccessTypeDef(RangerAccessTypeDef other) {
            this.setItemId(other.getItemId());
            this.setName(other.getName());
            this.setLabel(other.getLabel());
            this.setRbKeyLabel(other.getRbKeyLabel());
            this.setImpliedGrants(other.getImpliedGrants());
        }

        public Long getItemId() {
            return this.itemId;
        }

        public void setItemId(Long itemId) {
            this.itemId = itemId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getRbKeyLabel() {
            return this.rbKeyLabel;
        }

        public void setRbKeyLabel(String rbKeyLabel) {
            this.rbKeyLabel = rbKeyLabel;
        }

        public Collection<String> getImpliedGrants() {
            return this.impliedGrants;
        }

        public void setImpliedGrants(Collection<String> impliedGrants) {
            if (this.impliedGrants == null) {
                this.impliedGrants = new ArrayList<String>();
            }
            if (this.impliedGrants == impliedGrants) {
                return;
            }
            this.impliedGrants.clear();
            if (impliedGrants != null) {
                this.impliedGrants.addAll(impliedGrants);
            }
        }

        public void dedupStrings(Map<String, String> strTbl) {
            this.name = StringUtil.dedupString(this.name, strTbl);
            this.label = StringUtil.dedupString(this.label, strTbl);
            this.rbKeyLabel = StringUtil.dedupString(this.rbKeyLabel, strTbl);
            this.impliedGrants = StringUtil.dedupStringsCollection(this.impliedGrants, strTbl);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerAccessTypeDef={");
            sb.append("itemId={").append(this.itemId).append("} ");
            sb.append("name={").append(this.name).append("} ");
            sb.append("label={").append(this.label).append("} ");
            sb.append("rbKeyLabel={").append(this.rbKeyLabel).append("} ");
            sb.append("impliedGrants={");
            if (this.impliedGrants != null) {
                for (String impliedGrant : this.impliedGrants) {
                    if (impliedGrant == null) continue;
                    sb.append(impliedGrant).append(" ");
                }
            }
            sb.append("} ");
            sb.append("}");
            return sb;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
            result = 31 * result + (this.impliedGrants == null ? 0 : this.impliedGrants.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.rbKeyLabel == null ? 0 : this.rbKeyLabel.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerAccessTypeDef other = (RangerAccessTypeDef)obj;
            if (this.itemId == null ? other.itemId != null : other.itemId == null || !this.itemId.equals(other.itemId)) {
                return false;
            }
            if (this.impliedGrants == null ? other.impliedGrants != null : !this.impliedGrants.equals(other.impliedGrants)) {
                return false;
            }
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.rbKeyLabel == null ? other.rbKeyLabel != null : !this.rbKeyLabel.equals(other.rbKeyLabel));
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerResourceDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long itemId = null;
        private String name = null;
        private String type = null;
        private Integer level = null;
        private String parent = null;
        private Boolean mandatory = null;
        private Boolean lookupSupported = null;
        private Boolean recursiveSupported = null;
        private Boolean excludesSupported = null;
        private String matcher = null;
        private Map<String, String> matcherOptions = null;
        private String validationRegEx = null;
        private String validationMessage = null;
        private String uiHint = null;
        private String label = null;
        private String description = null;
        private String rbKeyLabel = null;
        private String rbKeyDescription = null;
        private String rbKeyValidationMessage = null;
        private Set<String> accessTypeRestrictions = null;
        private Boolean isValidLeaf = null;

        public RangerResourceDef() {
            this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }

        public RangerResourceDef(RangerResourceDef other) {
            this.setItemId(other.getItemId());
            this.setName(other.getName());
            this.setType(other.getType());
            this.setLevel(other.getLevel());
            this.setParent(other.getParent());
            this.setMandatory(other.getMandatory());
            this.setLookupSupported(other.getLookupSupported());
            this.setRecursiveSupported(other.getRecursiveSupported());
            this.setExcludesSupported(other.getExcludesSupported());
            this.setMatcher(other.getMatcher());
            this.setMatcherOptions(other.getMatcherOptions());
            this.setValidationRegEx(other.getValidationRegEx());
            this.setValidationMessage(other.getValidationMessage());
            this.setUiHint(other.getUiHint());
            this.setLabel(other.getLabel());
            this.setDescription(other.getDescription());
            this.setRbKeyLabel(other.getRbKeyLabel());
            this.setRbKeyDescription(other.getRbKeyDescription());
            this.setRbKeyValidationMessage(other.getRbKeyValidationMessage());
            this.setAccessTypeRestrictions(other.getAccessTypeRestrictions());
            this.setIsValidLeaf(other.getIsValidLeaf());
        }

        public RangerResourceDef(Long itemId, String name, String type, Integer level, String parent, Boolean mandatory, Boolean lookupSupported, Boolean recursiveSupported, Boolean excludesSupported, String matcher, Map<String, String> matcherOptions, String validationRegEx, String validationMessage, String uiHint, String label, String description, String rbKeyLabel, String rbKeyDescription, String rbKeyValidationMessage, Set<String> accessTypeRestrictions, Boolean isValidLeaf) {
            this.setItemId(itemId);
            this.setName(name);
            this.setType(type);
            this.setLevel(level);
            this.setParent(parent);
            this.setMandatory(mandatory);
            this.setLookupSupported(lookupSupported);
            this.setRecursiveSupported(recursiveSupported);
            this.setExcludesSupported(excludesSupported);
            this.setMatcher(matcher);
            this.setMatcherOptions(matcherOptions);
            this.setValidationRegEx(validationRegEx);
            this.setValidationMessage(validationMessage);
            this.setUiHint(uiHint);
            this.setLabel(label);
            this.setDescription(description);
            this.setRbKeyLabel(rbKeyLabel);
            this.setRbKeyDescription(rbKeyDescription);
            this.setRbKeyValidationMessage(rbKeyValidationMessage);
            this.setAccessTypeRestrictions(accessTypeRestrictions);
            this.setIsValidLeaf(isValidLeaf);
        }

        public Long getItemId() {
            return this.itemId;
        }

        public void setItemId(Long itemId) {
            this.itemId = itemId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Integer getLevel() {
            return this.level;
        }

        public void setLevel(Integer level) {
            this.level = level == null ? 1 : level;
        }

        public String getParent() {
            return this.parent;
        }

        public void setParent(String parent) {
            this.parent = parent;
        }

        public Boolean getMandatory() {
            return this.mandatory;
        }

        public void setMandatory(Boolean mandatory) {
            this.mandatory = mandatory == null ? Boolean.FALSE : mandatory;
        }

        public Boolean getLookupSupported() {
            return this.lookupSupported;
        }

        public void setLookupSupported(Boolean lookupSupported) {
            this.lookupSupported = lookupSupported == null ? Boolean.FALSE : lookupSupported;
        }

        public Boolean getRecursiveSupported() {
            return this.recursiveSupported;
        }

        public void setRecursiveSupported(Boolean recursiveSupported) {
            this.recursiveSupported = recursiveSupported == null ? Boolean.FALSE : recursiveSupported;
        }

        public Boolean getExcludesSupported() {
            return this.excludesSupported;
        }

        public void setExcludesSupported(Boolean excludesSupported) {
            this.excludesSupported = excludesSupported == null ? Boolean.FALSE : excludesSupported;
        }

        public String getMatcher() {
            return this.matcher;
        }

        public void setMatcher(String matcher) {
            this.matcher = matcher;
        }

        public Map<String, String> getMatcherOptions() {
            return this.matcherOptions;
        }

        public void setMatcherOptions(Map<String, String> matcherOptions) {
            this.matcherOptions = matcherOptions == null ? new HashMap<String, String>() : new HashMap<String, String>(matcherOptions);
        }

        public String getValidationRegEx() {
            return this.validationRegEx;
        }

        public void setValidationRegEx(String validationRegEx) {
            this.validationRegEx = validationRegEx;
        }

        public String getValidationMessage() {
            return this.validationMessage;
        }

        public void setValidationMessage(String validationMessage) {
            this.validationMessage = validationMessage;
        }

        public String getUiHint() {
            return this.uiHint;
        }

        public void setUiHint(String uiHint) {
            this.uiHint = uiHint;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getRbKeyLabel() {
            return this.rbKeyLabel;
        }

        public void setRbKeyLabel(String rbKeyLabel) {
            this.rbKeyLabel = rbKeyLabel;
        }

        public String getRbKeyDescription() {
            return this.rbKeyDescription;
        }

        public void setRbKeyDescription(String rbKeyDescription) {
            this.rbKeyDescription = rbKeyDescription;
        }

        public String getRbKeyValidationMessage() {
            return this.rbKeyValidationMessage;
        }

        public void setRbKeyValidationMessage(String rbKeyValidationMessage) {
            this.rbKeyValidationMessage = rbKeyValidationMessage;
        }

        public Set<String> getAccessTypeRestrictions() {
            return this.accessTypeRestrictions;
        }

        public void setAccessTypeRestrictions(Set<String> accessTypeRestrictions) {
            this.accessTypeRestrictions = accessTypeRestrictions == null ? new HashSet<String>() : new HashSet<String>(accessTypeRestrictions);
        }

        public Boolean getIsValidLeaf() {
            return this.isValidLeaf;
        }

        public void setIsValidLeaf(Boolean isValidLeaf) {
            this.isValidLeaf = isValidLeaf;
        }

        public void dedupStrings(Map<String, String> strTbl) {
            this.name = StringUtil.dedupString(this.name, strTbl);
            this.type = StringUtil.dedupString(this.type, strTbl);
            this.parent = StringUtil.dedupString(this.parent, strTbl);
            this.matcher = StringUtil.dedupString(this.matcher, strTbl);
            this.matcherOptions = StringUtil.dedupStringsMap(this.matcherOptions, strTbl);
            this.validationRegEx = StringUtil.dedupString(this.validationRegEx, strTbl);
            this.validationMessage = StringUtil.dedupString(this.validationMessage, strTbl);
            this.uiHint = StringUtil.dedupString(this.uiHint, strTbl);
            this.label = StringUtil.dedupString(this.label, strTbl);
            this.description = StringUtil.dedupString(this.description, strTbl);
            this.rbKeyLabel = StringUtil.dedupString(this.rbKeyLabel, strTbl);
            this.rbKeyDescription = StringUtil.dedupString(this.rbKeyDescription, strTbl);
            this.rbKeyValidationMessage = StringUtil.dedupString(this.rbKeyValidationMessage, strTbl);
            this.accessTypeRestrictions = StringUtil.dedupStringsSet(this.accessTypeRestrictions, strTbl);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerResourceDef={");
            sb.append("itemId={").append(this.itemId).append("} ");
            sb.append("name={").append(this.name).append("} ");
            sb.append("type={").append(this.type).append("} ");
            sb.append("level={").append(this.level).append("} ");
            sb.append("parent={").append(this.parent).append("} ");
            sb.append("mandatory={").append(this.mandatory).append("} ");
            sb.append("lookupSupported={").append(this.lookupSupported).append("} ");
            sb.append("recursiveSupported={").append(this.recursiveSupported).append("} ");
            sb.append("excludesSupported={").append(this.excludesSupported).append("} ");
            sb.append("matcher={").append(this.matcher).append("} ");
            sb.append("matcherOptions={").append(this.matcherOptions).append("} ");
            sb.append("validationRegEx={").append(this.validationRegEx).append("} ");
            sb.append("validationMessage={").append(this.validationMessage).append("} ");
            sb.append("uiHint={").append(this.uiHint).append("} ");
            sb.append("label={").append(this.label).append("} ");
            sb.append("description={").append(this.description).append("} ");
            sb.append("rbKeyLabel={").append(this.rbKeyLabel).append("} ");
            sb.append("rbKeyDescription={").append(this.rbKeyDescription).append("} ");
            sb.append("rbKeyValidationMessage={").append(this.rbKeyValidationMessage).append("} ");
            sb.append("accessTypeRestrictions={").append(this.accessTypeRestrictions == null ? "null" : this.accessTypeRestrictions.toString()).append("} ");
            sb.append("isValidLeaf={").append(this.isValidLeaf == null ? "null" : this.isValidLeaf.toString()).append("} ");
            sb.append("}");
            return sb;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.excludesSupported == null ? 0 : this.excludesSupported.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
            result = 31 * result + (this.lookupSupported == null ? 0 : this.lookupSupported.hashCode());
            result = 31 * result + (this.mandatory == null ? 0 : this.mandatory.hashCode());
            result = 31 * result + (this.matcher == null ? 0 : this.matcher.hashCode());
            result = 31 * result + (this.matcherOptions == null ? 0 : this.matcherOptions.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            result = 31 * result + (this.rbKeyDescription == null ? 0 : this.rbKeyDescription.hashCode());
            result = 31 * result + (this.rbKeyLabel == null ? 0 : this.rbKeyLabel.hashCode());
            result = 31 * result + (this.rbKeyValidationMessage == null ? 0 : this.rbKeyValidationMessage.hashCode());
            result = 31 * result + (this.recursiveSupported == null ? 0 : this.recursiveSupported.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.uiHint == null ? 0 : this.uiHint.hashCode());
            result = 31 * result + (this.validationMessage == null ? 0 : this.validationMessage.hashCode());
            result = 31 * result + (this.validationRegEx == null ? 0 : this.validationRegEx.hashCode());
            result = 31 * result + (this.accessTypeRestrictions == null ? 0 : this.accessTypeRestrictions.hashCode());
            result = 31 * result + (this.isValidLeaf == null ? 0 : this.isValidLeaf.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerResourceDef other = (RangerResourceDef)obj;
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.excludesSupported == null ? other.excludesSupported != null : !this.excludesSupported.equals(other.excludesSupported)) {
                return false;
            }
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            if (this.level == null ? other.level != null : !this.level.equals(other.level)) {
                return false;
            }
            if (this.lookupSupported == null ? other.lookupSupported != null : !this.lookupSupported.equals(other.lookupSupported)) {
                return false;
            }
            if (this.mandatory == null ? other.mandatory != null : !this.mandatory.equals(other.mandatory)) {
                return false;
            }
            if (this.matcher == null ? other.matcher != null : !this.matcher.equals(other.matcher)) {
                return false;
            }
            if (this.matcherOptions == null ? other.matcherOptions != null : !this.matcherOptions.equals(other.matcherOptions)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
                return false;
            }
            if (this.rbKeyDescription == null ? other.rbKeyDescription != null : !this.rbKeyDescription.equals(other.rbKeyDescription)) {
                return false;
            }
            if (this.rbKeyLabel == null ? other.rbKeyLabel != null : !this.rbKeyLabel.equals(other.rbKeyLabel)) {
                return false;
            }
            if (this.rbKeyValidationMessage == null ? other.rbKeyValidationMessage != null : !this.rbKeyValidationMessage.equals(other.rbKeyValidationMessage)) {
                return false;
            }
            if (this.recursiveSupported == null ? other.recursiveSupported != null : !this.recursiveSupported.equals(other.recursiveSupported)) {
                return false;
            }
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            if (this.uiHint == null ? other.uiHint != null : !this.uiHint.equals(other.uiHint)) {
                return false;
            }
            if (this.validationMessage == null ? other.validationMessage != null : !this.validationMessage.equals(other.validationMessage)) {
                return false;
            }
            if (this.validationRegEx == null ? other.validationRegEx != null : !this.validationRegEx.equals(other.validationRegEx)) {
                return false;
            }
            if (this.accessTypeRestrictions == null ? other.accessTypeRestrictions != null : !this.accessTypeRestrictions.equals(other.accessTypeRestrictions)) {
                return false;
            }
            return !(this.isValidLeaf == null ? other.isValidLeaf != null : !this.isValidLeaf.equals(other.isValidLeaf));
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerServiceConfigDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long itemId;
        private String name;
        private String type;
        private String subType;
        private Boolean mandatory;
        private String defaultValue;
        private String validationRegEx;
        private String validationMessage;
        private String uiHint;
        private String label;
        private String description;
        private String rbKeyLabel;
        private String rbKeyDescription;
        private String rbKeyValidationMessage;

        public RangerServiceConfigDef() {
            this(null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }

        public RangerServiceConfigDef(Long itemId, String name, String type, String subType, Boolean mandatory, String defaultValue, String validationRegEx, String validationMessage, String uiHint, String label, String description, String rbKeyLabel, String rbKeyDescription, String rbKeyValidationMessage) {
            this.setItemId(itemId);
            this.setName(name);
            this.setType(type);
            this.setSubType(subType);
            this.setMandatory(mandatory);
            this.setDefaultValue(defaultValue);
            this.setValidationRegEx(validationRegEx);
            this.setValidationMessage(validationMessage);
            this.setUiHint(uiHint);
            this.setLabel(label);
            this.setDescription(description);
            this.setRbKeyLabel(rbKeyLabel);
            this.setRbKeyDescription(rbKeyDescription);
            this.setRbKeyValidationMessage(rbKeyValidationMessage);
        }

        public Long getItemId() {
            return this.itemId;
        }

        public void setItemId(Long itemId) {
            this.itemId = itemId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getSubType() {
            return this.subType;
        }

        public void setSubType(String subType) {
            this.subType = subType;
        }

        public Boolean getMandatory() {
            return this.mandatory;
        }

        public void setMandatory(Boolean mandatory) {
            this.mandatory = mandatory == null ? Boolean.FALSE : mandatory;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getValidationRegEx() {
            return this.validationRegEx;
        }

        public void setValidationRegEx(String validationRegEx) {
            this.validationRegEx = validationRegEx;
        }

        public String getValidationMessage() {
            return this.validationMessage;
        }

        public void setValidationMessage(String validationMessage) {
            this.validationMessage = validationMessage;
        }

        public String getUiHint() {
            return this.uiHint;
        }

        public void setUiHint(String uiHint) {
            this.uiHint = uiHint;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getRbKeyLabel() {
            return this.rbKeyLabel;
        }

        public void setRbKeyLabel(String rbKeyLabel) {
            this.rbKeyLabel = rbKeyLabel;
        }

        public String getRbKeyDescription() {
            return this.rbKeyDescription;
        }

        public void setRbKeyDescription(String rbKeyDescription) {
            this.rbKeyDescription = rbKeyDescription;
        }

        public String getRbKeyValidationMessage() {
            return this.rbKeyValidationMessage;
        }

        public void setRbKeyValidationMessage(String rbKeyValidationMessage) {
            this.rbKeyValidationMessage = rbKeyValidationMessage;
        }

        public void dedupStrings(Map<String, String> strTbl) {
            this.name = StringUtil.dedupString(this.name, strTbl);
            this.type = StringUtil.dedupString(this.type, strTbl);
            this.subType = StringUtil.dedupString(this.subType, strTbl);
            this.defaultValue = StringUtil.dedupString(this.defaultValue, strTbl);
            this.validationRegEx = StringUtil.dedupString(this.validationRegEx, strTbl);
            this.validationMessage = StringUtil.dedupString(this.validationMessage, strTbl);
            this.uiHint = StringUtil.dedupString(this.uiHint, strTbl);
            this.label = StringUtil.dedupString(this.label, strTbl);
            this.description = StringUtil.dedupString(this.description, strTbl);
            this.rbKeyLabel = StringUtil.dedupString(this.rbKeyLabel, strTbl);
            this.rbKeyDescription = StringUtil.dedupString(this.rbKeyDescription, strTbl);
            this.rbKeyValidationMessage = StringUtil.dedupString(this.rbKeyValidationMessage, strTbl);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerServiceConfigDef={");
            sb.append("itemId={").append(this.name).append("} ");
            sb.append("name={").append(this.name).append("} ");
            sb.append("type={").append(this.type).append("} ");
            sb.append("subType={").append(this.subType).append("} ");
            sb.append("mandatory={").append(this.mandatory).append("} ");
            sb.append("defaultValue={").append(this.defaultValue).append("} ");
            sb.append("validationRegEx={").append(this.validationRegEx).append("} ");
            sb.append("validationMessage={").append(this.validationMessage).append("} ");
            sb.append("uiHint={").append(this.uiHint).append("} ");
            sb.append("label={").append(this.label).append("} ");
            sb.append("description={").append(this.description).append("} ");
            sb.append("rbKeyLabel={").append(this.rbKeyLabel).append("} ");
            sb.append("rbKeyDescription={").append(this.rbKeyDescription).append("} ");
            sb.append("rbKeyValidationMessage={").append(this.rbKeyValidationMessage).append("} ");
            sb.append("}");
            return sb;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.mandatory == null ? 0 : this.mandatory.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.rbKeyDescription == null ? 0 : this.rbKeyDescription.hashCode());
            result = 31 * result + (this.rbKeyLabel == null ? 0 : this.rbKeyLabel.hashCode());
            result = 31 * result + (this.rbKeyValidationMessage == null ? 0 : this.rbKeyValidationMessage.hashCode());
            result = 31 * result + (this.subType == null ? 0 : this.subType.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.uiHint == null ? 0 : this.uiHint.hashCode());
            result = 31 * result + (this.validationMessage == null ? 0 : this.validationMessage.hashCode());
            result = 31 * result + (this.validationRegEx == null ? 0 : this.validationRegEx.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerServiceConfigDef other = (RangerServiceConfigDef)obj;
            if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            if (this.mandatory == null ? other.mandatory != null : !this.mandatory.equals(other.mandatory)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.rbKeyDescription == null ? other.rbKeyDescription != null : !this.rbKeyDescription.equals(other.rbKeyDescription)) {
                return false;
            }
            if (this.rbKeyLabel == null ? other.rbKeyLabel != null : !this.rbKeyLabel.equals(other.rbKeyLabel)) {
                return false;
            }
            if (this.rbKeyValidationMessage == null ? other.rbKeyValidationMessage != null : !this.rbKeyValidationMessage.equals(other.rbKeyValidationMessage)) {
                return false;
            }
            if (this.subType == null ? other.subType != null : !this.subType.equals(other.subType)) {
                return false;
            }
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            if (this.uiHint == null ? other.uiHint != null : !this.uiHint.equals(other.uiHint)) {
                return false;
            }
            if (this.validationMessage == null ? other.validationMessage != null : !this.validationMessage.equals(other.validationMessage)) {
                return false;
            }
            return !(this.validationRegEx == null ? other.validationRegEx != null : !this.validationRegEx.equals(other.validationRegEx));
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerEnumElementDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long itemId;
        private String name;
        private String label;
        private String rbKeyLabel;

        public RangerEnumElementDef() {
            this(null, null, null, null);
        }

        public RangerEnumElementDef(Long itemId, String name, String label, String rbKeyLabel) {
            this.setItemId(itemId);
            this.setName(name);
            this.setLabel(label);
            this.setRbKeyLabel(rbKeyLabel);
        }

        public Long getItemId() {
            return this.itemId;
        }

        public void setItemId(Long itemId) {
            this.itemId = itemId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getRbKeyLabel() {
            return this.rbKeyLabel;
        }

        public void setRbKeyLabel(String rbKeyLabel) {
            this.rbKeyLabel = rbKeyLabel;
        }

        public void dedupStrings(Map<String, String> strTbl) {
            this.name = StringUtil.dedupString(this.name, strTbl);
            this.label = StringUtil.dedupString(this.label, strTbl);
            this.rbKeyLabel = StringUtil.dedupString(this.rbKeyLabel, strTbl);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerEnumElementDef={");
            sb.append("itemId={").append(this.itemId).append("} ");
            sb.append("name={").append(this.name).append("} ");
            sb.append("label={").append(this.label).append("} ");
            sb.append("rbKeyLabel={").append(this.rbKeyLabel).append("} ");
            sb.append("}");
            return sb;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.rbKeyLabel == null ? 0 : this.rbKeyLabel.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerEnumElementDef other = (RangerEnumElementDef)obj;
            if (this.itemId == null ? other.itemId != null : other.itemId == null || !this.itemId.equals(other.itemId)) {
                return false;
            }
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.rbKeyLabel == null ? other.rbKeyLabel != null : !this.rbKeyLabel.equals(other.rbKeyLabel));
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RangerEnumDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long itemId;
        private String name;
        private List<RangerEnumElementDef> elements;
        private Integer defaultIndex;

        public RangerEnumDef() {
            this(null, null, null, null);
        }

        public RangerEnumDef(Long itemId, String name, List<RangerEnumElementDef> elements, Integer defaultIndex) {
            this.setItemId(itemId);
            this.setName(name);
            this.setElements(elements);
            this.setDefaultIndex(defaultIndex);
        }

        public Long getItemId() {
            return this.itemId;
        }

        public void setItemId(Long itemId) {
            this.itemId = itemId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<RangerEnumElementDef> getElements() {
            return this.elements;
        }

        public void setElements(List<RangerEnumElementDef> elements) {
            if (this.elements == null) {
                this.elements = new ArrayList<RangerEnumElementDef>();
            }
            if (this.elements == elements) {
                return;
            }
            this.elements.clear();
            if (elements != null) {
                this.elements.addAll(elements);
            }
        }

        public Integer getDefaultIndex() {
            return this.defaultIndex;
        }

        public void setDefaultIndex(Integer defaultIndex) {
            this.defaultIndex = defaultIndex != null && this.elements.size() > defaultIndex ? defaultIndex : 0;
        }

        public void dedupStrings(Map<String, String> strTbl) {
            this.name = StringUtil.dedupString(this.name, strTbl);
            for (RangerEnumElementDef element : this.elements) {
                element.dedupStrings(strTbl);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            sb.append("RangerEnumDef={");
            sb.append("itemId={").append(this.itemId).append("} ");
            sb.append("name={").append(this.name).append("} ");
            sb.append("elements={");
            if (this.elements != null) {
                for (RangerEnumElementDef element : this.elements) {
                    if (element == null) continue;
                    element.toString(sb);
                }
            }
            sb.append("} ");
            sb.append("defaultIndex={").append(this.defaultIndex).append("} ");
            sb.append("}");
            return sb;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
            result = 31 * result + (this.defaultIndex == null ? 0 : this.defaultIndex.hashCode());
            result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerEnumDef other = (RangerEnumDef)obj;
            if (this.itemId == null ? other.itemId != null : other.itemId == null || !this.itemId.equals(other.itemId)) {
                return false;
            }
            if (this.defaultIndex == null ? other.defaultIndex != null : !this.defaultIndex.equals(other.defaultIndex)) {
                return false;
            }
            if (this.elements == null ? other.elements != null : !this.elements.equals(other.elements)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

