/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.security;

import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.security.SelectedRole;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class Identity {
    private final String user;
    private final Set<String> groups;
    private final Optional<Principal> principal;
    private final Map<String, SelectedRole> roles;
    private final Map<String, String> extraCredentials;
    private final Optional<Runnable> onDestroy;

    private Identity(String user, Set<String> groups, Optional<Principal> principal, Map<String, SelectedRole> roles, Map<String, String> extraCredentials, Optional<Runnable> onDestroy) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.groups = Collections.unmodifiableSet(new HashSet(Objects.requireNonNull(groups, "groups is null")));
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.roles = Collections.unmodifiableMap(new HashMap<String, SelectedRole>(Objects.requireNonNull(roles, "roles is null")));
        this.extraCredentials = Collections.unmodifiableMap(new HashMap<String, String>(Objects.requireNonNull(extraCredentials, "extraCredentials is null")));
        this.onDestroy = Objects.requireNonNull(onDestroy, "onDestroy is null");
    }

    public String getUser() {
        return this.user;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public Optional<Principal> getPrincipal() {
        return this.principal;
    }

    public Map<String, SelectedRole> getRoles() {
        return this.roles;
    }

    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    public ConnectorIdentity toConnectorIdentity() {
        return ConnectorIdentity.forUser(this.user).withGroups(this.groups).withPrincipal(this.principal).withExtraCredentials(this.extraCredentials).build();
    }

    public ConnectorIdentity toConnectorIdentity(String catalog) {
        return ConnectorIdentity.forUser(this.user).withGroups(this.groups).withPrincipal(this.principal).withRole(Optional.ofNullable(this.roles.get(catalog))).withExtraCredentials(this.extraCredentials).build();
    }

    public void destroy() {
        this.onDestroy.ifPresent(Runnable::run);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identity identity = (Identity)o;
        return Objects.equals(this.user, identity.user);
    }

    public int hashCode() {
        return Objects.hash(this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Identity{");
        sb.append("user='").append(this.user).append('\'');
        sb.append(", groups=").append(this.groups);
        this.principal.ifPresent(principal -> sb.append(", principal=").append(principal));
        sb.append(", roles=").append(this.roles);
        sb.append(", extraCredentials=").append(this.extraCredentials.keySet());
        sb.append('}');
        return sb.toString();
    }

    public static Identity ofUser(String user) {
        return new Builder(user).build();
    }

    public static Builder forUser(String user) {
        return new Builder(user);
    }

    public static Builder from(Identity identity) {
        return new Builder(identity.getUser()).withGroups(identity.getGroups()).withPrincipal(identity.getPrincipal()).withRoles(identity.getRoles()).withExtraCredentials(identity.getExtraCredentials());
    }

    private static final class InvokeOnceRunnable
    implements Runnable {
        private final Runnable delegate;
        private final AtomicBoolean invoked = new AtomicBoolean();

        public InvokeOnceRunnable(Runnable delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void run() {
            if (this.invoked.compareAndSet(false, true)) {
                this.delegate.run();
            }
        }
    }

    public static class Builder {
        private String user;
        private Set<String> groups = new HashSet<String>();
        private Optional<Principal> principal = Optional.empty();
        private Map<String, SelectedRole> roles = new HashMap<String, SelectedRole>();
        private Map<String, String> extraCredentials = new HashMap<String, String>();
        private Optional<Runnable> onDestroy = Optional.empty();

        public Builder(String user) {
            this.user = Objects.requireNonNull(user, "user is null");
        }

        public Builder withUser(String user) {
            this.user = Objects.requireNonNull(user, "user is null");
            return this;
        }

        public Builder withPrincipal(Principal principal) {
            return this.withPrincipal(Optional.of(Objects.requireNonNull(principal, "principal is null")));
        }

        public Builder withPrincipal(Optional<Principal> principal) {
            this.principal = Objects.requireNonNull(principal, "principal is null");
            return this;
        }

        public Builder withRole(String catalog, SelectedRole role) {
            Objects.requireNonNull(catalog, "catalog is null");
            Objects.requireNonNull(role, "role is null");
            if (this.roles.put(catalog, role) != null) {
                throw new IllegalStateException("There is already role set for " + catalog);
            }
            return this;
        }

        public Builder withRoles(Map<String, SelectedRole> roles) {
            this.roles = new HashMap<String, SelectedRole>(Objects.requireNonNull(roles, "roles is null"));
            return this;
        }

        public Builder withAdditionalRoles(Map<String, SelectedRole> roles) {
            this.roles.putAll(Objects.requireNonNull(roles, "roles is null"));
            return this;
        }

        public Builder withExtraCredentials(Map<String, String> extraCredentials) {
            this.extraCredentials = new HashMap<String, String>(Objects.requireNonNull(extraCredentials, "extraCredentials is null"));
            return this;
        }

        public Builder withAdditionalExtraCredentials(Map<String, String> extraCredentials) {
            this.extraCredentials.putAll(Objects.requireNonNull(extraCredentials, "extraCredentials is null"));
            return this;
        }

        public void withOnDestroy(Runnable onDestroy) {
            Objects.requireNonNull(onDestroy, "onDestroy is null");
            if (this.onDestroy.isPresent()) {
                throw new IllegalStateException("Destroy callback already set");
            }
            this.onDestroy = Optional.of(new InvokeOnceRunnable(onDestroy));
        }

        public Builder withGroups(Set<String> groups) {
            this.groups = new HashSet<String>((Collection)Objects.requireNonNull(groups, "groups is null"));
            return this;
        }

        public Builder withAdditionalGroups(Set<String> groups) {
            this.groups.addAll((Collection<String>)Objects.requireNonNull(groups, "groups is null"));
            return this;
        }

        public Identity build() {
            return new Identity(this.user, this.groups, this.principal, this.roles, this.extraCredentials, this.onDestroy);
        }
    }
}

