/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.util.function.CheckedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(Scheduler.class);
    private ScheduledExecutorService scheduledExecutorService;
    private volatile boolean isClosed;
    private String threadName;

    public Scheduler(String threadName, boolean isDaemon, int numCoreThreads) {
        this.scheduledExecutorService = Executors.newScheduledThreadPool(numCoreThreads, r -> {
            Thread t = new Thread(r);
            t.setName(threadName);
            t.setDaemon(isDaemon);
            return t;
        });
        this.threadName = threadName;
        this.isClosed = false;
    }

    public void schedule(Runnable runnable, long delay, TimeUnit timeUnit) {
        this.scheduledExecutorService.schedule(runnable, delay, timeUnit);
    }

    public void schedule(CheckedRunnable runnable, long delay, TimeUnit timeUnit, Logger logger, String errMsg) {
        this.scheduledExecutorService.schedule(() -> {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                logger.error(errMsg, throwable);
            }
        }, delay, timeUnit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long initialDelay, long fixedDelay, TimeUnit timeUnit) {
        return this.scheduledExecutorService.scheduleWithFixedDelay(runnable, initialDelay, fixedDelay, timeUnit);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void close() {
        this.isClosed = true;
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
            try {
                this.scheduledExecutorService.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.info("{} interrupted while waiting for task completion {}", (Object)this.threadName, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
        this.scheduledExecutorService = null;
    }
}

