/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="hdds.scm")
public class ScmConfig {
    @Config(key="kerberos.principal", type=ConfigType.STRING, defaultValue="", tags={ConfigTag.SECURITY, ConfigTag.OZONE}, description="This Kerberos principal is used by the SCM service.")
    private String principal;
    @Config(key="kerberos.keytab.file", type=ConfigType.STRING, defaultValue="", tags={ConfigTag.SECURITY, ConfigTag.OZONE}, description="The keytab file used by SCM daemon to login as its service principal.")
    private String keytab;
    @Config(key="unknown-container.action", type=ConfigType.STRING, defaultValue="WARN", tags={ConfigTag.SCM, ConfigTag.MANAGEMENT}, description="The action taken by SCM to process unknown containers that reported by Datanodes. The default action is just logging container not found warning, another available action is DELETE action. These unknown containers will be deleted under this action way.")
    private String action;
    public static final String HDDS_SCM_UNKNOWN_CONTAINER_ACTION = "hdds.scm.unknown-container.action";

    public void setKerberosPrincipal(String kerberosPrincipal) {
        this.principal = kerberosPrincipal;
    }

    public void setKerberosKeytab(String kerberosKeytab) {
        this.keytab = kerberosKeytab;
    }

    public void setUnknownContainerAction(String unknownContainerAction) {
        this.action = unknownContainerAction;
    }

    public String getKerberosPrincipal() {
        return this.principal;
    }

    public String getKerberosKeytab() {
        return this.keytab;
    }

    public String getUnknownContainerAction() {
        return this.action;
    }

    public static class ConfigStrings {
        public static final String HDDS_SCM_KERBEROS_PRINCIPAL_KEY = "hdds.scm.kerberos.principal";
        public static final String HDDS_SCM_KERBEROS_KEYTAB_FILE_KEY = "hdds.scm.kerberos.keytab.file";
    }
}

