/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.ratis.conf;

import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="hdds.ratis")
public class RatisClientConfig {
    @Config(key="client.request.write.timeout", defaultValue="5m", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="Timeout for ratis client write request.")
    private long writeRequestTimeoutInMs;
    @Config(key="client.request.watch.timeout", defaultValue="3m", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="Timeout for ratis client watch request.")
    private long watchRequestTimeoutInMs;
    @Config(key="client.multilinear.random.retry.policy", defaultValue="5s, 5, 10s, 5, 15s, 5, 20s, 5, 25s, 5, 60s, 10", type=ConfigType.STRING, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="Specifies multilinear random retry policy to be used by ratis client. e.g. given pairs of number of retries and sleep time (n0, t0), (n1, t1), ..., for the first n0 retries sleep duration is t0 on average, the following n1 retries sleep duration is t1 on average, and so on.")
    private String multilinearPolicy;
    @Config(key="client.exponential.backoff.base.sleep", defaultValue="4s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="Specifies base sleep for exponential backoff retry policy. With the default base sleep of 4s, the sleep duration for ith retry is min(4 * pow(2, i), max_sleep) * r, where r is random number in the range [0.5, 1.5).")
    private long exponentialPolicyBaseSleepInMs;
    @Config(key="client.exponential.backoff.max.sleep", defaultValue="40s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="The sleep duration obtained from exponential backoff policy is limited by the configured max sleep. Refer dfs.ratis.client.exponential.backoff.base.sleep for further details.")
    private long exponentialPolicyMaxSleepInMs;

    public long getWriteRequestTimeoutInMs() {
        return this.writeRequestTimeoutInMs;
    }

    public void setWriteRequestTimeoutInMs(long writeRequestTimeOut) {
        this.writeRequestTimeoutInMs = writeRequestTimeOut;
    }

    public long getWatchRequestTimeoutInMs() {
        return this.watchRequestTimeoutInMs;
    }

    public void setWatchRequestTimeoutInMs(long watchRequestTimeoutInMs) {
        this.watchRequestTimeoutInMs = watchRequestTimeoutInMs;
    }

    public String getMultilinearPolicy() {
        return this.multilinearPolicy;
    }

    public void setMultilinearPolicy(String multilinearPolicy) {
        this.multilinearPolicy = multilinearPolicy;
    }

    public long getExponentialPolicyBaseSleepInMs() {
        return this.exponentialPolicyBaseSleepInMs;
    }

    public void setExponentialPolicyBaseSleepInMs(long exponentialPolicyBaseSleepInMs) {
        this.exponentialPolicyBaseSleepInMs = exponentialPolicyBaseSleepInMs;
    }

    public long getExponentialPolicyMaxSleepInMs() {
        return this.exponentialPolicyMaxSleepInMs;
    }

    public void setExponentialPolicyMaxSleepInMs(long exponentialPolicyMaxSleepInMs) {
        this.exponentialPolicyMaxSleepInMs = exponentialPolicyMaxSleepInMs;
    }

    @ConfigGroup(prefix="hdds.ratis.raft.client")
    public static class RaftConfig {
        @Config(key="async.outstanding-requests.max", defaultValue="32", type=ConfigType.INT, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="Controls the maximum number of outstanding async requests that can be handled by the Standalone as well as Ratis client.")
        private int maxOutstandingRequests;
        @Config(key="rpc.request.timeout", defaultValue="60s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="The timeout duration for ratis client request (except for watch request). It should be set greater than leader election timeout in Ratis.")
        private long rpcRequestTimeout = 60000L;
        @Config(key="rpc.watch.request.timeout", defaultValue="180s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.CLIENT, ConfigTag.PERFORMANCE}, description="The timeout duration for ratis client watch request. Timeout for the watch API in Ratis client to acknowledge a particular request getting replayed to all servers.")
        private long rpcWatchRequestTimeout = 180000L;

        public int getMaxOutstandingRequests() {
            return this.maxOutstandingRequests;
        }

        public void setMaxOutstandingRequests(int maxOutstandingRequests) {
            this.maxOutstandingRequests = maxOutstandingRequests;
        }

        public long getRpcRequestTimeout() {
            return this.rpcRequestTimeout;
        }

        public void setRpcRequestTimeout(long rpcRequestTimeout) {
            this.rpcRequestTimeout = rpcRequestTimeout;
        }

        public long getRpcWatchRequestTimeout() {
            return this.rpcWatchRequestTimeout;
        }

        public void setRpcWatchRequestTimeout(long rpcWatchRequestTimeout) {
            this.rpcWatchRequestTimeout = rpcWatchRequestTimeout;
        }
    }
}

