/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.ShapeQuery;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.geo.XYRectangle2D;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.NumericUtils;

public class XYShapeBoundingBoxQuery
extends ShapeQuery {
    final Component2D rectangle2D;
    private final XYRectangle rectangle;

    public XYShapeBoundingBoxQuery(String field, ShapeField.QueryRelation queryRelation, double minX, double maxX, double minY, double maxY) {
        super(field, queryRelation);
        this.rectangle = new XYRectangle(minX, maxX, minY, maxY);
        this.rectangle2D = XYRectangle2D.create(this.rectangle);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        double minY = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])minTriangle, (int)minYOffset));
        double minX = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])minTriangle, (int)minXOffset));
        double maxY = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])maxTriangle, (int)maxYOffset));
        double maxX = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])maxTriangle, (int)maxXOffset));
        PointValues.Relation rel = this.rectangle2D.relate(minX, maxX, minY, maxY);
        if (this.queryRelation == ShapeField.QueryRelation.INTERSECTS && rel == PointValues.Relation.CELL_CROSSES_QUERY) {
            double innerMaxY = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])maxTriangle, (int)minYOffset));
            if (this.rectangle2D.relate(minX, maxX, minY, innerMaxY) == PointValues.Relation.CELL_INSIDE_QUERY) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
            double innerMaX = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])maxTriangle, (int)minXOffset));
            if (this.rectangle2D.relate(minX, innerMaX, minY, maxY) == PointValues.Relation.CELL_INSIDE_QUERY) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
            double innerMinY = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])minTriangle, (int)maxYOffset));
            if (this.rectangle2D.relate(minX, maxX, innerMinY, maxY) == PointValues.Relation.CELL_INSIDE_QUERY) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
            double innerMinX = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt((byte[])minTriangle, (int)maxXOffset));
            if (this.rectangle2D.relate(innerMinX, maxX, minY, maxY) == PointValues.Relation.CELL_INSIDE_QUERY) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
        }
        return rel;
    }

    @Override
    protected boolean queryMatches(byte[] t, ShapeField.DecodedTriangle scratchTriangle, ShapeField.QueryRelation queryRelation) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        double aY = XYEncodingUtils.decode(scratchTriangle.aY);
        double aX = XYEncodingUtils.decode(scratchTriangle.aX);
        double bY = XYEncodingUtils.decode(scratchTriangle.bY);
        double bX = XYEncodingUtils.decode(scratchTriangle.bX);
        double cY = XYEncodingUtils.decode(scratchTriangle.cY);
        double cX = XYEncodingUtils.decode(scratchTriangle.cX);
        switch (queryRelation) {
            case INTERSECTS: {
                return this.rectangle2D.relateTriangle(aX, aY, bX, bY, cX, cY) != PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            case WITHIN: {
                return this.rectangle2D.contains(aX, aY) && this.rectangle2D.contains(bX, bY) && this.rectangle2D.contains(cX, cY);
            }
            case DISJOINT: {
                return this.rectangle2D.relateTriangle(aX, aY, bX, bY, cX, cY) == PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        throw new IllegalArgumentException("Unsupported query type :[" + (Object)((Object)queryRelation) + "]");
    }

    @Override
    protected Component2D.WithinRelation queryWithin(byte[] t, ShapeField.DecodedTriangle scratchTriangle) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        double aY = XYEncodingUtils.decode(scratchTriangle.aY);
        double aX = XYEncodingUtils.decode(scratchTriangle.aX);
        double bY = XYEncodingUtils.decode(scratchTriangle.bY);
        double bX = XYEncodingUtils.decode(scratchTriangle.bX);
        double cY = XYEncodingUtils.decode(scratchTriangle.cY);
        double cX = XYEncodingUtils.decode(scratchTriangle.cX);
        return this.rectangle2D.withinTriangle(aX, aY, scratchTriangle.ab, bX, bY, scratchTriangle.bc, cX, cY, scratchTriangle.ca);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo(((Object)((Object)this)).getClass().cast(o));
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && this.rectangle.equals(((XYShapeBoundingBoxQuery)((Object)o)).rectangle);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.rectangle.hashCode();
        return hash;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.rectangle.toString());
        return sb.toString();
    }
}

