/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import java.net.InetAddress;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.security.UserGroupInformation;

public class RequestContext {
    private final String host;
    private final InetAddress ip;
    private final UserGroupInformation clientUgi;
    private final String serviceId;
    private final IAccessAuthorizer.ACLIdentityType aclType;
    private final IAccessAuthorizer.ACLType aclRights;

    public RequestContext(String host, InetAddress ip, UserGroupInformation clientUgi, String serviceId, IAccessAuthorizer.ACLIdentityType aclType, IAccessAuthorizer.ACLType aclRights) {
        this.host = host;
        this.ip = ip;
        this.clientUgi = clientUgi;
        this.serviceId = serviceId;
        this.aclType = aclType;
        this.aclRights = aclRights;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getHost() {
        return this.host;
    }

    public InetAddress getIp() {
        return this.ip;
    }

    public UserGroupInformation getClientUgi() {
        return this.clientUgi;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public IAccessAuthorizer.ACLIdentityType getAclType() {
        return this.aclType;
    }

    public IAccessAuthorizer.ACLType getAclRights() {
        return this.aclRights;
    }

    public static class Builder {
        private String host;
        private InetAddress ip;
        private UserGroupInformation clientUgi;
        private String serviceId;
        private IAccessAuthorizer.ACLIdentityType aclType;
        private IAccessAuthorizer.ACLType aclRights;

        public Builder setHost(String bHost) {
            this.host = bHost;
            return this;
        }

        public Builder setIp(InetAddress cIp) {
            this.ip = cIp;
            return this;
        }

        public Builder setClientUgi(UserGroupInformation cUgi) {
            this.clientUgi = cUgi;
            return this;
        }

        public Builder setServiceId(String sId) {
            this.serviceId = sId;
            return this;
        }

        public Builder setAclType(IAccessAuthorizer.ACLIdentityType acl) {
            this.aclType = acl;
            return this;
        }

        public Builder setAclRights(IAccessAuthorizer.ACLType aclRight) {
            this.aclRights = aclRight;
            return this;
        }

        public RequestContext build() {
            return new RequestContext(this.host, this.ip, this.clientUgi, this.serviceId, this.aclType, this.aclRights);
        }
    }
}

