/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.nio.file.Paths;
import org.apache.hadoop.fs.Path;

public final class OzoneFSUtils {
    private OzoneFSUtils() {
    }

    public static String pathToKey(Path path) {
        return path.toString().substring(1);
    }

    public static String getParent(String keyName) {
        java.nio.file.Path parentDir = Paths.get(keyName, new String[0]).getParent();
        if (parentDir == null) {
            return "";
        }
        return OzoneFSUtils.addTrailingSlashIfNeeded(parentDir.toString());
    }

    public static String getImmediateChild(String descendant, String ancestor) {
        int ancestorPathNameCount;
        String string = ancestor = !ancestor.isEmpty() ? OzoneFSUtils.addTrailingSlashIfNeeded(ancestor) : ancestor;
        if (!descendant.startsWith(ancestor)) {
            return null;
        }
        java.nio.file.Path descendantPath = Paths.get(descendant, new String[0]);
        java.nio.file.Path ancestorPath = Paths.get(ancestor, new String[0]);
        int n = ancestorPathNameCount = ancestor.isEmpty() ? 0 : ancestorPath.getNameCount();
        if (descendantPath.getNameCount() - ancestorPathNameCount > 1) {
            return OzoneFSUtils.addTrailingSlashIfNeeded(ancestor + descendantPath.getName(ancestorPathNameCount));
        }
        return descendant;
    }

    public static String addTrailingSlashIfNeeded(String key) {
        if (!key.endsWith("/")) {
            return key + "/";
        }
        return key;
    }

    public static boolean isFile(String keyName) {
        return !keyName.endsWith("/");
    }
}

