/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;

public final class OmBucketInfo
extends WithObjectID
implements Auditable {
    private final String volumeName;
    private final String bucketName;
    private List<OzoneAcl> acls;
    private Boolean isVersionEnabled;
    private StorageType storageType;
    private final long creationTime;
    private long modificationTime;
    private BucketEncryptionKeyInfo bekInfo;
    private final String sourceVolume;
    private final String sourceBucket;

    private OmBucketInfo(String volumeName, String bucketName, List<OzoneAcl> acls, boolean isVersionEnabled, StorageType storageType, long creationTime, long modificationTime, long objectID, long updateID, Map<String, String> metadata, BucketEncryptionKeyInfo bekInfo, String sourceVolume, String sourceBucket) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.acls = acls;
        this.isVersionEnabled = isVersionEnabled;
        this.storageType = storageType;
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
        this.objectID = objectID;
        this.updateID = updateID;
        this.metadata = metadata;
        this.bekInfo = bekInfo;
        this.sourceVolume = sourceVolume;
        this.sourceBucket = sourceBucket;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public boolean addAcl(OzoneAcl ozoneAcl) {
        return OzoneAclUtil.addAcl(this.acls, ozoneAcl);
    }

    public boolean removeAcl(OzoneAcl ozoneAcl) {
        return OzoneAclUtil.removeAcl(this.acls, ozoneAcl);
    }

    public boolean setAcls(List<OzoneAcl> ozoneAcls) {
        return OzoneAclUtil.setAcl(this.acls, ozoneAcls);
    }

    public boolean getIsVersionEnabled() {
        return this.isVersionEnabled;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public BucketEncryptionKeyInfo getEncryptionKeyInfo() {
        return this.bekInfo;
    }

    public String getSourceVolume() {
        return this.sourceVolume;
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public boolean isLink() {
        return this.sourceVolume != null && this.sourceBucket != null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", this.volumeName);
        auditMap.put("bucket", this.bucketName);
        auditMap.put("gdprEnabled", (String)this.metadata.get("gdprEnabled"));
        auditMap.put("acls", this.acls != null ? this.acls.toString() : null);
        auditMap.put("isVersionEnabled", String.valueOf(this.isVersionEnabled));
        auditMap.put("storageType", this.storageType != null ? this.storageType.name() : null);
        auditMap.put("creationTime", String.valueOf(this.creationTime));
        auditMap.put("bucketEncryptionKey", this.bekInfo != null ? this.bekInfo.getKeyName() : null);
        auditMap.put("modificationTime", String.valueOf(this.modificationTime));
        if (this.isLink()) {
            auditMap.put("sourceVolume", this.sourceVolume);
            auditMap.put("sourceBucket", this.sourceBucket);
        }
        return auditMap;
    }

    public OmBucketInfo copyObject() {
        Builder builder = this.toBuilder();
        if (this.bekInfo != null) {
            builder.setBucketEncryptionKey(this.bekInfo.copy());
        }
        builder.acls.clear();
        this.acls.forEach(acl -> builder.addAcl(new OzoneAcl(acl.getType(), acl.getName(), (BitSet)acl.getAclBitSet().clone(), acl.getAclScope())));
        return builder.build();
    }

    public Builder toBuilder() {
        return new Builder().setVolumeName(this.volumeName).setBucketName(this.bucketName).setStorageType(this.storageType).setIsVersionEnabled(this.isVersionEnabled).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).setObjectID(this.objectID).setUpdateID(this.updateID).setBucketEncryptionKey(this.bekInfo).setSourceVolume(this.sourceVolume).setSourceBucket(this.sourceBucket).setAcls(this.acls).addAllMetadata(this.metadata);
    }

    public OzoneManagerProtocolProtos.BucketInfo getProtobuf() {
        OzoneManagerProtocolProtos.BucketInfo.Builder bib = OzoneManagerProtocolProtos.BucketInfo.newBuilder().setVolumeName(this.volumeName).setBucketName(this.bucketName).addAllAcls(OzoneAclUtil.toProtobuf(this.acls)).setIsVersionEnabled(this.isVersionEnabled.booleanValue()).setStorageType(this.storageType.toProto()).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).setObjectID(this.objectID).setUpdateID(this.updateID).addAllMetadata(KeyValueUtil.toProtobuf(this.metadata));
        if (this.bekInfo != null && this.bekInfo.getKeyName() != null) {
            bib.setBeinfo(OMPBHelper.convert(this.bekInfo));
        }
        if (this.sourceVolume != null) {
            bib.setSourceVolume(this.sourceVolume);
        }
        if (this.sourceBucket != null) {
            bib.setSourceBucket(this.sourceBucket);
        }
        return bib.build();
    }

    public static OmBucketInfo getFromProtobuf(OzoneManagerProtocolProtos.BucketInfo bucketInfo) {
        Builder obib = OmBucketInfo.newBuilder().setVolumeName(bucketInfo.getVolumeName()).setBucketName(bucketInfo.getBucketName()).setAcls(bucketInfo.getAclsList().stream().map(OzoneAcl::fromProtobuf).collect(Collectors.toList())).setIsVersionEnabled(bucketInfo.getIsVersionEnabled()).setStorageType(StorageType.valueOf(bucketInfo.getStorageType())).setCreationTime(bucketInfo.getCreationTime()).setModificationTime(bucketInfo.getModificationTime());
        if (bucketInfo.hasObjectID()) {
            obib.setObjectID(bucketInfo.getObjectID());
        }
        if (bucketInfo.hasUpdateID()) {
            obib.setUpdateID(bucketInfo.getUpdateID());
        }
        if (bucketInfo.getMetadataList() != null) {
            obib.addAllMetadata(KeyValueUtil.getFromProtobuf(bucketInfo.getMetadataList()));
        }
        if (bucketInfo.hasBeinfo()) {
            obib.setBucketEncryptionKey(OMPBHelper.convert(bucketInfo.getBeinfo()));
        }
        if (bucketInfo.hasSourceVolume()) {
            obib.setSourceVolume(bucketInfo.getSourceVolume());
        }
        if (bucketInfo.hasSourceBucket()) {
            obib.setSourceBucket(bucketInfo.getSourceBucket());
        }
        return obib.build();
    }

    @Override
    public String getObjectInfo() {
        String sourceInfo = this.sourceVolume != null && this.sourceBucket != null ? ", source='" + this.sourceVolume + "/" + this.sourceBucket + "'" : "";
        return "OMBucketInfo{volume='" + this.volumeName + "', bucket='" + this.bucketName + "', isVersionEnabled='" + this.isVersionEnabled + "', storageType='" + (Object)((Object)this.storageType) + "', creationTime='" + this.creationTime + "'" + sourceInfo + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OmBucketInfo that = (OmBucketInfo)o;
        return this.creationTime == that.creationTime && this.modificationTime == that.modificationTime && this.volumeName.equals(that.volumeName) && this.bucketName.equals(that.bucketName) && Objects.equals(this.acls, that.acls) && Objects.equals(this.isVersionEnabled, that.isVersionEnabled) && this.storageType == that.storageType && this.objectID == that.objectID && this.updateID == that.updateID && Objects.equals(this.sourceVolume, that.sourceVolume) && Objects.equals(this.sourceBucket, that.sourceBucket) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.bekInfo, that.bekInfo);
    }

    public int hashCode() {
        return Objects.hash(this.volumeName, this.bucketName);
    }

    public String toString() {
        return "OmBucketInfo{volumeName='" + this.volumeName + "', bucketName='" + this.bucketName + "', acls=" + this.acls + ", isVersionEnabled=" + this.isVersionEnabled + ", storageType=" + (Object)((Object)this.storageType) + ", creationTime=" + this.creationTime + ", bekInfo=" + this.bekInfo + ", sourceVolume='" + this.sourceVolume + "', sourceBucket='" + this.sourceBucket + "', objectID=" + this.objectID + ", updateID=" + this.updateID + ", metadata=" + this.metadata + '}';
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private List<OzoneAcl> acls = new ArrayList<OzoneAcl>();
        private Boolean isVersionEnabled = false;
        private StorageType storageType = StorageType.DISK;
        private long creationTime;
        private long modificationTime;
        private long objectID;
        private long updateID;
        private Map<String, String> metadata = new HashMap<String, String>();
        private BucketEncryptionKeyInfo bekInfo;
        private String sourceVolume;
        private String sourceBucket;

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            if (listOfAcls != null) {
                this.acls.addAll(listOfAcls);
            }
            return this;
        }

        public Builder addAcl(OzoneAcl ozoneAcl) {
            if (ozoneAcl != null) {
                this.acls.add(ozoneAcl);
            }
            return this;
        }

        public Builder setIsVersionEnabled(Boolean versionFlag) {
            this.isVersionEnabled = versionFlag;
            return this;
        }

        public Builder setStorageType(StorageType storage) {
            this.storageType = storage;
            return this;
        }

        public Builder setCreationTime(long createdOn) {
            this.creationTime = createdOn;
            return this;
        }

        public Builder setModificationTime(long modifiedOn) {
            this.modificationTime = modifiedOn;
            return this;
        }

        public Builder setObjectID(long obId) {
            this.objectID = obId;
            return this;
        }

        public Builder setUpdateID(long id) {
            this.updateID = id;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder addAllMetadata(Map<String, String> additionalMetadata) {
            if (additionalMetadata != null) {
                this.metadata.putAll(additionalMetadata);
            }
            return this;
        }

        public Builder setBucketEncryptionKey(BucketEncryptionKeyInfo info) {
            this.bekInfo = info;
            return this;
        }

        public Builder setSourceVolume(String volume) {
            this.sourceVolume = volume;
            return this;
        }

        public Builder setSourceBucket(String bucket) {
            this.sourceBucket = bucket;
            return this;
        }

        public OmBucketInfo build() {
            Preconditions.checkNotNull((Object)this.volumeName);
            Preconditions.checkNotNull((Object)this.bucketName);
            Preconditions.checkNotNull(this.acls);
            Preconditions.checkNotNull((Object)this.isVersionEnabled);
            Preconditions.checkNotNull((Object)((Object)this.storageType));
            return new OmBucketInfo(this.volumeName, this.bucketName, this.acls, this.isVersionEnabled, this.storageType, this.creationTime, this.modificationTime, this.objectID, this.updateID, this.metadata, this.bekInfo, this.sourceVolume, this.sourceBucket);
        }
    }
}

