/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.conf;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="ozone.om.client")
public class OMClientConfig {
    public static final String OM_CLIENT_RPC_TIME_OUT = "rpc.timeout";
    @Config(key="rpc.timeout", defaultValue="15m", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.OM, ConfigTag.CLIENT}, timeUnit=TimeUnit.MILLISECONDS, description="RpcClient timeout on waiting for the response from OzoneManager. The default value is set to 15 minutes. If ipc.client.ping is set to true and this rpc-timeout is greater than the value of ipc.ping.interval, the effective value of the rpc-timeout is rounded up to multiple of ipc.ping.interval.")
    private long rpcTimeOut = 900000L;

    public long getRpcTimeOut() {
        return this.rpcTimeOut;
    }

    public void setRpcTimeOut(long timeOut) {
        if (this.rpcTimeOut > Integer.MAX_VALUE) {
            this.rpcTimeOut = Integer.MAX_VALUE;
        }
        this.rpcTimeOut = timeOut;
    }
}

