/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.scm.storage.CheckedBiFunction;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.ozone.common.OzoneChecksumException;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class ChunkInputStream
extends InputStream
implements Seekable {
    private ContainerProtos.ChunkInfo chunkInfo;
    private final long length;
    private final BlockID blockID;
    private XceiverClientSpi xceiverClient;
    private boolean verifyChecksum;
    private boolean allocated = false;
    private List<ByteBuffer> buffers;
    private int bufferIndex;
    private long bufferOffset;
    private long bufferLength;
    private long chunkPosition = -1L;
    private static final int EOF = -1;
    private CheckedBiFunction<ContainerProtos.ContainerCommandRequestProto, ContainerProtos.ContainerCommandResponseProto, IOException> validator = (request, response) -> {
        ContainerProtos.ChunkInfo reqChunkInfo = request.getReadChunk().getChunkData();
        ContainerProtos.ReadChunkResponseProto readChunkResponse = response.getReadChunk();
        ByteString byteString = readChunkResponse.getData();
        if ((long)byteString.size() != reqChunkInfo.getLen()) {
            throw new OzoneChecksumException(String.format("Inconsistent read for chunk=%s len=%d bytesRead=%d", reqChunkInfo.getChunkName(), reqChunkInfo.getLen(), byteString.size()));
        }
        if (this.verifyChecksum) {
            ChecksumData checksumData = ChecksumData.getFromProtoBuf((ContainerProtos.ChecksumData)this.chunkInfo.getChecksumData());
            long relativeOffset = reqChunkInfo.getOffset() - this.chunkInfo.getOffset();
            int bytesPerChecksum = checksumData.getBytesPerChecksum();
            int startIndex = (int)(relativeOffset / (long)bytesPerChecksum);
            Checksum.verifyChecksum((ByteString)byteString, (ChecksumData)checksumData, (int)startIndex);
        }
    };

    ChunkInputStream(ContainerProtos.ChunkInfo chunkInfo, BlockID blockId, XceiverClientSpi xceiverClient, boolean verifyChecksum) {
        this.chunkInfo = chunkInfo;
        this.length = chunkInfo.getLen();
        this.blockID = blockId;
        this.xceiverClient = xceiverClient;
        this.verifyChecksum = verifyChecksum;
    }

    public synchronized long getRemaining() throws IOException {
        return this.length - this.getPos();
    }

    @Override
    public synchronized int read() throws IOException {
        this.checkOpen();
        int available = this.prepareRead(1);
        int dataout = -1;
        if (available == -1) {
            Preconditions.checkState((this.buffers == null ? 1 : 0) != 0);
        } else {
            dataout = Byte.toUnsignedInt(this.buffers.get(this.bufferIndex).get());
        }
        if (this.chunkStreamEOF()) {
            this.releaseBuffers();
        }
        return dataout;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.checkOpen();
        int total = 0;
        while (len > 0) {
            int available = this.prepareRead(len);
            if (available == -1) {
                Preconditions.checkState((this.buffers == null ? 1 : 0) != 0);
                return total != 0 ? total : -1;
            }
            this.buffers.get(this.bufferIndex).get(b, off + total, available);
            len -= available;
            total += available;
        }
        if (this.chunkStreamEOF()) {
            this.releaseBuffers();
        }
        return total;
    }

    public synchronized void seek(long pos) throws IOException {
        if (pos < 0L || pos >= this.length) {
            if (pos == 0L) {
                return;
            }
            throw new EOFException("EOF encountered at pos: " + pos + " for chunk: " + this.chunkInfo.getChunkName());
        }
        if (this.buffersHavePosition(pos)) {
            this.adjustBufferPosition(pos - this.bufferOffset);
        } else {
            this.chunkPosition = pos;
        }
    }

    public synchronized long getPos() throws IOException {
        if (this.chunkPosition >= 0L) {
            return this.chunkPosition;
        }
        if (this.chunkStreamEOF()) {
            return this.length;
        }
        if (this.buffersHaveData()) {
            return this.bufferOffset + (long)this.buffers.get(this.bufferIndex).position();
        }
        if (this.buffersAllocated()) {
            return this.bufferOffset + this.bufferLength;
        }
        return 0L;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    @Override
    public synchronized void close() {
        if (this.xceiverClient != null) {
            this.xceiverClient = null;
        }
    }

    protected synchronized void checkOpen() throws IOException {
        if (this.xceiverClient == null) {
            throw new IOException("BlockInputStream has been closed.");
        }
    }

    private synchronized int prepareRead(int len) throws IOException {
        while (true) {
            if (this.chunkPosition >= 0L) {
                if (this.buffersHavePosition(this.chunkPosition)) {
                    this.adjustBufferPosition(this.chunkPosition - this.bufferOffset);
                } else {
                    this.readChunkFromContainer(len);
                }
            }
            if (this.buffersHaveData()) {
                ByteBuffer bb = this.buffers.get(this.bufferIndex);
                return len > bb.remaining() ? bb.remaining() : len;
            }
            if (!this.dataRemainingInChunk()) break;
            this.readChunkFromContainer(len);
        }
        return -1;
    }

    private synchronized void readChunkFromContainer(int len) throws IOException {
        long startByteIndex = this.chunkPosition >= 0L ? this.chunkPosition : this.bufferOffset + this.bufferLength;
        if (this.verifyChecksum) {
            this.computeChecksumBoundaries(startByteIndex, len);
        } else {
            this.bufferOffset = startByteIndex;
            this.bufferLength = len;
        }
        ContainerProtos.ChunkInfo adjustedChunkInfo = ContainerProtos.ChunkInfo.newBuilder((ContainerProtos.ChunkInfo)this.chunkInfo).setOffset(this.bufferOffset + this.chunkInfo.getOffset()).setLen(this.bufferLength).build();
        ByteString byteString = this.readChunk(adjustedChunkInfo);
        this.buffers = byteString.asReadOnlyByteBufferList();
        this.bufferIndex = 0;
        this.allocated = true;
        this.adjustBufferPosition(startByteIndex - this.bufferOffset);
    }

    @VisibleForTesting
    protected ByteString readChunk(ContainerProtos.ChunkInfo readChunkInfo) throws IOException {
        ContainerProtos.ReadChunkResponseProto readChunkResponse;
        try {
            List validators = ContainerProtocolCalls.getValidatorList();
            validators.add(this.validator);
            readChunkResponse = ContainerProtocolCalls.readChunk((XceiverClientSpi)this.xceiverClient, (ContainerProtos.ChunkInfo)readChunkInfo, (BlockID)this.blockID, (List)validators);
        }
        catch (IOException e) {
            if (e instanceof StorageContainerException) {
                throw e;
            }
            throw new IOException("Unexpected OzoneException: " + e.toString(), e);
        }
        return readChunkResponse.getData();
    }

    private void computeChecksumBoundaries(long startByteIndex, int dataLen) {
        int bytesPerChecksum = this.chunkInfo.getChecksumData().getBytesPerChecksum();
        long endByteIndex = startByteIndex + (long)dataLen - 1L;
        this.bufferOffset = startByteIndex / (long)bytesPerChecksum * (long)bytesPerChecksum;
        long endIndex = (endByteIndex / (long)bytesPerChecksum + 1L) * (long)bytesPerChecksum;
        this.bufferLength = Math.min(endIndex, this.length) - this.bufferOffset;
    }

    private void adjustBufferPosition(long bufferPosition) {
        long tempOffest = 0L;
        for (int i = 0; i < this.buffers.size(); ++i) {
            if (bufferPosition - tempOffest >= (long)this.buffers.get(i).capacity()) {
                tempOffest += (long)this.buffers.get(i).capacity();
                continue;
            }
            this.bufferIndex = i;
            break;
        }
        this.buffers.get(this.bufferIndex).position((int)(bufferPosition - tempOffest));
        this.resetPosition();
    }

    private boolean buffersAllocated() {
        return this.buffers != null && !this.buffers.isEmpty();
    }

    private boolean buffersHaveData() {
        boolean hasData = false;
        if (this.buffersAllocated()) {
            while (this.bufferIndex < this.buffers.size()) {
                if (this.buffers.get(this.bufferIndex).hasRemaining()) {
                    hasData = true;
                    break;
                }
                if (!this.buffersRemaining()) break;
                ++this.bufferIndex;
                Preconditions.checkState((this.bufferIndex < this.buffers.size() ? 1 : 0) != 0);
            }
        }
        return hasData;
    }

    private boolean buffersRemaining() {
        return this.bufferIndex < this.buffers.size() - 1;
    }

    private boolean buffersHavePosition(long pos) {
        if (this.buffersAllocated()) {
            return pos >= this.bufferOffset && pos < this.bufferOffset + this.bufferLength;
        }
        return false;
    }

    private boolean dataRemainingInChunk() {
        long bufferPos = this.chunkPosition >= 0L ? this.chunkPosition : this.bufferOffset + this.bufferLength;
        return bufferPos < this.length;
    }

    private boolean chunkStreamEOF() {
        if (!this.allocated) {
            return false;
        }
        if (this.buffersHaveData() || this.dataRemainingInChunk()) {
            return false;
        }
        Preconditions.checkState((this.bufferOffset + this.bufferLength == this.length ? 1 : 0) != 0, (Object)"EOF detected, but not at the last byte of the chunk");
        return true;
    }

    private void releaseBuffers() {
        this.buffers = null;
        this.bufferIndex = 0;
    }

    void resetPosition() {
        this.chunkPosition = -1L;
    }

    String getChunkName() {
        return this.chunkInfo.getChunkName();
    }

    protected long getLength() {
        return this.length;
    }

    @VisibleForTesting
    protected long getChunkPosition() {
        return this.chunkPosition;
    }
}

