/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.hadoop.hdds.scm.ByteStringConversion;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class BufferPool {
    private List<ChunkBuffer> bufferList;
    private int currentBufferIndex;
    private final int bufferSize;
    private final int capacity;
    private final Function<ByteBuffer, ByteString> byteStringConversion;

    public BufferPool(int bufferSize, int capacity) {
        this(bufferSize, capacity, ByteStringConversion.createByteBufferConversion(null));
    }

    public BufferPool(int bufferSize, int capacity, Function<ByteBuffer, ByteString> byteStringConversion) {
        this.capacity = capacity;
        this.bufferSize = bufferSize;
        this.bufferList = new ArrayList<ChunkBuffer>(capacity);
        this.currentBufferIndex = -1;
        this.byteStringConversion = byteStringConversion;
    }

    public Function<ByteBuffer, ByteString> byteStringConversion() {
        return this.byteStringConversion;
    }

    ChunkBuffer getCurrentBuffer() {
        return this.currentBufferIndex == -1 ? null : this.bufferList.get(this.currentBufferIndex);
    }

    public ChunkBuffer allocateBufferIfNeeded(int increment) {
        ChunkBuffer buffer = this.getCurrentBuffer();
        if (buffer != null && buffer.hasRemaining()) {
            return buffer;
        }
        if (this.currentBufferIndex < this.bufferList.size() - 1) {
            buffer = this.getBuffer(this.currentBufferIndex + 1);
        } else {
            buffer = ChunkBuffer.allocate((int)this.bufferSize, (int)increment);
            this.bufferList.add(buffer);
        }
        Preconditions.checkArgument((this.bufferList.size() <= this.capacity ? 1 : 0) != 0);
        ++this.currentBufferIndex;
        return buffer;
    }

    void releaseBuffer(ChunkBuffer chunkBuffer) {
        ChunkBuffer buffer = this.bufferList.remove(0);
        Preconditions.checkArgument((buffer == chunkBuffer ? 1 : 0) != 0);
        buffer.clear();
        this.bufferList.add(buffer);
        Preconditions.checkArgument((this.currentBufferIndex >= 0 ? 1 : 0) != 0);
        --this.currentBufferIndex;
    }

    public void clearBufferPool() {
        this.bufferList.clear();
        this.currentBufferIndex = -1;
    }

    public void checkBufferPoolEmpty() {
        Preconditions.checkArgument((this.computeBufferData() == 0L ? 1 : 0) != 0);
    }

    public long computeBufferData() {
        long totalBufferSize = 0L;
        for (ChunkBuffer buf : this.bufferList) {
            totalBufferSize += (long)buf.position();
        }
        return totalBufferSize;
    }

    public int getSize() {
        return this.bufferList.size();
    }

    public ChunkBuffer getBuffer(int index) {
        return this.bufferList.get(index);
    }

    int getCurrentBufferIndex() {
        return this.currentBufferIndex;
    }
}

