/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import com.google.common.annotations.VisibleForTesting;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.ChunkInputStream;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockInputStream
extends InputStream
implements Seekable {
    private static final Logger LOG = LoggerFactory.getLogger(BlockInputStream.class);
    private static final int EOF = -1;
    private final BlockID blockID;
    private final long length;
    private Pipeline pipeline;
    private final Token<OzoneBlockTokenIdentifier> token;
    private final boolean verifyChecksum;
    private XceiverClientManager xceiverClientManager;
    private XceiverClientSpi xceiverClient;
    private boolean initialized = false;
    private List<ChunkInputStream> chunkStreams;
    private long[] chunkOffsets = null;
    private int chunkIndex;
    private long blockPosition = 0L;
    private int chunkIndexOfPrevPosition;
    private Function<BlockID, Pipeline> refreshPipelineFunction;

    public BlockInputStream(BlockID blockId, long blockLen, Pipeline pipeline, Token<OzoneBlockTokenIdentifier> token, boolean verifyChecksum, XceiverClientManager xceiverClientManager, Function<BlockID, Pipeline> refreshPipelineFunction) {
        this.blockID = blockId;
        this.length = blockLen;
        this.pipeline = pipeline;
        this.token = token;
        this.verifyChecksum = verifyChecksum;
        this.xceiverClientManager = xceiverClientManager;
        this.refreshPipelineFunction = refreshPipelineFunction;
    }

    public BlockInputStream(BlockID blockId, long blockLen, Pipeline pipeline, Token<OzoneBlockTokenIdentifier> token, boolean verifyChecksum, XceiverClientManager xceiverClientManager) {
        this(blockId, blockLen, pipeline, token, verifyChecksum, xceiverClientManager, null);
    }

    public synchronized void initialize() throws IOException {
        List<ContainerProtos.ChunkInfo> chunks;
        block7: {
            if (this.initialized) {
                return;
            }
            chunks = null;
            try {
                chunks = this.getChunkInfos();
            }
            catch (ContainerNotFoundException ioEx) {
                LOG.error("Unable to read block information from pipeline.");
                if (this.refreshPipelineFunction == null) break block7;
                LOG.debug("Re-fetching pipeline for block {}", (Object)this.blockID);
                Pipeline newPipeline = this.refreshPipelineFunction.apply(this.blockID);
                if (newPipeline == null || newPipeline.equals((Object)this.pipeline)) {
                    throw ioEx;
                }
                LOG.debug("New pipeline got for block {}", (Object)this.blockID);
                this.pipeline = newPipeline;
                chunks = this.getChunkInfos();
            }
        }
        if (chunks != null && !chunks.isEmpty()) {
            this.chunkOffsets = new long[chunks.size()];
            long tempOffset = 0L;
            this.chunkStreams = new ArrayList<ChunkInputStream>(chunks.size());
            for (int i = 0; i < chunks.size(); ++i) {
                this.addStream(chunks.get(i));
                this.chunkOffsets[i] = tempOffset;
                tempOffset += chunks.get(i).getLen();
            }
            this.initialized = true;
            this.chunkIndex = 0;
            if (this.blockPosition > 0L) {
                this.seek(this.blockPosition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ContainerProtos.ChunkInfo> getChunkInfos() throws IOException {
        List chunks;
        if (this.pipeline.getType() != HddsProtos.ReplicationType.STAND_ALONE) {
            this.pipeline = Pipeline.newBuilder((Pipeline)this.pipeline).setType(HddsProtos.ReplicationType.STAND_ALONE).build();
        }
        this.xceiverClient = this.xceiverClientManager.acquireClientForReadData(this.pipeline);
        boolean success = false;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initializing BlockInputStream for get key to access {}", (Object)this.blockID.getContainerID());
            }
            if (this.token != null) {
                UserGroupInformation.getCurrentUser().addToken(this.token);
            }
            ContainerProtos.DatanodeBlockID datanodeBlockID = this.blockID.getDatanodeBlockIDProtobuf();
            ContainerProtos.GetBlockResponseProto response = ContainerProtocolCalls.getBlock((XceiverClientSpi)this.xceiverClient, (ContainerProtos.DatanodeBlockID)datanodeBlockID);
            chunks = response.getBlockData().getChunksList();
            success = true;
        }
        finally {
            if (!success) {
                this.xceiverClientManager.releaseClientForReadData(this.xceiverClient, false);
            }
        }
        return chunks;
    }

    protected synchronized void addStream(ContainerProtos.ChunkInfo chunkInfo) {
        this.chunkStreams.add(new ChunkInputStream(chunkInfo, this.blockID, this.xceiverClient, this.verifyChecksum));
    }

    public synchronized long getRemaining() throws IOException {
        return this.length - this.getPos();
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] buf = new byte[1];
        if (this.read(buf, 0, 1) == -1) {
            return -1;
        }
        return Byte.toUnsignedInt(buf[0]);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.initialized) {
            this.initialize();
        }
        this.checkOpen();
        int totalReadLen = 0;
        while (len > 0) {
            int numBytesToRead;
            if (this.chunkStreams.size() == 0 || this.chunkStreams.size() - 1 <= this.chunkIndex && this.chunkStreams.get(this.chunkIndex).getRemaining() == 0L) {
                return totalReadLen == 0 ? -1 : totalReadLen;
            }
            ChunkInputStream current = this.chunkStreams.get(this.chunkIndex);
            int numBytesRead = current.read(b, off, numBytesToRead = Math.min(len, (int)current.getRemaining()));
            if (numBytesRead != numBytesToRead) {
                throw new IOException(String.format("Inconsistent read for chunkName=%s length=%d numBytesToRead= %d numBytesRead=%d", current.getChunkName(), current.getLength(), numBytesToRead, numBytesRead));
            }
            totalReadLen += numBytesRead;
            off += numBytesRead;
            len -= numBytesRead;
            if (current.getRemaining() > 0L || this.chunkIndex + 1 >= this.chunkStreams.size()) continue;
            ++this.chunkIndex;
        }
        return totalReadLen;
    }

    public synchronized void seek(long pos) throws IOException {
        if (!this.initialized) {
            this.blockPosition = pos;
            return;
        }
        this.checkOpen();
        if (pos < 0L || pos >= this.length) {
            if (pos == 0L) {
                return;
            }
            throw new EOFException("EOF encountered at pos: " + pos + " for block: " + this.blockID);
        }
        if (this.chunkIndex >= this.chunkStreams.size()) {
            this.chunkIndex = Arrays.binarySearch(this.chunkOffsets, pos);
        } else if (pos < this.chunkOffsets[this.chunkIndex]) {
            this.chunkIndex = Arrays.binarySearch(this.chunkOffsets, 0, this.chunkIndex, pos);
        } else if (pos >= this.chunkOffsets[this.chunkIndex] + this.chunkStreams.get(this.chunkIndex).getLength()) {
            this.chunkIndex = Arrays.binarySearch(this.chunkOffsets, this.chunkIndex + 1, this.chunkStreams.size(), pos);
        }
        if (this.chunkIndex < 0) {
            this.chunkIndex = -this.chunkIndex - 2;
        }
        this.chunkStreams.get(this.chunkIndexOfPrevPosition).resetPosition();
        for (int index = this.chunkIndex + 1; index < this.chunkStreams.size(); ++index) {
            this.chunkStreams.get(index).seek(0L);
        }
        this.chunkStreams.get(this.chunkIndex).seek(pos - this.chunkOffsets[this.chunkIndex]);
        this.chunkIndexOfPrevPosition = this.chunkIndex;
    }

    public synchronized long getPos() throws IOException {
        if (this.length == 0L) {
            return 0L;
        }
        if (!this.initialized) {
            return this.blockPosition;
        }
        return this.chunkOffsets[this.chunkIndex] + this.chunkStreams.get(this.chunkIndex).getPos();
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    @Override
    public synchronized void close() {
        if (this.xceiverClientManager != null && this.xceiverClient != null) {
            this.xceiverClientManager.releaseClient(this.xceiverClient, false);
            this.xceiverClientManager = null;
            this.xceiverClient = null;
        }
    }

    public synchronized void resetPosition() {
        this.blockPosition = 0L;
    }

    protected synchronized void checkOpen() throws IOException {
        if (this.xceiverClient == null) {
            throw new IOException("BlockInputStream has been closed.");
        }
    }

    public BlockID getBlockID() {
        return this.blockID;
    }

    public long getLength() {
        return this.length;
    }

    @VisibleForTesting
    synchronized int getChunkIndex() {
        return this.chunkIndex;
    }

    @VisibleForTesting
    synchronized long getBlockPosition() {
        return this.blockPosition;
    }

    @VisibleForTesting
    synchronized List<ChunkInputStream> getChunkStreams() {
        return this.chunkStreams;
    }
}

