/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.kms.client;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.util.PasswordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMSClient {
    private static final Logger LOG = LoggerFactory.getLogger(KMSClient.class);
    private static final String EXPECTED_MIME_TYPE = "application/json";
    private static final String KMS_LIST_API_ENDPOINT = "v1/keys/names";
    private static final String errMessage = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
    private static final String AUTH_TYPE_KERBEROS = "kerberos";
    String provider;
    String username;
    String password;
    String rangerPrincipal;
    String rangerKeytab;
    String nameRules;
    String authType;

    public KMSClient(String provider, String username, String password, String rangerPrincipal, String rangerKeytab, String nameRules, String authType) {
        this.provider = provider;
        this.username = username;
        this.password = password;
        this.rangerPrincipal = rangerPrincipal;
        this.rangerKeytab = rangerKeytab;
        this.nameRules = nameRules;
        this.authType = authType;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Kms Client is build with url [" + provider + "] user: [" + username + "]");
        }
    }

    private String[] createProvider(String uri) throws IOException, URISyntaxException {
        URI providerUri = new URI(uri);
        URL origUrl = new URL(KMSClient.extractKMSPath(providerUri).toString());
        String authority = origUrl.getAuthority();
        if (Strings.isNullOrEmpty((String)authority)) {
            throw new IOException("No valid authority in kms uri [" + origUrl + "]");
        }
        int port = -1;
        String hostsPart = authority;
        if (authority.contains(":")) {
            String[] t = authority.split(":");
            try {
                port = Integer.parseInt(t[1]);
            }
            catch (Exception e) {
                throw new IOException("Could not parse port in kms uri [" + origUrl + "]");
            }
            hostsPart = t[0];
        }
        return this.createProvider(origUrl, port, hostsPart);
    }

    private static Path extractKMSPath(URI uri) throws MalformedURLException, IOException {
        return ProviderUtils.unnestUri((URI)uri);
    }

    private String[] createProvider(URL origUrl, int port, String hostsPart) throws IOException {
        String[] hosts = hostsPart.split(";");
        String[] providers = new String[hosts.length];
        if (hosts.length == 1) {
            providers[0] = origUrl.toString();
        } else {
            for (int i = 0; i < hosts.length; ++i) {
                try {
                    String url = origUrl.getProtocol() + "://" + hosts[i] + ":" + port + origUrl.getPath();
                    providers[i] = new URI(url).toString();
                    continue;
                }
                catch (URISyntaxException e) {
                    throw new IOException("Could not Prase KMS URL..", e);
                }
            }
        }
        return providers;
    }

    public List<String> getKeyList(String keyNameMatching, List<String> existingKeyList) {
        String[] providers = null;
        try {
            providers = this.createProvider(this.provider);
        }
        catch (IOException | URISyntaxException e) {
            return null;
        }
        String errMsg = errMessage;
        ArrayList<String> lret = null;
        for (int i = 0; i < providers.length; ++i) {
            lret = new ArrayList<String>();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting Kms Key list for keyNameMatching : " + keyNameMatching);
            }
            String uri = providers[i] + (providers[i].endsWith("/") ? KMS_LIST_API_ENDPOINT : "/v1/keys/names");
            Client client = null;
            ClientResponse response = null;
            boolean isKerberos = false;
            try {
                HadoopException hdpException;
                String msgDesc;
                String shortName;
                WebResource webResource;
                DefaultClientConfig cc = new DefaultClientConfig();
                cc.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
                client = Client.create((ClientConfig)cc);
                if (this.authType != null && this.authType.equalsIgnoreCase(AUTH_TYPE_KERBEROS)) {
                    isKerberos = true;
                }
                Subject sub = new Subject();
                if (!isKerberos) {
                    uri = uri.concat("?user.name=" + this.username);
                    webResource = client.resource(uri);
                    response = (ClientResponse)webResource.accept(new String[]{EXPECTED_MIME_TYPE}).get(ClientResponse.class);
                    LOG.info("Init Login: security not enabled, using username");
                    sub = SecureClientLogin.login((String)this.username);
                } else if (!StringUtils.isEmpty((String)this.rangerPrincipal) && !StringUtils.isEmpty((String)this.rangerKeytab)) {
                    LOG.info("Init Lookup Login: security enabled, using rangerPrincipal/rangerKeytab");
                    if (StringUtils.isEmpty((String)this.nameRules)) {
                        this.nameRules = "DEFAULT";
                    }
                    shortName = new HadoopKerberosName(this.rangerPrincipal).getShortName();
                    uri = uri.concat("?doAs=" + shortName);
                    sub = SecureClientLogin.loginUserFromKeytab((String)this.rangerPrincipal, (String)this.rangerKeytab, (String)this.nameRules);
                } else {
                    LOG.info("Init Login: using username/password");
                    shortName = new HadoopKerberosName(this.username).getShortName();
                    uri = uri.concat("?doAs=" + shortName);
                    String decryptedPwd = PasswordUtils.decryptPassword((String)this.password);
                    sub = SecureClientLogin.loginUserWithPassword((String)this.username, (String)decryptedPwd);
                }
                webResource = client.resource(uri);
                response = Subject.doAs(sub, new PrivilegedAction<ClientResponse>(){

                    @Override
                    public ClientResponse run() {
                        return (ClientResponse)webResource.accept(new String[]{KMSClient.EXPECTED_MIME_TYPE}).get(ClientResponse.class);
                    }
                });
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getKeyList():calling " + uri);
                }
                if (response != null) {
                    String jsonString;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getKeyList():response.getStatus()= " + response.getStatus());
                    }
                    if (response.getStatus() == 200) {
                        jsonString = (String)response.getEntity(String.class);
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        List keys = (List)gson.fromJson(jsonString, List.class);
                        if (keys == null) continue;
                        for (String key : keys) {
                            if (existingKeyList != null && existingKeyList.contains(key) || keyNameMatching != null && !keyNameMatching.isEmpty() && !key.startsWith(keyNameMatching)) continue;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("getKeyList():Adding kmsKey " + key);
                            }
                            lret.add(key);
                        }
                        ArrayList<String> arrayList = lret;
                        return arrayList;
                    }
                    if (response.getStatus() == 401) {
                        LOG.info("getKeyList():response.getStatus()= " + response.getStatus() + " for URL " + uri + ", so returning null list");
                        msgDesc = (String)response.getEntity(String.class);
                        hdpException = new HadoopException(msgDesc);
                        hdpException.generateResponseDataMap(false, msgDesc, msgDesc + errMessage, null, null);
                        lret = null;
                        throw hdpException;
                    }
                    if (response.getStatus() == 403) {
                        LOG.info("getKeyList():response.getStatus()= " + response.getStatus() + " for URL " + uri + ", so returning null list");
                        msgDesc = (String)response.getEntity(String.class);
                        hdpException = new HadoopException(msgDesc);
                        hdpException.generateResponseDataMap(false, msgDesc, msgDesc + errMessage, null, null);
                        lret = null;
                        throw hdpException;
                    }
                    LOG.info("getKeyList():response.getStatus()= " + response.getStatus() + " for URL " + uri + ", so returning null list");
                    jsonString = (String)response.getEntity(String.class);
                    LOG.info(jsonString);
                    lret = null;
                    continue;
                }
                msgDesc = "Unable to get a valid response for expected mime type : [application/json] URL : " + uri + " - got null response.";
                LOG.error(msgDesc);
                hdpException = new HadoopException(msgDesc);
                hdpException.generateResponseDataMap(false, msgDesc, msgDesc + errMessage, null, null);
                lret = null;
                throw hdpException;
            }
            catch (HadoopException he) {
                lret = null;
                throw he;
            }
            catch (Throwable t) {
                String msgDesc = "Exception while getting Kms Key List. URL : " + uri;
                HadoopException hdpException = new HadoopException(msgDesc, t);
                LOG.error(msgDesc, t);
                hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)t), msgDesc + errMessage, null, null);
                lret = null;
                throw hdpException;
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (client != null) {
                    client.destroy();
                }
                if (lret == null && i != providers.length - 1) continue;
            }
        }
        return lret;
    }

    public static Map<String, Object> testConnection(String serviceName, Map<String, String> configs) {
        List<Object> strList = new ArrayList();
        String errMsg = errMessage;
        boolean connectivityStatus = false;
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        KMSClient kmsClient = KMSClient.getKmsClient(serviceName, configs);
        strList = KMSClient.getKmsKey(kmsClient, "", null);
        if (strList != null) {
            connectivityStatus = true;
        }
        if (connectivityStatus) {
            String successMsg = "TestConnection Successful";
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)successMsg, (String)successMsg, null, null, responseData);
        } else {
            String failureMsg = "Unable to retrieve any Kms Key using given URL.";
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)failureMsg, (String)(failureMsg + errMsg), null, null, responseData);
        }
        return responseData;
    }

    public static KMSClient getKmsClient(String serviceName, Map<String, String> configs) {
        KMSClient kmsClient = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting KmsClient for datasource: " + serviceName);
            LOG.debug("configMap: " + configs);
        }
        String errMsg = errMessage;
        if (configs == null || configs.isEmpty()) {
            String msgDesc = "Could not connect as Connection ConfigMap is empty.";
            LOG.error(msgDesc);
            HadoopException hdpException = new HadoopException(msgDesc);
            hdpException.generateResponseDataMap(false, msgDesc, msgDesc + errMsg, null, null);
            throw hdpException;
        }
        String kmsUrl = configs.get("provider");
        String kmsUserName = configs.get("username");
        String kmsPassWord = configs.get("password");
        String rangerPrincipal = configs.get("rangerprincipal");
        String rangerKeytab = configs.get("rangerkeytab");
        String nameRules = configs.get("namerules");
        String authType = configs.get("authtype");
        kmsClient = new KMSClient(kmsUrl, kmsUserName, kmsPassWord, rangerPrincipal, rangerKeytab, nameRules, authType);
        return kmsClient;
    }

    public static List<String> getKmsKey(KMSClient kmsClient, String keyName, List<String> existingKeyName) {
        List<String> resultList = new ArrayList<String>();
        String errMsg = errMessage;
        try {
            String finalkmsKeyName;
            if (kmsClient == null) {
                String msgDesc = "Unable to get Kms Key : KmsClient is null.";
                LOG.error(msgDesc);
                HadoopException hdpException = new HadoopException(msgDesc);
                hdpException.generateResponseDataMap(false, msgDesc, msgDesc + errMsg, null, null);
                throw hdpException;
            }
            if (keyName != null && (resultList = kmsClient.getKeyList(finalkmsKeyName = keyName.trim(), existingKeyName)) != null && LOG.isDebugEnabled()) {
                LOG.debug("Returning list of " + resultList.size() + " Kms Keys");
            }
        }
        catch (HadoopException he) {
            resultList = null;
            throw he;
        }
        catch (Exception e) {
            String msgDesc = "Unable to get a valid response from the provider : " + e.getMessage();
            LOG.error(msgDesc, (Throwable)e);
            HadoopException hdpException = new HadoopException(msgDesc);
            hdpException.generateResponseDataMap(false, msgDesc, msgDesc + errMsg, null, null);
            resultList = null;
            throw hdpException;
        }
        return resultList;
    }
}

