/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.ZooKeeperMain;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.cli.CliException;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperHelper;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class ZKMainServer {
    private static final String SERVER_ARG = "-server";

    public String parse(Configuration c) {
        return ZKConfig.getZKQuorumServersString(c);
    }

    private static boolean hasServer(String[] args2) {
        return args2.length > 0 && args2[0].equals(SERVER_ARG);
    }

    private static boolean hasCommandLineArguments(String[] args2) {
        if (ZKMainServer.hasServer(args2)) {
            if (args2.length < 2) {
                throw new IllegalStateException("-server param but no value");
            }
            return args2.length > 2;
        }
        return args2.length > 0;
    }

    public static void main(String[] args2) throws Exception {
        Configuration conf;
        String hostport;
        String[] newArgs = args2;
        if (!ZKMainServer.hasServer(args2) && (hostport = new ZKMainServer().parse(conf = HBaseConfiguration.create())) != null && hostport.length() > 0) {
            newArgs = new String[args2.length + 2];
            System.arraycopy(args2, 0, newArgs, 2, args2.length);
            newArgs[0] = SERVER_ARG;
            newArgs[1] = hostport;
        }
        if (ZKMainServer.hasCommandLineArguments(args2)) {
            HACK_UNTIL_ZOOKEEPER_1897_ZooKeeperMain zkm = new HACK_UNTIL_ZOOKEEPER_1897_ZooKeeperMain(newArgs);
            zkm.runCmdLine();
        } else {
            ZooKeeperMain.main(newArgs);
        }
    }

    private static class HACK_UNTIL_ZOOKEEPER_1897_ZooKeeperMain
    extends ZooKeeperMain {
        public HACK_UNTIL_ZOOKEEPER_1897_ZooKeeperMain(String[] args2) throws IOException, InterruptedException {
            super(args2);
            ZooKeeperHelper.ensureConnectedZooKeeper(this.zk, 30000);
        }

        void runCmdLine() throws IOException, InterruptedException, CliException {
            this.processCmd(this.cl);
            System.exit(0);
        }
    }
}

