/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.metrics.JvmPauseMonitorSource;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.base.Stopwatch;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class JvmPauseMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(JvmPauseMonitor.class);
    private static final long SLEEP_INTERVAL_MS = 500L;
    private final long warnThresholdMs;
    public static final String WARN_THRESHOLD_KEY = "jvm.pause.warn-threshold.ms";
    private static final long WARN_THRESHOLD_DEFAULT = 10000L;
    private final long infoThresholdMs;
    public static final String INFO_THRESHOLD_KEY = "jvm.pause.info-threshold.ms";
    private static final long INFO_THRESHOLD_DEFAULT = 1000L;
    private Thread monitorThread;
    private volatile boolean shouldRun = true;
    private JvmPauseMonitorSource metricsSource;

    public JvmPauseMonitor(Configuration conf) {
        this(conf, null);
    }

    public JvmPauseMonitor(Configuration conf, JvmPauseMonitorSource metricsSource) {
        this.warnThresholdMs = conf.getLong(WARN_THRESHOLD_KEY, 10000L);
        this.infoThresholdMs = conf.getLong(INFO_THRESHOLD_KEY, 1000L);
        this.metricsSource = metricsSource;
    }

    public void start() {
        Preconditions.checkState(this.monitorThread == null, "Already started");
        this.monitorThread = new Thread((Runnable)new Monitor(), "JvmPauseMonitor");
        this.monitorThread.setDaemon(true);
        this.monitorThread.start();
    }

    public void stop() {
        this.shouldRun = false;
        this.monitorThread.interrupt();
        try {
            this.monitorThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private String formatMessage(long extraSleepTime, List<String> gcDiffs) {
        String ret = "Detected pause in JVM or host machine (eg GC): pause of approximately " + extraSleepTime + "ms\n";
        ret = gcDiffs.isEmpty() ? ret + "No GCs detected" : ret + Joiner.on("\n").join(gcDiffs);
        return ret;
    }

    private Map<String, GcTimes> getGcTimes() {
        HashMap<String, GcTimes> map = Maps.newHashMap();
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            map.put(gcBean.getName(), new GcTimes(gcBean));
        }
        return map;
    }

    public void updateMetrics(long sleepTime, boolean gcDetected) {
        if (this.metricsSource != null) {
            if (sleepTime > this.warnThresholdMs) {
                this.metricsSource.incWarnThresholdExceeded(1);
            } else {
                this.metricsSource.incInfoThresholdExceeded(1);
            }
            if (gcDetected) {
                this.metricsSource.updatePauseTimeWithGc(sleepTime);
            } else {
                this.metricsSource.updatePauseTimeWithoutGc(sleepTime);
            }
        }
    }

    public JvmPauseMonitorSource getMetricsSource() {
        return this.metricsSource;
    }

    public void setMetricsSource(JvmPauseMonitorSource metricsSource) {
        this.metricsSource = metricsSource;
    }

    public static void main(String[] args2) throws Exception {
        new JvmPauseMonitor(new Configuration()).start();
        ArrayList<String> list = Lists.newArrayList();
        int i = 0;
        while (true) {
            list.add(String.valueOf(i++));
        }
    }

    private class Monitor
    implements Runnable {
        private Monitor() {
        }

        @Override
        public void run() {
            Stopwatch sw = Stopwatch.createUnstarted();
            Map gcTimesBeforeSleep = JvmPauseMonitor.this.getGcTimes();
            while (JvmPauseMonitor.this.shouldRun) {
                sw.reset().start();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    return;
                }
                long extraSleepTime = sw.elapsed(TimeUnit.MILLISECONDS) - 500L;
                Map gcTimesAfterSleep = JvmPauseMonitor.this.getGcTimes();
                if (extraSleepTime > JvmPauseMonitor.this.infoThresholdMs) {
                    Sets.SetView<String> gcBeanNames = Sets.intersection(gcTimesAfterSleep.keySet(), gcTimesBeforeSleep.keySet());
                    ArrayList<String> gcDiffs = Lists.newArrayList();
                    for (String name : gcBeanNames) {
                        GcTimes diff = ((GcTimes)gcTimesAfterSleep.get(name)).subtract((GcTimes)gcTimesBeforeSleep.get(name));
                        if (diff.gcCount == 0L) continue;
                        gcDiffs.add("GC pool '" + name + "' had collection(s): " + diff.toString());
                    }
                    JvmPauseMonitor.this.updateMetrics(extraSleepTime, !gcDiffs.isEmpty());
                    if (extraSleepTime > JvmPauseMonitor.this.warnThresholdMs) {
                        LOG.warn(JvmPauseMonitor.this.formatMessage(extraSleepTime, gcDiffs));
                    } else {
                        LOG.info(JvmPauseMonitor.this.formatMessage(extraSleepTime, gcDiffs));
                    }
                }
                gcTimesBeforeSleep = gcTimesAfterSleep;
            }
        }
    }

    private static class GcTimes {
        private long gcCount;
        private long gcTimeMillis;

        private GcTimes(GarbageCollectorMXBean gcBean) {
            this.gcCount = gcBean.getCollectionCount();
            this.gcTimeMillis = gcBean.getCollectionTime();
        }

        private GcTimes(long count, long time) {
            this.gcCount = count;
            this.gcTimeMillis = time;
        }

        private GcTimes subtract(GcTimes other) {
            return new GcTimes(this.gcCount - other.gcCount, this.gcTimeMillis - other.gcTimeMillis);
        }

        public String toString() {
            return "count=" + this.gcCount + " time=" + this.gcTimeMillis + "ms";
        }
    }
}

