/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.math3.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math3.exception.NullArgumentException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math3.stat.descriptive.WeightedEvaluation;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math3.util.FastMath;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math3.util.MathUtils;

public class Product
extends AbstractStorelessUnivariateStatistic
implements Serializable,
WeightedEvaluation {
    private static final long serialVersionUID = 2824226005990582538L;
    private long n;
    private double value;

    public Product() {
        this.n = 0L;
        this.value = 1.0;
    }

    public Product(Product original) throws NullArgumentException {
        Product.copy(original, this);
    }

    public void increment(double d) {
        this.value *= d;
        ++this.n;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.value = 1.0;
        this.n = 0L;
    }

    public double evaluate(double[] values2, int begin, int length) throws MathIllegalArgumentException {
        double product = Double.NaN;
        if (this.test(values2, begin, length, true)) {
            product = 1.0;
            for (int i = begin; i < begin + length; ++i) {
                product *= values2[i];
            }
        }
        return product;
    }

    public double evaluate(double[] values2, double[] weights, int begin, int length) throws MathIllegalArgumentException {
        double product = Double.NaN;
        if (this.test(values2, weights, begin, length, true)) {
            product = 1.0;
            for (int i = begin; i < begin + length; ++i) {
                product *= FastMath.pow(values2[i], weights[i]);
            }
        }
        return product;
    }

    public double evaluate(double[] values2, double[] weights) throws MathIllegalArgumentException {
        return this.evaluate(values2, weights, 0, values2.length);
    }

    public Product copy() {
        Product result = new Product();
        Product.copy(this, result);
        return result;
    }

    public static void copy(Product source2, Product dest) throws NullArgumentException {
        MathUtils.checkNotNull(source2);
        MathUtils.checkNotNull(dest);
        dest.setData(source2.getDataRef());
        dest.n = source2.n;
        dest.value = source2.value;
    }
}

