/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.kotlin.time;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.shaded.kotlin.Metadata;
import org.apache.hadoop.hbase.shaded.kotlin.SinceKotlin;
import org.apache.hadoop.hbase.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import org.apache.hadoop.hbase.shaded.kotlin.jvm.internal.Intrinsics;
import org.apache.hadoop.hbase.shaded.kotlin.time.Duration;
import org.apache.hadoop.hbase.shaded.kotlin.time.DurationKt;
import org.apache.hadoop.hbase.shaded.kotlin.time.ExperimentalTime;
import org.apache.hadoop.hbase.shaded.kotlin.time.TimeMark;
import org.apache.hadoop.hbase.shaded.kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\fB\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH$R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/apache/hadoop/hbase/shaded/kotlin/time/AbstractLongTimeSource;", "Lorg/apache/hadoop/hbase/shaded/kotlin/time/TimeSource;", "unit", "Ljava/util/concurrent/TimeUnit;", "Lorg/apache/hadoop/hbase/shaded/kotlin/time/DurationUnit;", "(Ljava/util/concurrent/TimeUnit;)V", "getUnit", "()Ljava/util/concurrent/TimeUnit;", "markNow", "Lorg/apache/hadoop/hbase/shaded/kotlin/time/TimeMark;", "read", "", "LongTimeMark", "kotlin-stdlib"})
@SinceKotlin(version="1.3")
@ExperimentalTime
public abstract class AbstractLongTimeSource
implements TimeSource {
    @NotNull
    private final TimeUnit unit;

    protected abstract long read();

    @Override
    @NotNull
    public TimeMark markNow() {
        return new LongTimeMark(this.read(), this, Duration.Companion.getZERO-UwyO8pc(), null);
    }

    @NotNull
    protected final TimeUnit getUnit() {
        return this.unit;
    }

    public AbstractLongTimeSource(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        this.unit = unit;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B \u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\n\u001a\u00020\u0007H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0007H\u0096\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\b\n\u0002\b\u0019\n\u0002\b!\u00a8\u0006\u0011"}, d2={"Lorg/apache/hadoop/hbase/shaded/kotlin/time/AbstractLongTimeSource$LongTimeMark;", "Lorg/apache/hadoop/hbase/shaded/kotlin/time/TimeMark;", "startedAt", "", "timeSource", "Lorg/apache/hadoop/hbase/shaded/kotlin/time/AbstractLongTimeSource;", "offset", "Lorg/apache/hadoop/hbase/shaded/kotlin/time/Duration;", "(JLkotlin/time/AbstractLongTimeSource;DLkotlin/jvm/internal/DefaultConstructorMarker;)V", "D", "elapsedNow", "elapsedNow-UwyO8pc", "()D", "plus", "duration", "plus-LRDsOJo", "(D)Lkotlin/time/TimeMark;", "kotlin-stdlib"})
    private static final class LongTimeMark
    extends TimeMark {
        private final long startedAt;
        private final AbstractLongTimeSource timeSource;
        private final double offset;

        @Override
        public double elapsedNow-UwyO8pc() {
            return Duration.minus-LRDsOJo(DurationKt.toDuration(this.timeSource.read() - this.startedAt, this.timeSource.getUnit()), this.offset);
        }

        @Override
        @NotNull
        public TimeMark plus-LRDsOJo(double duration) {
            return new LongTimeMark(this.startedAt, this.timeSource, Duration.plus-LRDsOJo(this.offset, duration), null);
        }

        private LongTimeMark(long startedAt, AbstractLongTimeSource timeSource, double offset) {
            this.startedAt = startedAt;
            this.timeSource = timeSource;
            this.offset = offset;
        }

        public /* synthetic */ LongTimeMark(long startedAt, AbstractLongTimeSource timeSource, double offset, DefaultConstructorMarker $constructor_marker) {
            this(startedAt, timeSource, offset);
        }
    }
}

