/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.io.netty.channel.nio;

import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.hbase.shaded.io.netty.channel.DefaultSelectStrategyFactory;
import org.apache.hadoop.hbase.shaded.io.netty.channel.EventLoop;
import org.apache.hadoop.hbase.shaded.io.netty.channel.EventLoopTaskQueueFactory;
import org.apache.hadoop.hbase.shaded.io.netty.channel.MultithreadEventLoopGroup;
import org.apache.hadoop.hbase.shaded.io.netty.channel.SelectStrategyFactory;
import org.apache.hadoop.hbase.shaded.io.netty.channel.nio.NioEventLoop;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.EventExecutor;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.EventExecutorChooserFactory;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.RejectedExecutionHandler;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.RejectedExecutionHandlers;

public class NioEventLoopGroup
extends MultithreadEventLoopGroup {
    public NioEventLoopGroup() {
        this(0);
    }

    public NioEventLoopGroup(int nThreads) {
        this(nThreads, (Executor)null);
    }

    public NioEventLoopGroup(ThreadFactory threadFactory2) {
        this(0, threadFactory2, SelectorProvider.provider());
    }

    public NioEventLoopGroup(int nThreads, ThreadFactory threadFactory2) {
        this(nThreads, threadFactory2, SelectorProvider.provider());
    }

    public NioEventLoopGroup(int nThreads, Executor executor) {
        this(nThreads, executor, SelectorProvider.provider());
    }

    public NioEventLoopGroup(int nThreads, ThreadFactory threadFactory2, SelectorProvider selectorProvider) {
        this(nThreads, threadFactory2, selectorProvider, DefaultSelectStrategyFactory.INSTANCE);
    }

    public NioEventLoopGroup(int nThreads, ThreadFactory threadFactory2, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory) {
        super(nThreads, threadFactory2, selectorProvider, selectStrategyFactory, RejectedExecutionHandlers.reject());
    }

    public NioEventLoopGroup(int nThreads, Executor executor, SelectorProvider selectorProvider) {
        this(nThreads, executor, selectorProvider, DefaultSelectStrategyFactory.INSTANCE);
    }

    public NioEventLoopGroup(int nThreads, Executor executor, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory) {
        super(nThreads, executor, selectorProvider, selectStrategyFactory, RejectedExecutionHandlers.reject());
    }

    public NioEventLoopGroup(int nThreads, Executor executor, EventExecutorChooserFactory chooserFactory, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory) {
        super(nThreads, executor, chooserFactory, selectorProvider, selectStrategyFactory, RejectedExecutionHandlers.reject());
    }

    public NioEventLoopGroup(int nThreads, Executor executor, EventExecutorChooserFactory chooserFactory, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(nThreads, executor, chooserFactory, selectorProvider, selectStrategyFactory, rejectedExecutionHandler);
    }

    public NioEventLoopGroup(int nThreads, Executor executor, EventExecutorChooserFactory chooserFactory, SelectorProvider selectorProvider, SelectStrategyFactory selectStrategyFactory, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory taskQueueFactory) {
        super(nThreads, executor, chooserFactory, selectorProvider, selectStrategyFactory, rejectedExecutionHandler, taskQueueFactory);
    }

    public void setIoRatio(int ioRatio) {
        for (EventExecutor e : this) {
            ((NioEventLoop)e).setIoRatio(ioRatio);
        }
    }

    public void rebuildSelectors() {
        for (EventExecutor e : this) {
            ((NioEventLoop)e).rebuildSelector();
        }
    }

    @Override
    protected EventLoop newChild(Executor executor, Object ... args2) throws Exception {
        EventLoopTaskQueueFactory queueFactory = args2.length == 4 ? (EventLoopTaskQueueFactory)args2[3] : null;
        return new NioEventLoop(this, executor, (SelectorProvider)args2[0], ((SelectStrategyFactory)args2[1]).newSelectStrategy(), (RejectedExecutionHandler)args2[2], queueFactory);
    }
}

