/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.lmax.disruptor.dsl;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public class BasicExecutor
implements Executor {
    private final ThreadFactory factory;
    private final Queue<Thread> threads = new ConcurrentLinkedQueue<Thread>();

    public BasicExecutor(ThreadFactory factory2) {
        this.factory = factory2;
    }

    @Override
    public void execute(Runnable command) {
        Thread thread2 = this.factory.newThread(command);
        if (null == thread2) {
            throw new RuntimeException("Failed to create thread to run: " + command);
        }
        thread2.start();
        this.threads.add(thread2);
    }

    public String toString() {
        return "BasicExecutor{threads=" + this.dumpThreadInfo() + '}';
    }

    private String dumpThreadInfo() {
        StringBuilder sb = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (Thread t : this.threads) {
            ThreadInfo threadInfo = threadMXBean.getThreadInfo(t.getId());
            sb.append("{");
            sb.append("name=").append(t.getName()).append(",");
            sb.append("id=").append(t.getId()).append(",");
            sb.append("state=").append((Object)threadInfo.getThreadState()).append(",");
            sb.append("lockInfo=").append(threadInfo.getLockInfo());
            sb.append("}");
        }
        return sb.toString();
    }
}

