/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.management.MemoryType;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.ServerCall;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.FSWALEntry;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.RingBufferTruck;
import org.apache.hadoop.hbase.regionserver.wal.SequenceIdAccounting;
import org.apache.hadoop.hbase.regionserver.wal.SyncFuture;
import org.apache.hadoop.hbase.regionserver.wal.SyncFutureCache;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.RingBuffer;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALPrettyPrinter;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.htrace.core.TraceScope;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AbstractFSWAL<W extends WALProvider.WriterBase>
implements WAL {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFSWAL.class);
    protected static final String SLOW_SYNC_TIME_MS = "hbase.regionserver.wal.slowsync.ms";
    protected static final int DEFAULT_SLOW_SYNC_TIME_MS = 100;
    protected static final String ROLL_ON_SYNC_TIME_MS = "hbase.regionserver.wal.roll.on.sync.ms";
    protected static final int DEFAULT_ROLL_ON_SYNC_TIME_MS = 10000;
    protected static final String SLOW_SYNC_ROLL_THRESHOLD = "hbase.regionserver.wal.slowsync.roll.threshold";
    protected static final int DEFAULT_SLOW_SYNC_ROLL_THRESHOLD = 100;
    protected static final String SLOW_SYNC_ROLL_INTERVAL_MS = "hbase.regionserver.wal.slowsync.roll.interval.ms";
    protected static final int DEFAULT_SLOW_SYNC_ROLL_INTERVAL_MS = 60000;
    protected static final String WAL_SYNC_TIMEOUT_MS = "hbase.regionserver.wal.sync.timeout";
    protected static final int DEFAULT_WAL_SYNC_TIMEOUT_MS = 300000;
    public static final String WAL_ROLL_MULTIPLIER = "hbase.regionserver.logroll.multiplier";
    public static final String MAX_LOGS = "hbase.regionserver.maxlogs";
    public static final String RING_BUFFER_SLOT_COUNT = "hbase.regionserver.wal.disruptor.event.count";
    public static final String WAL_SHUTDOWN_WAIT_TIMEOUT_MS = "hbase.wal.shutdown.wait.timeout.ms";
    public static final int DEFAULT_WAL_SHUTDOWN_WAIT_TIMEOUT_MS = 15000;
    protected final FileSystem fs;
    protected final Path walDir;
    protected final Path walArchiveDir;
    protected final PathFilter ourFiles;
    protected final String walFilePrefix;
    protected final String walFileSuffix;
    protected final String prefixPathStr;
    protected final WALCoprocessorHost coprocessorHost;
    protected final Configuration conf;
    protected final Abortable abortable;
    protected final List<WALActionsListener> listeners = new CopyOnWriteArrayList<WALActionsListener>();
    protected final Map<String, W> inflightWALClosures = new ConcurrentHashMap<String, W>();
    protected final SequenceIdAccounting sequenceIdAccounting = new SequenceIdAccounting();
    protected final long slowSyncNs;
    protected final long rollOnSyncNs;
    protected final int slowSyncRollThreshold;
    protected final int slowSyncCheckInterval;
    protected final AtomicInteger slowSyncCount = new AtomicInteger();
    private final long walSyncTimeoutNs;
    protected final long logrollsize;
    protected final long blocksize;
    protected final int maxLogs;
    protected final boolean useHsync;
    protected final ReentrantLock rollWriterLock = new ReentrantLock(true);
    protected final AtomicLong filenum = new AtomicLong(-1L);
    protected final AtomicInteger numEntries = new AtomicInteger(0);
    protected volatile long highestUnsyncedTxid = -1L;
    protected final AtomicLong highestSyncedTxid = new AtomicLong(0L);
    protected final AtomicLong totalLogSize = new AtomicLong(0L);
    volatile W writer;
    private volatile long lastTimeCheckLowReplication = EnvironmentEdgeManager.currentTime();
    private volatile long lastTimeCheckSlowSync = EnvironmentEdgeManager.currentTime();
    protected volatile boolean closed = false;
    protected final AtomicBoolean shutdown = new AtomicBoolean(false);
    protected final long walShutdownTimeout;
    final Comparator<Path> LOG_NAME_COMPARATOR = (o1, o2) -> Long.compare(this.getFileNumFromFileName((Path)o1), this.getFileNumFromFileName((Path)o2));
    protected final ConcurrentNavigableMap<Path, WALProps> walFile2Props = new ConcurrentSkipListMap<Path, WALProps>(this.LOG_NAME_COMPARATOR);
    protected final SyncFutureCache syncFutureCache;
    protected final String implClassName;
    protected final AtomicBoolean rollRequested = new AtomicBoolean(false);
    protected final ExecutorService closeExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Close-WAL-Writer-%d").build());
    private final ExecutorService logArchiveExecutor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("WAL-Archive-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());
    private final int archiveRetries;

    public long getFilenum() {
        return this.filenum.get();
    }

    protected long getFileNumFromFileName(Path fileName) {
        Preconditions.checkNotNull(fileName, "file name can't be null");
        if (!this.ourFiles.accept(fileName)) {
            throw new IllegalArgumentException("The log file " + fileName + " doesn't belong to this WAL. (" + this.toString() + ")");
        }
        String fileNameString = fileName.toString();
        String chompedPath = fileNameString.substring(this.prefixPathStr.length(), fileNameString.length() - this.walFileSuffix.length());
        return Long.parseLong(chompedPath);
    }

    private int calculateMaxLogFiles(Configuration conf, long logRollSize) {
        Pair<Long, MemoryType> globalMemstoreSize = MemorySizeUtil.getGlobalMemStoreSize(conf);
        return (int)(globalMemstoreSize.getFirst() * 2L / logRollSize);
    }

    protected final int getPreallocatedEventCount() {
        int preallocatedEventCount = this.conf.getInt(RING_BUFFER_SLOT_COUNT, 16384);
        Preconditions.checkArgument(preallocatedEventCount >= 0, "hbase.regionserver.wal.disruptor.event.count must > 0");
        int floor = Integer.highestOneBit(preallocatedEventCount);
        if (floor == preallocatedEventCount) {
            return floor;
        }
        if (floor >= 0x20000000) {
            return 0x40000000;
        }
        return floor << 1;
    }

    protected AbstractFSWAL(FileSystem fs, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix) throws FailedLogCloseException, IOException {
        this(fs, null, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix);
    }

    protected AbstractFSWAL(FileSystem fs, Abortable abortable, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix) throws FailedLogCloseException, IOException {
        FileStatus[] walFiles;
        this.fs = fs;
        this.walDir = new Path(rootDir, logDir);
        this.walArchiveDir = new Path(rootDir, archiveDir);
        this.conf = conf;
        this.abortable = abortable;
        if (!fs.exists(this.walDir) && !fs.mkdirs(this.walDir)) {
            throw new IOException("Unable to mkdir " + this.walDir);
        }
        if (!fs.exists(this.walArchiveDir) && !fs.mkdirs(this.walArchiveDir)) {
            throw new IOException("Unable to mkdir " + this.walArchiveDir);
        }
        String string = this.walFilePrefix = prefix == null || prefix.isEmpty() ? "wal" : URLEncoder.encode(prefix, "UTF8");
        if (suffix != null && !suffix.isEmpty() && !suffix.startsWith(".")) {
            throw new IllegalArgumentException("WAL suffix must start with '.' but instead was '" + suffix + "'");
        }
        String storagePolicy = conf.get("hbase.wal.storage.policy", "NONE");
        CommonFSUtils.setStoragePolicy(fs, this.walDir, storagePolicy);
        this.walFileSuffix = suffix == null ? "" : URLEncoder.encode(suffix, "UTF8");
        this.prefixPathStr = new Path(this.walDir, this.walFilePrefix + ".").toString();
        this.ourFiles = new PathFilter(){

            public boolean accept(Path fileName) {
                String fileNameString = fileName.toString();
                if (!fileNameString.startsWith(AbstractFSWAL.this.prefixPathStr)) {
                    return false;
                }
                if (AbstractFSWAL.this.walFileSuffix.isEmpty()) {
                    return org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils.isNumeric(fileNameString.substring(AbstractFSWAL.this.prefixPathStr.length()));
                }
                return fileNameString.endsWith(AbstractFSWAL.this.walFileSuffix);
            }
        };
        if (failIfWALExists && null != (walFiles = CommonFSUtils.listStatus(fs, this.walDir, this.ourFiles)) && 0 != walFiles.length) {
            throw new IOException("Target WAL already exists within directory " + this.walDir);
        }
        if (listeners != null) {
            for (WALActionsListener i : listeners) {
                this.registerWALActionsListener(i);
            }
        }
        this.coprocessorHost = new WALCoprocessorHost(this, conf);
        this.blocksize = WALUtil.getWALBlockSize(this.conf, this.fs, this.walDir);
        float multiplier = conf.getFloat(WAL_ROLL_MULTIPLIER, 0.5f);
        this.logrollsize = (long)((float)this.blocksize * multiplier);
        this.maxLogs = conf.getInt(MAX_LOGS, Math.max(32, this.calculateMaxLogFiles(conf, this.logrollsize)));
        LOG.info("WAL configuration: blocksize=" + StringUtils.byteDesc((long)this.blocksize) + ", rollsize=" + StringUtils.byteDesc((long)this.logrollsize) + ", prefix=" + this.walFilePrefix + ", suffix=" + this.walFileSuffix + ", logDir=" + this.walDir + ", archiveDir=" + this.walArchiveDir + ", maxLogs=" + this.maxLogs);
        this.slowSyncNs = TimeUnit.MILLISECONDS.toNanos(conf.getInt(SLOW_SYNC_TIME_MS, conf.getInt("hbase.regionserver.hlog.slowsync.ms", 100)));
        this.rollOnSyncNs = TimeUnit.MILLISECONDS.toNanos(conf.getInt(ROLL_ON_SYNC_TIME_MS, 10000));
        this.slowSyncRollThreshold = conf.getInt(SLOW_SYNC_ROLL_THRESHOLD, 100);
        this.slowSyncCheckInterval = conf.getInt(SLOW_SYNC_ROLL_INTERVAL_MS, 60000);
        this.walSyncTimeoutNs = TimeUnit.MILLISECONDS.toNanos(conf.getLong(WAL_SYNC_TIMEOUT_MS, conf.getLong("hbase.regionserver.hlog.sync.timeout", 300000L)));
        this.syncFutureCache = new SyncFutureCache(conf);
        this.implClassName = this.getClass().getSimpleName();
        this.useHsync = conf.getBoolean("hbase.wal.hsync", false);
        this.archiveRetries = this.conf.getInt("hbase.regionserver.walroll.archive.retries", 0);
        this.walShutdownTimeout = conf.getLong(WAL_SHUTDOWN_WAIT_TIMEOUT_MS, 15000L);
    }

    public void init() throws IOException {
        this.rollWriter();
    }

    @Override
    public void registerWALActionsListener(WALActionsListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean unregisterWALActionsListener(WALActionsListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public WALCoprocessorHost getCoprocessorHost() {
        return this.coprocessorHost;
    }

    @Override
    public Long startCacheFlush(byte[] encodedRegionName, Set<byte[]> families) {
        return this.sequenceIdAccounting.startCacheFlush(encodedRegionName, families);
    }

    @Override
    public Long startCacheFlush(byte[] encodedRegionName, Map<byte[], Long> familyToSeq) {
        return this.sequenceIdAccounting.startCacheFlush(encodedRegionName, familyToSeq);
    }

    @Override
    public void completeCacheFlush(byte[] encodedRegionName, long maxFlushedSeqId) {
        this.sequenceIdAccounting.completeCacheFlush(encodedRegionName, maxFlushedSeqId);
    }

    @Override
    public void abortCacheFlush(byte[] encodedRegionName) {
        this.sequenceIdAccounting.abortCacheFlush(encodedRegionName);
    }

    @Override
    public long getEarliestMemStoreSeqNum(byte[] encodedRegionName) {
        return this.sequenceIdAccounting.getLowestSequenceId(encodedRegionName);
    }

    @Override
    public long getEarliestMemStoreSeqNum(byte[] encodedRegionName, byte[] familyName) {
        return this.sequenceIdAccounting.getLowestSequenceId(encodedRegionName, familyName);
    }

    @Override
    public Map<byte[], List<byte[]>> rollWriter() throws FailedLogCloseException, IOException {
        return this.rollWriter(false);
    }

    protected Path computeFilename(long filenum) {
        if (filenum < 0L) {
            throw new RuntimeException("WAL file number can't be < 0");
        }
        String child = this.walFilePrefix + "." + filenum + this.walFileSuffix;
        return new Path(this.walDir, child);
    }

    public Path getCurrentFileName() {
        return this.computeFilename(this.filenum.get());
    }

    private Path getNewPath() throws IOException {
        this.filenum.set(Math.max(this.getFilenum() + 1L, System.currentTimeMillis()));
        Path newPath = this.getCurrentFileName();
        return newPath;
    }

    Path getOldPath() {
        long currentFilenum = this.filenum.get();
        Path oldPath = null;
        if (currentFilenum > 0L) {
            oldPath = this.computeFilename(currentFilenum);
        }
        return oldPath;
    }

    private void tellListenersAboutPreLogRoll(Path oldPath, Path newPath) throws IOException {
        this.coprocessorHost.preWALRoll(oldPath, newPath);
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.preLogRoll(oldPath, newPath);
            }
        }
    }

    private void tellListenersAboutPostLogRoll(Path oldPath, Path newPath) throws IOException {
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.postLogRoll(oldPath, newPath);
            }
        }
        this.coprocessorHost.postWALRoll(oldPath, newPath);
    }

    public int getNumRolledLogFiles() {
        return this.walFile2Props.size();
    }

    public int getNumLogFiles() {
        return this.getNumRolledLogFiles() + 1;
    }

    Map<byte[], List<byte[]>> findRegionsToForceFlush() throws IOException {
        Map<byte[], List<byte[]>> regions = null;
        int logCount = this.getNumRolledLogFiles();
        if (logCount > this.maxLogs && logCount > 0) {
            Map.Entry firstWALEntry = this.walFile2Props.firstEntry();
            regions = this.sequenceIdAccounting.findLower(((WALProps)firstWALEntry.getValue()).encodedName2HighestSequenceId);
        }
        if (regions != null) {
            ArrayList<String> listForPrint = new ArrayList<String>();
            for (Map.Entry r : regions.entrySet()) {
                StringBuilder families = new StringBuilder();
                for (int i = 0; i < ((List)r.getValue()).size(); ++i) {
                    if (i > 0) {
                        families.append(",");
                    }
                    families.append(Bytes.toString((byte[])((List)r.getValue()).get(i)));
                }
                listForPrint.add(Bytes.toStringBinary((byte[])r.getKey()) + "[" + families.toString() + "]");
            }
            LOG.info("Too many WALs; count=" + logCount + ", max=" + this.maxLogs + "; forcing (partial) flush of " + regions.size() + " region(s): " + StringUtils.join((CharSequence)",", listForPrint));
        }
        return regions;
    }

    protected final void markClosedAndClean(Path path) {
        WALProps props = (WALProps)this.walFile2Props.get(path);
        if (props != null) {
            props.closed = true;
            this.cleanOldLogs();
        }
    }

    private synchronized void cleanOldLogs() {
        ArrayList<Pair<Path, Long>> logsToArchive = null;
        for (Map.Entry e : this.walFile2Props.entrySet()) {
            if (!((WALProps)e.getValue()).closed) {
                LOG.debug("{} is not closed yet, will try archiving it next time", e.getKey());
                continue;
            }
            Path path = (Path)e.getKey();
            Map sequenceNums = ((WALProps)e.getValue()).encodedName2HighestSequenceId;
            if (!this.sequenceIdAccounting.areAllLower(sequenceNums)) continue;
            if (logsToArchive == null) {
                logsToArchive = new ArrayList<Pair<Path, Long>>();
            }
            logsToArchive.add(Pair.newPair(path, ((WALProps)e.getValue()).logSize));
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("WAL file ready for archiving " + path);
        }
        if (logsToArchive != null) {
            ArrayList<Pair<Path, Long>> localLogsToArchive = logsToArchive;
            for (Pair pair : localLogsToArchive) {
                this.logArchiveExecutor.execute(() -> this.archive(pair));
                this.walFile2Props.remove(pair.getFirst());
            }
        }
    }

    protected void archive(Pair<Path, Long> log) {
        this.totalLogSize.addAndGet(-log.getSecond().longValue());
        int retry = 1;
        while (true) {
            try {
                this.archiveLogFile(log.getFirst());
            }
            catch (Throwable e) {
                if (retry > this.archiveRetries) {
                    LOG.error("Failed log archiving for the log {},", (Object)log.getFirst(), (Object)e);
                    if (this.abortable != null) {
                        this.abortable.abort("Failed log archiving", e);
                        break;
                    }
                } else {
                    LOG.error("Log archiving failed for the log {} - attempt {}", new Object[]{log.getFirst(), retry, e});
                }
                ++retry;
                continue;
            }
            break;
        }
    }

    public static Path getWALArchivePath(Path archiveDir, Path p) {
        return new Path(archiveDir, p.getName());
    }

    protected void archiveLogFile(Path p) throws IOException {
        Path newPath = AbstractFSWAL.getWALArchivePath(this.walArchiveDir, p);
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.preLogArchive(p, newPath);
            }
        }
        LOG.info("Archiving " + p + " to " + newPath);
        if (!CommonFSUtils.renameAndSetModifyTime(this.fs, p, newPath)) {
            throw new IOException("Unable to rename " + p + " to " + newPath);
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.postLogArchive(p, newPath);
            }
        }
    }

    protected final void logRollAndSetupWalProps(Path oldPath, Path newPath, long oldFileLen) {
        String newPathString;
        int oldNumEntries = this.numEntries.getAndSet(0);
        String string = newPathString = newPath != null ? CommonFSUtils.getPath(newPath) : null;
        if (oldPath != null) {
            this.walFile2Props.put(oldPath, new WALProps(this.sequenceIdAccounting.resetHighest(), oldFileLen));
            this.totalLogSize.addAndGet(oldFileLen);
            LOG.info("Rolled WAL {} with entries={}, filesize={}; new WAL {}", new Object[]{CommonFSUtils.getPath(oldPath), oldNumEntries, StringUtils.byteDesc((long)oldFileLen), newPathString});
        } else {
            LOG.info("New WAL {}", (Object)newPathString);
        }
    }

    Path replaceWriter(Path oldPath, Path newPath, W nextWriter) throws IOException {
        try (TraceScope scope = TraceUtil.createTrace("FSHFile.replaceWriter");){
            this.doReplaceWriter(oldPath, newPath, nextWriter);
            Path path = newPath;
            return path;
        }
    }

    protected final void blockOnSync(SyncFuture syncFuture) throws IOException {
        try {
            if (syncFuture != null) {
                if (this.closed) {
                    throw new IOException("WAL has been closed");
                }
                syncFuture.get(this.walSyncTimeoutNs);
            }
        }
        catch (TimeoutIOException tioe) {
            throw tioe;
        }
        catch (InterruptedException ie) {
            LOG.warn("Interrupted", (Throwable)ie);
            throw this.convertInterruptedExceptionToIOException(ie);
        }
        catch (ExecutionException e) {
            throw AbstractFSWAL.ensureIOException(e.getCause());
        }
    }

    private static IOException ensureIOException(Throwable t) {
        return t instanceof IOException ? (IOException)t : new IOException(t);
    }

    private IOException convertInterruptedExceptionToIOException(InterruptedException ie) {
        Thread.currentThread().interrupt();
        InterruptedIOException ioe = new InterruptedIOException();
        ioe.initCause(ie);
        return ioe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<byte[], List<byte[]>> rollWriter(boolean force) throws IOException {
        this.rollWriterLock.lock();
        try {
            if (!force && this.writer != null && this.numEntries.get() <= 0) {
                Map<byte[], List<byte[]>> map = null;
                return map;
            }
            Map<byte[], List<byte[]>> regionsToFlush = null;
            if (this.closed) {
                LOG.debug("WAL closed. Skipping rolling of writer");
                Map<byte[], List<byte[]>> map = regionsToFlush;
                return map;
            }
            try (TraceScope scope = TraceUtil.createTrace("FSHLog.rollWriter");){
                Path oldPath = this.getOldPath();
                Path newPath = this.getNewPath();
                W nextWriter = this.createWriterInstance(newPath);
                this.tellListenersAboutPreLogRoll(oldPath, newPath);
                newPath = this.replaceWriter(oldPath, newPath, nextWriter);
                this.tellListenersAboutPostLogRoll(oldPath, newPath);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Create new " + this.implClassName + " writer with pipeline: " + Arrays.toString(this.getPipeline()));
                }
                this.lastTimeCheckSlowSync = EnvironmentEdgeManager.currentTime();
                this.slowSyncCount.set(0);
                if (this.getNumRolledLogFiles() > 0) {
                    this.cleanOldLogs();
                    regionsToFlush = this.findRegionsToForceFlush();
                }
            }
            catch (CommonFSUtils.StreamLacksCapabilityException exception) {
                throw new IOException("Underlying FileSystem can't meet stream requirements. See RS log for details.", exception);
            }
            Map<byte[], List<byte[]>> map = regionsToFlush;
            return map;
        }
        finally {
            this.rollWriterLock.unlock();
        }
    }

    public long getLogFileSize() {
        return this.totalLogSize.get();
    }

    public void requestLogRoll() {
        this.requestLogRoll(WALActionsListener.RollRequestReason.ERROR);
    }

    FileStatus[] getFiles() throws IOException {
        return CommonFSUtils.listStatus(this.fs, this.walDir, this.ourFiles);
    }

    @Override
    public void shutdown() throws IOException {
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        this.closed = true;
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.logCloseRequested();
            }
        }
        ExecutorService shutdownExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("WAL-Shutdown-%d").build());
        Future<Void> future = shutdownExecutor.submit(new Callable<Void>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Void call() throws Exception {
                if (!AbstractFSWAL.this.rollWriterLock.tryLock(AbstractFSWAL.this.walShutdownTimeout, TimeUnit.SECONDS)) throw new IOException("Waiting for rollWriterLock timeout");
                try {
                    AbstractFSWAL.this.doShutdown();
                    if (AbstractFSWAL.this.syncFutureCache == null) return null;
                    AbstractFSWAL.this.syncFutureCache.clear();
                    return null;
                }
                finally {
                    AbstractFSWAL.this.rollWriterLock.unlock();
                }
            }
        });
        shutdownExecutor.shutdown();
        try {
            future.get(this.walShutdownTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted when waiting for shutdown WAL");
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException("We have waited " + this.walShutdownTimeout + "ms, but the shutdown of WAL doesn't complete! Please check the status of underlying filesystem or increase the wait time by the config \"" + WAL_SHUTDOWN_WAIT_TIMEOUT_MS + "\"", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
        finally {
            this.logArchiveExecutor.shutdown();
        }
        try {
            if (!this.logArchiveExecutor.awaitTermination(this.walShutdownTimeout, TimeUnit.MILLISECONDS)) {
                throw new TimeoutIOException("We have waited " + this.walShutdownTimeout + "ms, but the shutdown of WAL doesn't complete! Please check the status of underlying filesystem or increase the wait time by the config \"" + WAL_SHUTDOWN_WAIT_TIMEOUT_MS + "\"");
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted when waiting for shutdown WAL");
        }
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
        FileStatus[] files = this.getFiles();
        if (null != files && 0 != files.length) {
            for (FileStatus file : files) {
                Path p = AbstractFSWAL.getWALArchivePath(this.walArchiveDir, file.getPath());
                if (!this.listeners.isEmpty()) {
                    for (WALActionsListener i : this.listeners) {
                        i.preLogArchive(file.getPath(), p);
                    }
                }
                if (!CommonFSUtils.renameAndSetModifyTime(this.fs, file.getPath(), p)) {
                    throw new IOException("Unable to rename " + file.getPath() + " to " + p);
                }
                if (this.listeners.isEmpty()) continue;
                for (WALActionsListener i : this.listeners) {
                    i.postLogArchive(file.getPath(), p);
                }
            }
            LOG.debug("Moved " + files.length + " WAL file(s) to " + CommonFSUtils.getPath(this.walArchiveDir));
        }
        LOG.info("Closed WAL: " + this.toString());
    }

    public int getInflightWALCloseCount() {
        return this.inflightWALClosures.size();
    }

    @Override
    public void updateStore(byte[] encodedRegionName, byte[] familyName, Long sequenceid, boolean onlyIfGreater) {
        this.sequenceIdAccounting.updateStore(encodedRegionName, familyName, sequenceid, onlyIfGreater);
    }

    protected final SyncFuture getSyncFuture(long sequence, boolean forceSync) {
        return this.syncFutureCache.getIfPresentOrNew().reset(sequence, forceSync);
    }

    protected boolean isLogRollRequested() {
        return this.rollRequested.get();
    }

    protected final void requestLogRoll(WALActionsListener.RollRequestReason reason) {
        if (!this.listeners.isEmpty() && this.rollRequested.compareAndSet(false, true)) {
            for (WALActionsListener i : this.listeners) {
                i.logRollRequested(reason);
            }
        }
    }

    long getUnflushedEntriesCount() {
        long highestUnsynced;
        long highestSynced = this.highestSyncedTxid.get();
        return highestSynced >= (highestUnsynced = this.highestUnsyncedTxid) ? 0L : highestUnsynced - highestSynced;
    }

    boolean isUnflushedEntries() {
        return this.getUnflushedEntriesCount() > 0L;
    }

    protected void atHeadOfRingBufferEventHandlerAppend() {
    }

    protected final boolean appendEntry(W writer, FSWALEntry entry) throws IOException {
        this.atHeadOfRingBufferEventHandlerAppend();
        long start = EnvironmentEdgeManager.currentTime();
        byte[] encodedRegionName = entry.getKey().getEncodedRegionName();
        long regionSequenceId = entry.getKey().getSequenceId();
        if (entry.getEdit().isEmpty()) {
            return false;
        }
        this.coprocessorHost.preWALWrite(entry.getRegionInfo(), entry.getKey(), entry.getEdit());
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.visitLogEntryBeforeWrite(entry.getKey(), entry.getEdit());
            }
        }
        this.doAppend(writer, entry);
        assert (this.highestUnsyncedTxid < entry.getTxid());
        this.highestUnsyncedTxid = entry.getTxid();
        if (entry.isCloseRegion()) {
            this.sequenceIdAccounting.onRegionClose(encodedRegionName);
        } else {
            this.sequenceIdAccounting.update(encodedRegionName, entry.getFamilyNames(), regionSequenceId, entry.isInMemStore());
        }
        this.coprocessorHost.postWALWrite(entry.getRegionInfo(), entry.getKey(), entry.getEdit());
        this.postAppend(entry, EnvironmentEdgeManager.currentTime() - start);
        this.numEntries.incrementAndGet();
        return true;
    }

    private long postAppend(WAL.Entry e, long elapsedTime) throws IOException {
        long len = 0L;
        if (!this.listeners.isEmpty()) {
            for (Cell cell : e.getEdit().getCells()) {
                len += (long)PrivateCellUtil.estimatedSerializedSizeOf(cell);
            }
            for (WALActionsListener listener : this.listeners) {
                listener.postAppend(len, elapsedTime, e.getKey(), e.getEdit());
            }
        }
        return len;
    }

    protected final void postSync(long timeInNanos, int handlerSyncs) {
        if (timeInNanos > this.slowSyncNs) {
            String msg = "Slow sync cost: " + TimeUnit.NANOSECONDS.toMillis(timeInNanos) + " ms, current pipeline: " + Arrays.toString(this.getPipeline());
            TraceUtil.addTimelineAnnotation(msg);
            LOG.info(msg);
            if (timeInNanos > this.rollOnSyncNs) {
                LOG.warn("Requesting log roll because we exceeded slow sync threshold; time=" + TimeUnit.NANOSECONDS.toMillis(timeInNanos) + " ms, threshold=" + TimeUnit.NANOSECONDS.toMillis(this.rollOnSyncNs) + " ms, current pipeline: " + Arrays.toString(this.getPipeline()));
                this.requestLogRoll(WALActionsListener.RollRequestReason.SLOW_SYNC);
            }
            this.slowSyncCount.incrementAndGet();
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener listener : this.listeners) {
                listener.postSync(timeInNanos, handlerSyncs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long stampSequenceIdAndPublishToRingBuffer(RegionInfo hri, WALKeyImpl key, WALEdit edits, boolean inMemstore, RingBuffer<RingBufferTruck> ringBuffer) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot append; log is closed, regionName = " + hri.getRegionNameAsString());
        }
        MutableLong txidHolder = new MutableLong();
        MultiVersionConcurrencyControl.WriteEntry we = key.getMvcc().begin(() -> txidHolder.setValue(ringBuffer.next()));
        long txid = txidHolder.longValue();
        ServerCall rpcCall = RpcServer.getCurrentCall().filter(c -> c instanceof ServerCall).filter(c -> c.getCellScanner() != null).map(c -> (ServerCall)c).orElse(null);
        try (TraceScope scope = TraceUtil.createTrace(this.implClassName + ".append");){
            FSWALEntry entry = new FSWALEntry(txid, key, edits, hri, inMemstore, rpcCall);
            entry.stampRegionSequenceId(we);
            ringBuffer.get(txid).load(entry);
        }
        finally {
            ringBuffer.publish(txid);
        }
        return txid;
    }

    @Override
    public String toString() {
        return this.implClassName + " " + this.walFilePrefix + ":" + this.walFileSuffix + "(num " + this.filenum + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OptionalLong getLogFileSizeIfBeingWritten(Path path) {
        this.rollWriterLock.lock();
        try {
            Path currentPath = this.getOldPath();
            if (path.equals((Object)currentPath)) {
                W writer = this.writer;
                OptionalLong optionalLong = writer != null ? OptionalLong.of(writer.getSyncedLength()) : OptionalLong.empty();
                return optionalLong;
            }
            WALProvider.WriterBase temp = (WALProvider.WriterBase)this.inflightWALClosures.get(path.getName());
            if (temp != null) {
                OptionalLong optionalLong = OptionalLong.of(temp.getSyncedLength());
                return optionalLong;
            }
            OptionalLong optionalLong = OptionalLong.empty();
            return optionalLong;
        }
        finally {
            this.rollWriterLock.unlock();
        }
    }

    @Override
    public long appendData(RegionInfo info, WALKeyImpl key, WALEdit edits) throws IOException {
        return this.append(info, key, edits, true);
    }

    @Override
    public long appendMarker(RegionInfo info, WALKeyImpl key, WALEdit edits) throws IOException {
        return this.append(info, key, edits, false);
    }

    protected abstract long append(RegionInfo var1, WALKeyImpl var2, WALEdit var3, boolean var4) throws IOException;

    protected abstract void doAppend(W var1, FSWALEntry var2) throws IOException;

    protected abstract W createWriterInstance(Path var1) throws IOException, CommonFSUtils.StreamLacksCapabilityException;

    protected abstract void doReplaceWriter(Path var1, Path var2, W var3) throws IOException;

    protected abstract void doShutdown() throws IOException;

    protected abstract boolean doCheckLogLowReplication();

    protected boolean doCheckSlowSync() {
        boolean result = false;
        long now = EnvironmentEdgeManager.currentTime();
        long elapsedTime = now - this.lastTimeCheckSlowSync;
        if (elapsedTime >= (long)this.slowSyncCheckInterval) {
            if (this.slowSyncCount.get() >= this.slowSyncRollThreshold) {
                if (elapsedTime >= (long)(2 * this.slowSyncCheckInterval)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("checkSlowSync triggered but we decided to ignore it; count=" + this.slowSyncCount.get() + ", threshold=" + this.slowSyncRollThreshold + ", elapsedTime=" + elapsedTime + " ms, slowSyncCheckInterval=" + this.slowSyncCheckInterval + " ms");
                    }
                } else {
                    LOG.warn("Requesting log roll because we exceeded slow sync threshold; count=" + this.slowSyncCount.get() + ", threshold=" + this.slowSyncRollThreshold + ", current pipeline: " + Arrays.toString(this.getPipeline()));
                    result = true;
                }
            }
            this.lastTimeCheckSlowSync = now;
            this.slowSyncCount.set(0);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLogLowReplication(long checkInterval) {
        long now = EnvironmentEdgeManager.currentTime();
        if (now - this.lastTimeCheckLowReplication < checkInterval) {
            return;
        }
        if (!this.rollWriterLock.tryLock()) {
            return;
        }
        try {
            this.lastTimeCheckLowReplication = now;
            if (this.doCheckLogLowReplication()) {
                this.requestLogRoll(WALActionsListener.RollRequestReason.LOW_REPLICATION);
            }
        }
        finally {
            this.rollWriterLock.unlock();
        }
    }

    abstract DatanodeInfo[] getPipeline();

    abstract int getLogReplication();

    private static void split(Configuration conf, Path p) throws IOException {
        FileSystem fs = CommonFSUtils.getWALFileSystem(conf);
        if (!fs.exists(p)) {
            throw new FileNotFoundException(p.toString());
        }
        if (!fs.getFileStatus(p).isDirectory()) {
            throw new IOException(p + " is not a directory");
        }
        Path baseDir = CommonFSUtils.getWALRootDir(conf);
        Path archiveDir = new Path(baseDir, "oldWALs");
        if (conf.getBoolean("hbase.separate.oldlogdir.by.regionserver", false)) {
            archiveDir = new Path(archiveDir, p.getName());
        }
        WALSplitter.split(baseDir, p, archiveDir, fs, conf, WALFactory.getInstance(conf));
    }

    private static void usage() {
        System.err.println("Usage: AbstractFSWAL <ARGS>");
        System.err.println("Arguments:");
        System.err.println(" --dump  Dump textual representation of passed one or more files");
        System.err.println("         For example: AbstractFSWAL --dump hdfs://example.com:9000/hbase/WALs/MACHINE/LOGFILE");
        System.err.println(" --split Split the passed directory of WAL logs");
        System.err.println("         For example: AbstractFSWAL --split hdfs://example.com:9000/hbase/WALs/DIR");
    }

    public static void main(String[] args2) throws IOException {
        if (args2.length < 2) {
            AbstractFSWAL.usage();
            System.exit(-1);
        }
        if (args2[0].compareTo("--dump") == 0) {
            WALPrettyPrinter.run(Arrays.copyOfRange(args2, 1, args2.length));
        } else if (args2[0].compareTo("--perf") == 0) {
            LOG.error(HBaseMarkers.FATAL, "Please use the WALPerformanceEvaluation tool instead. i.e.:");
            LOG.error(HBaseMarkers.FATAL, "\thbase org.apache.hadoop.hbase.wal.WALPerformanceEvaluation --iterations " + args2[1]);
            System.exit(-1);
        } else if (args2[0].compareTo("--split") == 0) {
            Configuration conf = HBaseConfiguration.create();
            for (int i = 1; i < args2.length; ++i) {
                try {
                    Path logPath = new Path(args2[i]);
                    CommonFSUtils.setFsDefault(conf, logPath);
                    AbstractFSWAL.split(conf, logPath);
                    continue;
                }
                catch (IOException t) {
                    t.printStackTrace(System.err);
                    System.exit(-1);
                }
            }
        } else {
            AbstractFSWAL.usage();
            System.exit(-1);
        }
    }

    private static final class WALProps {
        private final Map<byte[], Long> encodedName2HighestSequenceId;
        private final long logSize;
        private volatile boolean closed = false;

        WALProps(Map<byte[], Long> encodedName2HighestSequenceId, long logSize) {
            this.encodedName2HighestSequenceId = encodedName2HighestSequenceId;
            this.logSize = logSize;
        }
    }
}

