/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.quotas.RegionSizeStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FileSystemUtilizationChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemUtilizationChore.class);
    static final String FS_UTILIZATION_CHORE_PERIOD_KEY = "hbase.regionserver.quotas.fs.utilization.chore.period";
    static final int FS_UTILIZATION_CHORE_PERIOD_DEFAULT = 300000;
    static final String FS_UTILIZATION_CHORE_DELAY_KEY = "hbase.regionserver.quotas.fs.utilization.chore.delay";
    static final long FS_UTILIZATION_CHORE_DELAY_DEFAULT = 60000L;
    static final String FS_UTILIZATION_CHORE_TIMEUNIT_KEY = "hbase.regionserver.quotas.fs.utilization.chore.timeunit";
    static final String FS_UTILIZATION_CHORE_TIMEUNIT_DEFAULT = TimeUnit.MILLISECONDS.name();
    static final String FS_UTILIZATION_MAX_ITERATION_DURATION_KEY = "hbase.regionserver.quotas.fs.utilization.chore.max.iteration.millis";
    static final long FS_UTILIZATION_MAX_ITERATION_DURATION_DEFAULT = 5000L;
    private final HRegionServer rs;
    private final long maxIterationMillis;
    private Iterator<Region> leftoverRegions;

    public FileSystemUtilizationChore(HRegionServer rs) {
        super(FileSystemUtilizationChore.class.getSimpleName(), rs, FileSystemUtilizationChore.getPeriod(rs.getConfiguration()), FileSystemUtilizationChore.getInitialDelay(rs.getConfiguration()), FileSystemUtilizationChore.getTimeUnit(rs.getConfiguration()));
        this.rs = rs;
        this.maxIterationMillis = rs.getConfiguration().getLong(FS_UTILIZATION_MAX_ITERATION_DURATION_KEY, 5000L);
    }

    @Override
    protected void chore() {
        boolean processingLeftovers;
        Iterator<Region> iterator2;
        RegionSizeStore regionSizeStore = this.getRegionSizeStore();
        HashSet<HRegion> onlineRegions = new HashSet<HRegion>(this.rs.getRegions());
        Iterator<Region> oldRegionsToProcess = this.getLeftoverRegions();
        if (oldRegionsToProcess == null) {
            iterator2 = onlineRegions.iterator();
            processingLeftovers = false;
        } else {
            iterator2 = oldRegionsToProcess;
            processingLeftovers = true;
        }
        this.setLeftoverRegions(null);
        long regionSizesCalculated = 0L;
        long offlineRegionsSkipped = 0L;
        long skippedSplitParents = 0L;
        long skippedRegionReplicas = 0L;
        long start = EnvironmentEdgeManager.currentTime();
        while (iterator2.hasNext()) {
            long timeRunning = EnvironmentEdgeManager.currentTime() - start;
            if (timeRunning > this.maxIterationMillis) {
                LOG.debug("Preempting execution of FileSystemUtilizationChore because it exceeds the maximum iteration configuration value. Will process remaining Regions on a subsequent invocation.");
                this.setLeftoverRegions(iterator2);
                break;
            }
            Region region = iterator2.next();
            if (processingLeftovers && !onlineRegions.contains(region)) {
                ++offlineRegionsSkipped;
                continue;
            }
            if (region.getRegionInfo().isSplitParent()) {
                ++skippedSplitParents;
                continue;
            }
            if (0 != region.getRegionInfo().getReplicaId()) {
                ++skippedRegionReplicas;
                continue;
            }
            long sizeInBytes = this.computeSize(region);
            regionSizeStore.put(region.getRegionInfo(), sizeInBytes);
            ++regionSizesCalculated;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Computed the size of " + regionSizesCalculated + " Regions. Skipped computation of " + offlineRegionsSkipped + " regions due to not being online on this RS, " + skippedSplitParents + " regions due to being the parent of a split, and" + skippedRegionReplicas + " regions due to being region replicas.");
        }
    }

    Iterator<Region> getLeftoverRegions() {
        return this.leftoverRegions;
    }

    void setLeftoverRegions(Iterator<Region> newLeftovers) {
        this.leftoverRegions = newLeftovers;
    }

    long computeSize(Region r) {
        long regionSize = 0L;
        for (Store store : r.getStores()) {
            regionSize += store.getHFilesSize();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Size of " + r + " is " + regionSize);
        }
        return regionSize;
    }

    RegionSizeStore getRegionSizeStore() {
        return this.rs.getRegionServerSpaceQuotaManager().getRegionSizeStore();
    }

    static int getPeriod(Configuration conf) {
        return conf.getInt(FS_UTILIZATION_CHORE_PERIOD_KEY, 300000);
    }

    static long getInitialDelay(Configuration conf) {
        return conf.getLong(FS_UTILIZATION_CHORE_DELAY_KEY, 60000L);
    }

    static TimeUnit getTimeUnit(Configuration conf) {
        return TimeUnit.valueOf(conf.get(FS_UTILIZATION_CHORE_TIMEUNIT_KEY, FS_UTILIZATION_CHORE_TIMEUNIT_DEFAULT));
    }
}

