/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.io.SizedCellScanner;
import org.apache.hadoop.hbase.ipc.HBaseRpcControllerImpl;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationProtbufUtil {
    public static void replicateWALEntry(AdminProtos.AdminService.BlockingInterface admin, WAL.Entry[] entries, String replicationClusterId, Path sourceBaseNamespaceDir, Path sourceHFileArchiveDir, int timeout2) throws IOException {
        Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner> p = ReplicationProtbufUtil.buildReplicateWALEntryRequest(entries, null, replicationClusterId, sourceBaseNamespaceDir, sourceHFileArchiveDir);
        HBaseRpcControllerImpl controller = new HBaseRpcControllerImpl(p.getSecond());
        controller.setCallTimeout(timeout2);
        try {
            admin.replicateWALEntry(controller, p.getFirst());
        }
        catch (ServiceException e) {
            throw ProtobufUtil.getServiceException(e);
        }
    }

    public static Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner> buildReplicateWALEntryRequest(WAL.Entry[] entries) throws IOException {
        return ReplicationProtbufUtil.buildReplicateWALEntryRequest(entries, null, null, null, null);
    }

    public static Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner> buildReplicateWALEntryRequest(WAL.Entry[] entries, byte[] encodedRegionName, String replicationClusterId, Path sourceBaseNamespaceDir, Path sourceHFileArchiveDir) throws IOException {
        ArrayList<List<? extends Cell>> allCells = new ArrayList<List<? extends Cell>>(entries.length);
        int size = 0;
        AdminProtos.WALEntry.Builder entryBuilder = AdminProtos.WALEntry.newBuilder();
        AdminProtos.ReplicateWALEntryRequest.Builder builder = AdminProtos.ReplicateWALEntryRequest.newBuilder();
        for (WAL.Entry entry : entries) {
            WALProtos.WALKey.Builder keyBuilder;
            entryBuilder.clear();
            try {
                keyBuilder = entry.getKey().getBuilder(WALCellCodec.getNoneCompressor());
            }
            catch (IOException e) {
                throw new IOException("There should not throw exception since NoneCompressor do not throw any exceptions", e);
            }
            if (encodedRegionName != null) {
                keyBuilder.setEncodedRegionName(UnsafeByteOperations.unsafeWrap(encodedRegionName));
            }
            entryBuilder.setKey(keyBuilder.build());
            WALEdit edit = entry.getEdit();
            ArrayList<Cell> cells = edit.getCells();
            for (Cell cell : cells) {
                size += PrivateCellUtil.estimatedSerializedSizeOf(cell);
            }
            allCells.add(cells);
            entryBuilder.setAssociatedCellCount(cells.size());
            builder.addEntry(entryBuilder.build());
        }
        if (replicationClusterId != null) {
            builder.setReplicationClusterId(replicationClusterId);
        }
        if (sourceBaseNamespaceDir != null) {
            builder.setSourceBaseNamespaceDirPath(sourceBaseNamespaceDir.toString());
        }
        if (sourceHFileArchiveDir != null) {
            builder.setSourceHFileArchiveDirPath(sourceHFileArchiveDir.toString());
        }
        return new Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner>(builder.build(), ReplicationProtbufUtil.getCellScanner(allCells, size));
    }

    static CellScanner getCellScanner(final List<List<? extends Cell>> cells, final int size) {
        return new SizedCellScanner(){
            private final Iterator<List<? extends Cell>> entries;
            private Iterator<? extends Cell> currentIterator;
            private Cell currentCell;
            {
                this.entries = cells.iterator();
                this.currentIterator = null;
            }

            @Override
            public Cell current() {
                return this.currentCell;
            }

            @Override
            public boolean advance() {
                if (this.currentIterator == null) {
                    if (!this.entries.hasNext()) {
                        return false;
                    }
                    this.currentIterator = this.entries.next().iterator();
                }
                if (this.currentIterator.hasNext()) {
                    this.currentCell = this.currentIterator.next();
                    return true;
                }
                this.currentCell = null;
                this.currentIterator = null;
                return this.advance();
            }

            @Override
            public long heapSize() {
                return size;
            }
        };
    }
}

