/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.store.LeaseRecovery;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStoreBase;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureStoreTracker;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureWALFile;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureWALFormat;
import org.apache.hadoop.hbase.procedure2.util.ByteSlot;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.Private
public class WALProcedureStore
extends ProcedureStoreBase {
    private static final Logger LOG = LoggerFactory.getLogger(WALProcedureStore.class);
    public static final String LOG_PREFIX = "pv2-";
    public static final String MASTER_PROCEDURE_LOGDIR = "MasterProcWALs";
    public static final String WAL_COUNT_WARN_THRESHOLD_CONF_KEY = "hbase.procedure.store.wal.warn.threshold";
    private static final int DEFAULT_WAL_COUNT_WARN_THRESHOLD = 10;
    public static final String EXEC_WAL_CLEANUP_ON_LOAD_CONF_KEY = "hbase.procedure.store.wal.exec.cleanup.on.load";
    private static final boolean DEFAULT_EXEC_WAL_CLEANUP_ON_LOAD_CONF_KEY = true;
    public static final String MAX_RETRIES_BEFORE_ROLL_CONF_KEY = "hbase.procedure.store.wal.max.retries.before.roll";
    private static final int DEFAULT_MAX_RETRIES_BEFORE_ROLL = 3;
    public static final String WAIT_BEFORE_ROLL_CONF_KEY = "hbase.procedure.store.wal.wait.before.roll";
    private static final int DEFAULT_WAIT_BEFORE_ROLL = 500;
    public static final String ROLL_RETRIES_CONF_KEY = "hbase.procedure.store.wal.max.roll.retries";
    private static final int DEFAULT_ROLL_RETRIES = 3;
    public static final String MAX_SYNC_FAILURE_ROLL_CONF_KEY = "hbase.procedure.store.wal.sync.failure.roll.max";
    private static final int DEFAULT_MAX_SYNC_FAILURE_ROLL = 3;
    public static final String PERIODIC_ROLL_CONF_KEY = "hbase.procedure.store.wal.periodic.roll.msec";
    private static final int DEFAULT_PERIODIC_ROLL = 3600000;
    public static final String SYNC_WAIT_MSEC_CONF_KEY = "hbase.procedure.store.wal.sync.wait.msec";
    private static final int DEFAULT_SYNC_WAIT_MSEC = 100;
    public static final String USE_HSYNC_CONF_KEY = "hbase.procedure.store.wal.use.hsync";
    private static final boolean DEFAULT_USE_HSYNC = true;
    public static final String ROLL_THRESHOLD_CONF_KEY = "hbase.procedure.store.wal.roll.threshold";
    private static final long DEFAULT_ROLL_THRESHOLD = 0x2000000L;
    public static final String STORE_WAL_SYNC_STATS_COUNT = "hbase.procedure.store.wal.sync.stats.count";
    private static final int DEFAULT_SYNC_STATS_COUNT = 10;
    private final LinkedList<ProcedureWALFile> logs = new LinkedList();
    private final ProcedureStoreTracker holdingCleanupTracker = new ProcedureStoreTracker();
    private final ProcedureStoreTracker storeTracker = new ProcedureStoreTracker();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition waitCond = this.lock.newCondition();
    private final Condition slotCond = this.lock.newCondition();
    private final Condition syncCond = this.lock.newCondition();
    private final LeaseRecovery leaseRecovery;
    private final Configuration conf;
    private final FileSystem fs;
    private final Path walDir;
    private final Path walArchiveDir;
    private final boolean enforceStreamCapability;
    private final AtomicReference<Throwable> syncException = new AtomicReference();
    private final AtomicBoolean loading = new AtomicBoolean(true);
    private final AtomicBoolean inSync = new AtomicBoolean(false);
    private final AtomicLong totalSynced = new AtomicLong(0L);
    private final AtomicLong lastRollTs = new AtomicLong(0L);
    private final AtomicLong syncId = new AtomicLong(0L);
    private LinkedTransferQueue<ByteSlot> slotsCache = null;
    private Set<ProcedureWALFile> corruptedLogs = null;
    private FSDataOutputStream stream = null;
    private int runningProcCount = 1;
    private long flushLogId = 0L;
    private int syncMaxSlot = 1;
    private int slotIndex = 0;
    private Thread syncThread;
    private ByteSlot[] slots;
    private int walCountWarnThreshold;
    private int maxRetriesBeforeRoll;
    private int maxSyncFailureRoll;
    private int waitBeforeRoll;
    private int rollRetries;
    private int periodicRollMsec;
    private long rollThreshold;
    private boolean useHsync;
    private int syncWaitMsec;
    private CircularFifoQueue<SyncMetrics> syncMetricsQueue;
    private static final PathFilter WALS_PATH_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getName();
            return name.startsWith(WALProcedureStore.LOG_PREFIX) && name.endsWith(".log");
        }
    };
    private static final Comparator<FileStatus> FILE_STATUS_ID_COMPARATOR = new Comparator<FileStatus>(){

        @Override
        public int compare(FileStatus a, FileStatus b) {
            long aId = WALProcedureStore.getLogIdFromName(a.getPath().getName());
            long bId = WALProcedureStore.getLogIdFromName(b.getPath().getName());
            return Long.compare(aId, bId);
        }
    };

    public WALProcedureStore(Configuration conf, LeaseRecovery leaseRecovery) throws IOException {
        this(conf, new Path(CommonFSUtils.getWALRootDir(conf), MASTER_PROCEDURE_LOGDIR), new Path(CommonFSUtils.getWALRootDir(conf), "oldWALs"), leaseRecovery);
    }

    public WALProcedureStore(Configuration conf, Path walDir, Path walArchiveDir, LeaseRecovery leaseRecovery) throws IOException {
        this.conf = conf;
        this.leaseRecovery = leaseRecovery;
        this.walDir = walDir;
        this.walArchiveDir = walArchiveDir;
        this.fs = CommonFSUtils.getWALFileSystem(conf);
        this.enforceStreamCapability = conf.getBoolean("hbase.unsafe.stream.capability.enforce", true);
        if (!this.fs.exists(walDir) && !this.fs.mkdirs(walDir)) {
            throw new IOException("Unable to mkdir " + walDir);
        }
        String storagePolicy = conf.get("hbase.wal.storage.policy", "NONE");
        CommonFSUtils.setStoragePolicy(this.fs, walDir, storagePolicy);
        if (this.walArchiveDir != null && !this.fs.exists(this.walArchiveDir)) {
            if (this.fs.mkdirs(this.walArchiveDir)) {
                LOG.debug("Created Procedure Store WAL archive dir {}", (Object)this.walArchiveDir);
            } else {
                LOG.warn("Failed create of {}", (Object)this.walArchiveDir);
            }
        }
    }

    @Override
    public void start(int numSlots) throws IOException {
        if (!this.setRunning(true)) {
            return;
        }
        this.loading.set(true);
        this.runningProcCount = numSlots;
        this.syncMaxSlot = numSlots;
        this.slots = new ByteSlot[numSlots];
        this.slotsCache = new LinkedTransferQueue();
        while (this.slotsCache.size() < numSlots) {
            this.slotsCache.offer(new ByteSlot());
        }
        this.walCountWarnThreshold = this.conf.getInt(WAL_COUNT_WARN_THRESHOLD_CONF_KEY, 10);
        this.maxRetriesBeforeRoll = this.conf.getInt(MAX_RETRIES_BEFORE_ROLL_CONF_KEY, 3);
        this.maxSyncFailureRoll = this.conf.getInt(MAX_SYNC_FAILURE_ROLL_CONF_KEY, 3);
        this.waitBeforeRoll = this.conf.getInt(WAIT_BEFORE_ROLL_CONF_KEY, 500);
        this.rollRetries = this.conf.getInt(ROLL_RETRIES_CONF_KEY, 3);
        this.rollThreshold = this.conf.getLong(ROLL_THRESHOLD_CONF_KEY, 0x2000000L);
        this.periodicRollMsec = this.conf.getInt(PERIODIC_ROLL_CONF_KEY, 3600000);
        this.syncWaitMsec = this.conf.getInt(SYNC_WAIT_MSEC_CONF_KEY, 100);
        this.useHsync = this.conf.getBoolean(USE_HSYNC_CONF_KEY, true);
        this.syncMetricsQueue = new CircularFifoQueue(this.conf.getInt(STORE_WAL_SYNC_STATS_COUNT, 10));
        this.syncThread = new Thread("WALProcedureStoreSyncThread"){

            @Override
            public void run() {
                block2: {
                    try {
                        WALProcedureStore.this.syncLoop();
                    }
                    catch (Throwable e) {
                        LOG.error("Got an exception from the sync-loop", e);
                        if (WALProcedureStore.this.isSyncAborted()) break block2;
                        WALProcedureStore.this.sendAbortProcessSignal();
                    }
                }
            }
        };
        this.syncThread.start();
    }

    @Override
    public void stop(boolean abort) {
        if (!this.setRunning(false)) {
            return;
        }
        LOG.info("Stopping the WAL Procedure Store, isAbort=" + abort + (this.isSyncAborted() ? " (self aborting)" : ""));
        this.sendStopSignal();
        if (!this.isSyncAborted()) {
            try {
                while (this.syncThread.isAlive()) {
                    this.sendStopSignal();
                    this.syncThread.join(250L);
                }
            }
            catch (InterruptedException e) {
                LOG.warn("join interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        this.closeCurrentLogStream(abort);
        for (ProcedureWALFile log : this.logs) {
            log.close();
        }
        this.logs.clear();
        this.loading.set(true);
    }

    private void sendStopSignal() {
        if (this.lock.tryLock()) {
            try {
                this.waitCond.signalAll();
                this.syncCond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public int getNumThreads() {
        return this.slots == null ? 0 : this.slots.length;
    }

    @Override
    public int setRunningProcedureCount(int count) {
        this.runningProcCount = count > 0 ? Math.min(count, this.slots.length) : this.slots.length;
        return this.runningProcCount;
    }

    public ProcedureStoreTracker getStoreTracker() {
        return this.storeTracker;
    }

    public ArrayList<ProcedureWALFile> getActiveLogs() {
        this.lock.lock();
        try {
            ArrayList<ProcedureWALFile> arrayList = new ArrayList<ProcedureWALFile>(this.logs);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<ProcedureWALFile> getCorruptedLogs() {
        return this.corruptedLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverLease() throws IOException {
        this.lock.lock();
        try {
            LOG.debug("Starting WAL Procedure Store lease recovery");
            boolean afterFirstAttempt = false;
            while (this.isRunning()) {
                if (afterFirstAttempt) {
                    LOG.trace("Sleep {} ms after first lease recovery attempt.", (Object)this.waitBeforeRoll);
                    Threads.sleepWithoutInterrupt(this.waitBeforeRoll);
                } else {
                    afterFirstAttempt = true;
                }
                FileStatus[] oldLogs = this.getLogFiles();
                try {
                    this.flushLogId = this.initOldLogs(oldLogs);
                }
                catch (FileNotFoundException e) {
                    LOG.warn("Someone else is active and deleted logs. retrying.", (Throwable)e);
                    continue;
                }
                if (!this.rollWriter(this.flushLogId + 1L)) {
                    LOG.debug("Someone else has already created log {}. Retrying.", (Object)this.flushLogId);
                    continue;
                }
                oldLogs = this.getLogFiles();
                if (WALProcedureStore.getMaxLogId(oldLogs) > this.flushLogId) {
                    LOG.debug("Someone else created new logs. Expected maxLogId < {}", (Object)this.flushLogId);
                    this.logs.getLast().removeFile(this.walArchiveDir);
                    continue;
                }
                LOG.debug("Lease acquired for flushLogId={}", (Object)this.flushLogId);
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void load(final ProcedureStore.ProcedureLoader loader) throws IOException {
        this.lock.lock();
        try {
            if (this.logs.isEmpty()) {
                throw new IllegalStateException("recoverLease() must be called before loading data");
            }
            if (this.logs.size() == 1) {
                LOG.debug("No state logs to replay.");
                loader.setMaxProcId(0L);
                this.loading.set(false);
                return;
            }
            Iterator<ProcedureWALFile> it = this.logs.descendingIterator();
            it.next();
            ProcedureWALFormat.load(it, this.storeTracker, new ProcedureWALFormat.Loader(){

                @Override
                public void setMaxProcId(long maxProcId) {
                    loader.setMaxProcId(maxProcId);
                }

                @Override
                public void load(ProcedureStore.ProcedureIterator procIter) throws IOException {
                    loader.load(procIter);
                }

                @Override
                public void handleCorrupted(ProcedureStore.ProcedureIterator procIter) throws IOException {
                    loader.handleCorrupted(procIter);
                }

                @Override
                public void markCorruptedWAL(ProcedureWALFile log, IOException e) {
                    if (WALProcedureStore.this.corruptedLogs == null) {
                        WALProcedureStore.this.corruptedLogs = new HashSet();
                    }
                    WALProcedureStore.this.corruptedLogs.add(log);
                }
            });
            this.loading.set(false);
            this.buildHoldingCleanupTracker();
            this.tryCleanupLogsOnLoad();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void tryCleanupLogsOnLoad() {
        if (this.logs.size() <= 1) {
            return;
        }
        if (!this.conf.getBoolean(EXEC_WAL_CLEANUP_ON_LOAD_CONF_KEY, true)) {
            LOG.debug("WALs cleanup on load is not enabled: " + this.getActiveLogs());
            return;
        }
        try {
            this.periodicRoll();
        }
        catch (IOException e) {
            LOG.warn("Unable to cleanup logs on load: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void insert(Procedure<?> proc, Procedure<?>[] subprocs) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Insert " + proc + ", subproc=" + Arrays.toString(subprocs));
        }
        ByteSlot slot = this.acquireSlot();
        try {
            long[] subProcIds = null;
            if (subprocs != null) {
                ProcedureWALFormat.writeInsert(slot, proc, subprocs);
                subProcIds = new long[subprocs.length];
                for (int i = 0; i < subprocs.length; ++i) {
                    subProcIds[i] = subprocs[i].getProcId();
                }
            } else {
                assert (!proc.hasParent());
                ProcedureWALFormat.writeInsert(slot, proc);
            }
            this.pushData(PushType.INSERT, slot, proc.getProcId(), subProcIds);
        }
        catch (IOException e) {
            LOG.error(HBaseMarkers.FATAL, "Unable to serialize one of the procedure: proc=" + proc + ", subprocs=" + Arrays.toString(subprocs), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.releaseSlot(slot);
        }
    }

    @Override
    public void insert(Procedure<?>[] procs) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Insert " + Arrays.toString(procs));
        }
        ByteSlot slot = this.acquireSlot();
        try {
            long[] procIds = new long[procs.length];
            for (int i = 0; i < procs.length; ++i) {
                assert (!procs[i].hasParent());
                procIds[i] = procs[i].getProcId();
                ProcedureWALFormat.writeInsert(slot, procs[i]);
            }
            this.pushData(PushType.INSERT, slot, -1L, procIds);
        }
        catch (IOException e) {
            LOG.error(HBaseMarkers.FATAL, "Unable to serialize one of the procedure: " + Arrays.toString(procs), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.releaseSlot(slot);
        }
    }

    @Override
    public void update(Procedure<?> proc) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Update " + proc);
        }
        ByteSlot slot = this.acquireSlot();
        try {
            ProcedureWALFormat.writeUpdate(slot, proc);
            this.pushData(PushType.UPDATE, slot, proc.getProcId(), null);
        }
        catch (IOException e) {
            LOG.error(HBaseMarkers.FATAL, "Unable to serialize the procedure: " + proc, (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.releaseSlot(slot);
        }
    }

    @Override
    public void delete(long procId) {
        LOG.trace("Delete {}", (Object)procId);
        ByteSlot slot = this.acquireSlot();
        try {
            ProcedureWALFormat.writeDelete(slot, procId);
            this.pushData(PushType.DELETE, slot, procId, null);
        }
        catch (IOException e) {
            LOG.error(HBaseMarkers.FATAL, "Unable to serialize the procedure: " + procId, (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.releaseSlot(slot);
        }
    }

    @Override
    public void delete(Procedure<?> proc, long[] subProcIds) {
        assert (proc != null) : "expected a non-null procedure";
        assert (subProcIds != null && subProcIds.length > 0) : "expected subProcIds";
        if (LOG.isTraceEnabled()) {
            LOG.trace("Update " + proc + " and Delete " + Arrays.toString(subProcIds));
        }
        ByteSlot slot = this.acquireSlot();
        try {
            ProcedureWALFormat.writeDelete(slot, proc, subProcIds);
            this.pushData(PushType.DELETE, slot, proc.getProcId(), subProcIds);
        }
        catch (IOException e) {
            LOG.error(HBaseMarkers.FATAL, "Unable to serialize the procedure: " + proc, (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.releaseSlot(slot);
        }
    }

    @Override
    public void delete(long[] procIds, int offset, int count) {
        if (count == 0) {
            return;
        }
        if (offset == 0 && count == procIds.length) {
            this.delete(procIds);
        } else if (count == 1) {
            this.delete(procIds[offset]);
        } else {
            this.delete(Arrays.copyOfRange(procIds, offset, offset + count));
        }
    }

    private void delete(long[] procIds) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Delete " + Arrays.toString(procIds));
        }
        ByteSlot slot = this.acquireSlot();
        try {
            for (int i = 0; i < procIds.length; ++i) {
                ProcedureWALFormat.writeDelete(slot, procIds[i]);
            }
            this.pushData(PushType.DELETE, slot, -1L, procIds);
        }
        catch (IOException e) {
            LOG.error("Unable to serialize the procedures: " + Arrays.toString(procIds), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.releaseSlot(slot);
        }
    }

    private ByteSlot acquireSlot() {
        ByteSlot slot = this.slotsCache.poll();
        return slot != null ? slot : new ByteSlot();
    }

    private void releaseSlot(ByteSlot slot) {
        slot.reset();
        this.slotsCache.offer(slot);
    }

    private long pushData(PushType type, ByteSlot slot, long procId, long[] subProcIds) {
        if (!this.isRunning()) {
            throw new RuntimeException("the store must be running before inserting data");
        }
        if (this.logs.isEmpty()) {
            throw new RuntimeException("recoverLease() must be called before inserting data");
        }
        long logId = -1L;
        this.lock.lock();
        try {
            while (true) {
                if (!this.isRunning()) {
                    throw new RuntimeException("store no longer running");
                }
                if (this.isSyncAborted()) {
                    throw new RuntimeException("sync aborted", this.syncException.get());
                }
                if (this.inSync.get()) {
                    this.syncCond.await();
                    continue;
                }
                if (this.slotIndex < this.syncMaxSlot) break;
                this.slotCond.signal();
                this.syncCond.await();
            }
            long pushSyncId = this.syncId.get();
            this.updateStoreTracker(type, procId, subProcIds);
            this.slots[this.slotIndex++] = slot;
            logId = this.flushLogId;
            if (this.slotIndex == 1) {
                this.waitCond.signal();
            }
            if (this.slotIndex == this.syncMaxSlot) {
                this.waitCond.signal();
                this.slotCond.signal();
            }
            while (pushSyncId == this.syncId.get() && this.isRunning()) {
                this.syncCond.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.sendAbortProcessSignal();
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
            if (this.isSyncAborted()) {
                throw new RuntimeException("sync aborted", this.syncException.get());
            }
        }
        return logId;
    }

    private void updateStoreTracker(PushType type, long procId, long[] subProcIds) {
        switch (type) {
            case INSERT: {
                if (subProcIds == null) {
                    this.storeTracker.insert(procId);
                    break;
                }
                if (procId == -1L) {
                    this.storeTracker.insert(subProcIds);
                    break;
                }
                this.storeTracker.insert(procId, subProcIds);
                this.holdingCleanupTracker.setDeletedIfModified(procId);
                break;
            }
            case UPDATE: {
                this.storeTracker.update(procId);
                this.holdingCleanupTracker.setDeletedIfModified(procId);
                break;
            }
            case DELETE: {
                if (subProcIds != null && subProcIds.length > 0) {
                    this.storeTracker.delete(subProcIds);
                    this.holdingCleanupTracker.setDeletedIfModified(subProcIds);
                    break;
                }
                this.storeTracker.delete(procId);
                this.holdingCleanupTracker.setDeletedIfModified(procId);
                break;
            }
            default: {
                throw new RuntimeException("invalid push type " + (Object)((Object)type));
            }
        }
    }

    private boolean isSyncAborted() {
        return this.syncException.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncLoop() throws Throwable {
        long totalSyncedToStore = 0L;
        this.inSync.set(false);
        this.lock.lock();
        try {
            while (this.isRunning()) {
                try {
                    if (this.slotIndex == 0) {
                        if (!this.loading.get()) {
                            this.periodicRoll();
                        }
                        if (LOG.isTraceEnabled()) {
                            float rollTsSec = (float)this.getMillisFromLastRoll() / 1000.0f;
                            LOG.trace(String.format("Waiting for data. flushed=%s (%s/sec)", StringUtils.humanSize(this.totalSynced.get()), StringUtils.humanSize((float)this.totalSynced.get() / rollTsSec)));
                        }
                        this.waitCond.await(this.getMillisToNextPeriodicRoll(), TimeUnit.MILLISECONDS);
                        if (this.slotIndex == 0) continue;
                    }
                    this.syncMaxSlot = this.runningProcCount;
                    assert (this.syncMaxSlot > 0) : "unexpected syncMaxSlot=" + this.syncMaxSlot;
                    long syncWaitSt = System.currentTimeMillis();
                    if (this.slotIndex != this.syncMaxSlot) {
                        this.slotCond.await(this.syncWaitMsec, TimeUnit.MILLISECONDS);
                    }
                    long currentTs = System.currentTimeMillis();
                    long syncWaitMs = currentTs - syncWaitSt;
                    float rollSec = (float)this.getMillisFromLastRoll() / 1000.0f;
                    float syncedPerSec = (float)totalSyncedToStore / rollSec;
                    if (LOG.isTraceEnabled() && (syncWaitMs > 10L || this.slotIndex < this.syncMaxSlot)) {
                        LOG.trace(String.format("Sync wait %s, slotIndex=%s , totalSynced=%s (%s/sec)", StringUtils.humanTimeDiff(syncWaitMs), this.slotIndex, StringUtils.humanSize(totalSyncedToStore), StringUtils.humanSize(syncedPerSec)));
                    }
                    SyncMetrics syncMetrics = new SyncMetrics();
                    syncMetrics.timestamp = currentTs;
                    syncMetrics.syncWaitMs = syncWaitMs;
                    syncMetrics.syncedEntries = this.slotIndex;
                    syncMetrics.totalSyncedBytes = totalSyncedToStore;
                    syncMetrics.syncedPerSec = syncedPerSec;
                    this.syncMetricsQueue.add(syncMetrics);
                    this.inSync.set(true);
                    long slotSize = this.syncSlots();
                    this.logs.getLast().addToSize(slotSize);
                    totalSyncedToStore = this.totalSynced.addAndGet(slotSize);
                    this.slotIndex = 0;
                    this.inSync.set(false);
                    this.syncId.incrementAndGet();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.syncException.compareAndSet(null, e);
                    this.sendAbortProcessSignal();
                    throw e;
                }
                catch (Throwable t) {
                    this.syncException.compareAndSet(null, t);
                    this.sendAbortProcessSignal();
                    throw t;
                }
                finally {
                    this.syncCond.signalAll();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public ArrayList<SyncMetrics> getSyncMetrics() {
        this.lock.lock();
        try {
            ArrayList<SyncMetrics> arrayList = new ArrayList<SyncMetrics>(this.syncMetricsQueue);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    private long syncSlots() throws Throwable {
        int retry = 0;
        int logRolled = 0;
        long totalSynced = 0L;
        while (true) {
            try {
                totalSynced = this.syncSlots(this.stream, this.slots, 0, this.slotIndex);
            }
            catch (Throwable e) {
                LOG.warn("unable to sync slots, retry=" + retry);
                if (++retry < this.maxRetriesBeforeRoll) continue;
                if (logRolled >= this.maxSyncFailureRoll && this.isRunning()) {
                    LOG.error("Sync slots after log roll failed, abort.", e);
                    throw e;
                }
                if (!this.rollWriterWithRetries()) {
                    throw e;
                }
                ++logRolled;
                retry = 0;
                if (this.isRunning()) continue;
            }
            break;
        }
        return totalSynced;
    }

    protected long syncSlots(FSDataOutputStream stream, ByteSlot[] slots, int offset, int count) throws IOException {
        long totalSynced = 0L;
        for (int i = 0; i < count; ++i) {
            ByteSlot data = slots[offset + i];
            data.writeTo((OutputStream)stream);
            totalSynced += (long)data.size();
        }
        this.syncStream(stream);
        this.sendPostSyncSignal();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sync slots=" + count + '/' + this.syncMaxSlot + ", flushed=" + StringUtils.humanSize(totalSynced));
        }
        return totalSynced;
    }

    protected void syncStream(FSDataOutputStream stream) throws IOException {
        if (this.useHsync) {
            stream.hsync();
        } else {
            stream.hflush();
        }
    }

    private boolean rollWriterWithRetries() {
        for (int i = 0; i < this.rollRetries && this.isRunning(); ++i) {
            if (i > 0) {
                Threads.sleepWithoutInterrupt(this.waitBeforeRoll * i);
            }
            try {
                if (!this.rollWriter()) continue;
                return true;
            }
            catch (IOException e) {
                LOG.warn("Unable to roll the log, attempt=" + (i + 1), (Throwable)e);
            }
        }
        LOG.error(HBaseMarkers.FATAL, "Unable to roll the log");
        return false;
    }

    private boolean tryRollWriter() {
        try {
            return this.rollWriter();
        }
        catch (IOException e) {
            LOG.warn("Unable to roll the log", (Throwable)e);
            return false;
        }
    }

    public long getMillisToNextPeriodicRoll() {
        if (this.lastRollTs.get() > 0L && this.periodicRollMsec > 0) {
            return (long)this.periodicRollMsec - this.getMillisFromLastRoll();
        }
        return Long.MAX_VALUE;
    }

    public long getMillisFromLastRoll() {
        return System.currentTimeMillis() - this.lastRollTs.get();
    }

    void periodicRollForTesting() throws IOException {
        this.lock.lock();
        try {
            this.periodicRoll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean rollWriterForTesting() throws IOException {
        this.lock.lock();
        try {
            boolean bl = this.rollWriter();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    void removeInactiveLogsForTesting() throws Exception {
        this.lock.lock();
        try {
            this.removeInactiveLogs();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void periodicRoll() throws IOException {
        if (this.storeTracker.isEmpty()) {
            LOG.trace("no active procedures");
            this.tryRollWriter();
            this.removeAllLogs(this.flushLogId - 1L, "no active procedures");
        } else {
            if (this.storeTracker.isAllModified()) {
                LOG.trace("all the active procedures are in the latest log");
                this.removeAllLogs(this.flushLogId - 1L, "all the active procedures are in the latest log");
            }
            if (this.totalSynced.get() > this.rollThreshold || this.getMillisToNextPeriodicRoll() <= 0L) {
                this.tryRollWriter();
            }
            this.removeInactiveLogs();
        }
    }

    private boolean rollWriter() throws IOException {
        if (!this.isRunning()) {
            return false;
        }
        if (!this.rollWriter(this.flushLogId + 1L)) {
            LOG.warn("someone else has already created log {}", (Object)this.flushLogId);
            return false;
        }
        if (WALProcedureStore.getMaxLogId(this.getLogFiles()) > this.flushLogId) {
            LOG.warn("Someone else created new logs. Expected maxLogId < {}", (Object)this.flushLogId);
            this.logs.getLast().removeFile(this.walArchiveDir);
            return false;
        }
        return true;
    }

    boolean rollWriter(long logId) throws IOException {
        String durability;
        assert (logId > this.flushLogId) : "logId=" + logId + " flushLogId=" + this.flushLogId;
        assert (this.lock.isHeldByCurrentThread()) : "expected to be the lock owner. " + this.lock.isLocked();
        ProcedureProtos.ProcedureWALHeader header = ProcedureProtos.ProcedureWALHeader.newBuilder().setVersion(1).setType(0).setMinProcId(this.storeTracker.getActiveMinProcId()).setLogId(logId).build();
        FSDataOutputStream newStream = null;
        Path newLogFile = null;
        long startPos = -1L;
        newLogFile = this.getLogFilePath(logId);
        try {
            newStream = CommonFSUtils.createForWal(this.fs, newLogFile, false);
        }
        catch (FileAlreadyExistsException e) {
            LOG.error("Log file with id={} already exists", (Object)logId, (Object)e);
            return false;
        }
        catch (RemoteException re) {
            LOG.warn("failed to create log file with id={}", (Object)logId, (Object)re);
            return false;
        }
        String string = durability = this.useHsync ? "hsync" : "hflush";
        if (this.enforceStreamCapability && !newStream.hasCapability(durability)) {
            throw new IllegalStateException("The procedure WAL relies on the ability to " + durability + " for proper operation during component failures, but the underlying filesystem does not support doing so. Please check the config value of '" + USE_HSYNC_CONF_KEY + "' to set the desired level of robustness and ensure the config value of '" + "hbase.wal.dir" + "' points to a FileSystem mount that can provide it.");
        }
        try {
            ProcedureWALFormat.writeHeader((OutputStream)newStream, header);
            startPos = newStream.getPos();
        }
        catch (IOException ioe) {
            LOG.warn("Encountered exception writing header", (Throwable)ioe);
            newStream.close();
            return false;
        }
        this.closeCurrentLogStream(false);
        this.storeTracker.resetModified();
        this.stream = newStream;
        this.flushLogId = logId;
        this.totalSynced.set(0L);
        long rollTs = System.currentTimeMillis();
        this.lastRollTs.set(rollTs);
        this.logs.add(new ProcedureWALFile(this.fs, newLogFile, header, startPos, rollTs));
        if (this.logs.size() == 2) {
            this.buildHoldingCleanupTracker();
        } else if (this.logs.size() > this.walCountWarnThreshold) {
            LOG.warn("procedure WALs count={} above the warning threshold {}. check running procedures to see if something is stuck.", (Object)this.logs.size(), (Object)this.walCountWarnThreshold);
            this.sendForceUpdateSignal(this.holdingCleanupTracker.getAllActiveProcIds());
        }
        LOG.info("Rolled new Procedure Store WAL, id={}", (Object)logId);
        return true;
    }

    private void closeCurrentLogStream(boolean abort) {
        if (this.stream == null || this.logs.isEmpty()) {
            return;
        }
        try {
            ProcedureWALFile log = this.logs.getLast();
            if (!this.loading.get()) {
                log.setProcIds(this.storeTracker.getModifiedMinProcId(), this.storeTracker.getModifiedMaxProcId());
                log.updateLocalTracker(this.storeTracker);
                if (!abort) {
                    long trailerSize = ProcedureWALFormat.writeTrailer(this.stream, this.storeTracker);
                    log.addToSize(trailerSize);
                }
            }
        }
        catch (IOException | FSError e) {
            LOG.warn("Unable to write the trailer", e);
        }
        try {
            this.stream.close();
        }
        catch (IOException | FSError e) {
            LOG.error("Unable to close the stream", e);
        }
        this.stream = null;
    }

    private void removeInactiveLogs() throws IOException {
        while (this.logs.size() > 1 && this.holdingCleanupTracker.isEmpty()) {
            LOG.info("Remove the oldest log {}", (Object)this.logs.getFirst());
            this.removeLogFile(this.logs.getFirst(), this.walArchiveDir);
            this.buildHoldingCleanupTracker();
        }
    }

    private void buildHoldingCleanupTracker() {
        if (this.logs.size() <= 1) {
            this.holdingCleanupTracker.reset();
            return;
        }
        this.holdingCleanupTracker.resetTo(this.logs.getFirst().getTracker(), true);
        this.holdingCleanupTracker.setDeletedIfDeletedByThem(this.storeTracker);
        Iterator iter = this.logs.iterator();
        iter.next();
        ProcedureStoreTracker tracker = ((ProcedureWALFile)iter.next()).getTracker();
        while (iter.hasNext()) {
            this.holdingCleanupTracker.setDeletedIfModifiedInBoth(tracker);
            if (this.holdingCleanupTracker.isEmpty()) break;
            tracker = ((ProcedureWALFile)iter.next()).getTracker();
        }
    }

    private void removeAllLogs(long lastLogId, String why) {
        ProcedureWALFile log;
        if (this.logs.size() <= 1) {
            return;
        }
        LOG.info("Remove all state logs with ID less than {}, since {}", (Object)lastLogId, (Object)why);
        boolean removed = false;
        while (this.logs.size() > 1 && lastLogId >= (log = this.logs.getFirst()).getLogId()) {
            this.removeLogFile(log, this.walArchiveDir);
            removed = true;
        }
        if (removed) {
            this.buildHoldingCleanupTracker();
        }
    }

    private boolean removeLogFile(ProcedureWALFile log, Path walArchiveDir) {
        try {
            LOG.trace("Removing log={}", (Object)log);
            log.removeFile(walArchiveDir);
            this.logs.remove(log);
            LOG.debug("Removed log={}, activeLogs={}", (Object)log, this.logs);
            assert (this.logs.size() > 0) : "expected at least one log";
        }
        catch (IOException e) {
            LOG.error("Unable to remove log: " + log, (Throwable)e);
            return false;
        }
        return true;
    }

    public Path getWALDir() {
        return this.walDir;
    }

    Path getWalArchiveDir() {
        return this.walArchiveDir;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    protected Path getLogFilePath(long logId) throws IOException {
        return new Path(this.walDir, String.format("pv2-%020d.log", logId));
    }

    private static long getLogIdFromName(String name) {
        int end = name.lastIndexOf(".log");
        int start = name.lastIndexOf(45) + 1;
        return Long.parseLong(name.substring(start, end));
    }

    private FileStatus[] getLogFiles() throws IOException {
        try {
            FileStatus[] files = this.fs.listStatus(this.walDir, WALS_PATH_FILTER);
            Arrays.sort(files, FILE_STATUS_ID_COMPARATOR);
            return files;
        }
        catch (FileNotFoundException e) {
            LOG.warn("Log directory not found: " + e.getMessage());
            return null;
        }
    }

    private static long getMaxLogId(FileStatus[] logFiles) {
        if (logFiles == null || logFiles.length == 0) {
            return 0L;
        }
        return WALProcedureStore.getLogIdFromName(logFiles[logFiles.length - 1].getPath().getName());
    }

    private long initOldLogs(FileStatus[] logFiles) throws IOException {
        if (logFiles == null || logFiles.length == 0) {
            return 0L;
        }
        long maxLogId = 0L;
        for (int i = 0; i < logFiles.length; ++i) {
            Path logPath = logFiles[i].getPath();
            this.leaseRecovery.recoverFileLease(this.fs, logPath);
            if (!this.isRunning()) {
                throw new IOException("wal aborting");
            }
            maxLogId = Math.max(maxLogId, WALProcedureStore.getLogIdFromName(logPath.getName()));
            ProcedureWALFile log = this.initOldLog(logFiles[i], this.walArchiveDir);
            if (log == null) continue;
            this.logs.add(log);
        }
        this.initTrackerFromOldLogs();
        return maxLogId;
    }

    private void initTrackerFromOldLogs() {
        if (this.logs.isEmpty() || !this.isRunning()) {
            return;
        }
        ProcedureWALFile log = this.logs.getLast();
        if (!log.getTracker().isPartial()) {
            this.storeTracker.resetTo(log.getTracker());
        } else {
            this.storeTracker.reset();
            this.storeTracker.setPartialFlag(true);
        }
    }

    private ProcedureWALFile initOldLog(FileStatus logFile, Path walArchiveDir) throws IOException {
        ProcedureWALFile log = new ProcedureWALFile(this.fs, logFile);
        if (logFile.getLen() == 0L) {
            LOG.warn("Remove uninitialized log: {}", (Object)logFile);
            log.removeFile(walArchiveDir);
            return null;
        }
        LOG.debug("Opening Pv2 {}", (Object)logFile);
        try {
            log.open();
        }
        catch (ProcedureWALFormat.InvalidWALDataException e) {
            LOG.warn("Remove uninitialized log: {}", (Object)logFile, (Object)e);
            log.removeFile(walArchiveDir);
            return null;
        }
        catch (IOException e) {
            String msg = "Unable to read state log: " + logFile;
            LOG.error(msg, (Throwable)e);
            throw new IOException(msg, e);
        }
        try {
            log.readTracker();
        }
        catch (IOException e) {
            log.getTracker().reset();
            log.getTracker().setPartialFlag(true);
            LOG.warn("Unable to read tracker for {}", (Object)log, (Object)e);
        }
        log.close();
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args2) throws IOException {
        Configuration conf = HBaseConfiguration.create();
        if (args2 == null || args2.length != 1) {
            System.out.println("ERROR: Empty arguments list; pass path to MASTERPROCWALS_DIR.");
            System.out.println("Usage: WALProcedureStore MASTERPROCWALS_DIR");
            System.exit(-1);
        }
        WALProcedureStore store = new WALProcedureStore(conf, new Path(args2[0]), null, new LeaseRecovery(){

            @Override
            public void recoverFileLease(FileSystem fs, Path path) throws IOException {
            }
        });
        try {
            store.start(16);
            ProcedureExecutor<Object> pe = new ProcedureExecutor<Object>(conf, new Object(), store);
            pe.init(1, true);
        }
        finally {
            store.stop(true);
        }
    }

    private static enum PushType {
        INSERT,
        UPDATE,
        DELETE;

    }

    public static class SyncMetrics {
        private long timestamp;
        private long syncWaitMs;
        private long totalSyncedBytes;
        private int syncedEntries;
        private float syncedPerSec;

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getSyncWaitMs() {
            return this.syncWaitMs;
        }

        public long getTotalSyncedBytes() {
            return this.totalSyncedBytes;
        }

        public long getSyncedEntries() {
            return this.syncedEntries;
        }

        public float getSyncedPerSec() {
            return this.syncedPerSec;
        }
    }
}

