/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureWALFile;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureWALFormat;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.hbase.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Options;
import org.apache.hbase.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@Deprecated
@InterfaceAudience.LimitedPrivate(value={"Tools"})
@InterfaceStability.Evolving
public class ProcedureWALPrettyPrinter
extends Configured
implements Tool {
    private final PrintStream out = System.out;

    public void processFile(Configuration conf, Path p) throws IOException {
        FileSystem fs = p.getFileSystem(conf);
        if (!fs.exists(p)) {
            System.err.println("ERROR, file doesnt exist: " + p);
            return;
        }
        if (!fs.isFile(p)) {
            System.err.println(p + " is not a file");
            return;
        }
        FileStatus logFile = fs.getFileStatus(p);
        if (logFile.getLen() == 0L) {
            this.out.println("Zero length file: " + p);
            return;
        }
        this.out.println("Opening procedure state-log: " + p);
        ProcedureWALFile log = new ProcedureWALFile(fs, logFile);
        this.processProcedureWALFile(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processProcedureWALFile(ProcedureWALFile log) throws IOException {
        log.open();
        ProcedureProtos.ProcedureWALHeader header = log.getHeader();
        this.printHeader(header);
        FSDataInputStream stream = log.getStream();
        try {
            boolean hasMore = true;
            block8: while (hasMore) {
                ProcedureProtos.ProcedureWALEntry entry = ProcedureWALFormat.readEntry((InputStream)stream);
                if (entry == null) {
                    this.out.println("No more entry, exiting with missing EOF");
                    hasMore = false;
                    break;
                }
                switch (entry.getType()) {
                    case PROCEDURE_WAL_EOF: {
                        hasMore = false;
                        continue block8;
                    }
                }
                this.printEntry(entry);
            }
        }
        catch (IOException e) {
            this.out.println("got an exception while reading the procedure WAL " + e.getMessage());
        }
        finally {
            log.close();
        }
    }

    private void printEntry(ProcedureProtos.ProcedureWALEntry entry) throws IOException {
        this.out.println("EntryType=" + entry.getType());
        int procCount = entry.getProcedureCount();
        for (int i = 0; i < procCount; ++i) {
            Procedure<?> proc = ProcedureUtil.convertToProcedure(entry.getProcedure(i));
            this.printProcedure(proc);
        }
    }

    private void printProcedure(Procedure<?> proc) {
        this.out.println(proc.toStringDetails());
    }

    private void printHeader(ProcedureProtos.ProcedureWALHeader header) {
        this.out.println("ProcedureWALHeader: ");
        this.out.println("  Version: " + header.getVersion());
        this.out.println("  Type: " + header.getType());
        this.out.println("  LogId: " + header.getLogId());
        this.out.println("  MinProcId: " + header.getMinProcId());
        this.out.println();
    }

    public int run(String[] args2) throws IOException {
        Options options = new Options();
        options.addOption("h", "help", false, "Output help message");
        options.addOption("f", "file", true, "File to print");
        ArrayList<Path> files = new ArrayList<Path>();
        try {
            CommandLine cmd = new DefaultParser().parse(options, args2);
            if (cmd.hasOption("f")) {
                files.add(new Path(cmd.getOptionValue("f")));
            }
            if (files.isEmpty() || cmd.hasOption("h")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("ProcedureWALPrettyPrinter ", options, true);
                return -1;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("ProcedureWALPrettyPrinter ", options, true);
            return -1;
        }
        for (Path file : files) {
            this.processFile(this.getConf(), file);
        }
        return 0;
    }

    public static void main(String[] args2) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int exitCode = ToolRunner.run((Configuration)conf, (Tool)new ProcedureWALPrettyPrinter(), (String[])args2);
        System.exit(exitCode);
    }
}

