/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionListener;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.errorhandling.TimeoutExceptionInjector;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureMember;
import org.apache.hadoop.hbase.procedure.ProcedureMemberRpcs;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class Subprocedure
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(Subprocedure.class);
    private final String barrierName;
    private final CountDownLatch inGlobalBarrier;
    private final CountDownLatch releasedLocalBarrier;
    protected final ForeignExceptionDispatcher monitor;
    protected final long wakeFrequency;
    protected final TimeoutExceptionInjector executionTimeoutTimer;
    protected final ProcedureMemberRpcs rpcs;
    private volatile boolean complete = false;

    public Subprocedure(ProcedureMember member, String procName, ForeignExceptionDispatcher monitor, long wakeFrequency, long timeout2) {
        assert (member != null) : "procedure member should be non-null";
        assert (member.getRpcs() != null) : "rpc handlers should be non-null";
        assert (procName != null) : "procedure name should be non-null";
        assert (monitor != null) : "monitor should be non-null";
        this.rpcs = member.getRpcs();
        this.barrierName = procName;
        this.monitor = monitor;
        this.monitor.addListener(new ForeignExceptionListener(){

            @Override
            public void receive(ForeignException ee) {
                if (ee.isRemote()) {
                    LOG.debug("Was remote foreign exception, not redispatching error", (Throwable)ee);
                    return;
                }
                if (ee.getCause() instanceof KeeperException) {
                    LOG.debug("Was KeeperException, not redispatching error", (Throwable)ee);
                    return;
                }
                try {
                    Subprocedure.this.rpcs.sendMemberAborted(Subprocedure.this, ee);
                }
                catch (IOException e) {
                    LOG.error("Can't reach controller, not propagating error", (Throwable)e);
                }
            }
        });
        this.wakeFrequency = wakeFrequency;
        this.inGlobalBarrier = new CountDownLatch(1);
        this.releasedLocalBarrier = new CountDownLatch(1);
        this.executionTimeoutTimer = new TimeoutExceptionInjector(monitor, timeout2);
    }

    public String getName() {
        return this.barrierName;
    }

    public String getMemberName() {
        return this.rpcs.getMemberName();
    }

    private void rethrowException() throws ForeignException {
        this.monitor.rethrowException();
    }

    @Override
    public final Void call() {
        LOG.debug("Starting subprocedure '" + this.barrierName + "' with timeout " + this.executionTimeoutTimer.getMaxTime() + "ms");
        this.executionTimeoutTimer.start();
        try {
            this.rethrowException();
            LOG.debug("Subprocedure '" + this.barrierName + "' starting 'acquire' stage");
            this.acquireBarrier();
            LOG.debug("Subprocedure '" + this.barrierName + "' locally acquired");
            this.rethrowException();
            this.rpcs.sendMemberAcquired(this);
            LOG.debug("Subprocedure '" + this.barrierName + "' coordinator notified of 'acquire', waiting on 'reached' or 'abort' from coordinator");
            this.waitForReachedGlobalBarrier();
            this.rethrowException();
            LOG.debug("Subprocedure '" + this.barrierName + "' received 'reached' from coordinator.");
            byte[] dataToCoordinator = this.insideBarrier();
            LOG.debug("Subprocedure '" + this.barrierName + "' locally completed");
            this.rethrowException();
            this.rpcs.sendMemberCompleted(this, dataToCoordinator);
            LOG.debug("Subprocedure '" + this.barrierName + "' has notified controller of completion");
            this.rethrowException();
        }
        catch (Exception e) {
            String msg = null;
            if (e instanceof InterruptedException) {
                msg = "Procedure '" + this.barrierName + "' aborting due to interrupt! Likely due to pool shutdown.";
                Thread.currentThread().interrupt();
            } else {
                msg = e instanceof ForeignException ? "Subprocedure '" + this.barrierName + "' aborting due to a ForeignException!" : "Subprocedure '" + this.barrierName + "' failed!";
            }
            this.cancel(msg, e);
            LOG.debug("Subprocedure '" + this.barrierName + "' running cleanup.");
            this.cleanup(e);
        }
        finally {
            this.releasedLocalBarrier.countDown();
            this.executionTimeoutTimer.complete();
            this.complete = true;
            LOG.debug("Subprocedure '" + this.barrierName + "' completed.");
            return null;
        }
    }

    boolean isComplete() {
        return this.complete;
    }

    ForeignExceptionSnare getErrorCheckable() {
        return this.monitor;
    }

    public abstract void acquireBarrier() throws ForeignException;

    public abstract byte[] insideBarrier() throws ForeignException;

    public abstract void cleanup(Exception var1);

    public void cancel(String msg, Throwable cause) {
        LOG.error(msg, cause);
        this.complete = true;
        if (cause instanceof ForeignException) {
            this.monitor.receive((ForeignException)cause);
        } else {
            this.monitor.receive(new ForeignException(this.getMemberName(), cause));
        }
    }

    public void receiveReachedGlobalBarrier() {
        this.inGlobalBarrier.countDown();
    }

    void waitForReachedGlobalBarrier() throws ForeignException, InterruptedException {
        Procedure.waitForLatch(this.inGlobalBarrier, this.monitor, this.wakeFrequency, this.barrierName + ":remote acquired");
    }

    public void waitForLocallyCompleted() throws ForeignException, InterruptedException {
        Procedure.waitForLatch(this.releasedLocalBarrier, this.monitor, this.wakeFrequency, this.barrierName + ":completed");
    }

    public static class SubprocedureImpl
    extends Subprocedure {
        public SubprocedureImpl(ProcedureMember member, String opName, ForeignExceptionDispatcher monitor, long wakeFrequency, long timeout2) {
            super(member, opName, monitor, wakeFrequency, timeout2);
        }

        @Override
        public void acquireBarrier() throws ForeignException {
        }

        @Override
        public byte[] insideBarrier() throws ForeignException {
            return new byte[0];
        }

        @Override
        public void cleanup(Exception e) {
        }
    }
}

