/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.master.cleaner.CleanerChore;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class DirScanPool
implements ConfigurationObserver {
    private static final Logger LOG = LoggerFactory.getLogger(DirScanPool.class);
    private volatile int size;
    private final ThreadPoolExecutor pool;
    private int cleanerLatch;
    private boolean reconfigNotification;
    private Type dirScanPoolType;
    private final String name;

    private DirScanPool(Configuration conf, Type dirScanPoolType) {
        this.dirScanPoolType = dirScanPoolType;
        this.name = dirScanPoolType.name().toLowerCase();
        String poolSize = conf.get(dirScanPoolType.cleanerPoolSizeConfigName, dirScanPoolType.cleanerPoolSizeConfigDefault);
        this.size = CleanerChore.calculatePoolSize(poolSize);
        this.size = this.size == 0 ? CleanerChore.calculatePoolSize(dirScanPoolType.cleanerPoolSizeConfigDefault) : this.size;
        this.pool = DirScanPool.initializePool(this.size, this.name);
        LOG.info("{} Cleaner pool size is {}", (Object)this.name, (Object)this.size);
        this.cleanerLatch = 0;
    }

    private static ThreadPoolExecutor initializePool(int size, String name) {
        return Threads.getBoundedCachedThreadPool(size, 1L, TimeUnit.MINUTES, new ThreadFactoryBuilder().setNameFormat(name + "-dir-scan-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build());
    }

    @Override
    public synchronized void onConfigurationChange(Configuration conf) {
        int newSize = CleanerChore.calculatePoolSize(conf.get(this.dirScanPoolType.cleanerPoolSizeConfigName, this.dirScanPoolType.cleanerPoolSizeConfigDefault));
        if (newSize == this.size) {
            LOG.trace("{} Cleaner Size from configuration is same as previous={}, no need to update.", (Object)this.name, (Object)newSize);
            return;
        }
        this.size = newSize;
        this.reconfigNotification = true;
    }

    synchronized void latchCountUp() {
        ++this.cleanerLatch;
    }

    synchronized void latchCountDown() {
        --this.cleanerLatch;
        this.notifyAll();
    }

    synchronized void execute(Runnable runnable2) {
        this.pool.execute(runnable2);
    }

    public synchronized void shutdownNow() {
        if (this.pool == null || this.pool.isShutdown()) {
            return;
        }
        this.pool.shutdownNow();
    }

    synchronized void tryUpdatePoolSize(long timeout2) {
        if (!this.reconfigNotification) {
            return;
        }
        this.reconfigNotification = false;
        long stopTime = System.currentTimeMillis() + timeout2;
        while (this.cleanerLatch != 0 && timeout2 > 0L) {
            try {
                this.wait(timeout2);
                timeout2 = stopTime - System.currentTimeMillis();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        LOG.info("Update {} chore's pool size from {} to {}", new Object[]{this.name, this.pool.getPoolSize(), this.size});
        this.pool.setCorePoolSize(this.size);
    }

    public int getSize() {
        return this.size;
    }

    public static DirScanPool getHFileCleanerScanPool(Configuration conf) {
        return new DirScanPool(conf, Type.HFILE_CLEANER);
    }

    public static DirScanPool getLogCleanerScanPool(Configuration conf) {
        return new DirScanPool(conf, Type.LOG_CLEANER);
    }

    private static enum Type {
        LOG_CLEANER("hbase.log.cleaner.scan.dir.concurrent.size", "1"),
        HFILE_CLEANER("hbase.cleaner.scan.dir.concurrent.size", "0.25");

        private final String cleanerPoolSizeConfigName;
        private final String cleanerPoolSizeConfigDefault;

        private Type(String cleanerPoolSizeConfigName, String cleanerPoolSizeConfigDefault) {
            this.cleanerPoolSizeConfigName = cleanerPoolSizeConfigName;
            this.cleanerPoolSizeConfigDefault = cleanerPoolSizeConfigDefault;
        }
    }
}

