/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.exceptions.IllegalArgumentIOException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.RegionSizeCalculator;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public abstract class TableInputFormatBase
extends InputFormat<ImmutableBytesWritable, Result> {
    private static final Logger LOG = LoggerFactory.getLogger(TableInputFormatBase.class);
    private static final String NOT_INITIALIZED = "The input format instance has not been properly initialized. Ensure you call initializeTable either in your constructor or initialize method";
    private static final String INITIALIZATION_ERROR = "Cannot create a record reader because of a previous error. Please look at the previous logs lines from the task's full log for more details.";
    public static final String MAPREDUCE_INPUT_AUTOBALANCE = "hbase.mapreduce.tif.input.autobalance";
    public static final String MAX_AVERAGE_REGION_SIZE = "hbase.mapreduce.tif.ave.regionsize";
    public static final String NUM_MAPPERS_PER_REGION = "hbase.mapreduce.tableinput.mappers.per.region";
    private Scan scan = null;
    private Admin admin;
    private Table table;
    private RegionLocator regionLocator;
    private TableRecordReader tableRecordReader = null;
    private Connection connection;
    private RegionSizeCalculator regionSizeCalculator;
    private HashMap<InetAddress, String> reverseDNSCacheMap = new HashMap();

    public RecordReader<ImmutableBytesWritable, Result> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        if (this.table == null) {
            this.initialize((JobContext)context);
        }
        try {
            if (this.getTable() == null) {
                throw new IOException(INITIALIZATION_ERROR);
            }
        }
        catch (IllegalStateException exception) {
            throw new IOException(INITIALIZATION_ERROR, exception);
        }
        TableSplit tSplit = (TableSplit)split;
        LOG.info("Input split length: " + StringUtils.humanReadableInt((long)tSplit.getLength()) + " bytes.");
        final TableRecordReader trr = this.tableRecordReader != null ? this.tableRecordReader : new TableRecordReader();
        Scan sc = new Scan(this.scan);
        sc.setStartRow(tSplit.getStartRow());
        sc.setStopRow(tSplit.getEndRow());
        trr.setScan(sc);
        trr.setTable(this.getTable());
        return new RecordReader<ImmutableBytesWritable, Result>(){

            public void close() throws IOException {
                trr.close();
                TableInputFormatBase.this.closeTable();
            }

            public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
                return trr.getCurrentKey();
            }

            public Result getCurrentValue() throws IOException, InterruptedException {
                return trr.getCurrentValue();
            }

            public float getProgress() throws IOException, InterruptedException {
                return trr.getProgress();
            }

            public void initialize(InputSplit inputsplit, TaskAttemptContext context) throws IOException, InterruptedException {
                trr.initialize(inputsplit, context);
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                return trr.nextKeyValue();
            }
        };
    }

    protected Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return this.getRegionLocator().getStartEndKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InputSplit> getSplits(JobContext context) throws IOException {
        boolean closeOnFinish = false;
        if (this.table == null) {
            this.initialize(context);
            closeOnFinish = true;
        }
        try {
            if (this.getTable() == null) {
                throw new IOException(INITIALIZATION_ERROR);
            }
        }
        catch (IllegalStateException exception) {
            throw new IOException(INITIALIZATION_ERROR, exception);
        }
        try {
            List<InputSplit> splits = this.oneInputSplitPerRegion();
            if (context.getConfiguration().get(NUM_MAPPERS_PER_REGION) != null) {
                int nSplitsPerRegion = context.getConfiguration().getInt(NUM_MAPPERS_PER_REGION, 1);
                ArrayList<InputSplit> res = new ArrayList<InputSplit>();
                for (int i = 0; i < splits.size(); ++i) {
                    List<InputSplit> tmp = this.createNInputSplitsUniform(splits.get(i), nSplitsPerRegion);
                    res.addAll(tmp);
                }
                ArrayList<InputSplit> arrayList = res;
                return arrayList;
            }
            if (context.getConfiguration().getBoolean(MAPREDUCE_INPUT_AUTOBALANCE, false)) {
                long maxAveRegionSize = context.getConfiguration().getLong(MAX_AVERAGE_REGION_SIZE, 0x200000000L);
                List<InputSplit> list = this.calculateAutoBalancedSplits(splits, maxAveRegionSize);
                return list;
            }
            List<InputSplit> list = splits;
            return list;
        }
        finally {
            if (closeOnFinish) {
                this.closeTable();
            }
        }
    }

    private List<InputSplit> oneInputSplitPerRegion() throws IOException {
        if (this.regionSizeCalculator == null) {
            this.regionSizeCalculator = this.createRegionSizeCalculator(this.getRegionLocator(), this.getAdmin());
        }
        TableName tableName = this.getTable().getName();
        Pair<byte[][], byte[][]> keys2 = this.getStartEndKeys();
        if (keys2 == null || keys2.getFirst() == null || keys2.getFirst().length == 0) {
            HRegionLocation regLoc = this.getRegionLocator().getRegionLocation(HConstants.EMPTY_BYTE_ARRAY, false);
            if (null == regLoc) {
                throw new IOException("Expecting at least one region.");
            }
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(1);
            long regionSize = this.regionSizeCalculator.getRegionSize(regLoc.getRegion().getRegionName());
            TableSplit split = new TableSplit(tableName, null, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, regLoc.getHostnamePort().split(":")[0], regionSize);
            splits.add(split);
            return splits;
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(keys2.getFirst().length);
        for (int i = 0; i < keys2.getFirst().length; ++i) {
            if (!this.includeRegionInSplit(keys2.getFirst()[i], keys2.getSecond()[i])) continue;
            byte[] startRow = this.scan.getStartRow();
            byte[] stopRow = this.scan.getStopRow();
            if (startRow.length != 0 && keys2.getSecond()[i].length != 0 && Bytes.compareTo(startRow, keys2.getSecond()[i]) >= 0 || stopRow.length != 0 && Bytes.compareTo(stopRow, keys2.getFirst()[i]) <= 0) continue;
            byte[] splitStart = startRow.length == 0 || Bytes.compareTo(keys2.getFirst()[i], startRow) >= 0 ? keys2.getFirst()[i] : startRow;
            byte[] splitStop = (stopRow.length == 0 || Bytes.compareTo(keys2.getSecond()[i], stopRow) <= 0) && keys2.getSecond()[i].length > 0 ? keys2.getSecond()[i] : stopRow;
            HRegionLocation location = this.getRegionLocator().getRegionLocation(keys2.getFirst()[i], false);
            InetSocketAddress isa = new InetSocketAddress(location.getHostname(), location.getPort());
            if (isa.isUnresolved()) {
                LOG.warn("Failed resolve " + isa);
            }
            InetAddress regionAddress = isa.getAddress();
            String regionLocation = this.reverseDNS(regionAddress);
            byte[] regionName = location.getRegion().getRegionName();
            String encodedRegionName = location.getRegion().getEncodedName();
            long regionSize = this.regionSizeCalculator.getRegionSize(regionName);
            TableSplit split = new TableSplit(tableName, null, splitStart, splitStop, regionLocation, encodedRegionName, regionSize);
            splits.add(split);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("getSplits: split -> " + i + " -> " + split);
        }
        return splits;
    }

    protected List<InputSplit> createNInputSplitsUniform(InputSplit split, int n) throws IllegalArgumentIOException {
        if (split == null || !(split instanceof TableSplit)) {
            throw new IllegalArgumentIOException("InputSplit for CreateNSplitsPerRegion can not be null + and should be instance of TableSplit");
        }
        n = n < 1 ? 1 : n;
        ArrayList<InputSplit> res = new ArrayList<InputSplit>(n);
        if (n == 1) {
            res.add(split);
            return res;
        }
        TableSplit ts = (TableSplit)split;
        TableName tableName = ts.getTable();
        String regionLocation = ts.getRegionLocation();
        String encodedRegionName = ts.getEncodedRegionName();
        long regionSize = ts.getLength();
        byte[] startRow = ts.getStartRow();
        byte[] endRow = ts.getEndRow();
        if (startRow.length == 0 && endRow.length == 0) {
            startRow = new byte[1];
            endRow = new byte[1];
            startRow[0] = 0;
            endRow[0] = -1;
        }
        if (startRow.length == 0 && endRow.length != 0) {
            startRow = new byte[]{0};
        }
        if (startRow.length != 0 && endRow.length == 0) {
            endRow = new byte[startRow.length];
            for (int k = 0; k < startRow.length; ++k) {
                endRow[k] = -1;
            }
        }
        byte[][] splitKeys = Bytes.split(startRow, endRow, true, n - 1);
        for (int i = 0; i < splitKeys.length - 1; ++i) {
            TableSplit tsplit = new TableSplit(tableName, null, splitKeys[i], splitKeys[i + 1], regionLocation, encodedRegionName, regionSize / (long)n);
            res.add(tsplit);
        }
        return res;
    }

    public List<InputSplit> calculateAutoBalancedSplits(List<InputSplit> splits, long maxAverageRegionSize) throws IOException {
        if (splits.size() == 0) {
            return splits;
        }
        ArrayList<InputSplit> resultList = new ArrayList<InputSplit>();
        long totalRegionSize = 0L;
        for (int i = 0; i < splits.size(); ++i) {
            TableSplit ts = (TableSplit)splits.get(i);
            totalRegionSize += ts.getLength();
        }
        long averageRegionSize = totalRegionSize / (long)splits.size();
        if (averageRegionSize <= 0L) {
            LOG.warn("The averageRegionSize is not positive: " + averageRegionSize + ", set it to Long.MAX_VALUE " + splits.size());
            averageRegionSize = Long.MAX_VALUE / (long)splits.size();
        }
        if (averageRegionSize > maxAverageRegionSize) {
            averageRegionSize = maxAverageRegionSize;
        }
        if (averageRegionSize < 0x1000000L) {
            return splits;
        }
        for (int i = 0; i < splits.size(); ++i) {
            TableSplit nextRegion;
            long nextRegionSize;
            int j;
            TableSplit ts = (TableSplit)splits.get(i);
            TableName tableName = ts.getTable();
            String regionLocation = ts.getRegionLocation();
            String encodedRegionName = ts.getEncodedRegionName();
            long regionSize = ts.getLength();
            if (regionSize >= averageRegionSize) {
                int n = (int)Math.round(Math.log((double)regionSize / (double)averageRegionSize) + 1.0);
                List<InputSplit> temp = this.createNInputSplitsUniform(ts, n);
                resultList.addAll(temp);
                continue;
            }
            long totalSize = regionSize;
            byte[] splitStartKey = ts.getStartRow();
            byte[] splitEndKey = ts.getEndRow();
            for (j = i + 1; j < splits.size() && totalSize + (nextRegionSize = (nextRegion = (TableSplit)splits.get(j)).getLength()) <= averageRegionSize && Bytes.equals(splitEndKey, nextRegion.getStartRow()); ++j) {
                totalSize += nextRegionSize;
                splitEndKey = nextRegion.getEndRow();
            }
            i = j - 1;
            TableSplit t = new TableSplit(tableName, null, splitStartKey, splitEndKey, regionLocation, encodedRegionName, totalSize);
            resultList.add(t);
        }
        return resultList;
    }

    String reverseDNS(InetAddress ipAddress) throws UnknownHostException {
        String hostName = this.reverseDNSCacheMap.get(ipAddress);
        if (hostName == null) {
            String ipAddressString = null;
            try {
                ipAddressString = DNS.reverseDns((InetAddress)ipAddress, null);
            }
            catch (Exception e) {
                ipAddressString = InetAddress.getByName(ipAddress.getHostAddress()).getHostName();
            }
            if (ipAddressString == null) {
                throw new UnknownHostException("No host found for " + ipAddress);
            }
            hostName = Strings.domainNamePointerToHostName(ipAddressString);
            this.reverseDNSCacheMap.put(ipAddress, hostName);
        }
        return hostName;
    }

    protected boolean includeRegionInSplit(byte[] startKey, byte[] endKey) {
        return true;
    }

    protected RegionLocator getRegionLocator() {
        if (this.regionLocator == null) {
            throw new IllegalStateException(NOT_INITIALIZED);
        }
        return this.regionLocator;
    }

    protected Table getTable() {
        if (this.table == null) {
            throw new IllegalStateException(NOT_INITIALIZED);
        }
        return this.table;
    }

    protected Admin getAdmin() {
        if (this.admin == null) {
            throw new IllegalStateException(NOT_INITIALIZED);
        }
        return this.admin;
    }

    protected void initializeTable(Connection connection, TableName tableName) throws IOException {
        if (this.table != null || this.connection != null) {
            LOG.warn("initializeTable called multiple times. Overwriting connection and table reference; TableInputFormatBase will not close these old references when done.");
        }
        this.table = connection.getTable(tableName);
        this.regionLocator = connection.getRegionLocator(tableName);
        this.admin = connection.getAdmin();
        this.connection = connection;
        this.regionSizeCalculator = null;
    }

    @InterfaceAudience.Private
    protected RegionSizeCalculator createRegionSizeCalculator(RegionLocator locator, Admin admin) throws IOException {
        return new RegionSizeCalculator(locator, admin);
    }

    public Scan getScan() {
        if (this.scan == null) {
            this.scan = new Scan();
        }
        return this.scan;
    }

    public void setScan(Scan scan) {
        this.scan = scan;
    }

    protected void setTableRecordReader(TableRecordReader tableRecordReader) {
        this.tableRecordReader = tableRecordReader;
    }

    protected void initialize(JobContext context) throws IOException {
    }

    protected void closeTable() throws IOException {
        this.close(this.admin, this.table, this.regionLocator, this.connection);
        this.admin = null;
        this.table = null;
        this.regionLocator = null;
        this.connection = null;
        this.regionSizeCalculator = null;
    }

    private void close(Closeable ... closables) throws IOException {
        for (Closeable c : closables) {
            if (c == null) continue;
            c.close();
        }
    }
}

