/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.ExportUtils;
import org.apache.hadoop.hbase.mapreduce.IdentityTableMapper;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hbase.util.Triple;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class Export
extends Configured
implements Tool {
    static final String NAME = "export";
    static final String JOB_NAME_CONF_KEY = "mapreduce.job.name";

    public static Job createSubmittableJob(Configuration conf, String[] args2) throws IOException {
        Triple<TableName, Scan, Path> arguments = ExportUtils.getArgumentsFromCommandLine(conf, args2);
        String tableName = arguments.getFirst().getNameAsString();
        Path outputDir = arguments.getThird();
        Job job = Job.getInstance((Configuration)conf, (String)conf.get(JOB_NAME_CONF_KEY, "export_" + tableName));
        job.setJobName("export_" + tableName);
        job.setJarByClass(Export.class);
        Scan s2 = arguments.getSecond();
        IdentityTableMapper.initJob(tableName, s2, IdentityTableMapper.class, job);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(Result.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
        return job;
    }

    public int run(String[] args2) throws Exception {
        if (!ExportUtils.isValidArguements(args2)) {
            ExportUtils.usage("Wrong number of arguments: " + ArrayUtils.getLength(args2));
            System.err.println("   -D mapreduce.job.name=jobName - use the specified mapreduce job name for the export");
            System.err.println("For MR performance consider the following properties:");
            System.err.println("   -D mapreduce.map.speculative=false");
            System.err.println("   -D mapreduce.reduce.speculative=false");
            return -1;
        }
        Job job = Export.createSubmittableJob(this.getConf(), args2);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args2) throws Exception {
        int errCode = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new Export(), (String[])args2);
        System.exit(errCode);
    }
}

