/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.errorhandling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ErrorHandlingProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ForeignException
extends IOException {
    private final String source;

    public ForeignException(String source2, Throwable cause) {
        super(cause);
        assert (source2 != null);
        assert (cause != null);
        this.source = source2;
    }

    public ForeignException(String source2, String msg) {
        super(new IllegalArgumentException(msg));
        this.source = source2;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isRemote() {
        return this.getCause() instanceof ProxyThrowable;
    }

    @Override
    public String toString() {
        String className = this.getCause().getClass().getName();
        return className + " via " + this.getSource() + ":" + this.getLocalizedMessage();
    }

    private static List<ErrorHandlingProtos.StackTraceElementMessage> toStackTraceElementMessages(StackTraceElement[] trace) {
        if (trace == null) {
            return null;
        }
        ArrayList<ErrorHandlingProtos.StackTraceElementMessage> pbTrace = new ArrayList<ErrorHandlingProtos.StackTraceElementMessage>(trace.length);
        for (StackTraceElement elem : trace) {
            ErrorHandlingProtos.StackTraceElementMessage.Builder stackBuilder = ErrorHandlingProtos.StackTraceElementMessage.newBuilder();
            stackBuilder.setDeclaringClass(elem.getClassName());
            stackBuilder.setFileName(elem.getFileName());
            stackBuilder.setLineNumber(elem.getLineNumber());
            stackBuilder.setMethodName(elem.getMethodName());
            pbTrace.add(stackBuilder.build());
        }
        return pbTrace;
    }

    public static byte[] serialize(String source2, Throwable t) {
        List<ErrorHandlingProtos.StackTraceElementMessage> stack;
        ErrorHandlingProtos.GenericExceptionMessage.Builder gemBuilder = ErrorHandlingProtos.GenericExceptionMessage.newBuilder();
        gemBuilder.setClassName(t.getClass().getName());
        if (t.getMessage() != null) {
            gemBuilder.setMessage(t.getMessage());
        }
        if ((stack = ForeignException.toStackTraceElementMessages(t.getStackTrace())) != null) {
            gemBuilder.addAllTrace(stack);
        }
        ErrorHandlingProtos.GenericExceptionMessage payload = gemBuilder.build();
        ErrorHandlingProtos.ForeignExceptionMessage.Builder exception = ErrorHandlingProtos.ForeignExceptionMessage.newBuilder();
        exception.setGenericException(payload).setSource(source2);
        ErrorHandlingProtos.ForeignExceptionMessage eem = exception.build();
        return eem.toByteArray();
    }

    public static ForeignException deserialize(byte[] bytes) throws IOException {
        ErrorHandlingProtos.ForeignExceptionMessage eem = ErrorHandlingProtos.ForeignExceptionMessage.parseFrom(bytes);
        ErrorHandlingProtos.GenericExceptionMessage gem = eem.getGenericException();
        StackTraceElement[] trace = ForeignException.toStackTrace(gem.getTraceList());
        ProxyThrowable dfe = new ProxyThrowable(gem.getMessage(), trace);
        ForeignException e = new ForeignException(eem.getSource(), dfe);
        return e;
    }

    private static StackTraceElement[] toStackTrace(List<ErrorHandlingProtos.StackTraceElementMessage> traceList) {
        if (traceList == null || traceList.isEmpty()) {
            return new StackTraceElement[0];
        }
        StackTraceElement[] trace = new StackTraceElement[traceList.size()];
        for (int i = 0; i < traceList.size(); ++i) {
            ErrorHandlingProtos.StackTraceElementMessage elem = traceList.get(i);
            trace[i] = new StackTraceElement(elem.getDeclaringClass(), elem.getMethodName(), elem.getFileName(), elem.getLineNumber());
        }
        return trace;
    }

    private static class ProxyThrowable
    extends Throwable {
        ProxyThrowable(String msg, StackTraceElement[] trace) {
            super(msg);
            this.setStackTrace(trace);
        }
    }
}

