/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionReplicaUtil {
    public static final String REGION_REPLICA_WAIT_FOR_PRIMARY_FLUSH_CONF_KEY = "hbase.region.replica.wait.for.primary.flush";
    protected static final boolean DEFAULT_REGION_REPLICA_WAIT_FOR_PRIMARY_FLUSH = true;
    static final int DEFAULT_REPLICA_ID = 0;

    public static RegionInfo getRegionInfoForReplica(RegionInfo regionInfo, int replicaId) {
        if (regionInfo.getReplicaId() == replicaId) {
            return regionInfo;
        }
        return RegionInfoBuilder.newBuilder(regionInfo).setReplicaId(replicaId).build();
    }

    public static RegionInfo getRegionInfoForDefaultReplica(RegionInfo regionInfo) {
        return RegionReplicaUtil.getRegionInfoForReplica(regionInfo, 0);
    }

    public static boolean isDefaultReplica(int replicaId) {
        return 0 == replicaId;
    }

    public static boolean isDefaultReplica(RegionInfo hri) {
        return hri.getReplicaId() == 0;
    }

    public static void removeNonDefaultRegions(Collection<RegionInfo> regions) {
        Iterator<RegionInfo> iterator2 = regions.iterator();
        while (iterator2.hasNext()) {
            RegionInfo hri = iterator2.next();
            if (RegionReplicaUtil.isDefaultReplica(hri)) continue;
            iterator2.remove();
        }
    }

    public static boolean isReplicasForSameRegion(RegionInfo regionInfoA, RegionInfo regionInfoB) {
        return RegionReplicaUtil.compareRegionInfosWithoutReplicaId(regionInfoA, regionInfoB) == 0;
    }

    private static int compareRegionInfosWithoutReplicaId(RegionInfo regionInfoA, RegionInfo regionInfoB) {
        int result = regionInfoA.getTable().compareTo(regionInfoB.getTable());
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo(regionInfoA.getStartKey(), regionInfoB.getStartKey());
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo(regionInfoA.getEndKey(), regionInfoB.getEndKey());
        if (result != 0) {
            if (regionInfoA.getStartKey().length != 0 && regionInfoA.getEndKey().length == 0) {
                return 1;
            }
            if (regionInfoB.getStartKey().length != 0 && regionInfoB.getEndKey().length == 0) {
                return -1;
            }
            return result;
        }
        if (regionInfoA.getRegionId() > regionInfoB.getRegionId()) {
            return 1;
        }
        if (regionInfoA.getRegionId() < regionInfoB.getRegionId()) {
            return -1;
        }
        return 0;
    }

    public static List<RegionInfo> addReplicas(List<RegionInfo> regions, int oldReplicaCount, int newReplicaCount) {
        if (newReplicaCount - 1 <= 0) {
            return regions;
        }
        ArrayList<RegionInfo> hRegionInfos = new ArrayList<RegionInfo>(newReplicaCount * regions.size());
        for (RegionInfo ri : regions) {
            if (!RegionReplicaUtil.isDefaultReplica(ri) || ri.isOffline() && (ri.isSplit() || ri.isSplitParent())) continue;
            for (int j = oldReplicaCount; j < newReplicaCount; ++j) {
                hRegionInfos.add(RegionReplicaUtil.getRegionInfoForReplica(ri, j));
            }
        }
        hRegionInfos.addAll(regions);
        return hRegionInfos;
    }
}

