/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.MobCompactPartitionPolicy;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.exceptions.HBaseException;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PrettyPrinter;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ColumnFamilyDescriptorBuilder {
    private static final byte COLUMN_DESCRIPTOR_VERSION = 11;
    @InterfaceAudience.Private
    public static final String IN_MEMORY_COMPACTION = "IN_MEMORY_COMPACTION";
    private static final Bytes IN_MEMORY_COMPACTION_BYTES = new Bytes(Bytes.toBytes("IN_MEMORY_COMPACTION"));
    @InterfaceAudience.Private
    public static final String IN_MEMORY = "IN_MEMORY";
    private static final Bytes IN_MEMORY_BYTES = new Bytes(Bytes.toBytes("IN_MEMORY"));
    @InterfaceAudience.Private
    public static final String COMPRESSION = "COMPRESSION";
    private static final Bytes COMPRESSION_BYTES = new Bytes(Bytes.toBytes("COMPRESSION"));
    @InterfaceAudience.Private
    public static final String COMPRESSION_COMPACT = "COMPRESSION_COMPACT";
    private static final Bytes COMPRESSION_COMPACT_BYTES = new Bytes(Bytes.toBytes("COMPRESSION_COMPACT"));
    @InterfaceAudience.Private
    public static final String DATA_BLOCK_ENCODING = "DATA_BLOCK_ENCODING";
    private static final Bytes DATA_BLOCK_ENCODING_BYTES = new Bytes(Bytes.toBytes("DATA_BLOCK_ENCODING"));
    @InterfaceAudience.Private
    public static final String BLOCKCACHE = "BLOCKCACHE";
    private static final Bytes BLOCKCACHE_BYTES = new Bytes(Bytes.toBytes("BLOCKCACHE"));
    @InterfaceAudience.Private
    public static final String CACHE_DATA_ON_WRITE = "CACHE_DATA_ON_WRITE";
    private static final Bytes CACHE_DATA_ON_WRITE_BYTES = new Bytes(Bytes.toBytes("CACHE_DATA_ON_WRITE"));
    @InterfaceAudience.Private
    public static final String CACHE_INDEX_ON_WRITE = "CACHE_INDEX_ON_WRITE";
    private static final Bytes CACHE_INDEX_ON_WRITE_BYTES = new Bytes(Bytes.toBytes("CACHE_INDEX_ON_WRITE"));
    @InterfaceAudience.Private
    public static final String CACHE_BLOOMS_ON_WRITE = "CACHE_BLOOMS_ON_WRITE";
    private static final Bytes CACHE_BLOOMS_ON_WRITE_BYTES = new Bytes(Bytes.toBytes("CACHE_BLOOMS_ON_WRITE"));
    @InterfaceAudience.Private
    public static final String EVICT_BLOCKS_ON_CLOSE = "EVICT_BLOCKS_ON_CLOSE";
    private static final Bytes EVICT_BLOCKS_ON_CLOSE_BYTES = new Bytes(Bytes.toBytes("EVICT_BLOCKS_ON_CLOSE"));
    @InterfaceAudience.Private
    public static final String PREFETCH_BLOCKS_ON_OPEN = "PREFETCH_BLOCKS_ON_OPEN";
    private static final Bytes PREFETCH_BLOCKS_ON_OPEN_BYTES = new Bytes(Bytes.toBytes("PREFETCH_BLOCKS_ON_OPEN"));
    @InterfaceAudience.Private
    public static final String BLOCKSIZE = "BLOCKSIZE";
    private static final Bytes BLOCKSIZE_BYTES = new Bytes(Bytes.toBytes("BLOCKSIZE"));
    @InterfaceAudience.Private
    public static final String TTL = "TTL";
    private static final Bytes TTL_BYTES = new Bytes(Bytes.toBytes("TTL"));
    @InterfaceAudience.Private
    public static final String BLOOMFILTER = "BLOOMFILTER";
    private static final Bytes BLOOMFILTER_BYTES = new Bytes(Bytes.toBytes("BLOOMFILTER"));
    @InterfaceAudience.Private
    public static final String REPLICATION_SCOPE = "REPLICATION_SCOPE";
    @InterfaceAudience.Private
    public static final String MAX_VERSIONS = "VERSIONS";
    private static final Bytes MAX_VERSIONS_BYTES = new Bytes(Bytes.toBytes("VERSIONS"));
    @InterfaceAudience.Private
    public static final String MIN_VERSIONS = "MIN_VERSIONS";
    private static final Bytes MIN_VERSIONS_BYTES = new Bytes(Bytes.toBytes("MIN_VERSIONS"));
    @InterfaceAudience.Private
    public static final String KEEP_DELETED_CELLS = "KEEP_DELETED_CELLS";
    private static final Bytes KEEP_DELETED_CELLS_BYTES = new Bytes(Bytes.toBytes("KEEP_DELETED_CELLS"));
    @InterfaceAudience.Private
    public static final String COMPRESS_TAGS = "COMPRESS_TAGS";
    private static final Bytes COMPRESS_TAGS_BYTES = new Bytes(Bytes.toBytes("COMPRESS_TAGS"));
    @InterfaceAudience.Private
    public static final String ENCRYPTION = "ENCRYPTION";
    private static final Bytes ENCRYPTION_BYTES = new Bytes(Bytes.toBytes("ENCRYPTION"));
    @InterfaceAudience.Private
    public static final String ENCRYPTION_KEY = "ENCRYPTION_KEY";
    private static final Bytes ENCRYPTION_KEY_BYTES = new Bytes(Bytes.toBytes("ENCRYPTION_KEY"));
    private static final boolean DEFAULT_MOB = false;
    @InterfaceAudience.Private
    public static final String IS_MOB = "IS_MOB";
    private static final Bytes IS_MOB_BYTES = new Bytes(Bytes.toBytes("IS_MOB"));
    @InterfaceAudience.Private
    public static final String MOB_THRESHOLD = "MOB_THRESHOLD";
    private static final Bytes MOB_THRESHOLD_BYTES = new Bytes(Bytes.toBytes("MOB_THRESHOLD"));
    public static final long DEFAULT_MOB_THRESHOLD = 102400L;
    @InterfaceAudience.Private
    public static final String MOB_COMPACT_PARTITION_POLICY = "MOB_COMPACT_PARTITION_POLICY";
    private static final Bytes MOB_COMPACT_PARTITION_POLICY_BYTES = new Bytes(Bytes.toBytes("MOB_COMPACT_PARTITION_POLICY"));
    public static final MobCompactPartitionPolicy DEFAULT_MOB_COMPACT_PARTITION_POLICY = MobCompactPartitionPolicy.DAILY;
    @InterfaceAudience.Private
    public static final String DFS_REPLICATION = "DFS_REPLICATION";
    private static final Bytes DFS_REPLICATION_BYTES = new Bytes(Bytes.toBytes("DFS_REPLICATION"));
    public static final short DEFAULT_DFS_REPLICATION = 0;
    @InterfaceAudience.Private
    public static final String STORAGE_POLICY = "STORAGE_POLICY";
    private static final Bytes STORAGE_POLICY_BYTES = new Bytes(Bytes.toBytes("STORAGE_POLICY"));
    public static final String NEW_VERSION_BEHAVIOR = "NEW_VERSION_BEHAVIOR";
    private static final Bytes NEW_VERSION_BEHAVIOR_BYTES = new Bytes(Bytes.toBytes("NEW_VERSION_BEHAVIOR"));
    public static final boolean DEFAULT_NEW_VERSION_BEHAVIOR = false;
    public static final Compression.Algorithm DEFAULT_COMPRESSION = Compression.Algorithm.NONE;
    public static final DataBlockEncoding DEFAULT_DATA_BLOCK_ENCODING = DataBlockEncoding.NONE;
    public static final int DEFAULT_MAX_VERSIONS = 1;
    public static final int DEFAULT_MIN_VERSIONS = 0;
    public static final boolean DEFAULT_IN_MEMORY = false;
    public static final KeepDeletedCells DEFAULT_KEEP_DELETED = KeepDeletedCells.FALSE;
    public static final boolean DEFAULT_BLOCKCACHE = true;
    public static final boolean DEFAULT_CACHE_DATA_ON_WRITE = false;
    public static final boolean DEFAULT_CACHE_INDEX_ON_WRITE = false;
    public static final int DEFAULT_BLOCKSIZE = 65536;
    public static final BloomType DEFAULT_BLOOMFILTER = BloomType.ROW;
    public static final boolean DEFAULT_CACHE_BLOOMS_ON_WRITE = false;
    public static final int DEFAULT_TTL = Integer.MAX_VALUE;
    public static final int DEFAULT_REPLICATION_SCOPE = 0;
    public static final boolean DEFAULT_EVICT_BLOCKS_ON_CLOSE = false;
    public static final boolean DEFAULT_COMPRESS_TAGS = true;
    public static final boolean DEFAULT_PREFETCH_BLOCKS_ON_OPEN = false;
    private static final Map<String, String> DEFAULT_VALUES = new HashMap<String, String>();
    private static final Set<Bytes> RESERVED_KEYWORDS = new HashSet<Bytes>();
    private final ModifyableColumnFamilyDescriptor desc;

    private static Map<Bytes, Bytes> getDefaultValuesBytes() {
        HashMap<Bytes, Bytes> values2 = new HashMap<Bytes, Bytes>();
        DEFAULT_VALUES.forEach((k, v) -> values2.put(new Bytes(Bytes.toBytes(k)), new Bytes(Bytes.toBytes(v))));
        return values2;
    }

    public static Map<String, String> getDefaultValues() {
        return Collections.unmodifiableMap(DEFAULT_VALUES);
    }

    public static PrettyPrinter.Unit getUnit(String key) {
        switch (key) {
            case "TTL": {
                return PrettyPrinter.Unit.TIME_INTERVAL;
            }
        }
        return PrettyPrinter.Unit.NONE;
    }

    public static byte[] isLegalColumnFamilyName(byte[] b) {
        if (b == null) {
            return null;
        }
        Preconditions.checkArgument(b.length != 0, "Column Family name can not be empty");
        if (b[0] == 46) {
            throw new IllegalArgumentException("Column Family names cannot start with a period: " + Bytes.toString(b));
        }
        for (int i = 0; i < b.length; ++i) {
            if (!Character.isISOControl(b[i]) && b[i] != 58 && b[i] != 92 && b[i] != 47) continue;
            throw new IllegalArgumentException("Illegal character <" + b[i] + ">. Column Family names cannot contain control characters or colons: " + Bytes.toString(b));
        }
        byte[] recoveredEdit = Bytes.toBytes("recovered.edits");
        if (Bytes.equals(recoveredEdit, b)) {
            throw new IllegalArgumentException("Column Family name cannot be: recovered.edits");
        }
        return b;
    }

    public static ColumnFamilyDescriptor parseFrom(byte[] pbBytes) throws DeserializationException {
        return ModifyableColumnFamilyDescriptor.parseFrom(pbBytes);
    }

    public static ColumnFamilyDescriptorBuilder newBuilder(byte[] name) {
        return new ColumnFamilyDescriptorBuilder(name);
    }

    public static ColumnFamilyDescriptorBuilder newBuilder(ColumnFamilyDescriptor desc) {
        return new ColumnFamilyDescriptorBuilder(desc);
    }

    public static ColumnFamilyDescriptor copy(ColumnFamilyDescriptor desc) {
        return new ModifyableColumnFamilyDescriptor(desc);
    }

    public static ColumnFamilyDescriptor of(String name) {
        return ColumnFamilyDescriptorBuilder.of(Bytes.toBytes(name));
    }

    public static ColumnFamilyDescriptor of(byte[] name) {
        return ColumnFamilyDescriptorBuilder.newBuilder(name).build();
    }

    private ColumnFamilyDescriptorBuilder(byte[] name) {
        this.desc = new ModifyableColumnFamilyDescriptor(name);
    }

    private ColumnFamilyDescriptorBuilder(ColumnFamilyDescriptor desc) {
        this.desc = new ModifyableColumnFamilyDescriptor(desc);
    }

    public static byte[] toByteArray(ColumnFamilyDescriptor desc) {
        if (desc instanceof ModifyableColumnFamilyDescriptor) {
            return ((ModifyableColumnFamilyDescriptor)desc).toByteArray();
        }
        return new ModifyableColumnFamilyDescriptor(desc).toByteArray();
    }

    public ColumnFamilyDescriptor build() {
        return new ModifyableColumnFamilyDescriptor(this.desc);
    }

    public ColumnFamilyDescriptorBuilder removeConfiguration(String key) {
        this.desc.removeConfiguration(key);
        return this;
    }

    public String getNameAsString() {
        return this.desc.getNameAsString();
    }

    public ColumnFamilyDescriptorBuilder setBlockCacheEnabled(boolean value) {
        this.desc.setBlockCacheEnabled(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setBlocksize(int value) {
        this.desc.setBlocksize(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setBloomFilterType(BloomType value) {
        this.desc.setBloomFilterType(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setCacheBloomsOnWrite(boolean value) {
        this.desc.setCacheBloomsOnWrite(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setCacheDataOnWrite(boolean value) {
        this.desc.setCacheDataOnWrite(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setCacheIndexesOnWrite(boolean value) {
        this.desc.setCacheIndexesOnWrite(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setCompactionCompressionType(Compression.Algorithm value) {
        this.desc.setCompactionCompressionType(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setCompressTags(boolean value) {
        this.desc.setCompressTags(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setCompressionType(Compression.Algorithm value) {
        this.desc.setCompressionType(value);
        return this;
    }

    public Compression.Algorithm getCompressionType() {
        return this.desc.getCompressionType();
    }

    public ColumnFamilyDescriptorBuilder setConfiguration(String key, String value) {
        this.desc.setConfiguration(key, value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setDFSReplication(short value) {
        this.desc.setDFSReplication(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setDataBlockEncoding(DataBlockEncoding value) {
        this.desc.setDataBlockEncoding(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setEncryptionKey(byte[] value) {
        this.desc.setEncryptionKey(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setEncryptionType(String value) {
        this.desc.setEncryptionType(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setEvictBlocksOnClose(boolean value) {
        this.desc.setEvictBlocksOnClose(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setInMemory(boolean value) {
        this.desc.setInMemory(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setInMemoryCompaction(MemoryCompactionPolicy value) {
        this.desc.setInMemoryCompaction(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setKeepDeletedCells(KeepDeletedCells value) {
        this.desc.setKeepDeletedCells(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setMaxVersions(int value) {
        this.desc.setMaxVersions(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setMinVersions(int value) {
        this.desc.setMinVersions(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setMobCompactPartitionPolicy(MobCompactPartitionPolicy value) {
        this.desc.setMobCompactPartitionPolicy(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setMobEnabled(boolean value) {
        this.desc.setMobEnabled(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setMobThreshold(long value) {
        this.desc.setMobThreshold(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setPrefetchBlocksOnOpen(boolean value) {
        this.desc.setPrefetchBlocksOnOpen(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setScope(int value) {
        this.desc.setScope(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setStoragePolicy(String value) {
        this.desc.setStoragePolicy(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setTimeToLive(int value) {
        this.desc.setTimeToLive(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setTimeToLive(String value) throws HBaseException {
        this.desc.setTimeToLive(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setNewVersionBehavior(boolean value) {
        this.desc.setNewVersionBehavior(value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setValue(Bytes key, Bytes value) {
        this.desc.setValue(key, value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setValue(byte[] key, byte[] value) {
        this.desc.setValue(key, value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setValue(String key, String value) {
        this.desc.setValue(key, value);
        return this;
    }

    public ColumnFamilyDescriptorBuilder setVersionsWithTimeToLive(int retentionInterval, int versionAfterInterval) {
        this.desc.setVersionsWithTimeToLive(retentionInterval, versionAfterInterval);
        return this;
    }

    static {
        DEFAULT_VALUES.put(BLOOMFILTER, DEFAULT_BLOOMFILTER.name());
        DEFAULT_VALUES.put(REPLICATION_SCOPE, String.valueOf(0));
        DEFAULT_VALUES.put(MAX_VERSIONS, String.valueOf(1));
        DEFAULT_VALUES.put(MIN_VERSIONS, String.valueOf(0));
        DEFAULT_VALUES.put(COMPRESSION, DEFAULT_COMPRESSION.name());
        DEFAULT_VALUES.put(TTL, String.valueOf(Integer.MAX_VALUE));
        DEFAULT_VALUES.put(BLOCKSIZE, String.valueOf(65536));
        DEFAULT_VALUES.put(IN_MEMORY, String.valueOf(false));
        DEFAULT_VALUES.put(BLOCKCACHE, String.valueOf(true));
        DEFAULT_VALUES.put(KEEP_DELETED_CELLS, String.valueOf((Object)DEFAULT_KEEP_DELETED));
        DEFAULT_VALUES.put(DATA_BLOCK_ENCODING, String.valueOf((Object)DEFAULT_DATA_BLOCK_ENCODING));
        DEFAULT_VALUES.keySet().forEach(s2 -> RESERVED_KEYWORDS.add(new Bytes(Bytes.toBytes(s2))));
        RESERVED_KEYWORDS.add(new Bytes(Bytes.toBytes(ENCRYPTION)));
        RESERVED_KEYWORDS.add(new Bytes(Bytes.toBytes(ENCRYPTION_KEY)));
        RESERVED_KEYWORDS.add(new Bytes(Bytes.toBytes(IS_MOB)));
        RESERVED_KEYWORDS.add(new Bytes(Bytes.toBytes(MOB_THRESHOLD)));
        RESERVED_KEYWORDS.add(new Bytes(Bytes.toBytes(MOB_COMPACT_PARTITION_POLICY)));
    }

    @InterfaceAudience.Private
    public static class ModifyableColumnFamilyDescriptor
    implements ColumnFamilyDescriptor,
    Comparable<ModifyableColumnFamilyDescriptor> {
        private final byte[] name;
        private final Map<Bytes, Bytes> values = new HashMap<Bytes, Bytes>();
        private final Map<String, String> configuration = new HashMap<String, String>();

        @InterfaceAudience.Private
        public ModifyableColumnFamilyDescriptor(byte[] name) {
            this(ColumnFamilyDescriptorBuilder.isLegalColumnFamilyName(name), ColumnFamilyDescriptorBuilder.getDefaultValuesBytes(), Collections.emptyMap());
        }

        @InterfaceAudience.Private
        public ModifyableColumnFamilyDescriptor(ColumnFamilyDescriptor desc) {
            this(desc.getName(), desc.getValues(), desc.getConfiguration());
        }

        private ModifyableColumnFamilyDescriptor(byte[] name, Map<Bytes, Bytes> values2, Map<String, String> config) {
            this.name = name;
            this.values.putAll(values2);
            this.configuration.putAll(config);
        }

        @Override
        public byte[] getName() {
            return Bytes.copy(this.name);
        }

        @Override
        public String getNameAsString() {
            return Bytes.toString(this.name);
        }

        @Override
        public Bytes getValue(Bytes key) {
            return this.values.get(key);
        }

        @Override
        public byte[] getValue(byte[] key) {
            Bytes value = this.values.get(new Bytes(key));
            return value == null ? null : value.get();
        }

        @Override
        public Map<Bytes, Bytes> getValues() {
            return Collections.unmodifiableMap(this.values);
        }

        public ModifyableColumnFamilyDescriptor setValue(byte[] key, byte[] value) {
            return this.setValue(ModifyableColumnFamilyDescriptor.toBytesOrNull(key, Function.identity()), ModifyableColumnFamilyDescriptor.toBytesOrNull(value, Function.identity()));
        }

        public ModifyableColumnFamilyDescriptor setValue(String key, String value) {
            return this.setValue(ModifyableColumnFamilyDescriptor.toBytesOrNull(key, Bytes::toBytes), ModifyableColumnFamilyDescriptor.toBytesOrNull(value, Bytes::toBytes));
        }

        private ModifyableColumnFamilyDescriptor setValue(Bytes key, String value) {
            return this.setValue(key, ModifyableColumnFamilyDescriptor.toBytesOrNull(value, Bytes::toBytes));
        }

        private ModifyableColumnFamilyDescriptor setValue(Bytes key, Bytes value) {
            if (value == null || value.getLength() == 0) {
                this.values.remove(key);
            } else {
                this.values.put(key, value);
            }
            return this;
        }

        public ModifyableColumnFamilyDescriptor removeValue(Bytes key) {
            return this.setValue(key, (Bytes)null);
        }

        private static <T> Bytes toBytesOrNull(T t, Function<T, byte[]> f) {
            if (t == null) {
                return null;
            }
            return new Bytes(f.apply(t));
        }

        private <T> T getStringOrDefault(Bytes key, Function<String, T> function, T defaultValue) {
            return (T)this.getOrDefault(key, b -> function.apply(Bytes.toString(b)), defaultValue);
        }

        private <T> T getOrDefault(Bytes key, Function<byte[], T> function, T defaultValue) {
            Bytes value = this.values.get(key);
            if (value == null) {
                return defaultValue;
            }
            return function.apply(value.get());
        }

        @Override
        public int getMaxVersions() {
            return this.getStringOrDefault(MAX_VERSIONS_BYTES, Integer::parseInt, 1);
        }

        public ModifyableColumnFamilyDescriptor setMaxVersions(int maxVersions) {
            if (maxVersions <= 0) {
                throw new IllegalArgumentException("Maximum versions must be positive");
            }
            if (maxVersions < this.getMinVersions()) {
                throw new IllegalArgumentException("Set MaxVersion to " + maxVersions + " while minVersion is " + this.getMinVersions() + ". Maximum versions must be >= minimum versions ");
            }
            this.setValue(MAX_VERSIONS_BYTES, Integer.toString(maxVersions));
            return this;
        }

        public ModifyableColumnFamilyDescriptor setVersions(int minVersions, int maxVersions) {
            if (minVersions <= 0) {
                throw new IllegalArgumentException("Minimum versions must be positive");
            }
            if (maxVersions < minVersions) {
                throw new IllegalArgumentException("Unable to set MaxVersion to " + maxVersions + " and set MinVersion to " + minVersions + ", as maximum versions must be >= minimum versions.");
            }
            this.setMinVersions(minVersions);
            this.setMaxVersions(maxVersions);
            return this;
        }

        @Override
        public int getBlocksize() {
            return this.getStringOrDefault(BLOCKSIZE_BYTES, Integer::valueOf, 65536);
        }

        public ModifyableColumnFamilyDescriptor setBlocksize(int s2) {
            return this.setValue(BLOCKSIZE_BYTES, Integer.toString(s2));
        }

        @Override
        public Compression.Algorithm getCompressionType() {
            return this.getStringOrDefault(COMPRESSION_BYTES, n -> Compression.Algorithm.valueOf(n.toUpperCase()), DEFAULT_COMPRESSION);
        }

        public ModifyableColumnFamilyDescriptor setCompressionType(Compression.Algorithm type) {
            return this.setValue(COMPRESSION_BYTES, type.name());
        }

        @Override
        public DataBlockEncoding getDataBlockEncoding() {
            return this.getStringOrDefault(DATA_BLOCK_ENCODING_BYTES, n -> DataBlockEncoding.valueOf(n.toUpperCase()), DataBlockEncoding.NONE);
        }

        public ModifyableColumnFamilyDescriptor setDataBlockEncoding(DataBlockEncoding type) {
            return this.setValue(DATA_BLOCK_ENCODING_BYTES, type == null ? DataBlockEncoding.NONE.name() : type.name());
        }

        public ModifyableColumnFamilyDescriptor setCompressTags(boolean compressTags) {
            return this.setValue(COMPRESS_TAGS_BYTES, String.valueOf(compressTags));
        }

        @Override
        public boolean isCompressTags() {
            return this.getStringOrDefault(COMPRESS_TAGS_BYTES, Boolean::valueOf, true);
        }

        @Override
        public Compression.Algorithm getCompactionCompressionType() {
            return this.getStringOrDefault(COMPRESSION_COMPACT_BYTES, n -> Compression.Algorithm.valueOf(n.toUpperCase()), this.getCompressionType());
        }

        public ModifyableColumnFamilyDescriptor setCompactionCompressionType(Compression.Algorithm type) {
            return this.setValue(COMPRESSION_COMPACT_BYTES, type.name());
        }

        @Override
        public boolean isInMemory() {
            return this.getStringOrDefault(IN_MEMORY_BYTES, Boolean::valueOf, false);
        }

        public ModifyableColumnFamilyDescriptor setInMemory(boolean inMemory) {
            return this.setValue(IN_MEMORY_BYTES, Boolean.toString(inMemory));
        }

        @Override
        public MemoryCompactionPolicy getInMemoryCompaction() {
            return this.getStringOrDefault(IN_MEMORY_COMPACTION_BYTES, n -> MemoryCompactionPolicy.valueOf(n.toUpperCase()), null);
        }

        public ModifyableColumnFamilyDescriptor setInMemoryCompaction(MemoryCompactionPolicy inMemoryCompaction) {
            return this.setValue(IN_MEMORY_COMPACTION_BYTES, inMemoryCompaction.name());
        }

        @Override
        public KeepDeletedCells getKeepDeletedCells() {
            return this.getStringOrDefault(KEEP_DELETED_CELLS_BYTES, KeepDeletedCells::getValue, DEFAULT_KEEP_DELETED);
        }

        public ModifyableColumnFamilyDescriptor setKeepDeletedCells(KeepDeletedCells keepDeletedCells) {
            return this.setValue(KEEP_DELETED_CELLS_BYTES, keepDeletedCells.name());
        }

        @Override
        public boolean isNewVersionBehavior() {
            return this.getStringOrDefault(NEW_VERSION_BEHAVIOR_BYTES, Boolean::parseBoolean, false);
        }

        public ModifyableColumnFamilyDescriptor setNewVersionBehavior(boolean newVersionBehavior) {
            return this.setValue(NEW_VERSION_BEHAVIOR_BYTES, Boolean.toString(newVersionBehavior));
        }

        @Override
        public int getTimeToLive() {
            return this.getStringOrDefault(TTL_BYTES, Integer::parseInt, Integer.MAX_VALUE);
        }

        public ModifyableColumnFamilyDescriptor setTimeToLive(int timeToLive) {
            return this.setValue(TTL_BYTES, Integer.toString(timeToLive));
        }

        public ModifyableColumnFamilyDescriptor setTimeToLive(String timeToLive) throws HBaseException {
            return this.setTimeToLive(Integer.parseInt(PrettyPrinter.valueOf(timeToLive, PrettyPrinter.Unit.TIME_INTERVAL)));
        }

        @Override
        public int getMinVersions() {
            return this.getStringOrDefault(MIN_VERSIONS_BYTES, Integer::valueOf, 0);
        }

        public ModifyableColumnFamilyDescriptor setMinVersions(int minVersions) {
            return this.setValue(MIN_VERSIONS_BYTES, Integer.toString(minVersions));
        }

        public ModifyableColumnFamilyDescriptor setVersionsWithTimeToLive(int retentionInterval, int versionAfterInterval) {
            ModifyableColumnFamilyDescriptor modifyableColumnFamilyDescriptor = this.setVersions(versionAfterInterval, Integer.MAX_VALUE);
            modifyableColumnFamilyDescriptor.setTimeToLive(retentionInterval);
            modifyableColumnFamilyDescriptor.setKeepDeletedCells(KeepDeletedCells.TTL);
            return modifyableColumnFamilyDescriptor;
        }

        @Override
        public boolean isBlockCacheEnabled() {
            return this.getStringOrDefault(BLOCKCACHE_BYTES, Boolean::valueOf, true);
        }

        public ModifyableColumnFamilyDescriptor setBlockCacheEnabled(boolean blockCacheEnabled) {
            return this.setValue(BLOCKCACHE_BYTES, Boolean.toString(blockCacheEnabled));
        }

        @Override
        public BloomType getBloomFilterType() {
            return this.getStringOrDefault(BLOOMFILTER_BYTES, n -> BloomType.valueOf(n.toUpperCase()), DEFAULT_BLOOMFILTER);
        }

        public ModifyableColumnFamilyDescriptor setBloomFilterType(BloomType bt) {
            return this.setValue(BLOOMFILTER_BYTES, bt.name());
        }

        @Override
        public int getScope() {
            return this.getStringOrDefault(REPLICATION_SCOPE_BYTES, Integer::valueOf, 0);
        }

        public ModifyableColumnFamilyDescriptor setScope(int scope) {
            return this.setValue(REPLICATION_SCOPE_BYTES, Integer.toString(scope));
        }

        @Override
        public boolean isCacheDataOnWrite() {
            return this.getStringOrDefault(CACHE_DATA_ON_WRITE_BYTES, Boolean::valueOf, false);
        }

        public ModifyableColumnFamilyDescriptor setCacheDataOnWrite(boolean value) {
            return this.setValue(CACHE_DATA_ON_WRITE_BYTES, Boolean.toString(value));
        }

        @Override
        public boolean isCacheIndexesOnWrite() {
            return this.getStringOrDefault(CACHE_INDEX_ON_WRITE_BYTES, Boolean::valueOf, false);
        }

        public ModifyableColumnFamilyDescriptor setCacheIndexesOnWrite(boolean value) {
            return this.setValue(CACHE_INDEX_ON_WRITE_BYTES, Boolean.toString(value));
        }

        @Override
        public boolean isCacheBloomsOnWrite() {
            return this.getStringOrDefault(CACHE_BLOOMS_ON_WRITE_BYTES, Boolean::valueOf, false);
        }

        public ModifyableColumnFamilyDescriptor setCacheBloomsOnWrite(boolean value) {
            return this.setValue(CACHE_BLOOMS_ON_WRITE_BYTES, Boolean.toString(value));
        }

        @Override
        public boolean isEvictBlocksOnClose() {
            return this.getStringOrDefault(EVICT_BLOCKS_ON_CLOSE_BYTES, Boolean::valueOf, false);
        }

        public ModifyableColumnFamilyDescriptor setEvictBlocksOnClose(boolean value) {
            return this.setValue(EVICT_BLOCKS_ON_CLOSE_BYTES, Boolean.toString(value));
        }

        @Override
        public boolean isPrefetchBlocksOnOpen() {
            return this.getStringOrDefault(PREFETCH_BLOCKS_ON_OPEN_BYTES, Boolean::valueOf, false);
        }

        public ModifyableColumnFamilyDescriptor setPrefetchBlocksOnOpen(boolean value) {
            return this.setValue(PREFETCH_BLOCKS_ON_OPEN_BYTES, Boolean.toString(value));
        }

        public String toString() {
            StringBuilder s2 = new StringBuilder();
            s2.append('{');
            s2.append("NAME");
            s2.append(" => '");
            s2.append(this.getNameAsString());
            s2.append("'");
            s2.append((CharSequence)this.getValues(true));
            s2.append('}');
            return s2.toString();
        }

        @Override
        public String toStringCustomizedValues() {
            StringBuilder s2 = new StringBuilder();
            s2.append('{');
            s2.append("NAME");
            s2.append(" => '");
            s2.append(this.getNameAsString());
            s2.append("'");
            s2.append((CharSequence)this.getValues(false));
            s2.append('}');
            return s2.toString();
        }

        private StringBuilder getValues(boolean printDefaults) {
            StringBuilder s2 = new StringBuilder();
            boolean hasConfigKeys = false;
            for (Map.Entry<Bytes, Bytes> entry : this.values.entrySet()) {
                if (!RESERVED_KEYWORDS.contains(entry.getKey())) {
                    hasConfigKeys = true;
                    continue;
                }
                String string = Bytes.toString(entry.getKey().get());
                String value = Bytes.toStringBinary(entry.getValue().get());
                if (!printDefaults && DEFAULT_VALUES.containsKey(string) && ((String)DEFAULT_VALUES.get(string)).equalsIgnoreCase(value)) continue;
                s2.append(", ");
                s2.append(string);
                s2.append(" => ");
                s2.append('\'').append(PrettyPrinter.format(value, ColumnFamilyDescriptorBuilder.getUnit(string))).append('\'');
            }
            if (hasConfigKeys) {
                s2.append(", ");
                s2.append("METADATA").append(" => ");
                s2.append('{');
                boolean printComma = false;
                for (Map.Entry<Bytes, Bytes> entry : this.values.entrySet()) {
                    Bytes k = entry.getKey();
                    if (RESERVED_KEYWORDS.contains(k)) continue;
                    String key = Bytes.toString(k.get());
                    String value = Bytes.toStringBinary(entry.getValue().get());
                    if (printComma) {
                        s2.append(", ");
                    }
                    printComma = true;
                    s2.append('\'').append(key).append('\'');
                    s2.append(" => ");
                    s2.append('\'').append(PrettyPrinter.format(value, ColumnFamilyDescriptorBuilder.getUnit(key))).append('\'');
                }
                s2.append('}');
            }
            if (!this.configuration.isEmpty()) {
                s2.append(", ");
                s2.append("CONFIGURATION").append(" => ");
                s2.append('{');
                boolean printCommaForConfiguration = false;
                for (Map.Entry<Object, Object> entry : this.configuration.entrySet()) {
                    if (printCommaForConfiguration) {
                        s2.append(", ");
                    }
                    printCommaForConfiguration = true;
                    s2.append('\'').append((String)entry.getKey()).append('\'');
                    s2.append(" => ");
                    s2.append('\'').append(PrettyPrinter.format((String)entry.getValue(), ColumnFamilyDescriptorBuilder.getUnit((String)entry.getKey()))).append('\'');
                }
                s2.append("}");
            }
            return s2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModifyableColumnFamilyDescriptor) {
                return ColumnFamilyDescriptor.COMPARATOR.compare(this, (ModifyableColumnFamilyDescriptor)obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            int result = Bytes.hashCode(this.name);
            result ^= 0xB;
            result ^= this.values.hashCode();
            return result ^= this.configuration.hashCode();
        }

        @Override
        public int compareTo(ModifyableColumnFamilyDescriptor other) {
            return COMPARATOR.compare(this, other);
        }

        private byte[] toByteArray() {
            return ProtobufUtil.prependPBMagic(ProtobufUtil.toColumnFamilySchema(this).toByteArray());
        }

        private static ColumnFamilyDescriptor parseFrom(byte[] bytes) throws DeserializationException {
            if (!ProtobufUtil.isPBMagicPrefix(bytes)) {
                throw new DeserializationException("No magic");
            }
            int pblen = ProtobufUtil.lengthOfPBMagic();
            HBaseProtos.ColumnFamilySchema.Builder builder = HBaseProtos.ColumnFamilySchema.newBuilder();
            HBaseProtos.ColumnFamilySchema cfs = null;
            try {
                ProtobufUtil.mergeFrom(builder, bytes, pblen, bytes.length - pblen);
                cfs = builder.build();
            }
            catch (IOException e) {
                throw new DeserializationException(e);
            }
            return ProtobufUtil.toColumnFamilyDescriptor(cfs);
        }

        @Override
        public String getConfigurationValue(String key) {
            return this.configuration.get(key);
        }

        @Override
        public Map<String, String> getConfiguration() {
            return Collections.unmodifiableMap(this.configuration);
        }

        public ModifyableColumnFamilyDescriptor setConfiguration(String key, String value) {
            if (value == null || value.length() == 0) {
                this.configuration.remove(key);
            } else {
                this.configuration.put(key, value);
            }
            return this;
        }

        public ModifyableColumnFamilyDescriptor removeConfiguration(String key) {
            return this.setConfiguration(key, null);
        }

        @Override
        public String getEncryptionType() {
            return this.getStringOrDefault(ENCRYPTION_BYTES, Function.identity(), null);
        }

        public ModifyableColumnFamilyDescriptor setEncryptionType(String algorithm) {
            return this.setValue(ENCRYPTION_BYTES, algorithm);
        }

        @Override
        public byte[] getEncryptionKey() {
            return this.getOrDefault(ENCRYPTION_KEY_BYTES, Bytes::copy, null);
        }

        public ModifyableColumnFamilyDescriptor setEncryptionKey(byte[] keyBytes) {
            return this.setValue(ENCRYPTION_KEY_BYTES, new Bytes(keyBytes));
        }

        @Override
        public long getMobThreshold() {
            return this.getStringOrDefault(MOB_THRESHOLD_BYTES, Long::valueOf, 102400L);
        }

        public ModifyableColumnFamilyDescriptor setMobThreshold(long threshold) {
            return this.setValue(MOB_THRESHOLD_BYTES, String.valueOf(threshold));
        }

        @Override
        public boolean isMobEnabled() {
            return this.getStringOrDefault(IS_MOB_BYTES, Boolean::valueOf, false);
        }

        public ModifyableColumnFamilyDescriptor setMobEnabled(boolean isMobEnabled) {
            return this.setValue(IS_MOB_BYTES, String.valueOf(isMobEnabled));
        }

        @Override
        public MobCompactPartitionPolicy getMobCompactPartitionPolicy() {
            return this.getStringOrDefault(MOB_COMPACT_PARTITION_POLICY_BYTES, n -> MobCompactPartitionPolicy.valueOf(n.toUpperCase()), DEFAULT_MOB_COMPACT_PARTITION_POLICY);
        }

        public ModifyableColumnFamilyDescriptor setMobCompactPartitionPolicy(MobCompactPartitionPolicy policy) {
            return this.setValue(MOB_COMPACT_PARTITION_POLICY_BYTES, policy.name());
        }

        @Override
        public short getDFSReplication() {
            return this.getStringOrDefault(DFS_REPLICATION_BYTES, Short::valueOf, (short)0);
        }

        public ModifyableColumnFamilyDescriptor setDFSReplication(short replication) {
            if (replication < 1 && replication != 0) {
                throw new IllegalArgumentException("DFS replication factor cannot be less than 1 if explicitly set.");
            }
            return this.setValue(DFS_REPLICATION_BYTES, Short.toString(replication));
        }

        @Override
        public String getStoragePolicy() {
            return this.getStringOrDefault(STORAGE_POLICY_BYTES, Function.identity(), null);
        }

        public ModifyableColumnFamilyDescriptor setStoragePolicy(String policy) {
            return this.setValue(STORAGE_POLICY_BYTES, policy);
        }
    }
}

