/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.fs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.ServerSocket;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, LargeTests.class})
public class TestBlockReorder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBlockReorder.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockReorder.class);
    private Configuration conf;
    private MiniDFSCluster cluster;
    private HBaseTestingUtility htu;
    private DistributedFileSystem dfs;
    private static final String host1 = "host1";
    private static final String host2 = "host2";
    private static final String host3 = "host3";
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        this.htu = new HBaseTestingUtility();
        this.htu.getConfiguration().setInt("dfs.blocksize", 1024);
        this.htu.getConfiguration().setInt("dfs.replication", 3);
        this.htu.startMiniDFSCluster(3, new String[]{"/r1", "/r2", "/r3"}, new String[]{host1, host2, host3});
        this.conf = this.htu.getConfiguration();
        this.cluster = this.htu.getDFSCluster();
        this.dfs = (DistributedFileSystem)FileSystem.get((Configuration)this.conf);
    }

    @After
    public void tearDownAfterClass() throws Exception {
        this.htu.shutdownMiniCluster();
    }

    @Test
    public void testBlockLocationReorder() throws Exception {
        ServerSocket ssI;
        BlockLocation[] lbs;
        Path p = new Path("hello");
        Assert.assertTrue(((short)this.cluster.getDataNodes().size() > 1 ? 1 : 0) != 0);
        int repCount = 2;
        FSDataOutputStream fop = this.dfs.create(p, (short)2);
        double toWrite = 875.5613;
        fop.writeDouble(875.5613);
        fop.close();
        long start = System.currentTimeMillis();
        FSDataInputStream fin = this.dfs.open(p);
        Assert.assertTrue((875.5613 == fin.readDouble() ? 1 : 0) != 0);
        long end = System.currentTimeMillis();
        LOG.info("readtime= " + (end - start));
        fin.close();
        Assert.assertTrue((end - start < 30000L ? 1 : 0) != 0);
        FileStatus f = this.dfs.getFileStatus(p);
        while ((lbs = this.dfs.getFileBlockLocations(f, 0L, 1L)).length != 1 && lbs[0].getLength() != 2L) {
        }
        String name = lbs[0].getNames()[0];
        Assert.assertTrue((name.indexOf(58) > 0 ? 1 : 0) != 0);
        String portS = name.substring(name.indexOf(58) + 1);
        int port = Integer.parseInt(portS);
        LOG.info("port= " + port);
        int ipcPort = -1;
        boolean ok = false;
        final String lookup = lbs[0].getHosts()[0];
        StringBuilder sb = new StringBuilder();
        for (DataNode dn : this.cluster.getDataNodes()) {
            String dnName = this.getHostName(dn);
            sb.append(dnName).append(' ');
            if (!lookup.equals(dnName)) continue;
            ok = true;
            LOG.info("killing datanode " + name + " / " + lookup);
            ipcPort = dn.ipcServer.getListenerAddress().getPort();
            dn.shutdown();
            LOG.info("killed datanode " + name + " / " + lookup);
            break;
        }
        Assert.assertTrue((String)("didn't find the server to kill, was looking for " + lookup + " found " + sb), (boolean)ok);
        LOG.info("ipc port= " + ipcPort);
        Assert.assertTrue((boolean)HFileSystem.addLocationsOrderInterceptor((Configuration)this.conf, (HFileSystem.ReorderBlocks)new HFileSystem.ReorderBlocks(){

            public void reorderBlocks(Configuration c, LocatedBlocks lbs, String src) {
                for (LocatedBlock lb : lbs.getLocatedBlocks()) {
                    DatanodeInfoWithStorage[] infos;
                    if (lb.getLocations().length <= 1 || !(infos = lb.getLocations())[0].getHostName().equals(lookup)) continue;
                    LOG.info("HFileSystem bad host, inverting");
                    DatanodeInfoWithStorage tmp = infos[0];
                    infos[0] = infos[1];
                    infos[1] = tmp;
                }
            }
        }));
        int retries = 10;
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port);
            ssI = new ServerSocket(ipcPort);
        }
        catch (BindException be) {
            LOG.warn("Got bind exception trying to set up socket on " + port + " or " + ipcPort + ", this means that the datanode has not closed the socket or someone else took it. It may happen, skipping this test for this time.", (Throwable)be);
            if (ss != null) {
                ss.close();
            }
            return;
        }
        for (int i = 0; i < 10; ++i) {
            start = System.currentTimeMillis();
            fin = this.dfs.open(p);
            Assert.assertTrue((875.5613 == fin.readDouble() ? 1 : 0) != 0);
            fin.close();
            end = System.currentTimeMillis();
            LOG.info("HFileSystem readtime= " + (end - start));
            Assert.assertFalse((String)"We took too much time to read", (end - start > 60000L ? 1 : 0) != 0);
        }
        ss.close();
        ssI.close();
    }

    private String getHostName(DataNode dn) throws InvocationTargetException, IllegalAccessException {
        Method m;
        try {
            m = DataNode.class.getMethod("getDisplayName", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                m = DataNode.class.getMethod("getHostName", new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                throw new RuntimeException(e1);
            }
        }
        String res = (String)m.invoke((Object)dn, new Object[0]);
        if (res.contains(":")) {
            return res.split(":")[0];
        }
        return res;
    }
}

