/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncRegionLocatorHelper;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableBatchRetryImmediately {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableBatchRetryImmediately.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static byte[] QUAL = Bytes.toBytes((String)"cq");
    private static byte[] VALUE_PREFIX = new byte[768];
    private static int COUNT = 1000;
    private static AsyncConnection CONN;

    @BeforeClass
    public static void setUp() throws Exception {
        LogManager.getLogger(AsyncRegionLocatorHelper.class).setLevel(Level.INFO);
        UTIL.getConfiguration().setLong("hbase.server.scanner.max.result.size", 1024L);
        UTIL.startMiniCluster(1);
        Table table = UTIL.createTable(TABLE_NAME, FAMILY);
        UTIL.waitTableAvailable(TABLE_NAME);
        Bytes.random((byte[])VALUE_PREFIX);
        for (int i = 0; i < COUNT; ++i) {
            table.put(new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUAL, Bytes.add((byte[])VALUE_PREFIX, (byte[])Bytes.toBytes((int)i))));
        }
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        CONN.close();
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() {
        AsyncTable table = CONN.getTable(TABLE_NAME);
        List gets = IntStream.range(0, COUNT).mapToObj(i -> new Get(Bytes.toBytes((int)i))).collect(Collectors.toList());
        List results = (List)table.getAll(gets).join();
        for (int i2 = 0; i2 < COUNT; ++i2) {
            byte[] value = ((Result)results.get(i2)).getValue(FAMILY, QUAL);
            Assert.assertEquals((long)(VALUE_PREFIX.length + 4), (long)value.length);
            Assert.assertArrayEquals((byte[])VALUE_PREFIX, (byte[])Arrays.copyOf(value, VALUE_PREFIX.length));
            Assert.assertEquals((long)i2, (long)Bytes.toInt((byte[])value, (int)VALUE_PREFIX.length));
        }
    }
}

