/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.test;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.factories.MonkeyFactory;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.mapreduce.Import;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.test.IntegrationTestBigLinkedList;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestBigLinkedListWithVisibility
extends IntegrationTestBigLinkedList {
    private static final String CONFIDENTIAL = "confidential";
    private static final String TOPSECRET = "topsecret";
    private static final String SECRET = "secret";
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String EVERYONE = "everyone";
    private static final String RESTRICTED = "restricted";
    private static final String GROUP = "group";
    private static final String PREVILIGED = "previliged";
    private static final String OPEN = "open";
    public static String labels = "confidential,topsecret,secret,restricted,private,previliged,group,open,public,everyone";
    private static final String COMMA = ",";
    private static final String UNDER_SCORE = "_";
    public static int DEFAULT_TABLES_COUNT = 3;
    public static String tableName = "tableName";
    public static final String COMMON_TABLE_NAME = "commontable";
    public static final String LABELS_KEY = "LABELS";
    public static final String INDEX_KEY = "INDEX";
    private static User USER;
    private static final String OR = "|";
    private static String USER_OPT;
    private static String userName;

    @Override
    protected void addOptions() {
        super.addOptions();
        this.addOptWithArg("u", USER_OPT, "User name");
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        super.processOptions(cmd);
        if (cmd.hasOption(USER_OPT)) {
            userName = cmd.getOptionValue(USER_OPT);
        }
    }

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(null);
        Configuration conf = this.util.getConfiguration();
        VisibilityTestUtil.enableVisiblityLabels((Configuration)conf);
        conf.set("hbase.superuser", User.getCurrent().getName());
        conf.setBoolean("dfs.permissions", false);
        USER = User.createUserForTesting((Configuration)conf, (String)userName, (String[])new String[0]);
        super.setUpCluster();
        this.addLabels();
    }

    static TableName getTableName(int i) {
        return TableName.valueOf((String)(tableName + UNDER_SCORE + i));
    }

    private void addLabels() throws Exception {
        try {
            VisibilityClient.addLabels((Connection)this.util.getConnection(), (String[])labels.split(COMMA));
            VisibilityClient.setAuths((Connection)this.util.getConnection(), (String[])labels.split(COMMA), (String)USER.getName());
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    @Override
    @Test
    public void testContinuousIngest() throws IOException, Exception {
        int ret = ToolRunner.run((Configuration)this.getTestingUtil(this.getConf()).getConfiguration(), (Tool)new VisibilityLoop(), (String[])new String[]{"1", "1", "20000", this.util.getDataTestDirOnTestFS("IntegrationTestBigLinkedListWithVisibility").toString(), "1", "10000"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestBigLinkedListWithVisibility(), (String[])args);
        System.exit(ret);
    }

    @Override
    protected MonkeyFactory getDefaultMonkeyFactory() {
        return MonkeyFactory.getFactory("calm");
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        VisibilityLoop tool = null;
        VisibilityLoop loop = new VisibilityLoop();
        ((IntegrationTestBigLinkedList.Loop)loop).it = this;
        tool = loop;
        return ToolRunner.run((Configuration)this.getConf(), (Tool)tool, (String[])this.otherArgs);
    }

    static {
        USER_OPT = "user";
        userName = "user1";
    }

    static class VisibilityLoop
    extends IntegrationTestBigLinkedList.Loop {
        private static final int SLEEP_IN_MS = 5000;
        private static final Logger LOG = LoggerFactory.getLogger(VisibilityLoop.class);
        IntegrationTestBigLinkedListWithVisibility it;

        VisibilityLoop() {
        }

        @Override
        protected void runGenerator(int numMappers, long numNodes, String outputDir, Integer width, Integer wrapMultiplier, Integer numWalkers) throws Exception {
            Path outputPath = new Path(outputDir);
            UUID uuid = UUID.randomUUID();
            Path generatorOutput = new Path(outputPath, uuid.toString());
            VisibilityGenerator generator = new VisibilityGenerator();
            generator.setConf(this.getConf());
            int retCode = generator.run(numMappers, numNodes, generatorOutput, width, wrapMultiplier, numWalkers);
            if (retCode > 0) {
                throw new RuntimeException("Generator failed with return code: " + retCode);
            }
        }

        protected void runDelete(int numMappers, long numNodes, String outputDir, Integer width, Integer wrapMultiplier, int tableIndex) throws Exception {
            LOG.info("Running copier on table " + IntegrationTestBigLinkedListWithVisibility.getTableName(tableIndex));
            Copier copier = new Copier(IntegrationTestBigLinkedListWithVisibility.getTableName(tableIndex), tableIndex, true);
            copier.setConf(this.getConf());
            copier.runCopier(outputDir);
            Thread.sleep(5000L);
        }

        protected void runVerify(String outputDir, int numReducers, long expectedNumNodes, boolean allTables) throws Exception {
            int i;
            Path outputPath = new Path(outputDir);
            if (allTables) {
                for (i = 0; i < DEFAULT_TABLES_COUNT; ++i) {
                    LOG.info("Verifying table " + i);
                    this.sleep(5000L);
                    UUID uuid = UUID.randomUUID();
                    Path iterationOutput = new Path(outputPath, uuid.toString());
                    VisibilityVerify verify = new VisibilityVerify(IntegrationTestBigLinkedListWithVisibility.getTableName(i).getNameAsString(), i);
                    this.verify(numReducers, expectedNumNodes, iterationOutput, verify);
                }
            }
            for (i = 0; i < DEFAULT_TABLES_COUNT; ++i) {
                this.runVerifyCommonTable(outputDir, numReducers, expectedNumNodes, i);
            }
        }

        private void runVerify(String outputDir, int numReducers, long expectedNodes, int tableIndex) throws Exception {
            long temp = expectedNodes;
            for (int i = 0; i < DEFAULT_TABLES_COUNT; ++i) {
                expectedNodes = i <= tableIndex ? 0L : temp;
                LOG.info("Verifying data in the table with index " + i + " and expected nodes is " + expectedNodes);
                this.runVerifyCommonTable(outputDir, numReducers, expectedNodes, i);
            }
        }

        private void sleep(long ms) throws InterruptedException {
            Thread.sleep(ms);
        }

        protected void runVerifyCommonTable(String outputDir, int numReducers, long expectedNumNodes, int index) throws Exception {
            LOG.info("Verifying common table with index " + index);
            this.sleep(5000L);
            Path outputPath = new Path(outputDir);
            UUID uuid = UUID.randomUUID();
            Path iterationOutput = new Path(outputPath, uuid.toString());
            VisibilityVerify verify = new VisibilityVerify(TableName.valueOf((String)IntegrationTestBigLinkedListWithVisibility.COMMON_TABLE_NAME).getNameAsString(), index);
            this.verify(numReducers, expectedNumNodes, iterationOutput, verify);
        }

        protected void runCopier(String outputDir) throws Exception {
            for (int i = 0; i < DEFAULT_TABLES_COUNT; ++i) {
                LOG.info("Running copier " + IntegrationTestBigLinkedListWithVisibility.getTableName(i));
                this.sleep(5000L);
                Copier copier = new Copier(IntegrationTestBigLinkedListWithVisibility.getTableName(i), i, false);
                copier.setConf(this.getConf());
                copier.runCopier(outputDir);
            }
        }

        private void verify(int numReducers, long expectedNumNodes, Path iterationOutput, IntegrationTestBigLinkedList.Verify verify) throws Exception {
            verify.setConf(this.getConf());
            int retCode = verify.run(iterationOutput, numReducers);
            if (retCode > 0) {
                throw new RuntimeException("Verify.run failed with return code: " + retCode);
            }
            if (!verify.verify(expectedNumNodes)) {
                throw new RuntimeException("Verify.verify failed");
            }
            LOG.info("Verify finished with succees. Total nodes=" + expectedNumNodes);
        }

        @Override
        public int run(String[] args) throws Exception {
            if (args.length < 5) {
                System.err.println("Usage: Loop <num iterations> <num mappers> <num nodes per mapper> <output dir> <num reducers> [<width> <wrap multiplier>]");
                return 1;
            }
            LOG.info("Running Loop with args:" + Arrays.deepToString(args));
            int numIterations = Integer.parseInt(args[0]);
            int numMappers = Integer.parseInt(args[1]);
            long numNodes = Long.parseLong(args[2]);
            String outputDir = args[3];
            int numReducers = Integer.parseInt(args[4]);
            Integer width = args.length < 6 ? null : Integer.valueOf(Integer.parseInt(args[5]));
            Integer wrapMultiplier = args.length < 7 ? null : Integer.valueOf(Integer.parseInt(args[6]));
            long expectedNumNodes = 0L;
            if (numIterations < 0) {
                numIterations = Integer.MAX_VALUE;
            }
            for (int i = 0; i < numIterations; ++i) {
                LOG.info("Starting iteration = " + i);
                LOG.info("Generating data");
                this.runGenerator(numMappers, numNodes, outputDir, width, wrapMultiplier, 0);
                expectedNumNodes += (long)numMappers * numNodes;
                LOG.info("Running copier");
                this.sleep(5000L);
                this.runCopier(outputDir);
                LOG.info("Verifying copied data");
                this.sleep(5000L);
                this.runVerify(outputDir, numReducers, expectedNumNodes, true);
                this.sleep(5000L);
                for (int j = 0; j < DEFAULT_TABLES_COUNT; ++j) {
                    LOG.info("Deleting data on table with index: " + j);
                    this.runDelete(numMappers, numNodes, outputDir, width, wrapMultiplier, j);
                    this.sleep(5000L);
                    LOG.info("Verifying common table after deleting");
                    this.runVerify(outputDir, numReducers, expectedNumNodes, j);
                    this.sleep(5000L);
                }
            }
            return 0;
        }
    }

    static class VisibilityVerify
    extends IntegrationTestBigLinkedList.Verify {
        private static final Logger LOG = LoggerFactory.getLogger(VisibilityVerify.class);
        private TableName tableName;
        private int labelIndex;

        public VisibilityVerify(String tableName, int index) {
            this.tableName = TableName.valueOf((String)tableName);
            this.labelIndex = index;
        }

        @Override
        public int run(final Path outputDir, final int numReducers) throws Exception {
            LOG.info("Running Verify with outputDir=" + outputDir + ", numReducers=" + numReducers);
            PrivilegedExceptionAction<Integer> scanAction = new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() throws Exception {
                    return this.doVerify(outputDir, numReducers);
                }
            };
            return (Integer)USER.runAs((PrivilegedExceptionAction)scanAction);
        }

        private int doVerify(Path outputDir, int numReducers) throws IOException, InterruptedException, ClassNotFoundException {
            this.job = new Job(this.getConf());
            this.job.setJobName("Link Verifier");
            this.job.setNumReduceTasks(numReducers);
            this.job.setJarByClass(((Object)((Object)this)).getClass());
            IntegrationTestBigLinkedList.setJobScannerConf(this.job);
            Scan scan = new Scan();
            scan.addColumn(IntegrationTestBigLinkedList.FAMILY_NAME, IntegrationTestBigLinkedList.COLUMN_PREV);
            scan.setCaching(10000);
            scan.setCacheBlocks(false);
            String[] split = labels.split(IntegrationTestBigLinkedListWithVisibility.COMMA);
            scan.setAuthorizations(new Authorizations(new String[]{split[this.labelIndex * 2], split[this.labelIndex * 2 + 1]}));
            TableMapReduceUtil.initTableMapperJob((byte[])this.tableName.getName(), (Scan)scan, IntegrationTestBigLinkedList.Verify.VerifyMapper.class, BytesWritable.class, BytesWritable.class, (Job)this.job);
            TableMapReduceUtil.addDependencyJars((Configuration)this.job.getConfiguration(), (Class[])new Class[]{AbstractHBaseTool.class});
            this.job.getConfiguration().setBoolean("mapreduce.map.speculative", false);
            this.job.setReducerClass(IntegrationTestBigLinkedList.Verify.VerifyReducer.class);
            this.job.setOutputFormatClass(TextOutputFormat.class);
            TextOutputFormat.setOutputPath((Job)this.job, (Path)outputDir);
            boolean success = this.job.waitForCompletion(true);
            return success ? 0 : 1;
        }

        @Override
        protected void handleFailure(Counters counters) throws IOException {
            try (Connection conn = ConnectionFactory.createConnection((Configuration)this.job.getConfiguration());){
                HRegionLocation loc;
                byte[] key;
                String keyString;
                TableName tableName = TableName.valueOf((String)IntegrationTestBigLinkedListWithVisibility.COMMON_TABLE_NAME);
                CounterGroup g = (CounterGroup)counters.getGroup("undef");
                Iterator it = g.iterator();
                while (it.hasNext()) {
                    keyString = ((Counter)it.next()).getName();
                    key = Bytes.toBytes((String)keyString);
                    loc = conn.getRegionLocator(tableName).getRegionLocation(key, true);
                    LOG.error("undefined row " + keyString + ", " + loc);
                }
                g = (CounterGroup)counters.getGroup("unref");
                it = g.iterator();
                while (it.hasNext()) {
                    keyString = ((Counter)it.next()).getName();
                    key = Bytes.toBytes((String)keyString);
                    loc = conn.getRegionLocator(tableName).getRegionLocation(key, true);
                    LOG.error("unreferred row " + keyString + ", " + loc);
                }
            }
        }
    }

    static class VisibilityDeleteImport
    extends Import.Importer {
        private int index;
        private String labels;
        private String[] split;

        VisibilityDeleteImport() {
        }

        public void setup(Mapper.Context context) {
            this.index = context.getConfiguration().getInt(IntegrationTestBigLinkedListWithVisibility.INDEX_KEY, -1);
            this.labels = context.getConfiguration().get(IntegrationTestBigLinkedListWithVisibility.LABELS_KEY);
            this.split = this.labels.split(IntegrationTestBigLinkedListWithVisibility.COMMA);
            super.setup(context);
        }

        protected void processKV(ImmutableBytesWritable key, Result result, Mapper.Context context, Put put, Delete delete) throws IOException, InterruptedException {
            String visibilityExps = this.split[this.index * 2] + IntegrationTestBigLinkedListWithVisibility.OR + this.split[this.index * 2 + 1];
            for (Cell kv : result.rawCells()) {
                if (kv == null) continue;
                if (delete == null) {
                    delete = new Delete(key.get());
                }
                delete.setCellVisibility(new CellVisibility(visibilityExps));
                delete.addFamily(CellUtil.cloneFamily((Cell)kv));
            }
            if (delete != null) {
                context.write((Object)key, (Object)delete);
            }
        }
    }

    static class VisibilityImport
    extends Import.Importer {
        private int index;
        private String labels;
        private String[] split;

        VisibilityImport() {
        }

        public void setup(Mapper.Context context) {
            this.index = context.getConfiguration().getInt(IntegrationTestBigLinkedListWithVisibility.INDEX_KEY, -1);
            this.labels = context.getConfiguration().get(IntegrationTestBigLinkedListWithVisibility.LABELS_KEY);
            this.split = this.labels.split(IntegrationTestBigLinkedListWithVisibility.COMMA);
            super.setup(context);
        }

        protected void addPutToKv(Put put, Cell kv) throws IOException {
            String visibilityExps = this.split[this.index * 2] + IntegrationTestBigLinkedListWithVisibility.OR + this.split[this.index * 2 + 1];
            put.setCellVisibility(new CellVisibility(visibilityExps));
            super.addPutToKv(put, kv);
        }
    }

    static class Copier
    extends Configured
    implements Tool {
        private static final Logger LOG = LoggerFactory.getLogger(Copier.class);
        private TableName tableName;
        private int labelIndex;
        private boolean delete;

        public Copier(TableName tableName, int index, boolean delete) {
            this.tableName = tableName;
            this.labelIndex = index;
            this.delete = delete;
        }

        public int runCopier(String outputDir) throws Exception {
            Job job = null;
            Scan scan = null;
            job = new Job(this.getConf());
            job.setJobName("Data copier");
            job.getConfiguration().setInt(IntegrationTestBigLinkedListWithVisibility.INDEX_KEY, this.labelIndex);
            job.getConfiguration().set(IntegrationTestBigLinkedListWithVisibility.LABELS_KEY, labels);
            job.setJarByClass(((Object)((Object)this)).getClass());
            scan = new Scan();
            scan.setCacheBlocks(false);
            scan.setRaw(true);
            String[] split = labels.split(IntegrationTestBigLinkedListWithVisibility.COMMA);
            scan.setAuthorizations(new Authorizations(new String[]{split[this.labelIndex * 2], split[this.labelIndex * 2 + 1]}));
            if (this.delete) {
                LOG.info("Running deletes");
            } else {
                LOG.info("Running copiers");
            }
            if (this.delete) {
                TableMapReduceUtil.initTableMapperJob((String)this.tableName.getNameAsString(), (Scan)scan, VisibilityDeleteImport.class, null, null, (Job)job);
            } else {
                TableMapReduceUtil.initTableMapperJob((String)this.tableName.getNameAsString(), (Scan)scan, VisibilityImport.class, null, null, (Job)job);
            }
            job.getConfiguration().setBoolean("mapreduce.map.speculative", false);
            job.getConfiguration().setBoolean("mapreduce.reduce.speculative", false);
            TableMapReduceUtil.initTableReducerJob((String)IntegrationTestBigLinkedListWithVisibility.COMMON_TABLE_NAME, null, (Job)job, null, null, null, null);
            TableMapReduceUtil.addDependencyJars((Job)job);
            TableMapReduceUtil.addDependencyJars((Configuration)job.getConfiguration(), (Class[])new Class[]{AbstractHBaseTool.class});
            TableMapReduceUtil.initCredentials((Job)job);
            job.setNumReduceTasks(0);
            boolean success = job.waitForCompletion(true);
            return success ? 0 : 1;
        }

        public int run(String[] arg0) throws Exception {
            return 0;
        }
    }

    static class VisibilityGenerator
    extends IntegrationTestBigLinkedList.Generator {
        private static final Logger LOG = LoggerFactory.getLogger(VisibilityGenerator.class);

        VisibilityGenerator() {
        }

        @Override
        protected void createSchema() throws IOException {
            LOG.info("Creating tables");
            boolean acl = AccessControlClient.isAccessControllerRunning((Connection)ConnectionFactory.createConnection((Configuration)this.getConf()));
            if (!acl) {
                LOG.info("No ACL available.");
            }
            try (Connection conn = ConnectionFactory.createConnection((Configuration)this.getConf());
                 Admin admin = conn.getAdmin();){
                for (int i = 0; i < DEFAULT_TABLES_COUNT; ++i) {
                    TableName tableName = IntegrationTestBigLinkedListWithVisibility.getTableName(i);
                    this.createTable(admin, tableName, false, acl);
                }
                TableName tableName = TableName.valueOf((String)IntegrationTestBigLinkedListWithVisibility.COMMON_TABLE_NAME);
                this.createTable(admin, tableName, true, acl);
            }
        }

        private void createTable(Admin admin, TableName tableName, boolean setVersion, boolean acl) throws IOException {
            if (!admin.tableExists(tableName)) {
                HTableDescriptor htd = new HTableDescriptor(tableName);
                HColumnDescriptor family = new HColumnDescriptor(IntegrationTestBigLinkedList.FAMILY_NAME);
                if (setVersion) {
                    family.setMaxVersions(DEFAULT_TABLES_COUNT);
                }
                htd.addFamily(family);
                admin.createTable((TableDescriptor)htd);
                if (acl) {
                    LOG.info("Granting permissions for user " + USER.getShortName());
                    Permission.Action[] actions = new Permission.Action[]{Permission.Action.READ};
                    try {
                        AccessControlClient.grant((Connection)ConnectionFactory.createConnection((Configuration)this.getConf()), (TableName)tableName, (String)USER.getShortName(), null, null, (Permission.Action[])actions);
                    }
                    catch (Throwable e) {
                        LOG.error(HBaseMarkers.FATAL, "Error in granting permission for the user " + USER.getShortName(), e);
                        throw new IOException(e);
                    }
                }
            }
        }

        @Override
        protected void setMapperForGenerator(Job job) {
            job.setMapperClass(VisibilityGeneratorMapper.class);
        }

        static class VisibilityGeneratorMapper
        extends IntegrationTestBigLinkedList.Generator.GeneratorMapper {
            BufferedMutator[] tables = new BufferedMutator[DEFAULT_TABLES_COUNT];

            VisibilityGeneratorMapper() {
            }

            @Override
            protected void setup(Mapper.Context context) throws IOException, InterruptedException {
                super.setup(context);
            }

            @Override
            protected void instantiateHTable() throws IOException {
                for (int i = 0; i < DEFAULT_TABLES_COUNT; ++i) {
                    BufferedMutator table;
                    BufferedMutatorParams params = new BufferedMutatorParams(IntegrationTestBigLinkedListWithVisibility.getTableName(i));
                    params.writeBufferSize(0x400000L);
                    this.tables[i] = table = this.connection.getBufferedMutator(params);
                }
            }

            @Override
            protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
                for (int i = 0; i < DEFAULT_TABLES_COUNT; ++i) {
                    if (this.tables[i] == null) continue;
                    this.tables[i].close();
                }
            }

            @Override
            protected void persist(Mapper.Context output, long count, byte[][] prev, byte[][] current, byte[] id) throws IOException {
                String visibilityExps = "";
                String[] split = labels.split(IntegrationTestBigLinkedListWithVisibility.COMMA);
                for (int i = 0; i < current.length; ++i) {
                    for (int j = 0; j < DEFAULT_TABLES_COUNT; ++j) {
                        Put put = new Put(current[i]);
                        byte[] value = prev == null ? IntegrationTestBigLinkedList.NO_KEY : prev[i];
                        put.addColumn(IntegrationTestBigLinkedList.FAMILY_NAME, IntegrationTestBigLinkedList.COLUMN_PREV, value);
                        if (count >= 0L) {
                            put.addColumn(IntegrationTestBigLinkedList.FAMILY_NAME, IntegrationTestBigLinkedList.COLUMN_COUNT, Bytes.toBytes((long)(count + (long)i)));
                        }
                        if (id != null) {
                            put.addColumn(IntegrationTestBigLinkedList.FAMILY_NAME, IntegrationTestBigLinkedList.COLUMN_CLIENT, id);
                        }
                        visibilityExps = split[j * 2] + IntegrationTestBigLinkedListWithVisibility.OR + split[j * 2 + 1];
                        put.setCellVisibility(new CellVisibility(visibilityExps));
                        this.tables[j].mutate((Mutation)put);
                        try {
                            Thread.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new IOException();
                        }
                    }
                    if (i % 1000 != 0) continue;
                    output.progress();
                }
            }
        }
    }
}

