/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mttr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.NamespaceExistException;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.actions.MoveRegionsOfTableAction;
import org.apache.hadoop.hbase.chaos.actions.RestartActiveMasterAction;
import org.apache.hadoop.hbase.chaos.actions.RestartRsHoldingMetaAction;
import org.apache.hadoop.hbase.chaos.actions.RestartRsHoldingTableAction;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestTool;
import org.apache.hbase.thirdparty.com.google.common.base.MoreObjects;
import org.apache.htrace.core.AlwaysSampler;
import org.apache.htrace.core.Sampler;
import org.apache.htrace.core.Span;
import org.apache.htrace.core.TraceScope;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestMTTR {
    private static final byte[] FAMILY = Bytes.toBytes((String)"d");
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationTestMTTR.class);
    private static long sleepTime;
    private static final String SLEEP_TIME_KEY = "hbase.IntegrationTestMTTR.sleeptime";
    private static final long SLEEP_TIME_DEFAULT = 60000L;
    private static TableName tableName;
    private static TableName loadTableName;
    private static IntegrationTestingUtility util;
    private static ExecutorService executorService;
    private static Action restartRSAction;
    private static Action restartMetaAction;
    private static Action moveMetaRegionsAction;
    private static Action moveRegionAction;
    private static Action restartMasterAction;
    private static LoadTestTool loadTool;

    @BeforeClass
    public static void setUp() throws Exception {
        if (util == null) {
            util = new IntegrationTestingUtility();
        }
        util.initializeCluster(3);
        loadTool = new LoadTestTool();
        loadTool.setConf(util.getConfiguration());
        executorService = Executors.newFixedThreadPool(8);
        IntegrationTestMTTR.setupTables();
        sleepTime = util.getConfiguration().getLong(SLEEP_TIME_KEY, 60000L);
        IntegrationTestMTTR.setupActions();
    }

    private static void setupActions() throws IOException {
        util.getConfiguration().setLong("hbase.chaosmonkey.action.startrstimeout", 180000L);
        restartRSAction = new RestartRsHoldingTableAction(sleepTime, util.getConnection().getRegionLocator(tableName));
        restartMetaAction = new RestartRsHoldingMetaAction(sleepTime);
        moveMetaRegionsAction = new MoveRegionsOfTableAction(sleepTime, 600000L, TableName.META_TABLE_NAME);
        moveRegionAction = new MoveRegionsOfTableAction(sleepTime, 600000L, tableName);
        restartMasterAction = new RestartActiveMasterAction(1000L);
        Action.ActionContext actionContext = new Action.ActionContext(util);
        restartRSAction.init(actionContext);
        restartMetaAction.init(actionContext);
        moveMetaRegionsAction.init(actionContext);
        moveRegionAction.init(actionContext);
        restartMasterAction.init(actionContext);
    }

    private static void setupTables() throws IOException {
        tableName = TableName.valueOf((String)util.getConfiguration().get("hbase.IntegrationTestMTTR.tableName", "IntegrationTestMTTR"));
        loadTableName = TableName.valueOf((String)util.getConfiguration().get("hbase.IntegrationTestMTTR.loadTableName", "IntegrationTestMTTRLoadTestTool"));
        if (util.getAdmin().tableExists(tableName)) {
            util.deleteTable(tableName);
        }
        if (util.getAdmin().tableExists(loadTableName)) {
            util.deleteTable(loadTableName);
        }
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        builder.setMaxFileSize(Long.MAX_VALUE);
        ColumnFamilyDescriptorBuilder colDescriptorBldr = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY);
        colDescriptorBldr.setMaxVersions(1);
        builder.setColumnFamily(colDescriptorBldr.build());
        util.getAdmin().createTable(builder.build());
        int ret = loadTool.run(new String[]{"-tn", loadTableName.getNameAsString(), "-init_only"});
        Assert.assertEquals((String)"Failed to initialize LoadTestTool", (long)0L, (long)ret);
    }

    @AfterClass
    public static void after() throws IOException {
        util.restoreCluster();
        util = null;
        executorService.shutdown();
        executorService = null;
        moveRegionAction = null;
        restartMetaAction = null;
        moveMetaRegionsAction = null;
        restartRSAction = null;
        restartMasterAction = null;
        loadTool = null;
    }

    private static boolean tablesOnMaster() {
        boolean ret = true;
        String value = util.getConfiguration().get("hbase.balancer.tablesOnMaster");
        if (value != null && value.equalsIgnoreCase("none")) {
            ret = false;
        }
        return ret;
    }

    @Test
    public void testRestartRsHoldingTable() throws Exception {
        this.run(new ActionCallable(restartRSAction), "RestartRsHoldingTableAction");
    }

    @Test
    public void testKillRsHoldingMeta() throws Exception {
        Assume.assumeFalse((boolean)IntegrationTestMTTR.tablesOnMaster());
        this.run(new ActionCallable(restartMetaAction), "KillRsHoldingMeta");
    }

    @Test
    public void testMoveMeta() throws Exception {
        this.run(new ActionCallable(moveMetaRegionsAction), "MoveMeta");
    }

    @Test
    public void testMoveRegion() throws Exception {
        this.run(new ActionCallable(moveRegionAction), "MoveRegion");
    }

    @Test
    public void testRestartMaster() throws Exception {
        this.run(new ActionCallable(restartMasterAction), "RestartMaster");
    }

    public void run(Callable<Boolean> monkeyCallable, String testName) throws Exception {
        int maxIters = util.getHBaseClusterInterface().isDistributedCluster() ? 10 : 3;
        LOG.info("Starting " + testName + " with " + maxIters + " iterations.");
        ArrayList<TimingResult> resultPuts = new ArrayList<TimingResult>(maxIters);
        ArrayList<TimingResult> resultScan = new ArrayList<TimingResult>(maxIters);
        ArrayList<TimingResult> resultAdmin = new ArrayList<TimingResult>(maxIters);
        long start = System.nanoTime();
        try {
            for (int fullIterations = 0; fullIterations < maxIters; ++fullIterations) {
                Future<Boolean> monkeyFuture = executorService.submit(monkeyCallable);
                Future<TimingResult> putFuture = executorService.submit(new PutCallable(monkeyFuture));
                Future<TimingResult> scanFuture = executorService.submit(new ScanCallable(monkeyFuture));
                Future<TimingResult> adminFuture = executorService.submit(new AdminCallable(monkeyFuture));
                Future<Boolean> loadFuture = executorService.submit(new LoadCallable(monkeyFuture));
                monkeyFuture.get();
                loadFuture.get();
                TimingResult putTime = putFuture.get();
                TimingResult scanTime = scanFuture.get();
                TimingResult adminTime = adminFuture.get();
                resultPuts.add(putTime);
                resultScan.add(scanTime);
                resultAdmin.add(adminTime);
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            long runtimeMs = TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            LOG.info(testName + " failed after " + runtimeMs + "ms.", (Throwable)e);
            throw e;
        }
        long runtimeMs = TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"MTTRResults").add("putResults", resultPuts).add("scanResults", resultScan).add("adminResults", resultAdmin).add("totalRuntimeMs", runtimeMs).add("name", (Object)testName);
        LOG.info(helper.toString());
    }

    static /* synthetic */ TableName access$200() {
        return tableName;
    }

    public static class LoadCallable
    implements Callable<Boolean> {
        private final Future<?> future;

        public LoadCallable(Future<?> f) {
            this.future = f;
        }

        @Override
        public Boolean call() throws Exception {
            int colsPerKey = 10;
            int numServers = util.getHBaseClusterInterface().getInitialClusterMetrics().getLiveServerMetrics().size();
            int numKeys = numServers * 5000;
            int writeThreads = 10;
            do {
                int ret = loadTool.run(new String[]{"-tn", loadTableName.getNameAsString(), "-write", String.format("%d:%d:%d", colsPerKey, 500, writeThreads), "-num_keys", String.valueOf(numKeys), "-skip_init"});
                Assert.assertEquals((String)"Load failed", (long)0L, (long)ret);
            } while (!this.future.isDone());
            return true;
        }
    }

    static class ActionCallable
    implements Callable<Boolean> {
        private final Action action;

        public ActionCallable(Action action) {
            this.action = action;
        }

        @Override
        public Boolean call() throws Exception {
            this.action.perform();
            return true;
        }
    }

    static class AdminCallable
    extends TimingCallable {
        public AdminCallable(Future<?> f) throws IOException {
            super(f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean doAction() throws Exception {
            try (Admin admin = null;){
                admin = util.getAdmin();
                ClusterStatus status = admin.getClusterStatus();
                boolean bl = status != null;
                return bl;
            }
        }

        @Override
        protected String getSpanName() {
            return "MTTR Admin Test";
        }
    }

    static class ScanCallable
    extends TimingCallable {
        private final Table table = IntegrationTestMTTR.access$300().getConnection().getTable(IntegrationTestMTTR.access$200());

        public ScanCallable(Future<?> f) throws IOException {
            super(f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean doAction() throws Exception {
            try (ResultScanner rs = null;){
                Scan s = new Scan();
                s.setBatch(2);
                s.addFamily(FAMILY);
                s.setFilter((Filter)new KeyOnlyFilter());
                s.setMaxVersions(1);
                rs = this.table.getScanner(s);
                Result result = rs.next();
                boolean bl = result != null && result.size() > 0;
                return bl;
            }
        }

        @Override
        protected String getSpanName() {
            return "MTTR Scan Test";
        }
    }

    static class PutCallable
    extends TimingCallable {
        private final Table table = IntegrationTestMTTR.access$300().getConnection().getTable(IntegrationTestMTTR.access$200());

        public PutCallable(Future<?> f) throws IOException {
            super(f);
        }

        @Override
        protected boolean doAction() throws Exception {
            Put p = new Put(Bytes.toBytes((String)RandomStringUtils.randomAlphanumeric((int)5)));
            p.addColumn(FAMILY, Bytes.toBytes((String)"\u0000"), Bytes.toBytes((String)RandomStringUtils.randomAscii((int)5)));
            this.table.put(p);
            return true;
        }

        @Override
        protected String getSpanName() {
            return "MTTR Put Test";
        }
    }

    static abstract class TimingCallable
    implements Callable<TimingResult> {
        protected final Future<?> future;

        public TimingCallable(Future<?> f) {
            this.future = f;
        }

        @Override
        public TimingResult call() throws Exception {
            TimingResult result = new TimingResult();
            int maxIterations = 10;
            int numAfterDone = 0;
            int resetCount = 0;
            TraceUtil.addSampler((Sampler)AlwaysSampler.INSTANCE);
            while (numAfterDone < 10) {
                long start = System.nanoTime();
                Span span = null;
                try (TraceScope scope = TraceUtil.createTrace((String)this.getSpanName());){
                    boolean actionResult;
                    if (scope != null) {
                        span = scope.getSpan();
                    }
                    if ((actionResult = this.doAction()) && this.future.isDone()) {
                        ++numAfterDone;
                    }
                }
                catch (AccessDeniedException e) {
                    throw e;
                }
                catch (CoprocessorException e) {
                    throw e;
                }
                catch (FatalConnectionException e) {
                    throw e;
                }
                catch (InvalidFamilyOperationException e) {
                    throw e;
                }
                catch (NamespaceExistException e) {
                    throw e;
                }
                catch (NamespaceNotFoundException e) {
                    throw e;
                }
                catch (NoSuchColumnFamilyException e) {
                    throw e;
                }
                catch (TableExistsException e) {
                    throw e;
                }
                catch (TableNotFoundException e) {
                    throw e;
                }
                catch (RetriesExhaustedException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (++resetCount < 10) {
                        LOG.info("Non-fatal exception while running " + this.toString() + ". Resetting loop counter", (Throwable)e);
                        numAfterDone = 0;
                    }
                    LOG.info("Too many unexpected Exceptions. Aborting.", (Throwable)e);
                    throw e;
                }
                result.addResult(System.nanoTime() - start, span);
            }
            return result;
        }

        protected abstract boolean doAction() throws Exception;

        protected String getSpanName() {
            return this.getClass().getSimpleName();
        }

        public String toString() {
            return this.getSpanName();
        }
    }

    private static class TimingResult {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        ArrayList<String> traces = new ArrayList(10);

        private TimingResult() {
        }

        public void addResult(long time, Span span) {
            if (span == null) {
                return;
            }
            this.stats.addValue((double)TimeUnit.MILLISECONDS.convert(time, TimeUnit.NANOSECONDS));
            if (TimeUnit.SECONDS.convert(time, TimeUnit.NANOSECONDS) >= 1L) {
                this.traces.add(span.getTracerId());
            }
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("numResults", this.stats.getN()).add("minTime", this.stats.getMin()).add("meanTime", this.stats.getMean()).add("maxTime", this.stats.getMax()).add("25th", this.stats.getPercentile(25.0)).add("50th", this.stats.getPercentile(50.0)).add("75th", this.stats.getPercentile(75.0)).add("90th", this.stats.getPercentile(90.0)).add("95th", this.stats.getPercentile(95.0)).add("99th", this.stats.getPercentile(99.0)).add("99.9th", this.stats.getPercentile(99.9)).add("99.99th", this.stats.getPercentile(99.99)).add("traces", this.traces);
            return helper.toString();
        }
    }
}

