/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.factories;

import java.lang.reflect.Constructor;
import java.util.function.Function;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.factories.SlowDeterministicMonkeyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableSlowDeterministicMonkeyFactory
extends SlowDeterministicMonkeyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableSlowDeterministicMonkeyFactory.class);
    static final String HEAVY_ACTIONS = "heavy.actions";
    static final String TABLE_PARAM = "\\$table_name";

    @Override
    protected Action[] getHeavyWeightedActions() {
        String actions = this.properties.getProperty(HEAVY_ACTIONS);
        if (actions == null || actions.isEmpty()) {
            return super.getHeavyWeightedActions();
        }
        try {
            String[] actionClasses = actions.split(";");
            Object[] heavyActions = new Action[actionClasses.length];
            for (int i = 0; i < actionClasses.length; ++i) {
                heavyActions[i] = this.instantiateAction(actionClasses[i]);
            }
            LOG.info("Created actions {}", heavyActions);
            return heavyActions;
        }
        catch (Exception e) {
            LOG.error("Error trying to instantiate heavy actions. Returning null array.", (Throwable)e);
            return null;
        }
    }

    private Action instantiateAction(String actionString) throws Exception {
        Constructor<?>[] constructors;
        String packageName = "org.apache.hadoop.hbase.chaos.actions";
        String[] classAndParams = actionString.split("\\)")[0].split("\\(");
        String className = "org.apache.hadoop.hbase.chaos.actions." + classAndParams[0];
        String[] params = classAndParams[1].replaceAll(TABLE_PARAM, this.tableName.getNameAsString()).split(",");
        LOG.info("About to instantiate action class: {}; With constructor params: {}", (Object)className, (Object)params);
        Class<?> actionClass = Class.forName(className);
        for (Constructor<?> c : constructors = actionClass.getDeclaredConstructors()) {
            if (c.getParameterCount() != params.length) continue;
            Class<?>[] paramTypes = c.getParameterTypes();
            Object[] constructorParams = new Object[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                constructorParams[i] = SupportedTypes.valueOf(paramTypes[i].getSimpleName().toUpperCase()).convert(params[i]);
            }
            return (Action)c.newInstance(constructorParams);
        }
        throw new IllegalArgumentException("Couldn't find any matching constructor for: " + actionString);
    }

    public static enum SupportedTypes {
        FLOAT(p -> Float.valueOf(Float.parseFloat(p))),
        LONG(p -> Long.parseLong(p)),
        INT(p -> Integer.parseInt(p)),
        TABLENAME(p -> TableName.valueOf((String)p));

        final Function<String, Object> converter;

        private SupportedTypes(Function<String, Object> converter) {
            this.converter = converter;
        }

        Object convert(String param) {
            return this.converter.apply(param);
        }
    }
}

