/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.hive.metastore;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.MockPartitionExpressionForMetastore;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.kudu.hive.metastore.KuduMetastorePlugin;
import org.apache.kudu.test.junit.RetryRule;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestKuduMetastorePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(TestKuduMetastorePlugin.class);
    private HiveConf clientConf;
    private HiveMetaStoreClient client;
    @Rule
    public RetryRule retryRule = new RetryRule();

    private EnvironmentContext masterContext() {
        return new EnvironmentContext((Map)ImmutableMap.of((Object)"kudu.master_event", (Object)"true"));
    }

    @Before
    public void setUp() throws Exception {
        HiveConf metastoreConf = new HiveConf();
        metastoreConf.setClass(HiveConf.ConfVars.METASTORE_EXPRESSION_PROXY_CLASS.varname, MockPartitionExpressionForMetastore.class, PartitionExpressionProxy.class);
        metastoreConf.setClass(HiveConf.ConfVars.METASTORE_TRANSACTIONAL_EVENT_LISTENERS.varname, KuduMetastorePlugin.class, MetaStoreEventListener.class);
        metastoreConf.setBoolVar(HiveConf.ConfVars.METASTORE_AUTO_CREATE_ALL, true);
        metastoreConf.setBoolVar(HiveConf.ConfVars.METASTORE_SCHEMA_VERIFICATION, false);
        Path hiveTestDir = Files.createTempDirectory("hive", new FileAttribute[0]);
        hiveTestDir.toFile().deleteOnExit();
        LOG.info("Using temporary test state directory:" + hiveTestDir);
        Path warehouseDir = hiveTestDir.resolve("warehouse");
        metastoreConf.setVar(HiveConf.ConfVars.METASTOREWAREHOUSE, warehouseDir.toString());
        System.setProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, warehouseDir.toString());
        Path warehouseExternalDir = hiveTestDir.resolve("external-warehouse");
        metastoreConf.set("metastore.warehouse.external.dir", warehouseExternalDir.toString());
        System.setProperty("metastore.warehouse.external.dir", warehouseExternalDir.toString());
        Path metadb = hiveTestDir.resolve("metadb");
        metastoreConf.setVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, "jdbc:derby:memory:" + metadb.toString() + ";create=true");
        Path derbyLogFile = hiveTestDir.resolve("derby.log");
        Assert.assertTrue((boolean)derbyLogFile.toFile().createNewFile());
        System.setProperty("derby.stream.error.file", derbyLogFile.toString());
        int msPort = MetaStoreUtils.startMetaStore((HiveConf)metastoreConf);
        this.clientConf = new HiveConf();
        this.clientConf.setVar(HiveConf.ConfVars.METASTOREURIS, "thrift://localhost:" + msPort);
        this.client = new HiveMetaStoreClient(this.clientConf);
    }

    @After
    public void tearDown() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private Table newKuduTable(String name, String storageHandler) {
        Table table = new Table();
        table.setDbName("default");
        table.setTableName(name);
        table.setTableType(TableType.EXTERNAL_TABLE.toString());
        table.putToParameters("EXTERNAL", "TRUE");
        table.putToParameters("external.table.purge", "TRUE");
        table.putToParameters("storage_handler", storageHandler);
        if (!storageHandler.equals("com.cloudera.kudu.hive.KuduStorageHandler")) {
            table.putToParameters("kudu.table_id", UUID.randomUUID().toString());
            table.putToParameters("kudu.master_addresses", "localhost");
        }
        StorageDescriptor sd = new StorageDescriptor();
        sd.addToCols(new FieldSchema("a", "bigint", ""));
        sd.setSerdeInfo(new SerDeInfo());
        sd.unsetLocation();
        table.setSd(sd);
        table.setPartitionKeys((List)Lists.newArrayList());
        return table;
    }

    private Table newLegacyTable(String name) {
        return this.newKuduTable(name, "com.cloudera.kudu.hive.KuduStorageHandler");
    }

    private Table newTable(String name) {
        return this.newKuduTable(name, "org.apache.hadoop.hive.kudu.KuduStorageHandler");
    }

    @Test
    public void testCreateTableHandler() throws Exception {
        Table table;
        try {
            table = this.newTable("table");
            table.getParameters().remove("storage_handler");
            table.getParameters().remove("kudu.master_addresses");
            this.client.createTable(table);
            Assert.fail();
        }
        catch (TException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("non-Kudu table entry must not contain a table ID property"));
        }
        try {
            table = this.newTable("table");
            table.getParameters().remove("kudu.table_id");
            this.client.createTable(table, this.masterContext());
            Assert.fail();
        }
        catch (TException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Kudu table entry must contain a table ID property"));
        }
        try {
            table = this.newTable("table");
            this.client.createTable(table);
            Assert.fail();
        }
        catch (TException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Kudu tables may not be created through Hive"));
        }
        try {
            table = this.newTable("table");
            table.getParameters().remove("kudu.master_addresses");
            this.client.createTable(table, this.masterContext());
            Assert.fail();
        }
        catch (TException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Kudu table entry must contain a Master addresses property"));
        }
        table = this.newTable("table");
        this.client.createTable(table, this.masterContext());
        this.client.dropTable(table.getDbName(), table.getTableName());
        table = this.newTable("table");
        table.setTableType(TableType.EXTERNAL_TABLE.toString());
        table.putToParameters("EXTERNAL", "TRUE");
        table.putToParameters("external.table.purge", "FALSE");
        this.client.createTable(table);
        this.client.dropTable(table.getDbName(), table.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlterTableHandler() throws Exception {
        Table initTable = this.newTable("table");
        this.client.createTable(initTable, this.masterContext());
        Table table = this.client.getTable(initTable.getDbName(), initTable.getTableName());
        Table legacyTable = this.newLegacyTable("legacy_table");
        this.client.createTable(legacyTable, this.masterContext());
        legacyTable = this.client.getTable(legacyTable.getDbName(), legacyTable.getTableName());
        try {
            Table alteredTable;
            this.client.alter_table(table.getDbName(), table.getTableName(), table);
            Table newTable = table.deepCopy();
            newTable.putToParameters("kudu.table_id", UUID.randomUUID().toString());
            try {
                this.client.alter_table(table.getDbName(), table.getTableName(), newTable);
                Assert.fail();
            }
            catch (TException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Kudu table ID does not match the existing HMS entry"));
            }
            EnvironmentContext noCheckIdCtx = new EnvironmentContext((Map)ImmutableMap.of((Object)"kudu.check_id", (Object)"false"));
            this.client.alter_table_with_environmentContext(table.getDbName(), table.getTableName(), newTable, noCheckIdCtx);
            this.client.alter_table_with_environmentContext(table.getDbName(), table.getTableName(), table, noCheckIdCtx);
            try {
                alteredTable = table.deepCopy();
                alteredTable.getParameters().remove("storage_handler");
                this.client.alter_table(table.getDbName(), table.getTableName(), alteredTable);
                Assert.fail();
            }
            catch (TException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Kudu table entry must contain a Kudu storage handler property"));
            }
            try {
                alteredTable = table.deepCopy();
                alteredTable.setTableType(TableType.MANAGED_TABLE.toString());
                alteredTable.getSd().setLocation(String.format("%s/%s/%s", this.clientConf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname), table.getDbName(), table.getTableName()));
                this.client.alter_table(table.getDbName(), table.getTableName(), alteredTable);
                Assert.fail();
            }
            catch (TException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Kudu table type may not be altered"));
            }
            try {
                alteredTable = table.deepCopy();
                alteredTable.putToParameters("EXTERNAL", "FALSE");
                this.client.alter_table(table.getDbName(), table.getTableName(), alteredTable);
                Assert.fail();
            }
            catch (TException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Kudu table type may not be altered"));
            }
            alteredTable = table.deepCopy();
            alteredTable.putToParameters("EXTERNAL", "TRUE");
            this.client.alter_table(table.getDbName(), table.getTableName(), alteredTable);
            alteredTable = table.deepCopy();
            alteredTable.setTableType(TableType.MANAGED_TABLE.toString());
            alteredTable.getSd().setLocation(String.format("%s/%s/%s", this.clientConf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname), table.getDbName(), table.getTableName()));
            alteredTable.putToParameters("EXTERNAL", "FALSE");
            alteredTable.putToParameters("external.table.purge", "FALSE");
            this.client.alter_table_with_environmentContext(table.getDbName(), table.getTableName(), alteredTable, this.masterContext());
            try {
                alteredTable = table.deepCopy();
                alteredTable.putToParameters("external.table.purge", "TRUE");
                this.client.alter_table(table.getDbName(), table.getTableName(), alteredTable);
                Assert.fail();
            }
            catch (TException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Kudu table type may not be altered"));
            }
            alteredTable = table.deepCopy();
            alteredTable.setTableType(TableType.EXTERNAL_TABLE.toString());
            alteredTable.putToParameters("EXTERNAL", "TRUE");
            alteredTable.putToParameters("external.table.purge", "TRUE");
            this.client.alter_table_with_environmentContext(table.getDbName(), table.getTableName(), alteredTable, this.masterContext());
            table.getSd().addToCols(new FieldSchema("b", "int", ""));
            try {
                this.client.alter_table(table.getDbName(), table.getTableName(), table);
                Assert.fail();
            }
            catch (TException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Kudu table columns may not be altered through Hive"));
            }
            this.client.alter_table_with_environmentContext(table.getDbName(), table.getTableName(), table, new EnvironmentContext((Map)ImmutableMap.of((Object)"kudu.master_event", (Object)"true")));
            alteredTable = table.deepCopy();
            alteredTable.getParameters().clear();
            alteredTable.setTableType(TableType.EXTERNAL_TABLE.toString());
            alteredTable.putToParameters("EXTERNAL", "TRUE");
            alteredTable.putToParameters("external.table.purge", "TRUE");
            alteredTable.putToParameters("storage_handler", "com.cloudera.kudu.hive.KuduStorageHandler");
            alteredTable.putToParameters("kudu.table_name", "legacy_table");
            alteredTable.putToParameters("kudu.master_addresses", "localhost");
            this.client.alter_table(table.getDbName(), table.getTableName(), alteredTable);
        }
        finally {
            this.client.dropTable(table.getDbName(), table.getTableName());
        }
        table = initTable.deepCopy();
        table.getParameters().clear();
        this.client.createTable(table);
        table = this.client.getTable(table.getDbName(), table.getTableName());
        try {
            Table alteredTable;
            try {
                alteredTable = table.deepCopy();
                alteredTable.putToParameters("kudu.table_id", UUID.randomUUID().toString());
                this.client.alter_table(table.getDbName(), table.getTableName(), alteredTable);
                Assert.fail();
            }
            catch (TException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("non-Kudu table entry must not contain a table ID property"));
            }
            try {
                alteredTable = table.deepCopy();
                alteredTable.putToParameters("storage_handler", "org.apache.hadoop.hive.kudu.KuduStorageHandler");
                this.client.alter_table(table.getDbName(), table.getTableName(), alteredTable);
                Assert.fail();
            }
            catch (TException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("non-Kudu table entry must not contain the Kudu storage handler"));
            }
            this.client.alter_table(table.getDbName(), table.getTableName(), table);
            alteredTable = legacyTable.deepCopy();
            alteredTable.putToParameters("storage_handler", "org.apache.hadoop.hive.kudu.KuduStorageHandler");
            alteredTable.putToParameters("kudu.table_id", UUID.randomUUID().toString());
            alteredTable.putToParameters("kudu.master_addresses", "localhost");
            this.client.alter_table(legacyTable.getDbName(), legacyTable.getTableName(), alteredTable);
        }
        finally {
            this.client.dropTable(table.getDbName(), table.getTableName());
        }
        table = initTable.deepCopy();
        table.setTableType(TableType.EXTERNAL_TABLE.name());
        table.putToParameters("EXTERNAL", "TRUE");
        table.putToParameters("external.table.purge", "FALSE");
        this.client.createTable(table);
        table = this.client.getTable(table.getDbName(), table.getTableName());
        try {
            this.client.alter_table(table.getDbName(), table.getTableName(), table);
        }
        finally {
            this.client.dropTable(table.getDbName(), table.getTableName());
        }
    }

    @Test
    public void testLegacyTableHandler() throws Exception {
        Table table = this.newLegacyTable("legacy_table");
        this.client.createTable(table);
        table = this.client.getTable(table.getDbName(), table.getTableName());
        Table alteredTable = table.deepCopy();
        alteredTable.getSd().addToCols(new FieldSchema("c", "int", ""));
        this.client.alter_table(table.getDbName(), table.getTableName(), alteredTable);
        String newTable = "new_table";
        Table alteredTable2 = table.deepCopy();
        alteredTable2.setTableName("new_table");
        this.client.alter_table(table.getDbName(), table.getTableName(), alteredTable2);
        this.client.dropTable(table.getDbName(), "new_table");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropTableHandler() throws Exception {
        EnvironmentContext envContext;
        Table table = this.newTable("table");
        this.client.createTable(table, this.masterContext());
        try {
            try {
                envContext = new EnvironmentContext();
                envContext.putToProperties("kudu.table_id", UUID.randomUUID().toString());
                this.client.dropTable(table.getDbName(), table.getTableName(), true, false, envContext);
                Assert.fail();
            }
            catch (TException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Kudu table ID does not match the HMS entry"));
            }
        }
        finally {
            this.client.dropTable(table.getDbName(), table.getTableName());
        }
        this.client.createTable(table, this.masterContext());
        envContext = new EnvironmentContext();
        envContext.putToProperties("kudu.table_id", (String)table.getParameters().get("kudu.table_id"));
        this.client.dropTable(table.getDbName(), table.getTableName(), true, false, envContext);
        table.getParameters().clear();
        this.client.createTable(table);
        try {
            this.client.dropTable(table.getDbName(), table.getTableName(), true, false, envContext);
            Assert.fail();
        }
        catch (TException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Kudu table ID does not match the non-Kudu HMS entry"));
        }
        finally {
            this.client.dropTable(table.getDbName(), table.getTableName());
        }
        table.getParameters().clear();
        this.client.createTable(table);
        try {
            this.client.dropTable(table.getDbName(), table.getTableName(), true, false, envContext);
            Assert.fail();
        }
        catch (TException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Kudu table ID does not match the non-Kudu HMS entry"));
        }
        finally {
            this.client.dropTable(table.getDbName(), table.getTableName());
        }
        table.getParameters().clear();
        table.setTableType(TableType.EXTERNAL_TABLE.name());
        table.putToParameters("EXTERNAL", "TRUE");
        table.putToParameters("external.table.purge", "FALSE");
        this.client.createTable(table);
        this.client.dropTable(table.getDbName(), table.getTableName());
    }
}

