/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

public class HashUtil {
    public static long fastHash64(byte[] buf, int len, long seed) {
        long v;
        long m = -8645972361240307355L;
        long h = seed ^ (long)len * -8645972361240307355L;
        int len8 = len / 8;
        for (int i = 0; i < len8; ++i) {
            int pos = i * 8;
            v = (long)buf[pos] + ((long)buf[pos + 1] << 8) + ((long)buf[pos + 2] << 16) + ((long)buf[pos + 3] << 24) + ((long)buf[pos + 4] << 32) + ((long)buf[pos + 5] << 40) + ((long)buf[pos + 6] << 48) + ((long)buf[pos + 7] << 56);
            h ^= HashUtil.fastHashMix(v);
            h *= -8645972361240307355L;
        }
        v = 0L;
        int pos2 = len8 * 8;
        switch (len & 7) {
            case 7: {
                v ^= (long)buf[pos2 + 6] << 48;
            }
            case 6: {
                v ^= (long)buf[pos2 + 5] << 40;
            }
            case 5: {
                v ^= (long)buf[pos2 + 4] << 32;
            }
            case 4: {
                v ^= (long)buf[pos2 + 3] << 24;
            }
            case 3: {
                v ^= (long)buf[pos2 + 2] << 16;
            }
            case 2: {
                v ^= (long)buf[pos2 + 1] << 8;
            }
            case 1: {
                h ^= HashUtil.fastHashMix(v ^= (long)buf[pos2]);
                h *= -8645972361240307355L;
            }
        }
        return HashUtil.fastHashMix(h);
    }

    public static int fastHash32(byte[] buf, int len, int seed) {
        long h = HashUtil.fastHash64(buf, len, seed);
        return (int)(h - (h >>> 32));
    }

    private static long fastHashMix(long h) {
        h ^= h >>> 23;
        h *= 2388976653695081527L;
        h ^= h >>> 47;
        return h;
    }
}

