/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.protobuf.Message;
import io.netty.util.Timer;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.PingResponse;
import org.apache.kudu.master.Master;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class PingRequest
extends KuduRpc<PingResponse> {
    private final String serviceName;

    static PingRequest makeMasterPingRequest() {
        return new PingRequest("kudu.master.MasterService", null, 0L);
    }

    static PingRequest makeTabletServerPingRequest() {
        return new PingRequest("kudu.tserver.TabletServerService", null, 0L);
    }

    private PingRequest(String serviceName, Timer timer, long timeoutMillis) {
        super(null, timer, timeoutMillis);
        this.serviceName = serviceName;
    }

    @Override
    Message createRequestPB() {
        return Master.PingRequestPB.getDefaultInstance();
    }

    @Override
    String serviceName() {
        return this.serviceName;
    }

    @Override
    String method() {
        return "Ping";
    }

    @Override
    Pair<PingResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.PingResponsePB.Builder respBuilder = Master.PingResponsePB.newBuilder();
        PingRequest.readProtobuf(callResponse.getPBMessage(), (Message.Builder)respBuilder);
        PingResponse response = new PingResponse(this.timeoutTracker.getElapsedMillis(), tsUUID);
        return new Pair<PingResponse, Object>(response, null);
    }
}

