/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.protobuf.Message;
import io.netty.util.Timer;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.DeleteTableResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.master.Master;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class DeleteTableRequest
extends KuduRpc<DeleteTableResponse> {
    static final String DELETE_TABLE = "DeleteTable";
    private final String name;

    DeleteTableRequest(KuduTable table, String name, Timer timer, long timeoutMillis) {
        super(table, timer, timeoutMillis);
        this.name = name;
    }

    @Override
    Message createRequestPB() {
        Master.DeleteTableRequestPB.Builder builder = Master.DeleteTableRequestPB.newBuilder();
        Master.TableIdentifierPB tableID = Master.TableIdentifierPB.newBuilder().setTableName(this.name).build();
        builder.setTable(tableID);
        return builder.build();
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return DELETE_TABLE;
    }

    @Override
    Pair<DeleteTableResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.DeleteTableResponsePB.Builder builder = Master.DeleteTableResponsePB.newBuilder();
        DeleteTableRequest.readProtobuf(callResponse.getPBMessage(), (Message.Builder)builder);
        DeleteTableResponse response = new DeleteTableResponse(this.timeoutTracker.getElapsedMillis(), tsUUID);
        return new Pair<DeleteTableResponse, Object>(response, builder.hasError() ? builder.getError() : null);
    }
}

