/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.util;

import org.apache.kudu.test.junit.RetryRule;
import org.apache.kudu.util.StringUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestStringUtil {
    @Rule
    public RetryRule retryRule = new RetryRule();

    private String escapeSQLString(String s) {
        StringBuilder sb = new StringBuilder();
        StringUtil.appendEscapedSQLString((String)s, (StringBuilder)sb);
        return sb.toString();
    }

    @Test
    public void testAppendEscapedSQLString() {
        Assert.assertEquals((Object)"", (Object)this.escapeSQLString(""));
        Assert.assertEquals((Object)"a", (Object)this.escapeSQLString("a"));
        Assert.assertEquals((Object)"\\n", (Object)this.escapeSQLString("\n"));
        Assert.assertEquals((Object)"the_quick brown\\tfox\\njumps\\rover\\bthe\\0lazy\\\\dog", (Object)this.escapeSQLString("the_quick brown\tfox\njumps\rover\bthe\u0000lazy\\dog"));
        Assert.assertEquals((Object)"\\u0012\\0", (Object)this.escapeSQLString("\u0012\u0000"));
    }
}

